/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.biolith.impl.biome;

import com.mojang.datafixers.util.Pair;
import com.terraformersmc.biolith.impl.Biolith;
import com.terraformersmc.biolith.impl.biome.BiomeCoordinator;
import com.terraformersmc.biolith.impl.biome.DimensionBiomePlacement;
import com.terraformersmc.biolith.impl.biome.VanillaEndBiomeParameters;
import com.terraformersmc.biolith.impl.config.BiolithState;
import com.terraformersmc.biolith.impl.noise.OpenSimplexNoise2;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.QuartPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.levelgen.DensityFunction;
import org.jetbrains.annotations.NotNull;

public class EndBiomePlacement
extends DimensionBiomePlacement {
    private final double[] scale = new double[4];
    public Climate.RTree.Leaf<Holder<Biome>> nodeTheEnd;
    public Climate.RTree.Leaf<Holder<Biome>> nodeSmallEndIslands;
    public Climate.RTree.Leaf<Holder<Biome>> nodeEndBarrens;
    public Climate.RTree.Leaf<Holder<Biome>> nodeEndMidlands;
    public Climate.RTree.Leaf<Holder<Biome>> nodeEndHighlands;
    private OpenSimplexNoise2 humidityNoise;
    private OpenSimplexNoise2 temperatureNoise;
    private OpenSimplexNoise2 weirdnessNoise;

    public EndBiomePlacement() {
        int configScale = Biolith.getConfigManager().getGeneralConfig().getEndReplacementScale();
        this.scale[0] = 256 * configScale;
        this.scale[1] = 64 * configScale;
        this.scale[2] = 16 * configScale;
        this.scale[3] = 4 * configScale;
    }

    @Override
    protected void serverReplaced(@NotNull BiolithState state, ServerLevel world) {
        super.serverReplaced(state, world);
        HolderGetter<Biome> biomeEntryGetter = BiomeCoordinator.getBiomeLookupOrThrow();
        this.nodeTheEnd = new Climate.RTree.Leaf(OUT_OF_RANGE, (Object)biomeEntryGetter.getOrThrow(Biomes.THE_END));
        this.nodeSmallEndIslands = new Climate.RTree.Leaf(VanillaEndBiomeParameters.NOISE_SMALL_END_ISLANDS, (Object)biomeEntryGetter.getOrThrow(Biomes.SMALL_END_ISLANDS));
        this.nodeEndBarrens = new Climate.RTree.Leaf(VanillaEndBiomeParameters.NOISE_END_BARRENS, (Object)biomeEntryGetter.getOrThrow(Biomes.END_BARRENS));
        this.nodeEndMidlands = new Climate.RTree.Leaf(VanillaEndBiomeParameters.NOISE_END_MIDLANDS, (Object)biomeEntryGetter.getOrThrow(Biomes.END_MIDLANDS));
        this.nodeEndHighlands = new Climate.RTree.Leaf(VanillaEndBiomeParameters.NOISE_END_HIGHLANDS, (Object)biomeEntryGetter.getOrThrow(Biomes.END_HIGHLANDS));
        this.humidityNoise = new OpenSimplexNoise2(this.seedlets[7]);
        this.temperatureNoise = new OpenSimplexNoise2(this.seedlets[5]);
        this.weirdnessNoise = new OpenSimplexNoise2(this.seedlets[3]);
    }

    @Override
    protected void serverStopped() {
        super.serverStopped();
        this.nodeTheEnd = null;
        this.nodeSmallEndIslands = null;
        this.nodeEndBarrens = null;
        this.nodeEndMidlands = null;
        this.nodeEndHighlands = null;
    }

    @Override
    public double getLocalNoise(int x, int y, int z) {
        double localNoise = this.replacementNoise.sample((double)(x + this.seedlets[0]) / this.scale[0], (double)(z + this.seedlets[1]) / this.scale[0]);
        localNoise += (double)this.replacementNoise.sample((double)(x + this.seedlets[2]) / this.scale[1], (double)(z + this.seedlets[3]) / this.scale[1]) / 4.0;
        localNoise += (double)this.replacementNoise.sample((double)(x + this.seedlets[4]) / this.scale[2], (double)(z + this.seedlets[5]) / this.scale[2]) / 16.0;
        localNoise += (double)this.replacementNoise.sample((double)(x + this.seedlets[6]) / this.scale[3], (double)(z + this.seedlets[7]) / this.scale[3]) / 32.0;
        localNoise = this.normalize(localNoise / 1.3125);
        return localNoise;
    }

    public void writeBiomeParameters(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> parameters) {
        this.biomesInjected = true;
        this.placementRequests.forEach(request -> parameters.accept(request.pair()));
        this.replacementRequests.values().stream().flatMap(requestSet -> requestSet.requests.stream()).map(DimensionBiomePlacement.ReplacementRequest::biome).distinct().forEach(biome -> {
            if (!biome.equals(VANILLA_PLACEHOLDER)) {
                parameters.accept(Pair.of((Object)OUT_OF_RANGE, (Object)biome));
            }
        });
        this.subBiomeRequests.values().stream().flatMap(requestSet -> requestSet.requests.stream()).map(DimensionBiomePlacement.SubBiomeRequest::biome).distinct().forEach(biome -> parameters.accept(Pair.of((Object)OUT_OF_RANGE, (Object)biome)));
    }

    public Climate.TargetPoint sampleEndNoise(int x, int y, int z, Climate.Sampler originalNoise, Holder<Biome> originalBiome) {
        double erosion = originalNoise.erosion().compute((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(QuartPos.toBlock((int)x), QuartPos.toBlock((int)y), QuartPos.toBlock((int)z)));
        return new Climate.TargetPoint(Climate.quantizeCoord((float)this.temperatureNoise.sample((double)x / 576.0, (double)z / 576.0)), Climate.quantizeCoord((float)this.humidityNoise.sample((double)x / 448.0, (double)z / 448.0)), originalBiome.is(Biomes.THE_END) ? 0L : Climate.quantizeCoord((float)Mth.clamp((float)((float)erosion + 0.0625f), (float)-1.0f, (float)1.0f)), Climate.quantizeCoord((float)((float)erosion)), 156L * (long)(56 - y), Climate.quantizeCoord((float)this.weirdnessNoise.sample((double)x / 192.0, (double)z / 192.0)));
    }
}

