/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.biolith.impl.biome.sub;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.terraformersmc.biolith.api.biome.sub.Criterion;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBiomeCriterion
implements Criterion {
    protected final BiomeTarget biomeTarget;

    public AbstractBiomeCriterion(BiomeTarget biomeTarget) {
        this.biomeTarget = biomeTarget;
    }

    protected static <T extends AbstractBiomeCriterion> MapCodec<T> buildCodec(Function<BiomeTarget, T> function) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)BiomeTarget.CODEC.fieldOf("biome").forGetter(AbstractBiomeCriterion::biomeTarget)).apply((Applicative)instance, function));
    }

    public BiomeTarget biomeTarget() {
        return this.biomeTarget;
    }

    public record BiomeTarget(@Nullable ResourceKey<Biome> biome, @Nullable TagKey<Biome> tag) {
        public static final Codec<BiomeTarget> CODEC = Codec.either((Codec)ResourceKey.codec((ResourceKey)Registries.BIOME), (Codec)TagKey.hashedCodec((ResourceKey)Registries.BIOME)).flatComapMap(BiomeTarget::fromEither, BiomeTarget::toEither);

        public BiomeTarget(@Nullable ResourceKey<Biome> biome, @Nullable TagKey<Biome> tag) {
            if (biome == null && tag == null) {
                throw new IllegalArgumentException("Must specify either biome or tag!");
            }
        }

        public static BiomeTarget of(@NotNull ResourceKey<Biome> biome) {
            return new BiomeTarget(biome, null);
        }

        public static BiomeTarget of(@NotNull TagKey<Biome> tag) {
            return new BiomeTarget(null, tag);
        }

        public static BiomeTarget fromEither(Either<ResourceKey<Biome>, TagKey<Biome>> either) {
            return new BiomeTarget((ResourceKey<Biome>)((ResourceKey)either.left().orElse(null)), (TagKey<Biome>)((TagKey)either.right().orElse(null)));
        }

        public DataResult<Either<ResourceKey<Biome>, TagKey<Biome>>> toEither() {
            return DataResult.success((Object)(this.biome != null ? Either.left(this.biome) : Either.right(this.tag)));
        }

        public boolean matches(@Nullable Holder<Biome> biome) {
            if (biome == null) {
                return false;
            }
            if (this.biome != null && biome.is(this.biome)) {
                return true;
            }
            return this.tag != null && biome.is(this.tag);
        }
    }
}

