/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.biolith.impl.mixin;

import com.terraformersmc.biolith.api.biome.BiolithFittestNodes;
import com.terraformersmc.biolith.impl.Biolith;
import com.terraformersmc.biolith.impl.biome.InterfaceSearchTree;
import com.terraformersmc.biolith.impl.biome.SimpleArrayIterator;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Climate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={Climate.RTree.class})
public class MixinSearchTree<T>
implements InterfaceSearchTree<T> {
    @Shadow
    @Final
    private Climate.RTree.Node<T> root;
    @Unique
    private final ThreadLocal<Climate.RTree.Leaf<T>> previousUltimateNode = new ThreadLocal();
    @Unique
    private final ThreadLocal<Climate.RTree.Leaf<T>> previousPenultimateNode = new ThreadLocal();

    @Override
    public BiolithFittestNodes<T> biolith$searchTreeGet(Climate.TargetPoint point, Climate.DistanceMetric<T> distanceFunction) {
        Climate.RTree.SubTree branchNode;
        long penultimateDistance;
        long[] otherParameters = point.toParameterArray();
        Climate.RTree.Node node = this.root;
        long nodeDistance = Long.MAX_VALUE;
        SimpleArrayIterator[] stack = new SimpleArrayIterator[64];
        int stackDepth = 0;
        Climate.RTree.Leaf ultimate = this.previousUltimateNode.get();
        Climate.RTree.Leaf penultimate = this.previousPenultimateNode.get();
        long ultimateDistance = ultimate != null ? distanceFunction.distance(ultimate, otherParameters) : Long.MAX_VALUE;
        long l = penultimateDistance = penultimate != null ? distanceFunction.distance(penultimate, otherParameters) : Long.MAX_VALUE;
        if (ultimateDistance > penultimateDistance) {
            Climate.RTree.Leaf temp = ultimate;
            ultimate = penultimate;
            penultimate = temp;
            long tempDistance = ultimateDistance;
            ultimateDistance = penultimateDistance;
            penultimateDistance = tempDistance;
        }
        if (node instanceof Climate.RTree.SubTree) {
            branchNode = (Climate.RTree.SubTree)node;
            stack[stackDepth] = new SimpleArrayIterator<Climate.RTree.Node>(branchNode.children);
        } else {
            if (node instanceof Climate.RTree.Leaf) {
                Climate.RTree.Leaf leafNode = (Climate.RTree.Leaf)node;
                return new BiolithFittestNodes(leafNode, distanceFunction.distance((Climate.RTree.Node)leafNode, otherParameters));
            }
            Biolith.LOGGER.error("No biomes are available in MultiNoiseBiomeSource!");
            return new BiolithFittestNodes<T>(ultimate, ultimateDistance);
        }
        while (stack[stackDepth].hasNext()) {
            node = (Climate.RTree.Node)stack[stackDepth].next();
            nodeDistance = distanceFunction.distance(node, otherParameters);
            while (node instanceof Climate.RTree.SubTree) {
                branchNode = (Climate.RTree.SubTree)node;
                if (penultimateDistance <= nodeDistance) break;
                stack[++stackDepth] = new SimpleArrayIterator<Climate.RTree.Node>(branchNode.children);
                node = (Climate.RTree.Node)stack[stackDepth].next();
                nodeDistance = distanceFunction.distance(node, otherParameters);
            }
            if (node instanceof Climate.RTree.Leaf) {
                Climate.RTree.Leaf leafNode = (Climate.RTree.Leaf)node;
                if (penultimateDistance > nodeDistance) {
                    if (ultimateDistance > nodeDistance) {
                        if (!this.biolith$keyOf(leafNode).location().equals((Object)this.biolith$keyOf(ultimate).location())) {
                            penultimateDistance = ultimateDistance;
                            penultimate = ultimate;
                        }
                        ultimateDistance = nodeDistance;
                        ultimate = leafNode;
                    } else if (!this.biolith$keyOf(leafNode).location().equals((Object)this.biolith$keyOf(ultimate).location())) {
                        penultimateDistance = nodeDistance;
                        penultimate = leafNode;
                    }
                }
            }
            while (stackDepth > 0 && !stack[stackDepth].hasNext()) {
                --stackDepth;
            }
        }
        this.previousUltimateNode.set(ultimate);
        this.previousPenultimateNode.set(penultimate);
        if (penultimate == null) {
            return new BiolithFittestNodes<T>(ultimate, ultimateDistance);
        }
        return new BiolithFittestNodes<T>(ultimate, ultimateDistance, penultimate, penultimateDistance);
    }

    @Unique
    @NotNull
    private ResourceKey<?> biolith$keyOf(@Nullable Climate.RTree.Leaf<T> leafNode) {
        if (leafNode == null) {
            return ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"biolith", (String)"null"));
        }
        return (ResourceKey)((Holder)leafNode.value).unwrapKey().orElseThrow();
    }
}

