/*
 * Decompiled with CFR 0.152.
 */
package me.robbot.nPCSpawner;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import me.robbot.nPCSpawner.NPCData;
import me.robbot.nPCSpawner.NPCGUI;
import me.robbot.nPCSpawner.NPCManager;
import org.bukkit.Location;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerChatEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001&B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0018\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J \u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J \u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J \u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\fH\u0002J(\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\fH\u0002J \u0010\u001f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010 \u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010!\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\"\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020#H\u0007J\u0010\u0010$\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020%H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lme/robbot/nPCSpawner/NPCGUIListener;", "Lorg/bukkit/event/Listener;", "npcManager", "Lme/robbot/nPCSpawner/NPCManager;", "<init>", "(Lme/robbot/nPCSpawner/NPCManager;)V", "playersInCommandInput", "", "Ljava/util/UUID;", "", "playersInNameInput", "playerNPCSettings", "Lme/robbot/nPCSpawner/NPCGUIListener$TempNPCSettings;", "playerEditingNPC", "playerPendingChanges", "onInventoryClick", "", "event", "Lorg/bukkit/event/inventory/InventoryClickEvent;", "handleNPCCreationClick", "player", "Lorg/bukkit/entity/Player;", "handleNPCListClick", "item", "Lorg/bukkit/inventory/ItemStack;", "handleNPCEditClick", "applyAllChanges", "originalNPCData", "Lme/robbot/nPCSpawner/NPCData;", "pendingSettings", "updateEditMenu", "handleDeleteConfirmationClick", "handleMobSelectionClick", "handleColorSelectionClick", "onPlayerChat", "Lorg/bukkit/event/player/PlayerChatEvent;", "onPlayerQuit", "Lorg/bukkit/event/player/PlayerQuitEvent;", "TempNPCSettings", "npcspawner"})
@SourceDebugExtension(value={"SMAP\nNPCSpawner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NPCSpawner.kt\nme/robbot/nPCSpawner/NPCGUIListener\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1263:1\n382#2,7:1264\n382#2,7:1272\n382#2,7:1279\n382#2,7:1286\n382#2,7:1293\n1#3:1271\n*S KotlinDebug\n*F\n+ 1 NPCSpawner.kt\nme/robbot/nPCSpawner/NPCGUIListener\n*L\n842#1:1264,7\n1098#1:1272,7\n1128#1:1279,7\n1159#1:1286,7\n1182#1:1293,7\n*E\n"})
public final class NPCGUIListener
implements Listener {
    @NotNull
    private final NPCManager npcManager;
    @NotNull
    private final Map<UUID, String> playersInCommandInput;
    @NotNull
    private final Map<UUID, String> playersInNameInput;
    @NotNull
    private final Map<UUID, TempNPCSettings> playerNPCSettings;
    @NotNull
    private final Map<UUID, String> playerEditingNPC;
    @NotNull
    private final Map<UUID, TempNPCSettings> playerPendingChanges;

    public NPCGUIListener(@NotNull NPCManager npcManager) {
        Intrinsics.checkNotNullParameter(npcManager, "npcManager");
        this.npcManager = npcManager;
        this.playersInCommandInput = new LinkedHashMap();
        this.playersInNameInput = new LinkedHashMap();
        this.playerNPCSettings = new LinkedHashMap();
        this.playerEditingNPC = new LinkedHashMap();
        this.playerPendingChanges = new LinkedHashMap();
    }

    @EventHandler
    public final void onInventoryClick(@NotNull InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        HumanEntity humanEntity = event.getWhoClicked();
        Player player = humanEntity instanceof Player ? (Player)humanEntity : null;
        if (player == null) {
            return;
        }
        Player player2 = player;
        String string = event.getView().getTitle();
        Intrinsics.checkNotNullExpressionValue(string, "getTitle(...)");
        String inventory = string;
        ItemStack itemStack = event.getCurrentItem();
        if (itemStack == null) {
            return;
        }
        ItemStack item = itemStack;
        if (StringsKt.startsWith$default(inventory, "\u00a76NPC List", false, 2, null)) {
            event.setCancelled(true);
            this.handleNPCListClick(event, player2, item);
        } else if (StringsKt.startsWith$default(inventory, "\u00a76Edit NPC", false, 2, null)) {
            event.setCancelled(true);
            this.handleNPCEditClick(event, player2, item);
        } else if (StringsKt.startsWith$default(inventory, "\u00a7cConfirm Delete", false, 2, null)) {
            event.setCancelled(true);
            this.handleDeleteConfirmationClick(event, player2, item);
        } else if (Intrinsics.areEqual(inventory, "\u00a76NPC Creator")) {
            event.setCancelled(true);
            this.handleNPCCreationClick(event, player2);
        } else if (Intrinsics.areEqual(inventory, "\u00a76Select Mob Type")) {
            event.setCancelled(true);
            this.handleMobSelectionClick(event, player2);
        } else if (Intrinsics.areEqual(inventory, "\u00a76Select Name Color")) {
            event.setCancelled(true);
            this.handleColorSelectionClick(event, player2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void handleNPCCreationClick(InventoryClickEvent event, Player player) {
        Object object;
        void $this$getOrPut$iv;
        ItemStack itemStack = event.getCurrentItem();
        if (itemStack == null) {
            return;
        }
        ItemStack item = itemStack;
        Map<UUID, TempNPCSettings> map = this.playerNPCSettings;
        UUID key$iv = player.getUniqueId();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            TempNPCSettings answer$iv = new TempNPCSettings(null, null, null, null, false, false, false, 127, null);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        TempNPCSettings settings = (TempNPCSettings)object;
        switch (event.getSlot()) {
            case 10: {
                player.closeInventory();
                player.sendMessage("\u00a7aPlease type the command in chat (without /):");
                this.playersInCommandInput.put(player.getUniqueId(), "command");
                break;
            }
            case 12: {
                NPCGUI.Companion.openMobSelectionMenu(player);
                break;
            }
            case 14: {
                player.closeInventory();
                player.sendMessage("\u00a7aPlease type the name tag in chat:");
                this.playersInNameInput.put(player.getUniqueId(), "name");
                break;
            }
            case 16: {
                NPCGUI.Companion.openColorSelectionMenu(player);
                break;
            }
            case 20: {
                String[] stringArray;
                ItemMeta moveMeta;
                ItemStack moveItem;
                settings.setCanMove(!settings.getCanMove());
                ItemStack itemStack2 = moveItem = event.getInventory().getItem(20);
                Object object2 = moveMeta = itemStack2 != null ? itemStack2.getItemMeta() : null;
                if (settings.getCanMove()) {
                    ItemMeta itemMeta = moveMeta;
                    if (itemMeta != null) {
                        itemMeta.setDisplayName("\u00a7cSet Mob Moving: \u00a7aTRUE");
                    }
                    ItemMeta itemMeta2 = moveMeta;
                    if (itemMeta2 != null) {
                        stringArray = new String[]{"\u00a77Click to toggle if the mob can move", "\u00a77Current: \u00a7aCan Move"};
                        itemMeta2.setLore(CollectionsKt.listOf(stringArray));
                    }
                } else {
                    ItemMeta itemMeta = moveMeta;
                    if (itemMeta != null) {
                        itemMeta.setDisplayName("\u00a7cSet Mob Moving: \u00a7cFALSE");
                    }
                    ItemMeta itemMeta3 = moveMeta;
                    if (itemMeta3 != null) {
                        stringArray = new String[]{"\u00a77Click to toggle if the mob can move", "\u00a77Current: \u00a7cCannot Move"};
                        itemMeta3.setLore(CollectionsKt.listOf(stringArray));
                    }
                }
                ItemStack itemStack3 = moveItem;
                if (itemStack3 != null) {
                    itemStack3.setItemMeta(moveMeta);
                }
                player.updateInventory();
                break;
            }
            case 22: {
                ItemMeta damageMeta;
                ItemStack damageItem;
                String[] stringArray;
                settings.setCanTakeDamage(!settings.getCanTakeDamage());
                ItemStack itemStack4 = damageItem = event.getInventory().getItem(22);
                Object object3 = damageMeta = itemStack4 != null ? itemStack4.getItemMeta() : null;
                if (settings.getCanTakeDamage()) {
                    ItemMeta itemMeta = damageMeta;
                    if (itemMeta != null) {
                        itemMeta.setDisplayName("\u00a74Set Damage: \u00a7aTRUE");
                    }
                    ItemMeta itemMeta4 = damageMeta;
                    if (itemMeta4 != null) {
                        stringArray = new String[]{"\u00a77Click to toggle if the mob can take damage", "\u00a77Current: \u00a7aCan Take Damage"};
                        itemMeta4.setLore(CollectionsKt.listOf(stringArray));
                    }
                } else {
                    ItemMeta itemMeta = damageMeta;
                    if (itemMeta != null) {
                        itemMeta.setDisplayName("\u00a74Set Damage: \u00a7cFALSE");
                    }
                    ItemMeta itemMeta5 = damageMeta;
                    if (itemMeta5 != null) {
                        stringArray = new String[]{"\u00a77Click to toggle if the mob can take damage", "\u00a77Current: \u00a7cCannot Take Damage"};
                        itemMeta5.setLore(CollectionsKt.listOf(stringArray));
                    }
                }
                ItemStack itemStack5 = damageItem;
                if (itemStack5 != null) {
                    itemStack5.setItemMeta(damageMeta);
                }
                player.updateInventory();
                break;
            }
            case 24: {
                ItemMeta noiseMeta;
                ItemStack noiseItem;
                String[] stringArray;
                settings.setCanMakeNoise(!settings.getCanMakeNoise());
                ItemStack itemStack6 = noiseItem = event.getInventory().getItem(24);
                Object object4 = noiseMeta = itemStack6 != null ? itemStack6.getItemMeta() : null;
                if (settings.getCanMakeNoise()) {
                    ItemMeta itemMeta = noiseMeta;
                    if (itemMeta != null) {
                        itemMeta.setDisplayName("\u00a7dSet Noise: \u00a7aTRUE");
                    }
                    ItemMeta itemMeta6 = noiseMeta;
                    if (itemMeta6 != null) {
                        stringArray = new String[]{"\u00a77Click to toggle if the mob makes noise", "\u00a77Current: \u00a7aCan Make Noise"};
                        itemMeta6.setLore(CollectionsKt.listOf(stringArray));
                    }
                } else {
                    ItemMeta itemMeta = noiseMeta;
                    if (itemMeta != null) {
                        itemMeta.setDisplayName("\u00a7dSet Noise: \u00a7cFALSE");
                    }
                    ItemMeta itemMeta7 = noiseMeta;
                    if (itemMeta7 != null) {
                        stringArray = new String[]{"\u00a77Click to toggle if the mob makes noise", "\u00a77Current: \u00a7cCannot Make Noise"};
                        itemMeta7.setLore(CollectionsKt.listOf(stringArray));
                    }
                }
                ItemStack itemStack7 = noiseItem;
                if (itemStack7 != null) {
                    itemStack7.setItemMeta(noiseMeta);
                }
                player.updateInventory();
                break;
            }
            case 40: {
                String string = UUID.randomUUID().toString();
                Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
                NPCData npcData = new NPCData(string, null, settings.getNameTag(), settings.getNameTagColor(), settings.getExecutionCommand(), settings.getCanMove(), settings.getCanTakeDamage(), settings.getCanMakeNoise(), null, 0.0, 0.0, 0.0, 0.0f, 0.0f, null, 32514, null);
                npcData.setEntityType(settings.getEntityType().name());
                Location location = player.getLocation();
                Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
                npcData.setLocation(location);
                this.npcManager.createNPC(player, npcData);
                player.closeInventory();
                player.sendMessage("\u00a7aNPC spawned successfully!");
                this.playerNPCSettings.remove(player.getUniqueId());
            }
        }
    }

    private final void handleNPCListClick(InventoryClickEvent event, Player player, ItemStack item) {
        List<NPCData> npcs = this.npcManager.getNPCs();
        int slot = event.getSlot();
        if (slot < npcs.size()) {
            NPCData npcData = npcs.get(slot);
            this.playerEditingNPC.put(player.getUniqueId(), npcData.getUuid());
            TempNPCSettings pendingSettings = new TempNPCSettings(null, null, null, null, false, false, false, 127, null);
            pendingSettings.setEntityType(npcData.getEntityType());
            pendingSettings.setNameTag(npcData.getNameTag());
            pendingSettings.setNameTagColor(npcData.getNameTagColor());
            pendingSettings.setExecutionCommand(npcData.getExecutionCommand());
            pendingSettings.setCanMove(npcData.getCanMove());
            pendingSettings.setCanTakeDamage(npcData.getCanTakeDamage());
            pendingSettings.setCanMakeNoise(npcData.getCanMakeNoise());
            this.playerPendingChanges.put(player.getUniqueId(), pendingSettings);
            NPCGUI.Companion.openNPCEditMenu(player, this.npcManager, npcData);
        }
    }

    private final void handleNPCEditClick(InventoryClickEvent event, Player player, ItemStack item) {
        String string = this.playerEditingNPC.get(player.getUniqueId());
        if (string == null) {
            return;
        }
        String npcUUID = string;
        NPCData nPCData = this.npcManager.getNPCByUUID(npcUUID);
        if (nPCData == null) {
            return;
        }
        NPCData npcData = nPCData;
        TempNPCSettings tempNPCSettings = this.playerPendingChanges.get(player.getUniqueId());
        if (tempNPCSettings == null) {
            return;
        }
        TempNPCSettings pendingSettings = tempNPCSettings;
        switch (event.getSlot()) {
            case 10: {
                player.closeInventory();
                player.sendMessage("\u00a7aPlease type the new command in chat (without /):");
                this.playersInCommandInput.put(player.getUniqueId(), "edit_command:" + npcUUID);
                break;
            }
            case 12: {
                this.playerEditingNPC.put(player.getUniqueId(), npcUUID);
                NPCGUI.Companion.openMobSelectionMenu(player);
                break;
            }
            case 14: {
                player.closeInventory();
                player.sendMessage("\u00a7aPlease type the new name tag in chat:");
                this.playersInNameInput.put(player.getUniqueId(), "edit_name:" + npcUUID);
                break;
            }
            case 16: {
                this.playerEditingNPC.put(player.getUniqueId(), npcUUID);
                NPCGUI.Companion.openColorSelectionMenu(player);
                break;
            }
            case 20: {
                pendingSettings.setCanMove(!pendingSettings.getCanMove());
                this.updateEditMenu(player, this.npcManager, npcData, pendingSettings);
                player.sendMessage("\u00a7eMovement setting changed to: " + (pendingSettings.getCanMove() ? "\u00a7aCan Move" : "\u00a7cCannot Move"));
                player.sendMessage("\u00a77Click 'Confirm Changes' to apply this change");
                break;
            }
            case 22: {
                pendingSettings.setCanTakeDamage(!pendingSettings.getCanTakeDamage());
                this.updateEditMenu(player, this.npcManager, npcData, pendingSettings);
                player.sendMessage("\u00a7eDamage setting changed to: " + (pendingSettings.getCanTakeDamage() ? "\u00a7aCan Take Damage" : "\u00a7cCannot Take Damage"));
                player.sendMessage("\u00a77Click 'Confirm Changes' to apply this change");
                break;
            }
            case 24: {
                pendingSettings.setCanMakeNoise(!pendingSettings.getCanMakeNoise());
                this.updateEditMenu(player, this.npcManager, npcData, pendingSettings);
                player.sendMessage("\u00a7eNoise setting changed to: " + (pendingSettings.getCanMakeNoise() ? "\u00a7aCan Make Noise" : "\u00a7cCannot Make Noise"));
                player.sendMessage("\u00a77Click 'Confirm Changes' to apply this change");
                break;
            }
            case 31: {
                this.applyAllChanges(player, npcData, pendingSettings);
                break;
            }
            case 40: {
                NPCGUI.Companion.openDeleteConfirmationMenu(player, this.npcManager, npcData);
            }
        }
    }

    private final void applyAllChanges(Player player, NPCData originalNPCData, TempNPCSettings pendingSettings) {
        NPCData updatedNPCData = new NPCData(originalNPCData.getUuid(), pendingSettings.getEntityType().name(), pendingSettings.getNameTag(), pendingSettings.getNameTagColor(), pendingSettings.getExecutionCommand(), pendingSettings.getCanMove(), pendingSettings.getCanTakeDamage(), pendingSettings.getCanMakeNoise(), originalNPCData.getWorld(), originalNPCData.getX(), originalNPCData.getY(), originalNPCData.getZ(), originalNPCData.getYaw(), originalNPCData.getPitch(), originalNPCData.getInteractionUUID());
        this.npcManager.removeNPC(originalNPCData.getUuid());
        this.npcManager.createNPC(player, updatedNPCData);
        player.sendMessage("\u00a7a\u2705 All changes applied successfully!");
        player.sendMessage("\u00a77NPC has been respawned with new settings");
        player.closeInventory();
        this.playerPendingChanges.remove(player.getUniqueId());
        this.playerEditingNPC.remove(player.getUniqueId());
    }

    private final void updateEditMenu(Player player, NPCManager npcManager, NPCData originalNPCData, TempNPCSettings pendingSettings) {
        NPCData displayNPCData = new NPCData(originalNPCData.getUuid(), pendingSettings.getEntityType().name(), pendingSettings.getNameTag(), pendingSettings.getNameTagColor(), pendingSettings.getExecutionCommand(), pendingSettings.getCanMove(), pendingSettings.getCanTakeDamage(), pendingSettings.getCanMakeNoise(), originalNPCData.getWorld(), originalNPCData.getX(), originalNPCData.getY(), originalNPCData.getZ(), originalNPCData.getYaw(), originalNPCData.getPitch(), originalNPCData.getInteractionUUID());
        NPCGUI.Companion.openNPCEditMenu(player, npcManager, displayNPCData);
    }

    private final void handleDeleteConfirmationClick(InventoryClickEvent event, Player player, ItemStack item) {
        String string = this.playerEditingNPC.get(player.getUniqueId());
        if (string == null) {
            return;
        }
        String npcUUID = string;
        NPCData nPCData = this.npcManager.getNPCByUUID(npcUUID);
        if (nPCData == null) {
            return;
        }
        NPCData npcData = nPCData;
        switch (event.getSlot()) {
            case 11: {
                this.npcManager.removeNPC(npcUUID);
                player.closeInventory();
                player.sendMessage("\u00a7aNPC '" + npcData.getDisplayName() + "' has been deleted and changes saved!");
                this.playerEditingNPC.remove(player.getUniqueId());
                this.playerPendingChanges.remove(player.getUniqueId());
                break;
            }
            case 15: {
                NPCGUI.Companion.openNPCEditMenu(player, this.npcManager, npcData);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void handleMobSelectionClick(InventoryClickEvent event, Player player) {
        String string;
        ItemStack itemStack = event.getCurrentItem();
        if (itemStack == null) {
            return;
        }
        ItemStack item = itemStack;
        Object object = item.getItemMeta();
        if (object != null && (object = object.getDisplayName()) != null && (object = StringsKt.replace$default((String)object, "\u00a7f", "", false, 4, null)) != null && (object = StringsKt.replace$default((String)object, ' ', '_', false, 4, null)) != null) {
            String string2 = ((String)object).toUpperCase(Locale.ROOT);
            string = string2;
            Intrinsics.checkNotNullExpressionValue(string2, "toUpperCase(...)");
        } else {
            string = null;
        }
        String entityTypeName = string;
        try {
            String string3 = entityTypeName;
            if (string3 == null) {
                string3 = "VILLAGER";
            }
            EntityType entityType = EntityType.valueOf(string3);
            String editingNPCUUID = this.playerEditingNPC.get(player.getUniqueId());
            if (editingNPCUUID != null) {
                String string4;
                TempNPCSettings tempNPCSettings = this.playerPendingChanges.get(player.getUniqueId());
                if (tempNPCSettings == null) {
                    return;
                }
                TempNPCSettings pendingSettings = tempNPCSettings;
                NPCData nPCData = this.npcManager.getNPCByUUID(editingNPCUUID);
                if (nPCData == null) {
                    return;
                }
                NPCData npcData = nPCData;
                pendingSettings.setEntityType(entityType);
                this.updateEditMenu(player, this.npcManager, npcData, pendingSettings);
                Player player2 = player;
                StringBuilder stringBuilder = new StringBuilder().append("\u00a7eMob type changed to: \u00a7f");
                String string5 = StringsKt.replace$default(entityType.name(), '_', ' ', false, 4, null).toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string5, "toLowerCase(...)");
                String string6 = string5;
                if (((CharSequence)string6).length() > 0) {
                    void it22;
                    char c = string6.charAt(0);
                    StringBuilder stringBuilder2 = new StringBuilder();
                    StringBuilder stringBuilder3 = stringBuilder;
                    Player player3 = player2;
                    int n = 0;
                    String string7 = String.valueOf((char)it22);
                    Intrinsics.checkNotNull(string7, "null cannot be cast to non-null type java.lang.String");
                    String string8 = string7.toUpperCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue(string8, "toUpperCase(...)");
                    CharSequence charSequence = string8;
                    player2 = player3;
                    stringBuilder = stringBuilder3;
                    StringBuilder stringBuilder4 = stringBuilder2.append((Object)charSequence);
                    String it22 = string6;
                    n = 1;
                    String string9 = it22.substring(n);
                    Intrinsics.checkNotNullExpressionValue(string9, "substring(...)");
                    string4 = stringBuilder4.append(string9).toString();
                } else {
                    string4 = string6;
                }
                player2.sendMessage(stringBuilder.append(string4).toString());
                player.sendMessage("\u00a77Click 'Confirm Changes' to apply this change");
            } else {
                String string10;
                Object object2;
                void $this$getOrPut$iv;
                Map<UUID, TempNPCSettings> npcData = this.playerNPCSettings;
                UUID key$iv2 = player.getUniqueId();
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv2);
                if (value$iv == null) {
                    boolean bl = false;
                    TempNPCSettings answer$iv = new TempNPCSettings(null, null, null, null, false, false, false, 127, null);
                    $this$getOrPut$iv.put(key$iv2, answer$iv);
                    object2 = answer$iv;
                } else {
                    object2 = value$iv;
                }
                TempNPCSettings settings = (TempNPCSettings)object2;
                settings.setEntityType(entityType);
                player.closeInventory();
                NPCGUI.Companion.openNPCCreationMenu(player, this.npcManager);
                Player player4 = player;
                StringBuilder stringBuilder = new StringBuilder().append("\u00a7aMob type set to: \u00a7f");
                String string11 = StringsKt.replace$default(entityType.name(), '_', ' ', false, 4, null).toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string11, "toLowerCase(...)");
                String string12 = string11;
                if (((CharSequence)string12).length() > 0) {
                    void it;
                    char key$iv2 = string12.charAt(0);
                    StringBuilder stringBuilder5 = new StringBuilder();
                    StringBuilder stringBuilder6 = stringBuilder;
                    Player player5 = player4;
                    boolean bl = false;
                    String string13 = String.valueOf((char)it);
                    Intrinsics.checkNotNull(string13, "null cannot be cast to non-null type java.lang.String");
                    String string14 = string13.toUpperCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue(string14, "toUpperCase(...)");
                    CharSequence charSequence = string14;
                    player4 = player5;
                    stringBuilder = stringBuilder6;
                    StringBuilder stringBuilder7 = stringBuilder5.append((Object)charSequence);
                    String string15 = string12;
                    int n = 1;
                    String string16 = string15.substring(n);
                    Intrinsics.checkNotNullExpressionValue(string16, "substring(...)");
                    string10 = stringBuilder7.append(string16).toString();
                } else {
                    string10 = string12;
                }
                player4.sendMessage(stringBuilder.append(string10).toString());
            }
        }
        catch (IllegalArgumentException e) {
            player.sendMessage("\u00a7cInvalid mob type selected!");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void handleColorSelectionClick(InventoryClickEvent event, Player player) {
        String colorName;
        ItemStack itemStack = event.getCurrentItem();
        if (itemStack == null) {
            return;
        }
        ItemStack item = itemStack;
        ItemMeta itemMeta = item.getItemMeta();
        String string = colorName = itemMeta != null ? itemMeta.getDisplayName() : null;
        if (colorName != null) {
            String string2 = colorName.substring(0, 2);
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
            String colorCode = string2;
            String editingNPCUUID = this.playerEditingNPC.get(player.getUniqueId());
            if (editingNPCUUID != null) {
                TempNPCSettings tempNPCSettings = this.playerPendingChanges.get(player.getUniqueId());
                if (tempNPCSettings == null) {
                    return;
                }
                TempNPCSettings pendingSettings = tempNPCSettings;
                NPCData nPCData = this.npcManager.getNPCByUUID(editingNPCUUID);
                if (nPCData == null) {
                    return;
                }
                NPCData npcData = nPCData;
                pendingSettings.setNameTagColor(colorCode);
                this.updateEditMenu(player, this.npcManager, npcData, pendingSettings);
                player.sendMessage("\u00a7eName color changed to: " + colorCode + "this color");
                player.sendMessage("\u00a77Click 'Confirm Changes' to apply this change");
            } else {
                Object object;
                void $this$getOrPut$iv;
                Map<UUID, TempNPCSettings> npcData = this.playerNPCSettings;
                UUID key$iv = player.getUniqueId();
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    TempNPCSettings answer$iv = new TempNPCSettings(null, null, null, null, false, false, false, 127, null);
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                TempNPCSettings settings = (TempNPCSettings)object;
                settings.setNameTagColor(colorCode);
                player.closeInventory();
                NPCGUI.Companion.openNPCCreationMenu(player, this.npcManager);
                player.sendMessage("\u00a7aName color set to: " + colorCode + "this color");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @EventHandler
    public final void onPlayerChat(@NotNull PlayerChatEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        String string = event.getMessage();
        Intrinsics.checkNotNullExpressionValue(string, "getMessage(...)");
        String message = string;
        if (this.playersInCommandInput.containsKey(player2.getUniqueId())) {
            event.setCancelled(true);
            String string2 = this.playersInCommandInput.get(player2.getUniqueId());
            Intrinsics.checkNotNull(string2);
            String inputType = string2;
            if (StringsKt.startsWith$default(inputType, "edit_command:", false, 2, null)) {
                String npcUUID = StringsKt.substringAfter$default(inputType, "edit_command:", null, 2, null);
                TempNPCSettings tempNPCSettings = this.playerPendingChanges.get(player2.getUniqueId());
                if (tempNPCSettings == null) {
                    return;
                }
                TempNPCSettings pendingSettings = tempNPCSettings;
                NPCData nPCData = this.npcManager.getNPCByUUID(npcUUID);
                if (nPCData == null) {
                    return;
                }
                NPCData npcData = nPCData;
                pendingSettings.setExecutionCommand(message);
                this.updateEditMenu(player2, this.npcManager, npcData, pendingSettings);
                this.playersInCommandInput.remove(player2.getUniqueId());
                player2.sendMessage("\u00a7eCommand changed to: \u00a7f/" + message);
                player2.sendMessage("\u00a77Click 'Confirm Changes' to apply this change");
            } else {
                Object object;
                void $this$getOrPut$iv;
                Map<UUID, TempNPCSettings> pendingSettings = this.playerNPCSettings;
                UUID key$iv = player2.getUniqueId();
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    TempNPCSettings answer$iv = new TempNPCSettings(null, null, null, null, false, false, false, 127, null);
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                TempNPCSettings settings = (TempNPCSettings)object;
                settings.setExecutionCommand(message);
                this.playersInCommandInput.remove(player2.getUniqueId());
                player2.sendMessage("\u00a7aCommand set to: \u00a7f/" + message);
                NPCGUI.Companion.openNPCCreationMenu(player2, this.npcManager);
            }
        } else if (this.playersInNameInput.containsKey(player2.getUniqueId())) {
            event.setCancelled(true);
            String string3 = this.playersInNameInput.get(player2.getUniqueId());
            Intrinsics.checkNotNull(string3);
            String inputType = string3;
            if (StringsKt.startsWith$default(inputType, "edit_name:", false, 2, null)) {
                String npcUUID = StringsKt.substringAfter$default(inputType, "edit_name:", null, 2, null);
                TempNPCSettings tempNPCSettings = this.playerPendingChanges.get(player2.getUniqueId());
                if (tempNPCSettings == null) {
                    return;
                }
                TempNPCSettings pendingSettings = tempNPCSettings;
                NPCData nPCData = this.npcManager.getNPCByUUID(npcUUID);
                if (nPCData == null) {
                    return;
                }
                NPCData npcData = nPCData;
                pendingSettings.setNameTag(message);
                this.updateEditMenu(player2, this.npcManager, npcData, pendingSettings);
                this.playersInNameInput.remove(player2.getUniqueId());
                player2.sendMessage("\u00a7eName changed to: \u00a7f" + message);
                player2.sendMessage("\u00a77Click 'Confirm Changes' to apply this change");
            } else {
                Object object;
                void $this$getOrPut$iv;
                Map<UUID, TempNPCSettings> pendingSettings = this.playerNPCSettings;
                UUID key$iv = player2.getUniqueId();
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    TempNPCSettings answer$iv = new TempNPCSettings(null, null, null, null, false, false, false, 127, null);
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                TempNPCSettings settings = (TempNPCSettings)object;
                settings.setNameTag(message);
                this.playersInNameInput.remove(player2.getUniqueId());
                player2.sendMessage("\u00a7aName tag set to: \u00a7f" + message);
                NPCGUI.Companion.openNPCCreationMenu(player2, this.npcManager);
            }
        }
    }

    @EventHandler
    public final void onPlayerQuit(@NotNull PlayerQuitEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        this.playersInCommandInput.remove(player2.getUniqueId());
        this.playersInNameInput.remove(player2.getUniqueId());
        this.playerNPCSettings.remove(player2.getUniqueId());
        this.playerEditingNPC.remove(player2.getUniqueId());
        this.playerPendingChanges.remove(player2.getUniqueId());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b#\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001BO\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\t\u00a2\u0006\u0004\b\f\u0010\rJ\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010#\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010$\u001a\u00020\u0005H\u00c6\u0003J\t\u0010%\u001a\u00020\u0005H\u00c6\u0003J\t\u0010&\u001a\u00020\tH\u00c6\u0003J\t\u0010'\u001a\u00020\tH\u00c6\u0003J\t\u0010(\u001a\u00020\tH\u00c6\u0003JQ\u0010)\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010*\u001a\u00020\t2\b\u0010+\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010,\u001a\u00020-H\u00d6\u0001J\t\u0010.\u001a\u00020\u0005H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0013\"\u0004\b\u0017\u0010\u0015R\u001a\u0010\u0007\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0013\"\u0004\b\u0019\u0010\u0015R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\n\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001b\"\u0004\b\u001f\u0010\u001dR\u001a\u0010\u000b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u001b\"\u0004\b!\u0010\u001d\u00a8\u0006/"}, d2={"Lme/robbot/nPCSpawner/NPCGUIListener$TempNPCSettings;", "", "entityType", "Lorg/bukkit/entity/EntityType;", "nameTag", "", "nameTagColor", "executionCommand", "canMove", "", "canTakeDamage", "canMakeNoise", "<init>", "(Lorg/bukkit/entity/EntityType;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZZZ)V", "getEntityType", "()Lorg/bukkit/entity/EntityType;", "setEntityType", "(Lorg/bukkit/entity/EntityType;)V", "getNameTag", "()Ljava/lang/String;", "setNameTag", "(Ljava/lang/String;)V", "getNameTagColor", "setNameTagColor", "getExecutionCommand", "setExecutionCommand", "getCanMove", "()Z", "setCanMove", "(Z)V", "getCanTakeDamage", "setCanTakeDamage", "getCanMakeNoise", "setCanMakeNoise", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "other", "hashCode", "", "toString", "npcspawner"})
    public static final class TempNPCSettings {
        @NotNull
        private EntityType entityType;
        @Nullable
        private String nameTag;
        @NotNull
        private String nameTagColor;
        @NotNull
        private String executionCommand;
        private boolean canMove;
        private boolean canTakeDamage;
        private boolean canMakeNoise;

        public TempNPCSettings(@NotNull EntityType entityType, @Nullable String nameTag, @NotNull String nameTagColor, @NotNull String executionCommand, boolean canMove, boolean canTakeDamage, boolean canMakeNoise) {
            Intrinsics.checkNotNullParameter(entityType, "entityType");
            Intrinsics.checkNotNullParameter(nameTagColor, "nameTagColor");
            Intrinsics.checkNotNullParameter(executionCommand, "executionCommand");
            this.entityType = entityType;
            this.nameTag = nameTag;
            this.nameTagColor = nameTagColor;
            this.executionCommand = executionCommand;
            this.canMove = canMove;
            this.canTakeDamage = canTakeDamage;
            this.canMakeNoise = canMakeNoise;
        }

        public /* synthetic */ TempNPCSettings(EntityType entityType, String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                entityType = EntityType.VILLAGER;
            }
            if ((n & 2) != 0) {
                string = null;
            }
            if ((n & 4) != 0) {
                string2 = "\u00a7f";
            }
            if ((n & 8) != 0) {
                string3 = "";
            }
            if ((n & 0x10) != 0) {
                bl = true;
            }
            if ((n & 0x20) != 0) {
                bl2 = true;
            }
            if ((n & 0x40) != 0) {
                bl3 = true;
            }
            this(entityType, string, string2, string3, bl, bl2, bl3);
        }

        @NotNull
        public final EntityType getEntityType() {
            return this.entityType;
        }

        public final void setEntityType(@NotNull EntityType entityType) {
            Intrinsics.checkNotNullParameter(entityType, "<set-?>");
            this.entityType = entityType;
        }

        @Nullable
        public final String getNameTag() {
            return this.nameTag;
        }

        public final void setNameTag(@Nullable String string) {
            this.nameTag = string;
        }

        @NotNull
        public final String getNameTagColor() {
            return this.nameTagColor;
        }

        public final void setNameTagColor(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            this.nameTagColor = string;
        }

        @NotNull
        public final String getExecutionCommand() {
            return this.executionCommand;
        }

        public final void setExecutionCommand(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            this.executionCommand = string;
        }

        public final boolean getCanMove() {
            return this.canMove;
        }

        public final void setCanMove(boolean bl) {
            this.canMove = bl;
        }

        public final boolean getCanTakeDamage() {
            return this.canTakeDamage;
        }

        public final void setCanTakeDamage(boolean bl) {
            this.canTakeDamage = bl;
        }

        public final boolean getCanMakeNoise() {
            return this.canMakeNoise;
        }

        public final void setCanMakeNoise(boolean bl) {
            this.canMakeNoise = bl;
        }

        @NotNull
        public final EntityType component1() {
            return this.entityType;
        }

        @Nullable
        public final String component2() {
            return this.nameTag;
        }

        @NotNull
        public final String component3() {
            return this.nameTagColor;
        }

        @NotNull
        public final String component4() {
            return this.executionCommand;
        }

        public final boolean component5() {
            return this.canMove;
        }

        public final boolean component6() {
            return this.canTakeDamage;
        }

        public final boolean component7() {
            return this.canMakeNoise;
        }

        @NotNull
        public final TempNPCSettings copy(@NotNull EntityType entityType, @Nullable String nameTag, @NotNull String nameTagColor, @NotNull String executionCommand, boolean canMove, boolean canTakeDamage, boolean canMakeNoise) {
            Intrinsics.checkNotNullParameter(entityType, "entityType");
            Intrinsics.checkNotNullParameter(nameTagColor, "nameTagColor");
            Intrinsics.checkNotNullParameter(executionCommand, "executionCommand");
            return new TempNPCSettings(entityType, nameTag, nameTagColor, executionCommand, canMove, canTakeDamage, canMakeNoise);
        }

        public static /* synthetic */ TempNPCSettings copy$default(TempNPCSettings tempNPCSettings, EntityType entityType, String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
            if ((n & 1) != 0) {
                entityType = tempNPCSettings.entityType;
            }
            if ((n & 2) != 0) {
                string = tempNPCSettings.nameTag;
            }
            if ((n & 4) != 0) {
                string2 = tempNPCSettings.nameTagColor;
            }
            if ((n & 8) != 0) {
                string3 = tempNPCSettings.executionCommand;
            }
            if ((n & 0x10) != 0) {
                bl = tempNPCSettings.canMove;
            }
            if ((n & 0x20) != 0) {
                bl2 = tempNPCSettings.canTakeDamage;
            }
            if ((n & 0x40) != 0) {
                bl3 = tempNPCSettings.canMakeNoise;
            }
            return tempNPCSettings.copy(entityType, string, string2, string3, bl, bl2, bl3);
        }

        @NotNull
        public String toString() {
            return "TempNPCSettings(entityType=" + this.entityType + ", nameTag=" + this.nameTag + ", nameTagColor=" + this.nameTagColor + ", executionCommand=" + this.executionCommand + ", canMove=" + this.canMove + ", canTakeDamage=" + this.canTakeDamage + ", canMakeNoise=" + this.canMakeNoise + ')';
        }

        public int hashCode() {
            int result = this.entityType.hashCode();
            result = result * 31 + (this.nameTag == null ? 0 : this.nameTag.hashCode());
            result = result * 31 + this.nameTagColor.hashCode();
            result = result * 31 + this.executionCommand.hashCode();
            result = result * 31 + Boolean.hashCode(this.canMove);
            result = result * 31 + Boolean.hashCode(this.canTakeDamage);
            result = result * 31 + Boolean.hashCode(this.canMakeNoise);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TempNPCSettings)) {
                return false;
            }
            TempNPCSettings tempNPCSettings = (TempNPCSettings)other;
            if (this.entityType != tempNPCSettings.entityType) {
                return false;
            }
            if (!Intrinsics.areEqual(this.nameTag, tempNPCSettings.nameTag)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.nameTagColor, tempNPCSettings.nameTagColor)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.executionCommand, tempNPCSettings.executionCommand)) {
                return false;
            }
            if (this.canMove != tempNPCSettings.canMove) {
                return false;
            }
            if (this.canTakeDamage != tempNPCSettings.canTakeDamage) {
                return false;
            }
            return this.canMakeNoise == tempNPCSettings.canMakeNoise;
        }

        public TempNPCSettings() {
            this(null, null, null, null, false, false, false, 127, null);
        }
    }
}

