/*
 * Decompiled with CFR 0.152.
 */
package me.robbot.nPCSpawner;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.robbot.nPCSpawner.NPCData;
import me.robbot.nPCSpawner.NPCSpawner;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Interaction;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\r\u001a\u00020\u0003J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\bJ\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\bH\u0002J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001c\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0006\u0010\u001c\u001a\u00020\u000fJ\u0006\u0010\u001d\u001a\u00020\u000fJ\u000e\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u001f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010 \u001a\u0004\u0018\u00010\b2\u0006\u0010!\u001a\u00020\"J\u0006\u0010#\u001a\u00020\u000fJ\u0006\u0010$\u001a\u00020\u000fJ\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\b0&J\u000e\u0010'\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lme/robbot/nPCSpawner/NPCManager;", "", "plugin", "Lme/robbot/nPCSpawner/NPCSpawner;", "<init>", "(Lme/robbot/nPCSpawner/NPCSpawner;)V", "npcs", "", "Lme/robbot/nPCSpawner/NPCData;", "dataFile", "Ljava/io/File;", "teleportTask", "", "getPlugin", "createNPC", "", "player", "Lorg/bukkit/entity/Player;", "npcData", "spawnNPC", "removeExistingEntities", "uuid", "", "getInteractionSize", "Lkotlin/Pair;", "", "entityType", "Lorg/bukkit/entity/EntityType;", "startTeleportTask", "stopTeleportTask", "removeNPC", "getNPCByUUID", "getNPCByInteraction", "interaction", "Lorg/bukkit/entity/Entity;", "saveNPCs", "loadNPCs", "getNPCs", "", "updateNPC", "npcspawner"})
@SourceDebugExtension(value={"SMAP\nNPCSpawner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NPCSpawner.kt\nme/robbot/nPCSpawner/NPCManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1263:1\n1#2:1264\n295#3,2:1265\n295#3,2:1267\n295#3,2:1269\n295#3,2:1271\n1878#3,3:1273\n1878#3,3:1276\n1869#3,2:1279\n360#3,7:1281\n295#3,2:1288\n295#3,2:1290\n*S KotlinDebug\n*F\n+ 1 NPCSpawner.kt\nme/robbot/nPCSpawner/NPCManager\n*L\n205#1:1265,2\n212#1:1267,2\n283#1:1269,2\n290#1:1271,2\n325#1:1273,3\n355#1:1276,3\n420#1:1279,2\n436#1:1281,7\n244#1:1288,2\n254#1:1290,2\n*E\n"})
public final class NPCManager {
    @NotNull
    private final NPCSpawner plugin;
    @NotNull
    private final List<NPCData> npcs;
    @NotNull
    private final File dataFile;
    private int teleportTask;

    public NPCManager(@NotNull NPCSpawner plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
        this.npcs = new ArrayList();
        this.dataFile = new File(this.plugin.getDataFolder(), "npcs.yml");
        this.teleportTask = -1;
    }

    @NotNull
    public final NPCSpawner getPlugin() {
        return this.plugin;
    }

    public final void createNPC(@NotNull Player player, @NotNull NPCData npcData) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(npcData, "npcData");
        this.npcs.add(npcData);
        this.plugin.getLogger().info("\ud83d\udcdd Added NPC to list: " + npcData.getDisplayName() + ", total NPCs: " + this.npcs.size());
        this.spawnNPC(npcData);
        this.saveNPCs();
        this.plugin.getLogger().info("\u2705 NPC created and saved immediately: " + npcData.getDisplayName());
    }

    private final void spawnNPC(NPCData npcData) {
        Location location = npcData.getLocation();
        if (location == null) {
            return;
        }
        Location location2 = location;
        World world = location2.getWorld();
        if (world == null) {
            return;
        }
        World world2 = world;
        this.removeExistingEntities(npcData.getUuid());
        try {
            Entity entity = world2.spawnEntity(location2, npcData.getEntityType());
            Intrinsics.checkNotNullExpressionValue(entity, "spawnEntity(...)");
            Entity mobEntity = entity;
            String string = npcData.getNameTag();
            if (string != null) {
                String name = string;
                boolean bl = false;
                mobEntity.setCustomName(npcData.getNameTagColor() + name);
                mobEntity.setCustomNameVisible(true);
            }
            mobEntity.setMetadata("npc_uuid", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)npcData.getUuid()));
            mobEntity.setMetadata("npc_data", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)npcData));
            if (!npcData.getCanMove()) {
                Entity entity2 = mobEntity;
                if (entity2 instanceof Mob) {
                    ((Mob)mobEntity).setAI(false);
                } else if (entity2 instanceof LivingEntity) {
                    mobEntity.addScoreboardTag("immobile");
                }
            }
            mobEntity.setInvulnerable(!npcData.getCanTakeDamage());
            if (!npcData.getCanMakeNoise()) {
                mobEntity.setSilent(true);
            }
            mobEntity.setGlowing(true);
            Entity entity3 = world2.spawnEntity(location2, EntityType.INTERACTION);
            Intrinsics.checkNotNull(entity3, "null cannot be cast to non-null type org.bukkit.entity.Interaction");
            Interaction interaction = (Interaction)entity3;
            interaction.setMetadata("npc_uuid", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)npcData.getUuid()));
            interaction.setMetadata("interaction_entity", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)true));
            interaction.setMetadata("npc_command", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)npcData.getExecutionCommand()));
            Pair<Float, Float> pair = this.getInteractionSize(npcData.getEntityType());
            float width = ((Number)pair.component1()).floatValue();
            float height = ((Number)pair.component2()).floatValue();
            interaction.setInteractionWidth(width);
            interaction.setInteractionHeight(height);
            String string2 = interaction.getUniqueId().toString();
            Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
            npcData.setInteractionUUID(string2);
            interaction.setInvisible(true);
            interaction.setSilent(true);
            this.plugin.getLogger().info("\ud83c\udfaf Spawned NPC '" + npcData.getDisplayName() + "' with command: '" + npcData.getExecutionCommand() + '\'');
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("\u274c Failed to spawn NPC: " + e.getMessage());
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void removeExistingEntities(String uuid) {
        block12: {
            block10: {
                block9: {
                    var5_2 = this.npcs;
                    for (T var7_4 : var5_2) {
                        it = (NPCData)var7_4;
                        $i$a$-find-NPCManager$removeExistingEntities$npcData$1 = false;
                        if (!Intrinsics.areEqual(it.getUuid(), uuid)) continue;
                        v0 = var7_4;
                        break block9;
                    }
                    v0 = null;
                }
                v1 = v0;
                if (v1 == null) {
                    return;
                }
                npcData = v1;
                v2 = location = npcData.getLocation();
                v3 /* !! */  = world = v2 != null ? v2.getWorld() : null;
                if (world == null || (var5_2 = world.getEntities()) == null) break block12;
                $this$firstOrNull$iv = var5_2;
                $i$f$firstOrNull = false;
                for (T element$iv : $this$firstOrNull$iv) {
                    entity = (Entity)element$iv;
                    $i$a$-firstOrNull-NPCManager$removeExistingEntities$1 = false;
                    if (!entity.hasMetadata("npc_uuid")) ** GOTO lbl-1000
                    v4 = entity.getMetadata("npc_uuid");
                    Intrinsics.checkNotNullExpressionValue(v4, "getMetadata(...)");
                    if (Intrinsics.areEqual(((MetadataValue)CollectionsKt.first(v4)).asString(), uuid) && entity.getType() != EntityType.INTERACTION) {
                        v5 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v5 = false;
                    }
                    if (!v5) continue;
                    v6 = element$iv;
                    break block10;
                }
                v6 = null;
            }
            var6_3 = v6;
            if (var6_3 != null) {
                var6_3.remove();
            }
        }
        if (world != null && (var5_2 = world.getEntities()) != null) {
            block11: {
                $this$firstOrNull$iv = var5_2;
                $i$f$firstOrNull = false;
                for (T element$iv : $this$firstOrNull$iv) {
                    entity = (Entity)element$iv;
                    $i$a$-firstOrNull-NPCManager$removeExistingEntities$2 = false;
                    if (!Intrinsics.areEqual(entity.getUniqueId().toString(), npcData.getInteractionUUID())) continue;
                    v7 = element$iv;
                    break block11;
                }
                v7 = null;
            }
            var6_3 = v7;
            if (var6_3 != null) {
                var6_3.remove();
            }
        }
        this.plugin.getLogger().info("\ud83d\uddd1\ufe0f Removed existing entities for NPC: " + npcData.getDisplayName());
    }

    private final Pair<Float, Float> getInteractionSize(EntityType entityType) {
        Pair<Float, Float> pair;
        switch (WhenMappings.$EnumSwitchMapping$0[entityType.ordinal()]) {
            case 1: {
                pair = TuplesKt.to(Float.valueOf(0.8f), Float.valueOf(2.0f));
                break;
            }
            case 2: {
                pair = TuplesKt.to(Float.valueOf(0.8f), Float.valueOf(2.0f));
                break;
            }
            case 3: {
                pair = TuplesKt.to(Float.valueOf(0.8f), Float.valueOf(2.0f));
                break;
            }
            case 4: {
                pair = TuplesKt.to(Float.valueOf(0.8f), Float.valueOf(1.8f));
                break;
            }
            case 5: {
                pair = TuplesKt.to(Float.valueOf(1.2f), Float.valueOf(1.6f));
                break;
            }
            case 6: {
                pair = TuplesKt.to(Float.valueOf(1.2f), Float.valueOf(1.2f));
                break;
            }
            case 7: {
                pair = TuplesKt.to(Float.valueOf(1.2f), Float.valueOf(1.4f));
                break;
            }
            case 8: {
                pair = TuplesKt.to(Float.valueOf(0.6f), Float.valueOf(0.8f));
                break;
            }
            case 9: {
                pair = TuplesKt.to(Float.valueOf(1.8f), Float.valueOf(2.9f));
                break;
            }
            case 10: {
                pair = TuplesKt.to(Float.valueOf(0.8f), Float.valueOf(2.0f));
                break;
            }
            case 11: {
                pair = TuplesKt.to(Float.valueOf(0.8f), Float.valueOf(3.0f));
                break;
            }
            default: {
                pair = TuplesKt.to(Float.valueOf(0.8f), Float.valueOf(1.8f));
            }
        }
        return pair;
    }

    public final void startTeleportTask() {
        this.teleportTask = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, () -> NPCManager.startTeleportTask$lambda$6(this), 0L, 1L);
    }

    public final void stopTeleportTask() {
        if (this.teleportTask != -1) {
            Bukkit.getScheduler().cancelTask(this.teleportTask);
            this.teleportTask = -1;
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public final void removeNPC(@NotNull String uuid) {
        block12: {
            block10: {
                block9: {
                    Intrinsics.checkNotNullParameter(uuid, "uuid");
                    var5_2 = this.npcs;
                    for (T var7_4 : var5_2) {
                        it = (NPCData)var7_4;
                        $i$a$-find-NPCManager$removeNPC$npcData$1 = false;
                        if (!Intrinsics.areEqual(it.getUuid(), uuid)) continue;
                        v0 = var7_4;
                        break block9;
                    }
                    v0 = null;
                }
                v1 = v0;
                if (v1 == null) {
                    return;
                }
                npcData = v1;
                v2 = location = npcData.getLocation();
                v3 /* !! */  = world = v2 != null ? v2.getWorld() : null;
                if (world == null || (var5_2 = world.getEntities()) == null) break block12;
                $this$firstOrNull$iv = var5_2;
                $i$f$firstOrNull = false;
                for (T element$iv : $this$firstOrNull$iv) {
                    entity = (Entity)element$iv;
                    $i$a$-firstOrNull-NPCManager$removeNPC$1 = false;
                    if (!entity.hasMetadata("npc_uuid")) ** GOTO lbl-1000
                    v4 = entity.getMetadata("npc_uuid");
                    Intrinsics.checkNotNullExpressionValue(v4, "getMetadata(...)");
                    if (Intrinsics.areEqual(((MetadataValue)CollectionsKt.first(v4)).asString(), uuid) && entity.getType() != EntityType.INTERACTION) {
                        v5 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v5 = false;
                    }
                    if (!v5) continue;
                    v6 = element$iv;
                    break block10;
                }
                v6 = null;
            }
            var6_3 = v6;
            if (var6_3 != null) {
                var6_3.remove();
            }
        }
        if (world != null && (var5_2 = world.getEntities()) != null) {
            block11: {
                $this$firstOrNull$iv = var5_2;
                $i$f$firstOrNull = false;
                for (T element$iv : $this$firstOrNull$iv) {
                    entity = (Entity)element$iv;
                    $i$a$-firstOrNull-NPCManager$removeNPC$2 = false;
                    if (!Intrinsics.areEqual(entity.getUniqueId().toString(), npcData.getInteractionUUID())) continue;
                    v7 = element$iv;
                    break block11;
                }
                v7 = null;
            }
            var6_3 = v7;
            if (var6_3 != null) {
                var6_3.remove();
            }
        }
        this.npcs.remove(npcData);
        this.saveNPCs();
        this.plugin.getLogger().info("\ud83d\uddd1\ufe0f Removed NPC '" + npcData.getDisplayName() + "' and saved changes");
    }

    @Nullable
    public final NPCData getNPCByUUID(@NotNull String uuid) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(uuid, "uuid");
            Iterable iterable = this.npcs;
            for (Object t : iterable) {
                NPCData it = (NPCData)t;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getUuid(), uuid)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Nullable
    public final NPCData getNPCByInteraction(@NotNull Entity interaction) {
        Intrinsics.checkNotNullParameter(interaction, "interaction");
        if (!interaction.hasMetadata("npc_uuid")) {
            return null;
        }
        List list = interaction.getMetadata("npc_uuid");
        Intrinsics.checkNotNullExpressionValue(list, "getMetadata(...)");
        String string = ((MetadataValue)CollectionsKt.first(list)).asString();
        Intrinsics.checkNotNullExpressionValue(string, "asString(...)");
        String uuid = string;
        return this.getNPCByUUID(uuid);
    }

    /*
     * WARNING - void declaration
     */
    public final void saveNPCs() {
        if (!this.plugin.getDataFolder().exists()) {
            this.plugin.getDataFolder().mkdirs();
        }
        try {
            NPCData npcData;
            int index;
            int n;
            YamlConfiguration yamlConfig = new YamlConfiguration();
            yamlConfig.set("npcs", null);
            Iterable $this$forEachIndexed$iv = this.npcs;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                NPCData nPCData = (NPCData)item$iv;
                index = n;
                boolean bl = false;
                String npcPath = "npcs." + index;
                yamlConfig.set(npcPath + ".uuid", (Object)npcData.getUuid());
                yamlConfig.set(npcPath + ".entityType", (Object)npcData.getEntityType());
                yamlConfig.set(npcPath + ".nameTag", (Object)npcData.getNameTag());
                yamlConfig.set(npcPath + ".nameTagColor", (Object)npcData.getNameTagColor());
                yamlConfig.set(npcPath + ".executionCommand", (Object)npcData.getExecutionCommand());
                yamlConfig.set(npcPath + ".canMove", (Object)npcData.getCanMove());
                yamlConfig.set(npcPath + ".canTakeDamage", (Object)npcData.getCanTakeDamage());
                yamlConfig.set(npcPath + ".canMakeNoise", (Object)npcData.getCanMakeNoise());
                yamlConfig.set(npcPath + ".world", (Object)npcData.getWorld());
                yamlConfig.set(npcPath + ".x", (Object)npcData.getX());
                yamlConfig.set(npcPath + ".y", (Object)npcData.getY());
                yamlConfig.set(npcPath + ".z", (Object)npcData.getZ());
                yamlConfig.set(npcPath + ".yaw", (Object)npcData.getYaw());
                yamlConfig.set(npcPath + ".pitch", (Object)npcData.getPitch());
                yamlConfig.set(npcPath + ".interactionUUID", (Object)npcData.getInteractionUUID());
            }
            yamlConfig.set("npc-count", (Object)this.npcs.size());
            yamlConfig.save(this.dataFile);
            this.plugin.getLogger().info("\ud83d\udcbe SAVED " + this.npcs.size() + " NPCs to YAML file: " + this.dataFile.getAbsolutePath());
            this.plugin.getLogger().info("\ud83d\udcc4 File contents (" + this.npcs.size() + " NPCs):");
            if (this.npcs.isEmpty()) {
                this.plugin.getLogger().info("  No NPCs to display");
            } else {
                $this$forEachIndexed$iv = this.npcs;
                $i$f$forEachIndexed = false;
                index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    void npc;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    npcData = (NPCData)item$iv;
                    index = n;
                    boolean bl = false;
                    this.plugin.getLogger().info("  NPC " + index + ": " + npc.getDisplayName() + " - Command: '" + npc.getExecutionCommand() + '\'');
                }
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("\u274c Failed to save NPCs: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public final void loadNPCs() {
        if (!this.dataFile.exists()) {
            this.plugin.getLogger().info("\ud83d\udcdd No NPCs file found at: " + this.dataFile.getAbsolutePath() + " - Creating new file");
            this.saveNPCs();
            return;
        }
        try {
            YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)this.dataFile);
            Intrinsics.checkNotNullExpressionValue(yamlConfiguration, "loadConfiguration(...)");
            YamlConfiguration yamlConfig = yamlConfiguration;
            this.npcs.clear();
            if (!yamlConfig.contains("npcs")) {
                this.plugin.getLogger().info("\u2139\ufe0f No NPCs found in YAML file");
                return;
            }
            int npcCount = yamlConfig.getInt("npc-count", 0);
            this.plugin.getLogger().info("\ud83d\udce5 Loading " + npcCount + " NPCs from YAML file");
            for (int i = 0; i < npcCount; ++i) {
                try {
                    String string;
                    String string2;
                    String npcPath = "npcs." + i;
                    if (!yamlConfig.contains(npcPath + ".uuid")) continue;
                    String string3 = yamlConfig.getString(npcPath + ".uuid");
                    if (string3 == null) {
                        String string4 = UUID.randomUUID().toString();
                        string3 = string4;
                        Intrinsics.checkNotNullExpressionValue(string4, "toString(...)");
                    }
                    if ((string2 = yamlConfig.getString(npcPath + ".entityType")) == null) {
                        string2 = "VILLAGER";
                    }
                    String string5 = yamlConfig.getString(npcPath + ".nameTag");
                    String string6 = yamlConfig.getString(npcPath + ".nameTagColor");
                    if (string6 == null) {
                        string6 = "\u00a7f";
                    }
                    if ((string = yamlConfig.getString(npcPath + ".executionCommand")) == null) {
                        string = "";
                    }
                    boolean bl = yamlConfig.getBoolean(npcPath + ".canMove", true);
                    boolean bl2 = yamlConfig.getBoolean(npcPath + ".canTakeDamage", true);
                    boolean bl3 = yamlConfig.getBoolean(npcPath + ".canMakeNoise", true);
                    String string7 = yamlConfig.getString(npcPath + ".world");
                    if (string7 == null) {
                        string7 = "world";
                    }
                    double d = yamlConfig.getDouble(npcPath + ".x", 0.0);
                    double d2 = yamlConfig.getDouble(npcPath + ".y", 0.0);
                    double d3 = yamlConfig.getDouble(npcPath + ".z", 0.0);
                    float f = (float)yamlConfig.getDouble(npcPath + ".yaw", 0.0);
                    float f2 = (float)yamlConfig.getDouble(npcPath + ".pitch", 0.0);
                    String string8 = yamlConfig.getString(npcPath + ".interactionUUID");
                    if (string8 == null) {
                        string8 = "";
                    }
                    NPCData npcData = new NPCData(string3, string2, string5, string6, string, bl, bl2, bl3, string7, d, d2, d3, f, f2, string8);
                    this.npcs.add(npcData);
                    this.plugin.getLogger().info("\u2705 Loaded NPC: " + npcData.getDisplayName() + " with command: '" + npcData.getExecutionCommand() + '\'');
                    continue;
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning("\u274c Failed to load NPC " + i + ": " + e.getMessage());
                }
            }
            Iterable $this$forEach$iv = this.npcs;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                NPCData it = (NPCData)element$iv;
                boolean bl = false;
                this.spawnNPC(it);
            }
            this.plugin.getLogger().info("\ud83c\udf89 Successfully loaded " + this.npcs.size() + " NPCs from YAML file");
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("\u274c Failed to load NPCs: " + e.getMessage());
            e.printStackTrace();
        }
    }

    @NotNull
    public final List<NPCData> getNPCs() {
        return CollectionsKt.toList((Iterable)this.npcs);
    }

    public final void updateNPC(@NotNull NPCData npcData) {
        int index;
        block3: {
            int n;
            Intrinsics.checkNotNullParameter(npcData, "npcData");
            List<NPCData> $this$indexOfFirst$iv = this.npcs;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<NPCData> iterator2 = $this$indexOfFirst$iv.iterator();
            while (iterator2.hasNext()) {
                NPCData item$iv;
                NPCData it = item$iv = iterator2.next();
                boolean bl = false;
                if (Intrinsics.areEqual(it.getUuid(), npcData.getUuid())) {
                    n = index$iv;
                    break block3;
                }
                ++index$iv;
            }
            n = index = -1;
        }
        if (index != -1) {
            this.npcs.set(index, npcData);
            this.saveNPCs();
            this.plugin.getLogger().info("\u270f\ufe0f Updated and saved NPC: " + npcData.getDisplayName());
        }
    }

    /*
     * Unable to fully structure code
     */
    private static final void startTeleportTask$lambda$6(NPCManager this$0) {
        for (NPCData npcData : this$0.npcs) {
            block7: {
                block6: {
                    if (npcData.getLocation() == null || mobLocation.getWorld() == null) continue;
                    v0 = world.getEntities();
                    Intrinsics.checkNotNullExpressionValue(v0, "getEntities(...)");
                    $this$firstOrNull$iv = v0;
                    $i$f$firstOrNull = false;
                    for (T element$iv : $this$firstOrNull$iv) {
                        entity = (Entity)element$iv;
                        $i$a$-firstOrNull-NPCManager$startTeleportTask$1$mobEntity$1 = false;
                        if (!entity.hasMetadata("npc_uuid")) ** GOTO lbl-1000
                        v1 = entity.getMetadata("npc_uuid");
                        Intrinsics.checkNotNullExpressionValue(v1, "getMetadata(...)");
                        if (Intrinsics.areEqual(((MetadataValue)CollectionsKt.first(v1)).asString(), npcData.getUuid()) && entity.getType() != EntityType.INTERACTION) {
                            v2 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v2 = false;
                        }
                        if (!v2) continue;
                        v3 = element$iv;
                        break block6;
                    }
                    v3 = null;
                }
                if ((Entity)v3 == null) continue;
                v4 = mobEntity.getLocation();
                Intrinsics.checkNotNullExpressionValue(v4, "getLocation(...)");
                npcData.setLocation(v4);
                v5 = world.getEntities();
                Intrinsics.checkNotNullExpressionValue(v5, "getEntities(...)");
                $this$firstOrNull$iv = v5;
                $i$f$firstOrNull = false;
                for (T element$iv : $this$firstOrNull$iv) {
                    entity = (Entity)element$iv;
                    $i$a$-firstOrNull-NPCManager$startTeleportTask$1$interaction$1 = false;
                    if (!Intrinsics.areEqual(entity.getUniqueId().toString(), npcData.getInteractionUUID())) continue;
                    v6 = element$iv;
                    break block7;
                }
                v6 = var8_9 = null;
            }
            if ((var8_9 instanceof Interaction != false ? (Interaction)var8_9 : null) == null) continue;
            interaction = interaction;
            interaction.teleport(mobEntity.getLocation());
            if (interaction.hasMetadata("npc_command")) {
                v7 = interaction.getMetadata("npc_command");
                Intrinsics.checkNotNullExpressionValue(v7, "getMetadata(...)");
                if (Intrinsics.areEqual(((MetadataValue)CollectionsKt.first(v7)).asString(), npcData.getExecutionCommand())) continue;
            }
            interaction.setMetadata("npc_command", (MetadataValue)new FixedMetadataValue((Plugin)this$0.plugin, (Object)npcData.getExecutionCommand()));
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EntityType.values().length];
            try {
                nArray[EntityType.VILLAGER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EntityType.ZOMBIE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EntityType.SKELETON.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EntityType.CREEPER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EntityType.COW.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EntityType.PIG.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EntityType.SHEEP.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EntityType.CHICKEN.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EntityType.IRON_GOLEM.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EntityType.WITCH.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EntityType.ENDERMAN.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

