/*
 * Decompiled with CFR 0.152.
 */
package me.robbot.rbnpcspawnernewverison;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.robbot.rbnpcspawnernewverison.NPCData;
import me.robbot.rbnpcspawnernewverison.NPCSpawner;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Interaction;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\r\u001a\u00020\u0003J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\bJ\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\bH\u0002J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001c\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0006\u0010\u001c\u001a\u00020\u000fJ\u0006\u0010\u001d\u001a\u00020\u000fJ\u000e\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u001f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010 \u001a\u0004\u0018\u00010\b2\u0006\u0010!\u001a\u00020\"J\u0006\u0010#\u001a\u00020\u000fJ\u0006\u0010$\u001a\u00020\u000fJ\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\b0&J\u000e\u0010'\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lme/robbot/rbnpcspawnernewverison/NPCManager;", "", "plugin", "Lme/robbot/rbnpcspawnernewverison/NPCSpawner;", "<init>", "(Lme/robbot/rbnpcspawnernewverison/NPCSpawner;)V", "npcs", "", "Lme/robbot/rbnpcspawnernewverison/NPCData;", "dataFile", "Ljava/io/File;", "teleportTask", "", "getPlugin", "createNPC", "", "player", "Lorg/bukkit/entity/Player;", "npcData", "spawnNPC", "removeExistingEntities", "uuid", "", "getInteractionSize", "Lkotlin/Pair;", "", "entityType", "Lorg/bukkit/entity/EntityType;", "startTeleportTask", "stopTeleportTask", "removeNPC", "getNPCByUUID", "getNPCByInteraction", "interaction", "Lorg/bukkit/entity/Entity;", "saveNPCs", "loadNPCs", "getNPCs", "", "updateNPC", "rbnpcspawnernewverison"})
@SourceDebugExtension(value={"SMAP\nRbnpcspawnernewverison.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Rbnpcspawnernewverison.kt\nme/robbot/rbnpcspawnernewverison/NPCManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1372:1\n1#2:1373\n296#3,2:1374\n296#3,2:1376\n296#3,2:1378\n296#3,2:1380\n1924#3,3:1382\n363#3,7:1385\n296#3,2:1392\n296#3,2:1394\n1915#3:1396\n1924#3,3:1397\n1916#3:1400\n1915#3:1401\n1915#3,2:1402\n1915#3,2:1404\n1916#3:1406\n1915#3,2:1407\n*S KotlinDebug\n*F\n+ 1 Rbnpcspawnernewverison.kt\nme/robbot/rbnpcspawnernewverison/NPCManager\n*L\n213#1:1374,2\n220#1:1376,2\n291#1:1378,2\n298#1:1380,2\n333#1:1382,3\n472#1:1385,7\n252#1:1392,2\n262#1:1394,2\n425#1:1396\n426#1:1397,3\n425#1:1400\n432#1:1401\n434#1:1402,2\n445#1:1404,2\n432#1:1406\n451#1:1407,2\n*E\n"})
public final class NPCManager {
    @NotNull
    private final NPCSpawner plugin;
    @NotNull
    private final List<NPCData> npcs;
    @NotNull
    private final File dataFile;
    private int teleportTask;

    public NPCManager(@NotNull NPCSpawner plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
        this.npcs = new ArrayList();
        this.dataFile = new File(this.plugin.getDataFolder(), "npcs.yml");
        this.teleportTask = -1;
    }

    @NotNull
    public final NPCSpawner getPlugin() {
        return this.plugin;
    }

    public final void createNPC(@NotNull Player player, @NotNull NPCData npcData) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(npcData, "npcData");
        this.npcs.add(npcData);
        this.plugin.getLogger().info("\ud83d\udcdd Added NPC to list: " + npcData.getDisplayName() + ", total NPCs: " + this.npcs.size());
        this.spawnNPC(npcData);
        this.saveNPCs();
        this.plugin.getLogger().info("\u2705 NPC created and saved immediately: " + npcData.getDisplayName());
    }

    private final void spawnNPC(NPCData npcData) {
        Location location = npcData.getLocation();
        if (location == null) {
            return;
        }
        Location location2 = location;
        World world = location2.getWorld();
        if (world == null) {
            return;
        }
        World world2 = world;
        this.removeExistingEntities(npcData.getUuid());
        try {
            Entity entity = world2.spawnEntity(location2, npcData.getEntityType());
            Intrinsics.checkNotNullExpressionValue(entity, "spawnEntity(...)");
            Entity mobEntity = entity;
            String string = npcData.getNameTag();
            if (string != null) {
                String name = string;
                boolean bl = false;
                mobEntity.setCustomName(npcData.getNameTagColor() + name);
                mobEntity.setCustomNameVisible(true);
            }
            mobEntity.setMetadata("npc_uuid", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)npcData.getUuid()));
            mobEntity.setMetadata("npc_data", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)npcData));
            if (!npcData.getCanMove()) {
                Entity entity2 = mobEntity;
                if (entity2 instanceof Mob) {
                    ((Mob)mobEntity).setAI(false);
                } else if (entity2 instanceof LivingEntity) {
                    mobEntity.addScoreboardTag("immobile");
                }
            }
            mobEntity.setInvulnerable(!npcData.getCanTakeDamage());
            if (!npcData.getCanMakeNoise()) {
                mobEntity.setSilent(true);
            }
            mobEntity.setGlowing(true);
            Entity entity3 = world2.spawnEntity(location2, EntityType.INTERACTION);
            Intrinsics.checkNotNull(entity3, "null cannot be cast to non-null type org.bukkit.entity.Interaction");
            Interaction interaction = (Interaction)entity3;
            interaction.setMetadata("npc_uuid", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)npcData.getUuid()));
            interaction.setMetadata("interaction_entity", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)true));
            interaction.setMetadata("npc_command", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)npcData.getExecutionCommand()));
            interaction.setMetadata("npc_full_uuid", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)npcData.getUuid()));
            Pair<Float, Float> pair = this.getInteractionSize(npcData.getEntityType());
            float width = ((Number)pair.component1()).floatValue();
            float height = ((Number)pair.component2()).floatValue();
            interaction.setInteractionWidth(width);
            interaction.setInteractionHeight(height);
            String string2 = interaction.getUniqueId().toString();
            Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
            npcData.setInteractionUUID(string2);
            interaction.setInvisible(true);
            interaction.setSilent(true);
            this.plugin.getLogger().info("\ud83c\udfaf Spawned NPC '" + npcData.getDisplayName() + "' with command: '" + npcData.getExecutionCommand() + "'");
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("\u274c Failed to spawn NPC: " + e.getMessage());
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void removeExistingEntities(String uuid) {
        block12: {
            block10: {
                block9: {
                    var5_2 = this.npcs;
                    for (T var7_4 : var5_2) {
                        it = (NPCData)var7_4;
                        $i$a$-find-NPCManager$removeExistingEntities$npcData$1 = false;
                        if (!Intrinsics.areEqual(it.getUuid(), uuid)) continue;
                        v0 = var7_4;
                        break block9;
                    }
                    v0 = null;
                }
                v1 = v0;
                if (v1 == null) {
                    return;
                }
                npcData = v1;
                v2 = location = npcData.getLocation();
                v3 /* !! */  = world = v2 != null ? v2.getWorld() : null;
                if (world == null || (var5_2 = world.getEntities()) == null) break block12;
                $this$firstOrNull$iv = var5_2;
                $i$f$firstOrNull = false;
                for (T element$iv : $this$firstOrNull$iv) {
                    entity = (Entity)element$iv;
                    $i$a$-firstOrNull-NPCManager$removeExistingEntities$1 = false;
                    if (!entity.hasMetadata("npc_uuid")) ** GOTO lbl-1000
                    v4 = entity.getMetadata("npc_uuid");
                    Intrinsics.checkNotNullExpressionValue(v4, "getMetadata(...)");
                    if (Intrinsics.areEqual(((MetadataValue)CollectionsKt.first(v4)).asString(), uuid) && entity.getType() != EntityType.INTERACTION) {
                        v5 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v5 = false;
                    }
                    if (!v5) continue;
                    v6 = element$iv;
                    break block10;
                }
                v6 = null;
            }
            var6_3 = v6;
            if (var6_3 != null) {
                var6_3.remove();
            }
        }
        if (world != null && (var5_2 = world.getEntities()) != null) {
            block11: {
                $this$firstOrNull$iv = var5_2;
                $i$f$firstOrNull = false;
                for (T element$iv : $this$firstOrNull$iv) {
                    entity = (Entity)element$iv;
                    $i$a$-firstOrNull-NPCManager$removeExistingEntities$2 = false;
                    if (!Intrinsics.areEqual(entity.getUniqueId().toString(), npcData.getInteractionUUID())) continue;
                    v7 = element$iv;
                    break block11;
                }
                v7 = null;
            }
            var6_3 = v7;
            if (var6_3 != null) {
                var6_3.remove();
            }
        }
        this.plugin.getLogger().info("\ud83d\uddd1\ufe0f Removed existing entities for NPC: " + npcData.getDisplayName());
    }

    private final Pair<Float, Float> getInteractionSize(EntityType entityType) {
        return switch (WhenMappings.$EnumSwitchMapping$0[entityType.ordinal()]) {
            case 1 -> TuplesKt.to(Float.valueOf(0.8f), Float.valueOf(2.0f));
            case 2 -> TuplesKt.to(Float.valueOf(0.8f), Float.valueOf(2.0f));
            case 3 -> TuplesKt.to(Float.valueOf(0.8f), Float.valueOf(2.0f));
            case 4 -> TuplesKt.to(Float.valueOf(0.8f), Float.valueOf(1.8f));
            case 5 -> TuplesKt.to(Float.valueOf(1.2f), Float.valueOf(1.6f));
            case 6 -> TuplesKt.to(Float.valueOf(1.2f), Float.valueOf(1.2f));
            case 7 -> TuplesKt.to(Float.valueOf(1.2f), Float.valueOf(1.4f));
            case 8 -> TuplesKt.to(Float.valueOf(0.6f), Float.valueOf(0.8f));
            case 9 -> TuplesKt.to(Float.valueOf(1.8f), Float.valueOf(2.9f));
            case 10 -> TuplesKt.to(Float.valueOf(0.8f), Float.valueOf(2.0f));
            case 11 -> TuplesKt.to(Float.valueOf(0.8f), Float.valueOf(3.0f));
            default -> TuplesKt.to(Float.valueOf(0.8f), Float.valueOf(1.8f));
        };
    }

    public final void startTeleportTask() {
        this.teleportTask = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, () -> NPCManager.startTeleportTask$lambda$0(this), 0L, 1L);
    }

    public final void stopTeleportTask() {
        if (this.teleportTask != -1) {
            Bukkit.getScheduler().cancelTask(this.teleportTask);
            this.teleportTask = -1;
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public final void removeNPC(@NotNull String uuid) {
        block12: {
            block10: {
                block9: {
                    Intrinsics.checkNotNullParameter(uuid, "uuid");
                    var5_2 = this.npcs;
                    for (T var7_4 : var5_2) {
                        it = (NPCData)var7_4;
                        $i$a$-find-NPCManager$removeNPC$npcData$1 = false;
                        if (!Intrinsics.areEqual(it.getUuid(), uuid)) continue;
                        v0 = var7_4;
                        break block9;
                    }
                    v0 = null;
                }
                v1 = v0;
                if (v1 == null) {
                    return;
                }
                npcData = v1;
                v2 = location = npcData.getLocation();
                v3 /* !! */  = world = v2 != null ? v2.getWorld() : null;
                if (world == null || (var5_2 = world.getEntities()) == null) break block12;
                $this$firstOrNull$iv = var5_2;
                $i$f$firstOrNull = false;
                for (T element$iv : $this$firstOrNull$iv) {
                    entity = (Entity)element$iv;
                    $i$a$-firstOrNull-NPCManager$removeNPC$1 = false;
                    if (!entity.hasMetadata("npc_uuid")) ** GOTO lbl-1000
                    v4 = entity.getMetadata("npc_uuid");
                    Intrinsics.checkNotNullExpressionValue(v4, "getMetadata(...)");
                    if (Intrinsics.areEqual(((MetadataValue)CollectionsKt.first(v4)).asString(), uuid) && entity.getType() != EntityType.INTERACTION) {
                        v5 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v5 = false;
                    }
                    if (!v5) continue;
                    v6 = element$iv;
                    break block10;
                }
                v6 = null;
            }
            var6_3 = v6;
            if (var6_3 != null) {
                var6_3.remove();
            }
        }
        if (world != null && (var5_2 = world.getEntities()) != null) {
            block11: {
                $this$firstOrNull$iv = var5_2;
                $i$f$firstOrNull = false;
                for (T element$iv : $this$firstOrNull$iv) {
                    entity = (Entity)element$iv;
                    $i$a$-firstOrNull-NPCManager$removeNPC$2 = false;
                    if (!Intrinsics.areEqual(entity.getUniqueId().toString(), npcData.getInteractionUUID())) continue;
                    v7 = element$iv;
                    break block11;
                }
                v7 = null;
            }
            var6_3 = v7;
            if (var6_3 != null) {
                var6_3.remove();
            }
        }
        this.npcs.remove(npcData);
        this.saveNPCs();
        this.plugin.getLogger().info("\ud83d\uddd1\ufe0f Removed NPC '" + npcData.getDisplayName() + "' and saved changes");
    }

    @Nullable
    public final NPCData getNPCByUUID(@NotNull String uuid) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(uuid, "uuid");
            Iterable iterable = this.npcs;
            for (Object t : iterable) {
                NPCData it = (NPCData)t;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getUuid(), uuid)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Nullable
    public final NPCData getNPCByInteraction(@NotNull Entity interaction) {
        Intrinsics.checkNotNullParameter(interaction, "interaction");
        if (!interaction.hasMetadata("npc_uuid")) {
            return null;
        }
        List list = interaction.getMetadata("npc_uuid");
        Intrinsics.checkNotNullExpressionValue(list, "getMetadata(...)");
        String string = ((MetadataValue)CollectionsKt.first(list)).asString();
        Intrinsics.checkNotNullExpressionValue(string, "asString(...)");
        String uuid = string;
        return this.getNPCByUUID(uuid);
    }

    /*
     * WARNING - void declaration
     */
    public final void saveNPCs() {
        if (!this.plugin.getDataFolder().exists()) {
            this.plugin.getDataFolder().mkdirs();
        }
        try {
            YamlConfiguration yamlConfig = new YamlConfiguration();
            yamlConfig.set("npcs", null);
            Iterable $this$forEachIndexed$iv = this.npcs;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void npcData;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                NPCData nPCData = (NPCData)item$iv;
                int index = n;
                boolean bl = false;
                String npcPath = "npcs." + index;
                yamlConfig.set(npcPath + ".uuid", (Object)npcData.getUuid());
                yamlConfig.set(npcPath + ".entityType", (Object)npcData.getEntityType());
                yamlConfig.set(npcPath + ".nameTag", (Object)npcData.getNameTag());
                yamlConfig.set(npcPath + ".nameTagColor", (Object)npcData.getNameTagColor());
                yamlConfig.set(npcPath + ".executionCommand", (Object)npcData.getExecutionCommand());
                yamlConfig.set(npcPath + ".commandRunner", (Object)npcData.getCommandRunner());
                yamlConfig.set(npcPath + ".canMove", (Object)npcData.getCanMove());
                yamlConfig.set(npcPath + ".canTakeDamage", (Object)npcData.getCanTakeDamage());
                yamlConfig.set(npcPath + ".canMakeNoise", (Object)npcData.getCanMakeNoise());
                yamlConfig.set(npcPath + ".world", (Object)npcData.getWorld());
                yamlConfig.set(npcPath + ".x", (Object)npcData.getX());
                yamlConfig.set(npcPath + ".y", (Object)npcData.getY());
                yamlConfig.set(npcPath + ".z", (Object)npcData.getZ());
                yamlConfig.set(npcPath + ".yaw", (Object)npcData.getYaw());
                yamlConfig.set(npcPath + ".pitch", (Object)npcData.getPitch());
                yamlConfig.set(npcPath + ".interactionUUID", (Object)npcData.getInteractionUUID());
            }
            yamlConfig.set("npc-count", (Object)this.npcs.size());
            yamlConfig.save(this.dataFile);
            this.plugin.getLogger().info("\ud83d\udcbe SAVED " + this.npcs.size() + " NPCs to YAML file: " + this.dataFile.getAbsolutePath());
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("\u274c Failed to save NPCs: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public final void loadNPCs() {
        if (!this.dataFile.exists()) {
            this.plugin.getLogger().info("\ud83d\udcdd No NPCs file found at: " + this.dataFile.getAbsolutePath() + " - Creating new file");
            this.saveNPCs();
            return;
        }
        try {
            YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)this.dataFile);
            Intrinsics.checkNotNullExpressionValue(yamlConfiguration, "loadConfiguration(...)");
            YamlConfiguration yamlConfig = yamlConfiguration;
            this.npcs.clear();
            if (!yamlConfig.contains("npcs")) {
                this.plugin.getLogger().info("\u2139\ufe0f No NPCs found in YAML file");
                return;
            }
            int npcCount = yamlConfig.getInt("npc-count", 0);
            this.plugin.getLogger().info("\ud83d\udce5 Loading " + npcCount + " NPCs from YAML file");
            for (int i = 0; i < npcCount; ++i) {
                try {
                    String string;
                    String string2;
                    String string3;
                    String npcPath = "npcs." + i;
                    if (!yamlConfig.contains(npcPath + ".uuid")) continue;
                    String string4 = yamlConfig.getString(npcPath + ".uuid");
                    if (string4 == null) {
                        String string5 = UUID.randomUUID().toString();
                        string4 = string5;
                        Intrinsics.checkNotNullExpressionValue(string5, "toString(...)");
                    }
                    if ((string3 = yamlConfig.getString(npcPath + ".entityType")) == null) {
                        string3 = "VILLAGER";
                    }
                    String string6 = yamlConfig.getString(npcPath + ".nameTag");
                    String string7 = yamlConfig.getString(npcPath + ".nameTagColor");
                    if (string7 == null) {
                        string7 = "\u00a7f";
                    }
                    if ((string2 = yamlConfig.getString(npcPath + ".executionCommand")) == null) {
                        string2 = "";
                    }
                    if ((string = yamlConfig.getString(npcPath + ".commandRunner")) == null) {
                        string = "console";
                    }
                    boolean bl = yamlConfig.getBoolean(npcPath + ".canMove", true);
                    boolean bl2 = yamlConfig.getBoolean(npcPath + ".canTakeDamage", true);
                    boolean bl3 = yamlConfig.getBoolean(npcPath + ".canMakeNoise", true);
                    String string8 = yamlConfig.getString(npcPath + ".world");
                    if (string8 == null) {
                        string8 = "world";
                    }
                    double d = yamlConfig.getDouble(npcPath + ".x", 0.0);
                    double d2 = yamlConfig.getDouble(npcPath + ".y", 0.0);
                    double d3 = yamlConfig.getDouble(npcPath + ".z", 0.0);
                    float f = (float)yamlConfig.getDouble(npcPath + ".yaw", 0.0);
                    float f2 = (float)yamlConfig.getDouble(npcPath + ".pitch", 0.0);
                    String string9 = yamlConfig.getString(npcPath + ".interactionUUID");
                    if (string9 == null) {
                        string9 = "";
                    }
                    NPCData npcData = new NPCData(string4, string3, string6, string7, string2, string, bl, bl2, bl3, string8, d, d2, d3, f, f2, string9);
                    this.npcs.add(npcData);
                    this.plugin.getLogger().info("\u2705 Loaded NPC: " + npcData.getDisplayName() + " with command: '" + npcData.getExecutionCommand() + "' (Runner: " + npcData.getCommandRunner() + ")");
                    continue;
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning("\u274c Failed to load NPC " + i + ": " + e.getMessage());
                }
            }
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> NPCManager.loadNPCs$lambda$0(this), 60L);
            this.plugin.getLogger().info("\ud83c\udf89 Successfully loaded " + this.npcs.size() + " NPCs from YAML file");
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("\u274c Failed to load NPCs: " + e.getMessage());
            e.printStackTrace();
        }
    }

    @NotNull
    public final List<NPCData> getNPCs() {
        return CollectionsKt.toList((Iterable)this.npcs);
    }

    public final void updateNPC(@NotNull NPCData npcData) {
        int index;
        block3: {
            int n;
            Intrinsics.checkNotNullParameter(npcData, "npcData");
            List<NPCData> $this$indexOfFirst$iv = this.npcs;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<NPCData> iterator2 = $this$indexOfFirst$iv.iterator();
            while (iterator2.hasNext()) {
                NPCData item$iv;
                NPCData it = item$iv = iterator2.next();
                boolean bl = false;
                if (Intrinsics.areEqual(it.getUuid(), npcData.getUuid())) {
                    n = index$iv;
                    break block3;
                }
                ++index$iv;
            }
            n = index = -1;
        }
        if (index != -1) {
            this.npcs.set(index, npcData);
            this.saveNPCs();
            this.plugin.getLogger().info("\u270f\ufe0f Updated and saved NPC: " + npcData.getDisplayName());
        }
    }

    /*
     * Unable to fully structure code
     */
    private static final void startTeleportTask$lambda$0(NPCManager this$0) {
        for (NPCData npcData : this$0.npcs) {
            block7: {
                block6: {
                    if (npcData.getLocation() == null || mobLocation.getWorld() == null) continue;
                    v0 = world.getEntities();
                    Intrinsics.checkNotNullExpressionValue(v0, "getEntities(...)");
                    $this$firstOrNull$iv = v0;
                    $i$f$firstOrNull = false;
                    for (T element$iv : $this$firstOrNull$iv) {
                        entity = (Entity)element$iv;
                        $i$a$-firstOrNull-NPCManager$startTeleportTask$1$mobEntity$1 = false;
                        if (!entity.hasMetadata("npc_uuid")) ** GOTO lbl-1000
                        v1 = entity.getMetadata("npc_uuid");
                        Intrinsics.checkNotNullExpressionValue(v1, "getMetadata(...)");
                        if (Intrinsics.areEqual(((MetadataValue)CollectionsKt.first(v1)).asString(), npcData.getUuid()) && entity.getType() != EntityType.INTERACTION) {
                            v2 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v2 = false;
                        }
                        if (!v2) continue;
                        v3 = element$iv;
                        break block6;
                    }
                    v3 = null;
                }
                if ((Entity)v3 == null) continue;
                v4 = mobEntity.getLocation();
                Intrinsics.checkNotNullExpressionValue(v4, "getLocation(...)");
                npcData.setLocation(v4);
                v5 = world.getEntities();
                Intrinsics.checkNotNullExpressionValue(v5, "getEntities(...)");
                $this$firstOrNull$iv = v5;
                $i$f$firstOrNull = false;
                for (T element$iv : $this$firstOrNull$iv) {
                    entity = (Entity)element$iv;
                    $i$a$-firstOrNull-NPCManager$startTeleportTask$1$interaction$1 = false;
                    if (!Intrinsics.areEqual(entity.getUniqueId().toString(), npcData.getInteractionUUID())) continue;
                    v6 = element$iv;
                    break block7;
                }
                v6 = var8_9 = null;
            }
            if ((var8_9 instanceof Interaction != false ? (Interaction)var8_9 : null) == null) continue;
            interaction = interaction;
            interaction.teleport(mobEntity.getLocation());
            if (interaction.hasMetadata("npc_command")) {
                v7 = interaction.getMetadata("npc_command");
                Intrinsics.checkNotNullExpressionValue(v7, "getMetadata(...)");
                if (Intrinsics.areEqual(((MetadataValue)CollectionsKt.first(v7)).asString(), npcData.getExecutionCommand())) continue;
            }
            interaction.setMetadata("npc_command", (MetadataValue)new FixedMetadataValue((Plugin)this$0.plugin, (Object)npcData.getExecutionCommand()));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void loadNPCs$lambda$0(NPCManager this$0) {
        World world;
        this$0.plugin.getLogger().info("\ud83d\uddd1\ufe0f Cleaning up ALL old NPC entities before respawning...");
        this$0.plugin.getLogger().info("\ud83d\udd0d DEBUG: All entities before cleanup:");
        List list = Bukkit.getWorlds();
        Intrinsics.checkNotNullExpressionValue(list, "getWorlds(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            world = (World)element$iv;
            boolean bl = false;
            List list2 = world.getEntities();
            Intrinsics.checkNotNullExpressionValue(list2, "getEntities(...)");
            Iterable $this$forEachIndexed$iv = list2;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void entity;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Entity entity2 = (Entity)item$iv;
                int index = n;
                boolean bl2 = false;
                this$0.plugin.getLogger().info("  Entity " + index + ": " + entity.getType() + " at " + entity.getLocation().getX() + "," + entity.getLocation().getY() + "," + entity.getLocation().getZ() + " - Glowing: " + entity.isGlowing() + " - CustomName: " + entity.getCustomName());
            }
        }
        List list3 = Bukkit.getWorlds();
        Intrinsics.checkNotNullExpressionValue(list3, "getWorlds(...)");
        $this$forEach$iv = list3;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            world = (World)element$iv;
            boolean bl = false;
            List entitiesToRemove = new ArrayList();
            List list4 = world.getEntities();
            Intrinsics.checkNotNullExpressionValue(list4, "getEntities(...)");
            Iterable $this$forEach$iv2 = list4;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Entity entity = (Entity)element$iv2;
                boolean bl3 = false;
                if (!entity.hasMetadata("npc_uuid") && !entity.hasMetadata("interaction_entity") && entity.getType() != EntityType.INTERACTION && (!entity.isGlowing() || entity instanceof Player) && (!(entity instanceof LivingEntity) || ((LivingEntity)entity).getCustomName() == null || ((LivingEntity)entity).hasAI())) continue;
                Intrinsics.checkNotNull(entity);
                entitiesToRemove.add(entity);
                this$0.plugin.getLogger().info("\ud83d\uddd1\ufe0f Marked for removal: " + entity.getType() + " at " + entity.getLocation().getX() + "," + entity.getLocation().getY() + "," + entity.getLocation().getZ());
            }
            $this$forEach$iv2 = entitiesToRemove;
            $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Entity it = (Entity)element$iv2;
                boolean bl4 = false;
                it.remove();
            }
            this$0.plugin.getLogger().info("\ud83e\uddf9 Cleaned up " + entitiesToRemove.size() + " entities from world " + world.getName());
        }
        this$0.plugin.getLogger().info("\ud83d\udd04 Respawning " + this$0.npcs.size() + " NPCs...");
        $this$forEach$iv = this$0.npcs;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NPCData it = (NPCData)element$iv;
            boolean bl = false;
            this$0.spawnNPC(it);
            this$0.plugin.getLogger().info("\ud83d\udd27 Spawned NPC: " + it.getDisplayName() + " -> '" + it.getExecutionCommand() + "'");
        }
        this$0.plugin.getLogger().info("\u2705 All NPCs have been properly cleaned and respawned");
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EntityType.values().length];
            try {
                nArray[EntityType.VILLAGER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EntityType.ZOMBIE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EntityType.SKELETON.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EntityType.CREEPER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EntityType.COW.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EntityType.PIG.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EntityType.SHEEP.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EntityType.CHICKEN.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EntityType.IRON_GOLEM.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EntityType.WITCH.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EntityType.ENDERMAN.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

