/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1087;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_918;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.IDynamicRenderTracker;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;

public class DynamicRenderTracker
implements IDynamicRenderTracker {
    private static final int DYNAMIC_CHECK_WINDOW_TICKS = 100;
    private static final int MAX_ITEM_CHANGES_IN_WINDOW = 4;
    private long lastItemChangeTime = 0L;
    private final int[] itemChangeExpirationTimes = new int[4];
    private boolean dynamicRenderer = false;
    private boolean fullyDynamic = false;
    private final List<class_1799> lastRenderedItems = new ArrayList<class_1799>();
    private final StorageBlockEntity storageBlockEntity;

    public DynamicRenderTracker(StorageBlockEntity storageBlockEntity) {
        this.storageBlockEntity = storageBlockEntity;
    }

    @Override
    public void onRenderInfoUpdated(RenderInfo ri) {
        if (this.getLevel().field_9236) {
            RenderInfo.ItemDisplayRenderInfo itemDisplayRenderInfo = ri.getItemDisplayRenderInfo();
            List displayItems = itemDisplayRenderInfo.getDisplayItems();
            if (displayItems.isEmpty()) {
                this.lastRenderedItems.clear();
                this.dynamicRenderer = false;
                return;
            }
            if (this.renderedItemsHaventChanged(displayItems)) {
                return;
            }
            this.updateDynamicFlags(displayItems);
        } else {
            WorldHelper.notifyBlockUpdate((class_2586)this.storageBlockEntity);
        }
    }

    private void updateDynamicFlags(List<RenderInfo.DisplayItem> displayItems) {
        this.lastRenderedItems.clear();
        displayItems.forEach(displayItem -> this.lastRenderedItems.add(displayItem.getItem()));
        boolean wasDynamic = this.dynamicRenderer;
        boolean wasFullyDynamic = this.fullyDynamic;
        this.fullyDynamic = !displayItems.isEmpty();
        this.dynamicRenderer = false;
        for (RenderInfo.DisplayItem displayItem2 : displayItems) {
            if (this.hasItemModelCustomRenderer(displayItem2.getItem())) {
                this.dynamicRenderer = true;
                continue;
            }
            this.fullyDynamic = false;
        }
        if (!this.updateItemChangeExpirations()) {
            this.dynamicRenderer = true;
            this.fullyDynamic = true;
        }
        if (this.dynamicRenderer != wasDynamic || this.fullyDynamic != wasFullyDynamic) {
            WorldHelper.notifyBlockUpdate((class_2586)this.storageBlockEntity);
        }
    }

    private boolean renderedItemsHaventChanged(List<RenderInfo.DisplayItem> displayItems) {
        if (this.lastRenderedItems.size() != displayItems.size()) {
            return false;
        }
        for (int i = 0; i < this.lastRenderedItems.size(); ++i) {
            if (class_1799.method_31577((class_1799)this.lastRenderedItems.get(i), (class_1799)displayItems.get(i).getItem())) continue;
            return false;
        }
        return true;
    }

    private boolean hasItemModelCustomRenderer(class_1799 item) {
        class_310 minecraft = class_310.method_1551();
        class_918 itemRenderer = minecraft.method_1480();
        class_1087 model = itemRenderer.method_4019(item, null, (class_1309)minecraft.field_1724, 0);
        return model.method_4713();
    }

    private boolean updateItemChangeExpirations() {
        boolean timeSet = false;
        int timeDiff = (int)Math.min(100L, this.getLevel().method_8510() - this.lastItemChangeTime);
        this.lastItemChangeTime = this.getLevel().method_8510();
        for (int i = 0; i < this.itemChangeExpirationTimes.length; ++i) {
            int val = Math.max(0, this.itemChangeExpirationTimes[i] - timeDiff);
            if (!timeSet && val == 0) {
                timeSet = true;
                val = 100;
            }
            this.itemChangeExpirationTimes[i] = val;
        }
        return timeSet;
    }

    private class_1937 getLevel() {
        return this.storageBlockEntity.method_10997();
    }

    @Override
    public boolean isDynamicRenderer() {
        return this.dynamicRenderer;
    }

    @Override
    public boolean isFullyDynamicRenderer() {
        return this.fullyDynamic;
    }
}

