/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2494;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5819;
import net.minecraft.class_7225;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.upgrades.voiding.VoidUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedcore.util.CapabilityHelper;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.RandHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.ICountDisplay;
import net.p3pp3rf1y.sophisticatedstorage.block.IFillLevelDisplay;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;

public class LimitedBarrelBlockEntity
extends BarrelBlockEntity
implements ICountDisplay,
IFillLevelDisplay {
    private static final String SLOT_COUNTS_TAG = "slotCounts";
    private static final String SLOT_FILL_LEVELS_TAG = "slotFillLevels";
    public static final Consumer<VoidUpgradeWrapper> VOID_UPGRADE_VOIDING_OVERFLOW_OF_EVERYTHING_BY_DEFAULT = voidUpgrade -> {
        voidUpgrade.getFilterLogic().setAllowByDefault(false);
        voidUpgrade.setShouldVoidOverflowDefaultOrLoadFromNbt(true);
    };
    public static final String STORAGE_TYPE = "limited_barrel";
    private long lastDepositTime = -100L;
    private final List<Integer> slotCounts = new ArrayList<Integer>();
    private final List<Float> slotFillLevels = new ArrayList<Float>();
    private Map<Integer, class_1767> slotColors = new HashMap<Integer, class_1767>();
    private boolean showCounts = true;
    private boolean showFillLevels = false;

    public LimitedBarrelBlockEntity(class_2338 pos, class_2680 state) {
        super(pos, state, (class_2591<? extends BarrelBlockEntity>)ModBlocks.LIMITED_BARREL_BLOCK_ENTITY_TYPE.get());
        this.registerUpgradeDefaults();
        this.registerClientNotificationOnCountChange();
    }

    private void registerUpgradeDefaults() {
        this.getStorageWrapper().registerUpgradeDefaultsHandler(VoidUpgradeWrapper.class, VOID_UPGRADE_VOIDING_OVERFLOW_OF_EVERYTHING_BY_DEFAULT);
    }

    private void registerClientNotificationOnCountChange() {
        this.getStorageWrapper().getInventoryHandler().addListener(slot -> WorldHelper.notifyBlockUpdate((class_2586)this));
    }

    @Override
    protected void onUpgradeCachesInvalidated() {
        super.onUpgradeCachesInvalidated();
        this.registerClientNotificationOnCountChange();
    }

    @Override
    public boolean shouldShowCounts() {
        return this.showCounts;
    }

    @Override
    public boolean memorizesItemsWhenLocked() {
        return true;
    }

    @Override
    public boolean allowsEmptySlotsMatchingItemInsertsWhenLocked() {
        return false;
    }

    @Override
    public void toggleCountVisibility() {
        this.showCounts = !this.showCounts;
        this.method_5431();
        WorldHelper.notifyBlockUpdate((class_2586)this);
    }

    @Override
    public List<Integer> getSlotCounts() {
        return this.slotCounts;
    }

    @Override
    public List<Float> getSlotFillLevels() {
        return this.slotFillLevels;
    }

    @Override
    public float getSlotFillPercentage(int slot) {
        return slot > -1 && slot < this.slotFillLevels.size() ? this.slotFillLevels.get(slot).floatValue() : 0.0f;
    }

    @Override
    public boolean shouldShowFillLevels() {
        return this.showFillLevels;
    }

    @Override
    public void toggleFillLevelVisibility() {
        this.showFillLevels = !this.showFillLevels;
        this.method_5431();
        WorldHelper.notifyBlockUpdate((class_2586)this);
    }

    public boolean applyDye(int slot, class_1799 dyeStack, class_1767 dyeColor, boolean applyToAll) {
        if (slot < 0 || slot >= this.getStorageWrapper().getInventoryHandler().getSlotCount()) {
            return false;
        }
        StorageWrapper storageWrapper = this.getStorageWrapper();
        InventoryHandler invHandler = storageWrapper.getInventoryHandler();
        if (applyToAll) {
            boolean success = false;
            for (int i = 0; i < invHandler.getSlotCount(); ++i) {
                success |= this.applyDye(i, dyeColor, invHandler);
            }
            if (!success) {
                return false;
            }
        } else if (!this.applyDye(slot, dyeColor, invHandler)) {
            return false;
        }
        this.method_5431();
        dyeStack.method_7934(1);
        WorldHelper.notifyBlockUpdate((class_2586)this);
        return true;
    }

    private boolean applyDye(int slot, class_1767 dyeColor, InventoryHandler invHandler) {
        class_1799 stackInSlot = invHandler.getStackInSlot(slot);
        if (stackInSlot.method_7960() || dyeColor.equals((Object)this.slotColors.get(slot))) {
            return false;
        }
        this.slotColors.put(slot, dyeColor);
        return true;
    }

    public int getSlotColor(int slot) {
        return this.slotColors.getOrDefault(slot, class_1767.field_7952).method_16357();
    }

    public boolean depositItem(class_1657 player, class_1268 hand, class_1799 stackInHand, int slot) {
        long gameTime = this.method_10997().method_8510();
        boolean doubleClick = gameTime - this.lastDepositTime < 10L;
        this.lastDepositTime = gameTime;
        StorageWrapper storageWrapper = this.getStorageWrapper();
        InventoryHandler invHandler = storageWrapper.getInventoryHandler();
        class_1799 stackInSlot = invHandler.getStackInSlot(slot);
        MemorySettingsCategory memorySettings = (MemorySettingsCategory)this.getStorageWrapper().getSettingsHandler().getTypeCategory(MemorySettingsCategory.class);
        if (doubleClick) {
            return this.depositFromAllOfPlayersInventory(player, slot, invHandler, stackInSlot, memorySettings);
        }
        if (stackInSlot.method_7960()) {
            if (invHandler.isItemValid(slot, stackInHand, player)) {
                int stackLimit = invHandler.getStackLimit(slot, stackInHand);
                invHandler.setStackInSlot(slot, stackInHand.method_7971(stackLimit));
                if (this.isLocked()) {
                    memorySettings.selectSlot(slot);
                }
                if (stackInHand.method_7960()) {
                    player.method_6122(hand, class_1799.field_8037);
                }
                return true;
            }
        } else {
            class_1799 result = invHandler.insertItemOnlyToSlot(slot, stackInHand, true);
            if (result.method_7947() != stackInHand.method_7947()) {
                result = invHandler.insertItemOnlyToSlot(slot, stackInHand, false);
                if (this.isLocked()) {
                    memorySettings.selectSlot(slot);
                }
                player.method_6122(hand, result);
                return true;
            }
        }
        return false;
    }

    private boolean depositFromAllOfPlayersInventory(class_1657 player, int slot, InventoryHandler invHandler, class_1799 stackInSlot, MemorySettingsCategory memorySettings) {
        AtomicBoolean success = new AtomicBoolean(false);
        Predicate<class_1799> memoryItemMatches = itemStack -> memorySettings.isSlotSelected(slot) && memorySettings.matchesFilter(slot, itemStack);
        CapabilityHelper.runOnItemHandler((class_1297)player, inventoryHandler -> InventoryHelper.iterate((SlottedStorage)inventoryHandler, (playerSlot, playerStack) -> {
            class_1799 extracted;
            class_1799 result;
            if ((stackInSlot.method_7960() && (memoryItemMatches.test((class_1799)playerStack) || invHandler.isFilterItem(playerStack.method_7909())) || !playerStack.method_7960() && class_1799.method_31577((class_1799)stackInSlot, (class_1799)playerStack)) && (result = invHandler.insertItemOnlyToSlot(slot, playerStack, true)).method_7947() < playerStack.method_7947() && !(extracted = inventoryHandler.extractItem(playerSlot.intValue(), playerStack.method_7947() - result.method_7947(), true)).method_7960()) {
                invHandler.insertItemOnlyToSlot(slot, inventoryHandler.extractItem(playerSlot.intValue(), extracted.method_7947(), false), false);
                success.set(true);
            }
        }));
        return success.get();
    }

    boolean tryToTakeItem(class_1657 player, int slot) {
        InventoryHandler inventoryHandler = this.getStorageWrapper().getInventoryHandler();
        class_1799 stackInSlot = inventoryHandler.getStackInSlot(slot);
        if (stackInSlot.method_7960()) {
            return false;
        }
        int countToTake = player.method_5715() ? Math.min(stackInSlot.method_7914(), stackInSlot.method_7947()) : 1;
        class_1799 stackTaken = inventoryHandler.extractItem(slot, countToTake, false);
        if (player.method_31548().method_7394(stackTaken)) {
            this.method_10997().method_8396(null, this.method_11016(), class_3417.field_15197, class_3419.field_15248, 0.2f, (RandHelper.getRandomMinusOneToOne((class_5819)this.method_10997().field_9229) * 0.7f + 1.0f) * 2.0f);
        } else {
            player.method_7328(stackTaken, false);
        }
        return true;
    }

    @Override
    void updateOpenBlockState(class_2680 state, boolean open) {
    }

    @Override
    public class_2487 method_16887(class_7225.class_7874 registries) {
        class_2487 updateTag = super.method_16887(registries);
        ArrayList sc = new ArrayList();
        class_2499 sfl = new class_2499();
        InventoryHelper.iterate((SlottedStorage)this.getStorageWrapper().getInventoryHandler(), (slot, stack) -> {
            sc.add((int)slot, stack.method_7947());
            sfl.method_10531(slot.intValue(), (class_2520)class_2494.method_23244((float)((float)stack.method_7947() / (float)this.getStorageWrapper().getInventoryHandler().getStackLimit(slot.intValue(), stack))));
        });
        updateTag.method_10572(SLOT_COUNTS_TAG, sc);
        updateTag.method_10566(SLOT_FILL_LEVELS_TAG, (class_2520)sfl);
        return updateTag;
    }

    @Override
    public void loadSynchronizedData(class_2487 tag, class_7225.class_7874 registries) {
        int i;
        super.loadSynchronizedData(tag, registries);
        if (tag.method_10545(SLOT_COUNTS_TAG)) {
            int[] countsArray = tag.method_10561(SLOT_COUNTS_TAG);
            if (this.slotCounts.size() != countsArray.length) {
                this.slotCounts.clear();
                for (i = 0; i < countsArray.length; ++i) {
                    this.slotCounts.add(i, countsArray[i]);
                }
            } else {
                for (i = 0; i < countsArray.length; ++i) {
                    this.slotCounts.set(i, countsArray[i]);
                }
            }
        }
        if (tag.method_10545(SLOT_FILL_LEVELS_TAG)) {
            class_2499 fillLevelsList = tag.method_10554(SLOT_FILL_LEVELS_TAG, 5);
            if (this.slotFillLevels.size() != fillLevelsList.size()) {
                this.slotFillLevels.clear();
                for (i = 0; i < fillLevelsList.size(); ++i) {
                    this.slotFillLevels.add(i, Float.valueOf(fillLevelsList.method_10604(i)));
                }
            } else {
                for (i = 0; i < fillLevelsList.size(); ++i) {
                    this.slotFillLevels.set(i, Float.valueOf(fillLevelsList.method_10604(i)));
                }
            }
        }
        this.showCounts = NBTHelper.getBoolean((class_2487)tag, (String)"showCounts").orElse(true);
        this.showFillLevels = NBTHelper.getBoolean((class_2487)tag, (String)"showFillLevels").orElse(false);
        this.slotColors = NBTHelper.getMap((class_2487)tag, (String)"slotColors", Integer::valueOf, (tagName, t) -> Optional.of(class_1767.method_7791((int)((class_2497)t).method_10701()))).orElseGet(HashMap::new);
    }

    @Override
    protected void saveSynchronizedData(class_2487 tag) {
        super.saveSynchronizedData(tag);
        if (!this.showCounts) {
            tag.method_10556("showCounts", this.showCounts);
        }
        if (this.showFillLevels) {
            tag.method_10556("showFillLevels", this.showFillLevels);
        }
        if (!this.slotColors.isEmpty()) {
            NBTHelper.putMap((class_2487)tag, (String)"slotColors", this.slotColors, String::valueOf, color -> class_2497.method_23247((int)color.method_7789()));
        }
    }

    @Override
    protected String getStorageType() {
        return STORAGE_TYPE;
    }
}

