/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.render;

import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1058;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2745;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4719;
import net.minecraft.class_4730;
import net.minecraft.class_5603;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_5614;
import net.minecraft.class_630;
import net.minecraft.class_7833;
import net.p3pp3rf1y.sophisticatedcore.renderdata.DisplaySide;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo;
import net.p3pp3rf1y.sophisticatedstorage.block.ChestBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.ChestBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.client.ClientEventHandler;
import net.p3pp3rf1y.sophisticatedstorage.client.StorageTextureManager;
import net.p3pp3rf1y.sophisticatedstorage.client.render.DisplayItemRenderer;
import net.p3pp3rf1y.sophisticatedstorage.client.render.LockRenderer;
import net.p3pp3rf1y.sophisticatedstorage.client.render.StorageRenderer;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;

public class ChestRenderer
extends StorageRenderer<ChestBlockEntity> {
    private static final String BOTTOM = "bottom";
    private static final String LID = "lid";
    private static final String LOCK = "lock";
    private final DisplayItemRenderer displayItemRenderer = new DisplayItemRenderer(0.4378125, new class_243(-0.0625, 0.0, -0.0075));
    private final Map<class_2745, ChestSubRenderer> chestSubRenderers;

    public ChestRenderer(class_5614.class_5615 context) {
        class_630 modelpart = context.method_32140(ClientEventHandler.CHEST_LAYER);
        ChestSubRenderer singleChestRenderer = new ChestSubRenderer(class_2745.field_12569, modelpart.method_32086(LID), modelpart.method_32086(BOTTOM), modelpart.method_32086(LOCK));
        modelpart = context.method_32140(ClientEventHandler.CHEST_RIGHT_LAYER);
        ChestSubRenderer doubleChestRightRenderer = new ChestSubRenderer(class_2745.field_12571, modelpart.method_32086(LID), modelpart.method_32086(BOTTOM), modelpart.method_32086(LOCK));
        modelpart = context.method_32140(ClientEventHandler.CHEST_LEFT_LAYER);
        ChestSubRenderer doubleChestLeftRenderer = new ChestSubRenderer(class_2745.field_12574, modelpart.method_32086(LID), modelpart.method_32086(BOTTOM), modelpart.method_32086(LOCK));
        this.chestSubRenderers = Map.of(class_2745.field_12569, singleChestRenderer, class_2745.field_12571, doubleChestRightRenderer, class_2745.field_12574, doubleChestLeftRenderer);
    }

    public static class_5607 createSingleBodyLayer(boolean addLock) {
        class_5609 meshDefinition = new class_5609();
        class_5610 partDefinition = meshDefinition.method_32111();
        partDefinition.method_32117(BOTTOM, class_5606.method_32108().method_32101(0, 19).method_32097(1.0f, 0.0f, 1.0f, 14.0f, 10.0f, 14.0f), class_5603.field_27701);
        partDefinition.method_32117(LID, class_5606.method_32108().method_32101(0, 0).method_32097(1.0f, 0.0f, 0.0f, 14.0f, 5.0f, 14.0f), class_5603.method_32090((float)0.0f, (float)9.0f, (float)1.0f));
        if (addLock) {
            partDefinition.method_32117(LOCK, class_5606.method_32108().method_32101(0, 0).method_32097(7.0f, -1.0f, 15.0f, 2.0f, 4.0f, 1.0f), class_5603.method_32090((float)0.0f, (float)8.0f, (float)0.0f));
        }
        return class_5607.method_32110((class_5609)meshDefinition, (int)64, (int)64);
    }

    public static class_5607 createDoubleBodyRightLayer() {
        class_5609 meshDefinition = new class_5609();
        class_5610 partDefinition = meshDefinition.method_32111();
        partDefinition.method_32117(BOTTOM, class_5606.method_32108().method_32101(0, 19).method_32097(1.0f, 0.0f, 1.0f, 15.0f, 10.0f, 14.0f), class_5603.field_27701);
        partDefinition.method_32117(LID, class_5606.method_32108().method_32101(0, 0).method_32097(1.0f, 0.0f, 0.0f, 15.0f, 5.0f, 14.0f), class_5603.method_32090((float)0.0f, (float)9.0f, (float)1.0f));
        partDefinition.method_32117(LOCK, class_5606.method_32108().method_32101(0, 0).method_32097(15.0f, -2.0f, 14.0f, 1.0f, 4.0f, 1.0f), class_5603.method_32090((float)0.0f, (float)9.0f, (float)1.0f));
        return class_5607.method_32110((class_5609)meshDefinition, (int)64, (int)64);
    }

    public static class_5607 createDoubleBodyLeftLayer() {
        class_5609 meshDefinition = new class_5609();
        class_5610 partDefinition = meshDefinition.method_32111();
        partDefinition.method_32117(BOTTOM, class_5606.method_32108().method_32101(0, 19).method_32097(0.0f, 0.0f, 1.0f, 15.0f, 10.0f, 14.0f), class_5603.field_27701);
        partDefinition.method_32117(LID, class_5606.method_32108().method_32101(0, 0).method_32097(0.0f, 0.0f, 0.0f, 15.0f, 5.0f, 14.0f), class_5603.method_32090((float)0.0f, (float)9.0f, (float)1.0f));
        partDefinition.method_32117(LOCK, class_5606.method_32108().method_32101(0, 0).method_32097(0.0f, -2.0f, 14.0f, 1.0f, 4.0f, 1.0f), class_5603.method_32090((float)0.0f, (float)9.0f, (float)1.0f));
        return class_5607.method_32110((class_5609)meshDefinition, (int)64, (int)64);
    }

    public void render(ChestBlockEntity chestEntity, float partialTick, class_4587 poseStack, class_4597 bufferSource, int packedLight, int packedOverlay) {
        class_2680 blockstate = chestEntity.method_11010();
        Optional<class_4719> woodType = chestEntity.getWoodType();
        class_2745 chestType = (class_2745)blockstate.method_11654(ChestBlock.TYPE);
        ChestSubRenderer subRenderer = this.chestSubRenderers.get(chestType);
        if (!subRenderer.setChestMaterialsFrom(woodType.orElse(class_4719.field_21679), blockstate.method_26204())) {
            return;
        }
        poseStack.method_22903();
        class_2350 facing = (class_2350)blockstate.method_11654((class_2769)ChestBlock.FACING);
        float f = facing.method_10144();
        poseStack.method_22904(0.5, 0.5, 0.5);
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(-f));
        poseStack.method_22904(-0.5, -0.5, -0.5);
        float lidAngle = chestEntity.getOpenNess(partialTick);
        lidAngle = 1.0f - lidAngle;
        lidAngle = 1.0f - lidAngle * lidAngle * lidAngle;
        StorageWrapper storageWrapper = chestEntity.getMainStorageWrapper();
        boolean hasMainColor = storageWrapper.hasMainColor();
        boolean hasAccentColor = storageWrapper.hasAccentColor();
        if (woodType.isPresent() || !hasMainColor || !hasAccentColor) {
            subRenderer.renderBottomAndLid(poseStack, bufferSource, lidAngle, packedLight, packedOverlay, StorageTextureManager.ChestMaterial.BASE);
        }
        if (hasMainColor) {
            subRenderer.renderBottomAndLidWithTint(poseStack, bufferSource, lidAngle, packedLight, packedOverlay, storageWrapper.getMainColor(), StorageTextureManager.ChestMaterial.TINTABLE_MAIN);
        }
        if (hasAccentColor) {
            subRenderer.renderBottomAndLidWithTint(poseStack, bufferSource, lidAngle, packedLight, packedOverlay, storageWrapper.getAccentColor(), StorageTextureManager.ChestMaterial.TINTABLE_ACCENT);
        }
        if (chestEntity.shouldShowTier()) {
            subRenderer.renderTier(poseStack, bufferSource, lidAngle, packedLight, packedOverlay);
        } else if (this.holdsItemThatShowsHiddenTiers()) {
            subRenderer.renderHiddenTier(poseStack, bufferSource, packedLight, packedOverlay);
        }
        Optional displayItem = storageWrapper.getRenderInfo().getItemDisplayRenderInfo().getDisplayItem();
        if (displayItem.map(di -> di.getDisplaySide() != DisplaySide.FRONT).orElse(true).booleanValue()) {
            subRenderer.renderChestLock(poseStack, bufferSource, lidAngle, packedLight, packedOverlay);
        }
        if (chestEntity.isPacked()) {
            poseStack.method_22903();
            poseStack.method_22904(-0.005, -0.005, -0.005);
            poseStack.method_22905(1.01f, 1.01f, 1.01f);
            subRenderer.renderBottomAndLid(poseStack, bufferSource, lidAngle, packedLight, packedOverlay, StorageTextureManager.ChestMaterial.PACKED);
            poseStack.method_22909();
        } else if (chestEntity.method_11016() == class_2338.field_10980 || this.shouldRenderFrontFace(chestEntity.method_11016())) {
            poseStack.method_22903();
            poseStack.method_22904(0.5, 0.5, 0.5);
            poseStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
            poseStack.method_22903();
            poseStack.method_22904(-0.5, -0.5, -0.4375);
            if (chestEntity.isMainChest() && (chestEntity.shouldShowUpgrades() || this.holdsItemThatShowsUpgrades())) {
                poseStack.method_22903();
                if (chestType == class_2745.field_12574) {
                    poseStack.method_46416(1.0f, 0.0f, 0.0f);
                }
                if (chestEntity.showUpgradesOnTop) {
                    if (lidAngle > 0.0f) {
                        poseStack.method_22904(0.0, 0.5625, 0.875);
                        poseStack.method_22907(class_7833.field_40714.rotationDegrees(lidAngle * 90.0f));
                        poseStack.method_22904(0.0, -0.5625, -0.875);
                    }
                    poseStack.method_22904(0.5, 0.5, 0.4375);
                    poseStack.method_22907(class_7833.field_40714.rotationDegrees(90.0f));
                    poseStack.method_22904(-0.5, -0.4375, -0.375);
                }
                this.displayItemRenderer.renderUpgradeItems(chestEntity, poseStack, bufferSource, packedLight, packedOverlay, this.holdsItemThatShowsUpgrades(), this.shouldShowDisabledUpgradesDisplay(chestEntity));
                poseStack.method_22909();
            }
            if (chestEntity.isMainChest()) {
                this.renderLocked(chestEntity, poseStack, bufferSource, packedLight, packedOverlay, chestType, lidAngle);
            }
            poseStack.method_22909();
            if (chestEntity.isMainChest()) {
                displayItem.ifPresent(di -> this.renderDisplayItem((RenderInfo.DisplayItem)di, poseStack, bufferSource, packedLight, packedOverlay, chestType));
            }
            poseStack.method_22909();
        }
        poseStack.method_22909();
    }

    private void renderDisplayItem(RenderInfo.DisplayItem displayItem, class_4587 poseStack, class_4597 bufferSource, int packedLight, int packedOverlay, class_2745 chestType) {
        DisplaySide displaySide = displayItem.getDisplaySide();
        if (displaySide == DisplaySide.LEFT) {
            poseStack.method_22907(class_7833.field_40716.rotationDegrees(-90.0f));
            if (chestType == class_2745.field_12574) {
                poseStack.method_46416(0.0f, 0.0f, -1.0f);
            }
        } else if (displaySide == DisplaySide.RIGHT) {
            poseStack.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
            if (chestType == class_2745.field_12571) {
                poseStack.method_46416(0.0f, 0.0f, -1.0f);
            }
        } else if (displaySide == DisplaySide.FRONT) {
            if (chestType == class_2745.field_12571) {
                poseStack.method_22904(-0.5, 0.0, 0.0);
            } else if (chestType == class_2745.field_12574) {
                poseStack.method_22904(0.5, 0.0, 0.0);
            }
        }
        poseStack.method_22904(-0.5, -0.5, -0.4375);
        this.displayItemRenderer.renderDisplayItem(poseStack, bufferSource, packedLight, packedOverlay, displayItem);
    }

    private void renderLocked(ChestBlockEntity chestEntity, class_4587 poseStack, class_4597 bufferSource, int packedLight, int packedOverlay, class_2745 chestType, float lidAngle) {
        poseStack.method_22903();
        if (lidAngle > 0.0f) {
            poseStack.method_22904(0.0, 0.5625, 0.875);
            poseStack.method_22907(class_7833.field_40714.rotationDegrees(lidAngle * 90.0f));
            poseStack.method_22904(0.0, -0.5625, -0.875);
        }
        if (chestType == class_2745.field_12574) {
            poseStack.method_22904(0.5, 0.0, 0.0);
        } else if (chestType == class_2745.field_12571) {
            poseStack.method_22904(-0.5, 0.0, 0.0);
        }
        LockRenderer.renderLock(chestEntity, poseStack, bufferSource, packedLight, packedOverlay, 0.8125f, this::holdsToolInToggleLockOrLockDisplay);
        poseStack.method_22909();
    }

    private boolean shouldRenderFrontFace(class_2338 chestPos) {
        class_4184 camera = class_310.method_1551().field_1773.method_19418();
        return class_243.method_24953((class_2382)chestPos).method_24802((class_2374)camera.method_19326(), 32.0);
    }

    private static class ChestSubRenderer {
        private final class_2745 chestType;
        private final class_630 lidPart;
        private final class_630 bottomPart;
        private final class_630 lockPart;
        private Map<StorageTextureManager.ChestMaterial, class_4730> chestMaterials;
        private class_4730 tierMaterial;

        public ChestSubRenderer(class_2745 chestType, class_630 lidPart, class_630 bottomPart, class_630 lockPart) {
            this.chestType = chestType;
            this.lidPart = lidPart;
            this.bottomPart = bottomPart;
            this.lockPart = lockPart;
        }

        private boolean setChestMaterialsFrom(class_4719 woodType, class_2248 block) {
            this.chestMaterials = StorageTextureManager.INSTANCE.getWoodChestMaterials(this.chestType, woodType);
            if (this.chestMaterials == null) {
                return false;
            }
            this.tierMaterial = this.getTierMaterial(block);
            return true;
        }

        private void renderHiddenTier(class_4587 poseStack, class_4597 bufferSource, int packedLight, int packedOverlay) {
            class_1058 sprite = this.tierMaterial.method_24148();
            class_4588 translucentConsumer = sprite.method_24108(bufferSource.getBuffer(class_1921.method_23580((class_2960)sprite.method_45852())));
            poseStack.method_22903();
            poseStack.method_22904(-0.005, -0.005, -0.005);
            poseStack.method_22905(1.01f, 1.01f, 1.01f);
            int color = Integer.MAX_VALUE;
            this.lidPart.method_22699(poseStack, translucentConsumer, packedLight, packedOverlay, color);
            this.bottomPart.method_22699(poseStack, translucentConsumer, packedLight, packedOverlay, color);
            poseStack.method_22909();
        }

        private void renderBottomAndLid(class_4587 poseStack, class_4597 bufferSource, float lidAngle, int packedLight, int packedOverlay, StorageTextureManager.ChestMaterial chestMaterial) {
            class_4588 consumer = this.chestMaterials.get((Object)chestMaterial).method_24145(bufferSource, class_1921::method_23576);
            this.renderBottomAndLid(poseStack, lidAngle, packedLight, packedOverlay, consumer);
        }

        private void renderBottomAndLid(class_4587 poseStack, float lidAngle, int packedLight, int packedOverlay, class_4588 consumer) {
            this.lidPart.field_3654 = -(lidAngle * 1.5707964f);
            if (lidAngle > 0.0f) {
                poseStack.method_22903();
                poseStack.method_46416(-5.0E-4f, -0.001f, -5.0E-4f);
                poseStack.method_22905(1.001f, 1.001f, 1.001f);
            }
            this.lidPart.method_22698(poseStack, consumer, packedLight, packedOverlay);
            if (lidAngle > 0.0f) {
                poseStack.method_22909();
            }
            this.bottomPart.method_22698(poseStack, consumer, packedLight, packedOverlay);
        }

        private void renderBottomAndLidWithTint(class_4587 poseStack, class_4597 bufferSource, float lidAngle, int packedLight, int packedOverlay, int tint, StorageTextureManager.ChestMaterial chestMaterial) {
            class_4588 consumer = this.chestMaterials.get((Object)chestMaterial).method_24145(bufferSource, class_1921::method_23576);
            this.lidPart.field_3654 = -(lidAngle * 1.5707964f);
            int color = 0xFF000000 | tint;
            if (lidAngle > 0.0f) {
                poseStack.method_22903();
                poseStack.method_46416(-5.0E-4f, -0.001f, -5.0E-4f);
                poseStack.method_22905(1.001f, 1.001f, 1.001f);
            }
            this.lidPart.method_22699(poseStack, consumer, packedLight, packedOverlay, color);
            if (lidAngle > 0.0f) {
                poseStack.method_22909();
            }
            this.bottomPart.method_22699(poseStack, consumer, packedLight, packedOverlay, color);
        }

        private void renderChestLock(class_4587 poseStack, class_4597 bufferSource, float lidAngle, int packedLight, int packedOverlay) {
            class_4588 consumer = this.tierMaterial.method_24145(bufferSource, class_1921::method_23576);
            this.lockPart.field_3654 = -(lidAngle * 1.5707964f);
            this.lockPart.method_22698(poseStack, consumer, packedLight, packedOverlay);
        }

        private class_4730 getTierMaterial(class_2248 block) {
            if (block == ModBlocks.COPPER_CHEST.get()) {
                return this.chestMaterials.get((Object)StorageTextureManager.ChestMaterial.COPPER_TIER);
            }
            if (block == ModBlocks.IRON_CHEST.get()) {
                return this.chestMaterials.get((Object)StorageTextureManager.ChestMaterial.IRON_TIER);
            }
            if (block == ModBlocks.GOLD_CHEST.get()) {
                return this.chestMaterials.get((Object)StorageTextureManager.ChestMaterial.GOLD_TIER);
            }
            if (block == ModBlocks.DIAMOND_CHEST.get()) {
                return this.chestMaterials.get((Object)StorageTextureManager.ChestMaterial.DIAMOND_TIER);
            }
            if (block == ModBlocks.NETHERITE_CHEST.get()) {
                return this.chestMaterials.get((Object)StorageTextureManager.ChestMaterial.NETHERITE_TIER);
            }
            return this.chestMaterials.get((Object)StorageTextureManager.ChestMaterial.WOOD_TIER);
        }

        public void renderTier(class_4587 poseStack, class_4597 bufferSource, float lidAngle, int packedLight, int packedOverlay) {
            class_4588 vertexconsumer = this.tierMaterial.method_24145(bufferSource, class_1921::method_23576);
            this.renderBottomAndLid(poseStack, lidAngle, packedLight, packedOverlay, vertexconsumer);
        }
    }
}

