/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.render;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Either;
import io.github.fabricators_of_create.porting_lib.models.geometry.IGeometryBakingContext;
import io.github.fabricators_of_create.porting_lib.models.geometry.IGeometryLoader;
import io.github.fabricators_of_create.porting_lib.models.geometry.IUnbakedGeometry;
import io.github.fabricators_of_create.porting_lib.models.geometry.SimpleModelState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1100;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3665;
import net.minecraft.class_4590;
import net.minecraft.class_4730;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import net.minecraft.class_7775;
import net.minecraft.class_785;
import net.minecraft.class_793;
import net.minecraft.class_806;
import net.minecraft.class_809;
import org.jetbrains.annotations.NotNull;

public class SimpleCompositeModel
implements IUnbakedGeometry<SimpleCompositeModel> {
    private static final String PARTICLE_MATERIAL = "particle";
    private final ImmutableMap<String, class_793> children;

    private SimpleCompositeModel(ImmutableMap<String, class_793> children) {
        this.children = children;
    }

    public class_1087 bake(IGeometryBakingContext context, class_7775 baker, Function<class_4730, class_1058> spriteGetter, class_3665 modelState, class_806 overrides) {
        class_4730 particleLocation = context.getMaterial(PARTICLE_MATERIAL);
        class_1058 particle = spriteGetter.apply(particleLocation);
        class_4590 rootTransform = context.getRootTransform();
        if (!rootTransform.isIdentity()) {
            modelState = new SimpleModelState(modelState.method_3509().method_22933(rootTransform), modelState.method_3512());
        }
        ImmutableMap.Builder bakedPartsBuilder = ImmutableMap.builder();
        for (Map.Entry entry : this.children.entrySet()) {
            String name = (String)entry.getKey();
            if (!context.isComponentVisible(name, true)) continue;
            class_793 model = (class_793)entry.getValue();
            bakedPartsBuilder.put((Object)name, (Object)model.method_3446(baker, model, spriteGetter, modelState, true));
        }
        ImmutableMap bakedParts = bakedPartsBuilder.build();
        ImmutableList.Builder itemPassesBuilder = ImmutableList.builder();
        return new Baked(context.isGui3d(), context.useBlockLight(), context.useAmbientOcclusion(), particle, context.getTransforms(), overrides, (ImmutableMap<String, class_1087>)bakedParts, (ImmutableList<class_1087>)itemPassesBuilder.build());
    }

    public Map<String, Either<class_4730, String>> getTextures() {
        HashMap<String, Either<class_4730, String>> textures = new HashMap<String, Either<class_4730, String>>();
        this.children.values().forEach(childModel -> {
            IUnbakedGeometry patt0$temp;
            childModel.field_4251.forEach(textures::putIfAbsent);
            if (childModel.port_lib$getCustomData().hasCustomGeometry() && (patt0$temp = childModel.port_lib$getCustomData().getCustomGeometry()) instanceof SimpleCompositeModel) {
                SimpleCompositeModel compositeModel = (SimpleCompositeModel)patt0$temp;
                compositeModel.getTextures().forEach(textures::putIfAbsent);
            } else if (childModel.field_4253 != null) {
                childModel.field_4253.field_4251.forEach(textures::putIfAbsent);
            }
        });
        return textures;
    }

    public void resolveParents(Function<class_2960, class_1100> modelGetter, IGeometryBakingContext context) {
        this.children.values().forEach(childModel -> childModel.method_45785(modelGetter));
    }

    public List<class_785> getElements() {
        ArrayList<class_785> elements = new ArrayList<class_785>();
        this.children.forEach((name, model) -> {
            IUnbakedGeometry patt0$temp;
            elements.addAll(model.method_3433());
            if (model.port_lib$getCustomData().hasCustomGeometry() && (patt0$temp = model.port_lib$getCustomData().getCustomGeometry()) instanceof SimpleCompositeModel) {
                SimpleCompositeModel compositeModel = (SimpleCompositeModel)patt0$temp;
                elements.addAll(compositeModel.getElements());
            }
        });
        return elements;
    }

    public Set<String> getConfigurableComponentNames() {
        return this.children.keySet();
    }

    public static class Baked
    implements class_1087,
    FabricBakedModel {
        private final boolean isAmbientOcclusion;
        private final boolean isGui3d;
        private final boolean isSideLit;
        private final class_1058 particle;
        private final class_806 overrides;
        private final class_809 transforms;
        private final ImmutableMap<String, class_1087> children;
        private final ImmutableList<class_1087> itemPasses;

        public Baked(boolean isGui3d, boolean isSideLit, boolean isAmbientOcclusion, class_1058 particle, class_809 transforms, class_806 overrides, ImmutableMap<String, class_1087> children, ImmutableList<class_1087> itemPasses) {
            this.children = children;
            this.isAmbientOcclusion = isAmbientOcclusion;
            this.isGui3d = isGui3d;
            this.isSideLit = isSideLit;
            this.particle = particle;
            this.overrides = overrides;
            this.transforms = transforms;
            this.itemPasses = itemPasses;
        }

        public boolean isVanillaAdapter() {
            return false;
        }

        public void emitBlockQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context) {
            for (Map.Entry entry : this.children.entrySet()) {
                ((class_1087)entry.getValue()).emitBlockQuads(blockView, state, pos, randomSupplier, context);
            }
        }

        public void emitItemQuads(class_1799 stack, Supplier<class_5819> randomSupplier, RenderContext context) {
            for (Map.Entry entry : this.children.entrySet()) {
                ((class_1087)entry.getValue()).emitItemQuads(stack, randomSupplier, context);
            }
        }

        @NotNull
        public List<class_777> method_4707(@Nullable class_2680 state, @Nullable class_2350 side, class_5819 rand) {
            ArrayList quadLists = new ArrayList();
            for (Map.Entry entry : this.children.entrySet()) {
                quadLists.addAll(((class_1087)entry.getValue()).method_4707(state, side, rand));
            }
            return Collections.unmodifiableList(quadLists);
        }

        public boolean method_4708() {
            return this.isAmbientOcclusion;
        }

        public boolean method_4712() {
            return this.isGui3d;
        }

        public boolean method_24304() {
            return this.isSideLit;
        }

        public boolean method_4713() {
            return false;
        }

        public class_1058 method_4711() {
            return this.particle;
        }

        public class_806 method_4710() {
            return this.overrides;
        }

        public class_809 method_4709() {
            return this.transforms;
        }
    }

    public static final class Loader
    implements IGeometryLoader<SimpleCompositeModel> {
        public static final Loader INSTANCE = new Loader();

        private Loader() {
        }

        public SimpleCompositeModel read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) {
            ImmutableMap.Builder childrenBuilder = ImmutableMap.builder();
            this.readChildren(jsonObject, deserializationContext, (ImmutableMap.Builder<String, class_793>)childrenBuilder);
            ImmutableMap children = childrenBuilder.build();
            if (children.isEmpty()) {
                throw new JsonParseException("Composite model requires a \"parts\" element with at least one element.");
            }
            return new SimpleCompositeModel((ImmutableMap<String, class_793>)children);
        }

        private void readChildren(JsonObject jsonObject, JsonDeserializationContext deserializationContext, ImmutableMap.Builder<String, class_793> children) {
            if (!jsonObject.has("parts")) {
                return;
            }
            JsonObject childrenJsonObject = jsonObject.getAsJsonObject("parts");
            for (Map.Entry entry : childrenJsonObject.entrySet()) {
                children.put((Object)((String)entry.getKey()), (Object)((class_793)deserializationContext.deserialize((JsonElement)entry.getValue(), class_793.class)));
            }
        }
    }
}

