/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.common.gui;

import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.p3pp3rf1y.sophisticatedcore.common.gui.IServerUpdater;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.VerticalFacing;
import net.p3pp3rf1y.sophisticatedstorage.common.gui.BlockSide;
import net.p3pp3rf1y.sophisticatedstorage.upgrades.IOMode;

public class SideIOContainer {
    private static final String DATA_SIDE_PREFIX = "side";
    private static final String DATA_IO_MODE_PREFIX = "ioMode";
    private final Supplier<class_2350> horizontalDirection;
    private final Supplier<VerticalFacing> verticalFacing;
    private final Function<class_2350, IOMode> getDirectionIOMode;
    private final BiConsumer<class_2350, IOMode> setDirectionIOMode;
    private final boolean canSideIOBeDisabled;
    private final IServerUpdater serverUpdater;

    public SideIOContainer(IServerUpdater serverUpdater, Supplier<class_2350> horizontalDirection, Supplier<VerticalFacing> verticalFacing, Function<class_2350, IOMode> getDirectionIOMode, BiConsumer<class_2350, IOMode> setDirectionIOMode, boolean canSideIOBeDisabled) {
        this.serverUpdater = serverUpdater;
        this.horizontalDirection = horizontalDirection;
        this.verticalFacing = verticalFacing;
        this.getDirectionIOMode = getDirectionIOMode;
        this.setDirectionIOMode = setDirectionIOMode;
        this.canSideIOBeDisabled = canSideIOBeDisabled;
    }

    public boolean handlePacket(class_2487 data) {
        if (data.method_10545(DATA_IO_MODE_PREFIX)) {
            IOMode ioMode = NBTHelper.getEnumConstant((class_2487)data, (String)DATA_IO_MODE_PREFIX, IOMode::fromName).orElse(IOMode.OFF);
            BlockSide side = NBTHelper.getEnumConstant((class_2487)data, (String)DATA_SIDE_PREFIX, BlockSide::fromName).orElse(BlockSide.FRONT);
            this.setSideIO(side, ioMode);
            return true;
        }
        return false;
    }

    public void toggleSideIO(BlockSide side) {
        IOMode currentIO = this.getSideIOMode(side);
        IOMode next = currentIO.next();
        if (!this.canSideIOBeDisabled && next == IOMode.DISABLED) {
            next = next.next();
        }
        this.setSideIO(side, next);
    }

    private void setSideIO(BlockSide side, IOMode ioMode) {
        this.setDirectionIOMode.accept(this.toDirection(side), ioMode);
        this.serverUpdater.sendDataToServer(() -> {
            class_2487 tag = new class_2487();
            NBTHelper.putEnumConstant((class_2487)tag, (String)DATA_SIDE_PREFIX, (Enum)side);
            NBTHelper.putEnumConstant((class_2487)tag, (String)DATA_IO_MODE_PREFIX, (Enum)ioMode);
            return tag;
        });
    }

    public class_2350 toDirection(BlockSide side) {
        return side.toDirection(this.horizontalDirection.get(), this.verticalFacing.get());
    }

    public IOMode getSideIOMode(BlockSide side) {
        return this.getDirectionIOMode.apply(this.toDirection(side));
    }
}

