/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.upgrades.hopper;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.github.fabricators_of_create.porting_lib.util.DeferredHolder;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1799;
import net.minecraft.class_9331;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ContentsFilterLogic;
import net.p3pp3rf1y.sophisticatedcore.upgrades.FilterAttributes;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;

public class TargetContentsFilterLogic
extends ContentsFilterLogic {
    private Set<ItemStackKey> inventoryFilterStacks = new HashSet<ItemStackKey>();
    private final LoadingCache<Storage<ItemVariant>, Set<ItemStackKey>> inventoryCache = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<Storage<ItemVariant>, Set<ItemStackKey>>(this){

        public Set<ItemStackKey> load(Storage<ItemVariant> inventory) {
            return InventoryHelper.getUniqueStacks(inventory);
        }
    });

    public TargetContentsFilterLogic(class_1799 upgrade, Consumer<class_1799> saveHandler, int filterSlotCount, Supplier<InventoryHandler> getInventoryHandler, MemorySettingsCategory memorySettings, DeferredHolder<class_9331<?>, class_9331<FilterAttributes>> filterAttributesComponent) {
        super(upgrade, saveHandler, filterSlotCount, getInventoryHandler, memorySettings, filterAttributesComponent);
    }

    public void setInventory(Storage<ItemVariant> inventory) {
        this.inventoryFilterStacks = (Set)this.inventoryCache.getUnchecked(inventory);
    }

    public boolean matchesFilter(class_1799 stack) {
        if (!this.shouldFilterByStorage()) {
            return super.matchesFilter(stack);
        }
        for (ItemStackKey filterStack : this.inventoryFilterStacks) {
            if (!this.stackMatchesFilter(stack, filterStack.getStack())) continue;
            return true;
        }
        return false;
    }
}

