/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiCache;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_7225;
import net.p3pp3rf1y.sophisticatedcore.controller.ControllerBlockEntityBase;
import net.p3pp3rf1y.sophisticatedcore.controller.IControllerBoundable;
import net.p3pp3rf1y.sophisticatedcore.controller.ILinkable;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.ControllerBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import org.jetbrains.annotations.Nullable;

public class StorageIOBlockEntity
extends class_2586
implements IControllerBoundable,
ILinkable {
    @javax.annotation.Nullable
    private class_2338 controllerPos = null;
    private boolean isLinkedToController = false;
    private boolean chunkBeingUnloaded = false;
    @javax.annotation.Nullable
    private BlockApiCache<Storage<ItemVariant>, @Nullable class_2350> controllerItemHandlerCache;

    protected StorageIOBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public StorageIOBlockEntity(class_2338 pos, class_2680 state) {
        this(ModBlocks.STORAGE_IO_BLOCK_ENTITY_TYPE.get(), pos, state);
    }

    public Set<class_2338> getConnectablePositions() {
        return Collections.emptySet();
    }

    public boolean connectLinkedSelf() {
        return true;
    }

    public void setControllerPos(class_2338 controllerPos) {
        this.controllerPos = controllerPos;
        this.controllerItemHandlerCache = null;
        this.method_5431();
    }

    public Optional<class_2338> getControllerPos() {
        return Optional.ofNullable(this.controllerPos);
    }

    public boolean isLinked() {
        return this.isLinkedToController && this.getControllerPos().isPresent();
    }

    public void linkToController(class_2338 controllerPos) {
        if (this.getControllerPos().isPresent()) {
            return;
        }
        this.isLinkedToController = true;
        super.linkToController(controllerPos);
        this.method_5431();
    }

    public void setNotLinked() {
        super.setNotLinked();
        this.isLinkedToController = false;
        this.removeControllerPos();
        this.method_5431();
    }

    public void removeControllerPos() {
        this.controllerPos = null;
        this.controllerItemHandlerCache = null;
        this.method_5431();
    }

    public class_2338 getStorageBlockPos() {
        return this.method_11016();
    }

    public class_1937 getStorageBlockLevel() {
        return this.method_10997();
    }

    public boolean canConnectStorages() {
        return false;
    }

    public void addToController(class_1937 level, class_2338 pos, class_2338 controllerPos) {
        WorldHelper.getBlockEntity((class_1922)level, (class_2338)controllerPos, ControllerBlockEntityBase.class).ifPresent(c -> c.addStorage(pos));
    }

    public boolean canBeConnected() {
        return this.isLinked() || this.getControllerPos().isEmpty();
    }

    public void registerController(ControllerBlockEntityBase controllerBlockEntity) {
        this.setControllerPos(controllerBlockEntity.method_11016());
    }

    public void unregisterController() {
        this.removeControllerPos();
    }

    public void removeFromController() {
        if (!this.field_11863.method_8608()) {
            this.getControllerPos().flatMap(p -> WorldHelper.getBlockEntity((class_1922)this.field_11863, (class_2338)p, ControllerBlockEntityBase.class)).ifPresent(c -> c.removeNonConnectingBlock(this.method_11016()));
            this.removeControllerPos();
        }
    }

    protected void method_11007(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11007(tag, registries);
        this.saveControllerPos(tag);
        if (this.isLinkedToController) {
            tag.method_10556("isLinkedToController", this.isLinkedToController);
        }
    }

    public void method_11014(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11014(tag, registries);
        this.loadControllerPos(tag);
        this.isLinkedToController = NBTHelper.getBoolean((class_2487)tag, (String)"isLinkedToController").orElse(false);
    }

    protected void invalidateItemHandlerCache() {
        this.controllerItemHandlerCache = null;
        this.sophisticatedCore_invalidateCapabilities();
    }

    @javax.annotation.Nullable
    public Storage<ItemVariant> getExternalItemHandler(@javax.annotation.Nullable class_2350 side) {
        class_1937 class_19372;
        if (this.getControllerPos().isEmpty()) {
            return null;
        }
        if (this.controllerItemHandlerCache == null && (class_19372 = this.field_11863) instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            this.controllerItemHandlerCache = BlockApiCache.create((BlockApiLookup)ItemStorage.SIDED, (class_3218)serverLevel, (class_2338)this.getControllerPos().get());
        }
        if (this.controllerItemHandlerCache != null) {
            return (Storage)this.controllerItemHandlerCache.find((Object)side);
        }
        return WorldHelper.getBlockEntity((class_1922)this.method_10997(), (class_2338)this.getControllerPos().get(), ControllerBlockEntity.class).map(c -> c.getExternalItemHandler(side)).orElse(null);
    }

    public void sophisticatedCore_onChunkUnloaded() {
        super.sophisticatedCore_onChunkUnloaded();
        this.chunkBeingUnloaded = true;
    }

    public void method_11012() {
        if (!this.chunkBeingUnloaded && this.field_11863 != null) {
            this.unlinkFromController();
        }
        super.method_11012();
    }
}

