/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.render;

import java.util.OptionalDouble;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3726;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4668;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_761;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.ControllerBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.init.ModItems;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageToolItem;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class ControllerRenderer
implements class_827<ControllerBlockEntity> {
    public void render(ControllerBlockEntity controller, float partialTick, class_4587 poseStack, class_4597 bufferSource, int packedLight, int packedOverlay) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        InventoryHelper.getItemFromEitherHand((class_1657)player, (class_1792)((class_1792)ModItems.DEBUG_TOOL.get())).ifPresent(storageTool -> this.renderConnectedStorageBlocksInfo(controller, class_2350.method_10159((class_1297)player)[0].method_10153(), poseStack, bufferSource));
        InventoryHelper.getItemFromEitherHand((class_1657)player, (class_1792)((class_1792)ModItems.STORAGE_TOOL.get())).ifPresent(storageTool -> {
            if (StorageToolItem.getMode(storageTool) != StorageToolItem.Mode.LINK) {
                return;
            }
            if (StorageToolItem.getControllerLink(storageTool).map(controllerPos -> controllerPos.equals((Object)controller.method_11016())).orElse(false).booleanValue()) {
                this.renderBlockOutline(controller.method_11016(), controller.method_11016(), level, poseStack, bufferSource, class_1767.field_7951.method_16357());
            }
            this.renderLinkedBlocksOutline(controller, level, poseStack, bufferSource);
        });
    }

    private void renderConnectedStorageBlocksInfo(ControllerBlockEntity controller, class_2350 playerLookDirection, class_4587 poseStack, class_4597 bufferSource) {
        class_327 fontRenderer = class_310.method_1551().field_1772;
        double zScale = 0.001;
        float scale = 0.015f;
        int storageOrder = 1;
        for (class_2338 position : controller.getStoragePositions()) {
            class_2338 controllerPos = controller.method_11016();
            double translateX = (double)position.method_10263() + 0.5 - (double)controllerPos.method_10263() + 0.501 * (double)playerLookDirection.method_10163().method_10263();
            double translateY = (double)position.method_10264() + 0.5 - (double)controllerPos.method_10264() + 0.501 * (double)playerLookDirection.method_10163().method_10264();
            double translateZ = (double)position.method_10260() + 0.5 - (double)controllerPos.method_10260() + 0.501 * (double)playerLookDirection.method_10163().method_10260();
            poseStack.method_22903();
            poseStack.method_22904(translateX, translateY, translateZ);
            Quaternionf rotation = playerLookDirection.method_23224();
            rotation.mul((Quaternionfc)class_7833.field_40714.rotationDegrees(-90.0f));
            poseStack.method_22907(rotation);
            poseStack.method_46416(-0.45f, 0.45f, 0.0f);
            poseStack.method_22905(scale, -scale, (float)zScale);
            fontRenderer.method_27521("Order: " + storageOrder, 0.0f, 0.0f, class_1767.field_7952.method_16357(), false, poseStack.method_23760().method_23761(), bufferSource, class_327.class_6415.field_33994, 0, 0xF000F0);
            poseStack.method_46416(0.0f, 10.0f, 0.0f);
            fontRenderer.method_27521("Slots: " + controller.getSlots(storageOrder - 1), 0.0f, 0.0f, class_1767.field_7952.method_16357(), false, poseStack.method_23760().method_23761(), bufferSource, class_327.class_6415.field_33994, 0, 0xF000F0);
            poseStack.method_22909();
            ++storageOrder;
        }
    }

    private void renderLinkedBlocksOutline(ControllerBlockEntity controller, class_638 level, class_4587 poseStack, class_4597 bufferSource) {
        controller.getLinkedBlocks().forEach(pos -> {
            class_2680 state = level.method_8320(pos);
            class_265 shape = state.method_26172((class_1922)level, pos, class_3726.method_16194());
            this.renderLineBetweenBlocks(controller.method_11016(), (class_2338)pos, shape, poseStack, bufferSource, class_1767.field_7961.method_16357());
            this.renderBlockOutline(controller.method_11016(), (class_2338)pos, shape, poseStack, bufferSource, class_1767.field_7961.method_16357());
        });
    }

    private void renderLineBetweenBlocks(class_2338 initialPos, class_2338 pos, class_265 shape, class_4587 poseStack, class_4597 bufferSource, int color) {
        if (shape.method_1110()) {
            return;
        }
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        class_243 center = shape.method_1107().method_1005();
        class_4588 buffer = bufferSource.getBuffer(LineRenderType.LINES);
        class_4587.class_4665 pose = poseStack.method_23760();
        Matrix4f matrix4f = pose.method_23761();
        float normalX = (float)((double)(pos.method_10263() - initialPos.method_10263()) + (0.5 - center.method_10216()));
        float normalY = (float)((double)(pos.method_10264() - initialPos.method_10264()) + (0.5 - center.method_10214()));
        float normalZ = (float)((double)(pos.method_10260() - initialPos.method_10260()) + (0.5 - center.method_10215()));
        buffer.method_22918(matrix4f, 0.5f, 0.5f, 0.5f).method_1336(red, green, blue, 255).method_60831(pose, normalX, normalY, normalZ);
        buffer.method_22918(matrix4f, (float)((double)(pos.method_10263() - initialPos.method_10263()) + center.method_10216()), (float)((double)(pos.method_10264() - initialPos.method_10264()) + center.method_10214()), (float)((double)(pos.method_10260() - initialPos.method_10260()) + center.method_10215())).method_1336(red, green, blue, 255).method_60831(pose, normalX, normalY, normalZ);
    }

    private void renderBlockOutline(class_2338 controllerPos, class_2338 pos, class_638 level, class_4587 poseStack, class_4597 bufferSource, int color) {
        class_2680 state = level.method_8320(pos);
        class_265 shape = state.method_26172((class_1922)level, pos, class_3726.method_16194());
        this.renderBlockOutline(controllerPos, pos, shape, poseStack, bufferSource, color);
    }

    private void renderBlockOutline(class_2338 controllerPos, class_2338 pos, class_265 shape, class_4587 poseStack, class_4597 bufferSource, int color) {
        class_4588 vertexConsumer = bufferSource.getBuffer(LineRenderType.LINES);
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        class_761.method_3291((class_4587)poseStack, (class_4588)vertexConsumer, (class_265)shape, (double)((double)(-controllerPos.method_10263()) + (double)pos.method_10263()), (double)((double)(-controllerPos.method_10264()) + (double)pos.method_10264()), (double)((double)(-controllerPos.method_10260()) + (double)pos.method_10260()), (float)red, (float)green, (float)blue, (float)1.0f);
    }

    public boolean shouldRenderOffScreen(ControllerBlockEntity blockEntity) {
        return true;
    }

    private static class LineRenderType
    extends class_1921 {
        private static final class_1921 LINES = class_1921.method_24049((String)"storage_lines", (class_293)class_290.field_29337, (class_293.class_5596)class_293.class_5596.field_27377, (int)256, (boolean)false, (boolean)false, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34578(field_29433).method_23604(field_21346).method_23609(new class_4668.class_4677(OptionalDouble.empty())).method_23607(field_22241).method_23603(class_4668.field_21345).method_23617(false));

        public LineRenderType(String name, class_293 format, class_293.class_5596 mode, int bufferSize, boolean affectsCrumbling, boolean sortOnUpload, Runnable setupState, Runnable clearState) {
            super(name, format, mode, bufferSize, affectsCrumbling, sortOnUpload, setupState, clearState);
        }
    }
}

