/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.render;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.UnaryOperator;
import net.minecraft.class_1087;
import net.minecraft.class_1309;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3726;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_6673;
import net.minecraft.class_7384;
import net.minecraft.class_777;
import net.minecraft.class_7833;
import net.minecraft.class_804;
import net.minecraft.class_811;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.client.render.TranslucentVertexConsumer;
import net.p3pp3rf1y.sophisticatedstorage.client.util.QuaternionHelper;
import net.p3pp3rf1y.sophisticatedstorage.init.ModItems;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class DisplayItemRenderer {
    private static final class_1799 EMPTY_UPGRADE_STACK = new class_1799((class_1935)ModItems.UPGRADE_BASE.get());
    public static final float SMALL_3D_ITEM_SCALE = 0.5f;
    static final float BIG_2D_ITEM_SCALE = 0.5f;
    static final float SMALL_2D_ITEM_SCALE = 0.25f;
    static final float UPGRADE_ITEM_SCALE = 0.125f;
    private static final class_1799 INACCESSIBLE_SLOT_STACK = new class_1799((class_1935)ModItems.INACCESSIBLE_SLOT.get());
    private static final class_5819 RAND = new class_7384(class_6673.method_39001());
    private final double yCenterTranslation;
    private final class_243 upgradesOffset;
    private static final Cache<Integer, Double> ITEM_HASHCODE_OFFSETS = CacheBuilder.newBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build();

    public DisplayItemRenderer(double yCenterTranslation, class_243 upgradesOffset) {
        this.yCenterTranslation = yCenterTranslation;
        this.upgradesOffset = upgradesOffset;
    }

    public void renderDisplayItem(StorageBlockEntity blockEntity, class_4587 poseStack, class_4597 bufferSource, int packedLight, int packedOverlay) {
        blockEntity.getStorageWrapper().getRenderInfo().getItemDisplayRenderInfo().getDisplayItem().ifPresent(displayItem -> this.renderDisplayItem(poseStack, bufferSource, packedLight, packedOverlay, (RenderInfo.DisplayItem)displayItem));
    }

    public void renderDisplayItem(class_4587 poseStack, class_4597 bufferSource, int packedLight, int packedOverlay, RenderInfo.DisplayItem displayItem) {
        this.renderSingleItem(poseStack, bufferSource, packedLight, packedOverlay, class_310.method_1551(), false, 0, 1, displayItem.getItem(), displayItem.getRotation());
    }

    public void renderDisplayItems(StorageBlockEntity blockEntity, class_4587 poseStack, class_4597 bufferSource, int packedLight, int packedOverlay, boolean renderOnlyCustom) {
        int displayItemIndex;
        RenderInfo.ItemDisplayRenderInfo itemDisplayRenderInfo = blockEntity.getStorageWrapper().getRenderInfo().getItemDisplayRenderInfo();
        List displayItems = itemDisplayRenderInfo.getDisplayItems();
        List inaccessibleSlots = itemDisplayRenderInfo.getInaccessibleSlots();
        if (displayItems.isEmpty() && inaccessibleSlots.isEmpty()) {
            return;
        }
        class_2680 blockState = blockEntity.method_11010();
        class_2248 class_22482 = blockState.method_26204();
        if (!(class_22482 instanceof StorageBlockBase)) {
            return;
        }
        StorageBlockBase storageBlock = (StorageBlockBase)class_22482;
        class_310 minecraft = class_310.method_1551();
        int displayItemCount = storageBlock.getDisplayItemsCount(displayItems);
        for (displayItemIndex = 0; displayItemIndex < displayItemCount; ++displayItemIndex) {
            if (!inaccessibleSlots.contains(displayItemIndex)) continue;
            this.renderSingleItem(poseStack, bufferSource, packedLight, packedOverlay, minecraft, renderOnlyCustom, displayItemIndex, displayItemCount, INACCESSIBLE_SLOT_STACK, 0);
        }
        displayItemIndex = 0;
        for (RenderInfo.DisplayItem displayItem : displayItems) {
            this.renderSingleItem(poseStack, bufferSource, packedLight, packedOverlay, minecraft, renderOnlyCustom, storageBlock.hasFixedIndexDisplayItems() ? displayItem.getSlotIndex() : displayItemIndex, displayItemCount, displayItem.getItem(), displayItem.getRotation());
            ++displayItemIndex;
        }
    }

    public void renderUpgradeItems(StorageBlockEntity blockEntity, class_4587 poseStack, class_4597 bufferSource, int packedLight, int packedOverlay, boolean renderEmptySlots, boolean renderDisabledUpgradeDisplay) {
        List upgradeItems = blockEntity.getStorageWrapper().getRenderInfo().getUpgradeItems();
        poseStack.method_22903();
        class_310 minecraft = class_310.method_1551();
        int i = 0;
        for (class_1799 upgradeItem : upgradeItems) {
            if (upgradeItem.method_7960() && !renderEmptySlots) continue;
            poseStack.method_22903();
            poseStack.method_22904((double)(1.0f - (float)(i * 2) / 16.0f - 0.0625f) + this.upgradesOffset.method_10216(), 0.0625 + this.upgradesOffset.method_10214(), this.upgradesOffset.method_10215());
            poseStack.method_22905(0.125f, 0.125f, 0.125f);
            class_1799 itemToRender = upgradeItem.method_7960() ? EMPTY_UPGRADE_STACK : upgradeItem;
            class_1087 itemModel = minecraft.method_1480().method_4019(itemToRender, null, (class_1309)minecraft.field_1724, 0);
            class_4597 buffer = upgradeItem.method_7960() ? TranslucentVertexConsumer.wrapBuffer(bufferSource, 128) : bufferSource;
            minecraft.method_1480().method_23179(itemToRender, class_811.field_4319, false, poseStack, buffer, packedLight, packedOverlay, itemModel);
            if (renderDisabledUpgradeDisplay) {
                poseStack.method_22903();
                poseStack.method_46416(0.0f, 0.0f, -0.001f);
                itemModel = minecraft.method_1480().method_4019(INACCESSIBLE_SLOT_STACK, null, (class_1309)minecraft.field_1724, 0);
                buffer = bufferSource;
                minecraft.method_1480().method_23179(INACCESSIBLE_SLOT_STACK, class_811.field_4319, false, poseStack, buffer, packedLight, packedOverlay, itemModel);
                poseStack.method_22909();
            }
            poseStack.method_22909();
            ++i;
        }
        poseStack.method_22909();
    }

    private void renderSingleItem(class_4587 poseStack, class_4597 bufferSource, int packedLight, int packedOverlay, class_310 minecraft, boolean renderOnlyCustom, int displayItemIndex, int displayItemCount, class_1799 stack, int rotation) {
        if (stack.method_7960()) {
            return;
        }
        class_1087 itemModel = minecraft.method_1480().method_4019(stack, null, (class_1309)minecraft.field_1724, 0);
        if (!itemModel.method_4713() && renderOnlyCustom) {
            return;
        }
        float itemOffset = (float)DisplayItemRenderer.getDisplayItemOffset(stack, itemModel, displayItemCount == 1 ? 1.0f : 0.5f);
        poseStack.method_22903();
        Vector3f frontOffset = DisplayItemRenderer.getDisplayItemIndexFrontOffset(displayItemIndex, displayItemCount, (float)this.yCenterTranslation);
        poseStack.method_46416(frontOffset.x(), frontOffset.y(), -itemOffset);
        poseStack.method_22907(class_7833.field_40718.rotationDegrees((float)rotation));
        float itemScale = displayItemCount == 1 ? (itemModel.method_4712() ? 1.0f : 0.5f) : (itemModel.method_4712() ? 0.5f : 0.25f);
        poseStack.method_22905(itemScale, itemScale, itemScale);
        minecraft.method_1480().method_23179(stack, class_811.field_4319, false, poseStack, bufferSource, packedLight, packedOverlay, itemModel);
        poseStack.method_22909();
    }

    public static double getDisplayItemOffset(class_1799 item, class_1087 itemModel, float additionalScale) {
        int hash = class_1799.method_57355((class_1799)item) * 31 + Float.hashCode(additionalScale);
        Double offset = (Double)ITEM_HASHCODE_OFFSETS.getIfPresent((Object)hash);
        if (offset != null) {
            return offset;
        }
        offset = DisplayItemRenderer.calculateDisplayItemOffset(item, itemModel, additionalScale);
        ITEM_HASHCODE_OFFSETS.put((Object)hash, (Object)offset);
        return offset;
    }

    private static double calculateDisplayItemOffset(class_1799 item, class_1087 itemModel, float additionalScale) {
        class_1792 class_17922;
        double itemOffset = 0.0;
        if (itemModel.method_4712() && (class_17922 = item.method_7909()) instanceof class_1747) {
            class_1747 blockItem = (class_1747)class_17922;
            class_2248 block = blockItem.method_7711();
            class_638 level = class_310.method_1551().field_1687;
            if (level != null) {
                itemOffset = DisplayItemRenderer.calculateOffsetFromModelOrShape(itemModel, block, level, additionalScale);
            }
        }
        return itemOffset;
    }

    private static double calculateOffsetFromModelOrShape(class_1087 itemModel, class_2248 block, class_638 level, float additionalScale) {
        if (itemModel.method_4713()) {
            return DisplayItemRenderer.transformBoundsCornersAndCalculateOffset(itemModel, DisplayItemRenderer.getBoundsCornersFromShape(block, level), additionalScale);
        }
        return DisplayItemRenderer.transformBoundsCornersAndCalculateOffset(itemModel, DisplayItemRenderer.getBoundsCornersFromModel(itemModel), additionalScale);
    }

    private static double transformBoundsCornersAndCalculateOffset(class_1087 itemModel, Set<Vector3f> points, float additionalScale) {
        class_804 transform = itemModel.method_4709().method_3503(class_811.field_4319);
        points = DisplayItemRenderer.scalePoints(points, transform.field_4285);
        points = DisplayItemRenderer.rotatePoints(points, transform.field_4287);
        points = DisplayItemRenderer.translatePoints(points, transform.field_4286);
        float zScale = transform.field_4285.z();
        return ((double)zScale * 0.12539184952978058 - DisplayItemRenderer.getMaxZ(points)) * (double)additionalScale;
    }

    private static Set<Vector3f> getBoundsCornersFromShape(class_2248 block, class_638 level) {
        class_265 shape = block.method_9564().method_26172((class_1922)level, class_2338.field_10980, class_3726.method_16194());
        return DisplayItemRenderer.getCornerPointsRelativeToCenter(shape.method_1107());
    }

    private static Set<Vector3f> getBoundsCornersFromModel(class_1087 itemModel) {
        float minX = 2.0f;
        float minY = 2.0f;
        float minZ = 2.0f;
        float maxX = -2.0f;
        float maxY = -2.0f;
        float maxZ = -2.0f;
        for (class_2350 direction : class_2350.values()) {
            List quads = itemModel.method_4707(null, direction, RAND);
            for (class_777 quad : quads) {
                int i = 0;
                int[] verts = quad.method_3357();
                while (i + 2 < verts.length) {
                    float x = Float.intBitsToFloat(verts[i]);
                    float y = Float.intBitsToFloat(verts[i + 1]);
                    float z = Float.intBitsToFloat(verts[i + 2]);
                    minX = Math.min(minX, x);
                    maxX = Math.max(maxX, x);
                    minY = Math.min(minY, y);
                    maxY = Math.max(maxY, y);
                    minZ = Math.min(minZ, z);
                    maxZ = Math.max(maxZ, z);
                    i += 8;
                }
            }
        }
        List quads = itemModel.method_4707(null, null, RAND);
        for (class_777 quad : quads) {
            int i = 0;
            int[] verts = quad.method_3357();
            while (i + 2 < verts.length) {
                float x = Float.intBitsToFloat(verts[i]);
                float y = Float.intBitsToFloat(verts[i + 1]);
                float z = Float.intBitsToFloat(verts[i + 2]);
                minX = Math.min(minX, x);
                maxX = Math.max(maxX, x);
                minY = Math.min(minY, y);
                maxY = Math.max(maxY, y);
                minZ = Math.min(minZ, z);
                maxZ = Math.max(maxZ, z);
                i += 8;
            }
        }
        return DisplayItemRenderer.getCornerPointsRelativeToCenter(minX, minY, minZ, maxX, maxY, maxZ);
    }

    private static double getMaxZ(Set<Vector3f> points) {
        float maxZ = Float.MIN_VALUE;
        for (Vector3f point : points) {
            if (!(point.z() > maxZ)) continue;
            maxZ = point.z();
        }
        return maxZ;
    }

    private static Set<Vector3f> translatePoints(Set<Vector3f> points, Vector3f translation) {
        return DisplayItemRenderer.transformPoints(points, point -> {
            point.sub((Vector3fc)translation);
            return point;
        });
    }

    private static Set<Vector3f> rotatePoints(Set<Vector3f> points, Vector3f rotation) {
        Quaternionf rot = QuaternionHelper.quatFromXYZDegree(rotation);
        return DisplayItemRenderer.transformPoints(points, point -> {
            point.rotate((Quaternionfc)rot);
            return point;
        });
    }

    private static Set<Vector3f> scalePoints(Set<Vector3f> points, Vector3f scale) {
        return DisplayItemRenderer.transformPoints(points, point -> new Vector3f(point.x() * scale.x(), point.y() * scale.y(), point.z() * scale.z()));
    }

    private static Set<Vector3f> transformPoints(Set<Vector3f> points, UnaryOperator<Vector3f> transform) {
        HashSet<Vector3f> ret = new HashSet<Vector3f>();
        for (Vector3f point : points) {
            ret.add((Vector3f)transform.apply(point));
        }
        return ret;
    }

    private static Set<Vector3f> getCornerPointsRelativeToCenter(class_238 aabb) {
        return DisplayItemRenderer.getCornerPointsRelativeToCenter((float)aabb.field_1323, (float)aabb.field_1322, (float)aabb.field_1321, (float)aabb.field_1320, (float)aabb.field_1325, (float)aabb.field_1324);
    }

    private static Set<Vector3f> getCornerPointsRelativeToCenter(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        HashSet<Vector3f> ret = new HashSet<Vector3f>();
        ret.add(new Vector3f(0.5f - minX, 0.5f - minY, 0.5f - minZ));
        ret.add(new Vector3f(0.5f - minX, 0.5f - minY, 0.5f - maxZ));
        ret.add(new Vector3f(0.5f - minX, 0.5f - maxY, 0.5f - minZ));
        ret.add(new Vector3f(0.5f - minX, 0.5f - maxY, 0.5f - maxZ));
        ret.add(new Vector3f(0.5f - maxX, 0.5f - minY, 0.5f - minZ));
        ret.add(new Vector3f(0.5f - maxX, 0.5f - minY, 0.5f - maxZ));
        ret.add(new Vector3f(0.5f - maxX, 0.5f - maxY, 0.5f - minZ));
        ret.add(new Vector3f(0.5f - maxX, 0.5f - maxY, 0.5f - maxZ));
        return ret;
    }

    public static Vector3f getDisplayItemIndexFrontOffset(int displayItemIndex, int displayItemCount) {
        return DisplayItemRenderer.getDisplayItemIndexFrontOffset(displayItemIndex, displayItemCount, 0.5f);
    }

    public static Vector3f getDisplayItemIndexFrontOffset(int displayItemIndex, int displayItemCount, float centerYOffset) {
        Vector3f frontOffset;
        if (displayItemCount <= 0 || displayItemCount > 4) {
            frontOffset = new Vector3f(0.0f, 0.0f, 0.5f);
        } else if (displayItemCount == 1) {
            frontOffset = new Vector3f(0.5f, centerYOffset, 0.5f);
        } else if (displayItemCount == 2) {
            float halfCenterYOffset = centerYOffset / 2.0f;
            frontOffset = new Vector3f(0.5f, displayItemIndex == 0 ? centerYOffset + halfCenterYOffset : halfCenterYOffset, 0.5f);
        } else if (displayItemCount == 3) {
            float xOffset = 0.5f;
            if (displayItemIndex > 0) {
                xOffset = 0.75f - (float)(displayItemIndex - 1) * 0.5f;
            }
            float halfCenterYOffset = centerYOffset / 2.0f;
            frontOffset = new Vector3f(xOffset, displayItemIndex == 0 ? centerYOffset + halfCenterYOffset : halfCenterYOffset, 0.5f);
        } else {
            float halfCenterYOffset = centerYOffset / 2.0f;
            frontOffset = new Vector3f(displayItemIndex == 0 || displayItemIndex == 2 ? centerYOffset + halfCenterYOffset : halfCenterYOffset, displayItemIndex == 0 || displayItemIndex == 1 ? centerYOffset + halfCenterYOffset : halfCenterYOffset, 0.5f);
        }
        return frontOffset;
    }

    public static Quaternionf getNorthBasedRotation(class_2350 dir) {
        return switch (dir) {
            default -> throw new MatchException(null, null);
            case class_2350.field_11033 -> class_7833.field_40714.rotationDegrees(-90.0f);
            case class_2350.field_11036 -> class_7833.field_40714.rotationDegrees(90.0f);
            case class_2350.field_11043 -> new Quaternionf();
            case class_2350.field_11035 -> class_7833.field_40716.rotationDegrees(180.0f);
            case class_2350.field_11039 -> class_7833.field_40716.rotationDegrees(90.0f);
            case class_2350.field_11034 -> class_7833.field_40716.rotationDegrees(-90.0f);
        };
    }
}

