/*
 * Decompiled with CFR 0.152.
 */
package net.nokunami.elementus.client;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ModAtlases {
    public static Material MOVCADIA_CHEST_MATERIAL;
    public static Material MOVCADIA_CHEST_LEFT_MATERIAL;
    public static Material MOVCADIA_CHEST_RIGHT_MATERIAL;
    public static final Map<WoodType, Material> SIGN_MATERIALS;
    public static final Map<WoodType, Material> HANGING_SIGN_MATERIALS;

    @SubscribeEvent
    public static void registerSheets() {
        MOVCADIA_CHEST_MATERIAL = ModAtlases.getChestMaterial("movcadia_chest");
        MOVCADIA_CHEST_LEFT_MATERIAL = ModAtlases.getChestMaterial("movcadia_chest_left");
        MOVCADIA_CHEST_RIGHT_MATERIAL = ModAtlases.getChestMaterial("movcadia_chest_right");
    }

    private static Material createSignMaterial(WoodType woodType) {
        ResourceLocation location = new ResourceLocation(woodType.f_61839_());
        return new Material(Sheets.f_110739_, new ResourceLocation("elementus", "entity/signs/" + location.m_135815_()));
    }

    private static Material createHangingSignMaterial(WoodType woodType) {
        ResourceLocation location = new ResourceLocation(woodType.f_61839_());
        return new Material(Sheets.f_110739_, new ResourceLocation("elementus", "entity/signs/hanging/" + location.m_135815_()));
    }

    public static Material getChestMaterial(String chestName) {
        return new Material(Sheets.f_110740_, new ResourceLocation("elementus", "entity/tiles/chest/" + chestName));
    }

    public static Material getSignMaterial(WoodType pWoodType) {
        return SIGN_MATERIALS.get(pWoodType);
    }

    public static Material getHangingSignMaterial(WoodType pWoodType) {
        return HANGING_SIGN_MATERIALS.get(pWoodType);
    }

    static {
        SIGN_MATERIALS = WoodType.m_61843_().collect(Collectors.toMap(Function.identity(), ModAtlases::createSignMaterial));
        HANGING_SIGN_MATERIALS = WoodType.m_61843_().collect(Collectors.toMap(Function.identity(), ModAtlases::createHangingSignMaterial));
    }
}

