/*
 * Decompiled with CFR 0.152.
 */
package net.nokunami.elementus.client;

import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.nokunami.elementus.Elementus;
import net.nokunami.elementus.common.entity.living.TamableChestedGolem;
import net.nokunami.elementus.common.entity.living.TamableGolem;
import net.nokunami.elementus.common.inventory.SteelGolemInventoryMenu;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class SteelGolemInventoryScreen
extends AbstractContainerScreen<SteelGolemInventoryMenu> {
    private static final ResourceLocation RESOURCE_LOCATION = Elementus.modLoc("textures/gui/container/steel_golem.png");
    private static final Component MISSING_UPGRADE_TOOLTIP = Component.m_237115_((String)"container.steel_golem.missing_upgrade_tooltip");
    private static final Component MISSING_LEAVES_TOOLTIP = Component.m_237115_((String)"container.steel_golem.missing_leaves_tooltip");
    private static final Component MISSING_CARPET_TOOLTIP = Component.m_237115_((String)"container.steel_golem.missing_carpet_tooltip");
    private final TamableGolem golem;
    private float xMouse;
    private float yMouse;

    public SteelGolemInventoryScreen(SteelGolemInventoryMenu inventoryMenu, Inventory inventory, TamableGolem steelGolem) {
        super((AbstractContainerMenu)inventoryMenu, inventory, steelGolem.m_5446_());
        this.golem = steelGolem;
        this.f_97731_ = this.f_97727_ - 75;
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        TamableChestedGolem chestedGolem;
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        guiGraphics.m_280218_(RESOURCE_LOCATION, i, j, 0, 0, this.f_97726_, 182);
        TamableGolem tamableGolem = this.golem;
        if (tamableGolem instanceof TamableChestedGolem && (chestedGolem = (TamableChestedGolem)tamableGolem).hasChest()) {
            guiGraphics.m_280218_(RESOURCE_LOCATION, i + 79, j + 17, 0, this.f_97727_ + 18, ((TamableChestedGolem)this.golem).getInventoryColumns() * 18, 72);
        }
        if (this.golem.m_6741_()) {
            guiGraphics.m_280218_(RESOURCE_LOCATION, i + 7, j + 35 - 18, 90, this.f_97727_ + 18, 18, 18);
        }
        if (this.golem.canWearArmor()) {
            guiGraphics.m_280218_(RESOURCE_LOCATION, i + 7, j + 35, 90, this.f_97727_ + 36, 18, 18);
        }
        guiGraphics.m_280218_(RESOURCE_LOCATION, i + 7, j + 35 + 18, 90, this.f_97727_ + 54, 18, 18);
        guiGraphics.m_280218_(RESOURCE_LOCATION, i + 7, j + 35 + 36, 90, this.f_97727_ + 72, 18, 18);
        InventoryScreen.m_274545_((GuiGraphics)guiGraphics, (int)(i + 51), (int)(j + 80), (int)18, (float)((float)(i + 51) - this.xMouse), (float)((float)(j + 75 - 50) - this.yMouse), (LivingEntity)this.golem);
    }

    private void renderOnboardingTooltips(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        Optional<Component> optional = Optional.empty();
        if (this.f_97734_ != null) {
            ItemStack armorSlot = ((SteelGolemInventoryMenu)this.f_97732_).m_38853_(1).m_7993_();
            ItemStack leavesSlot = ((SteelGolemInventoryMenu)this.f_97732_).m_38853_(2).m_7993_();
            ItemStack carpetSlot = ((SteelGolemInventoryMenu)this.f_97732_).m_38853_(3).m_7993_();
            if (armorSlot.m_41619_() && this.f_97734_.f_40219_ == 1) {
                optional = Optional.of(MISSING_UPGRADE_TOOLTIP);
            }
            if (leavesSlot.m_41619_() && this.f_97734_.f_40219_ == 2) {
                optional = Optional.of(MISSING_LEAVES_TOOLTIP);
            }
            if (carpetSlot.m_41619_() && this.f_97734_.f_40219_ == 3) {
                optional = Optional.of(MISSING_CARPET_TOOLTIP);
            }
        }
        optional.ifPresent(p_280863_ -> pGuiGraphics.m_280245_(this.f_96547_, this.f_96547_.m_92923_((FormattedText)p_280863_, 115), pMouseX, pMouseY));
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        this.xMouse = mouseX;
        this.yMouse = mouseY;
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.renderOnboardingTooltips(guiGraphics, mouseX, mouseY);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }
}

