/*
 * Decompiled with CFR 0.152.
 */
package net.nokunami.elementus.client.gui.screens.inventory.tooltip;

import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.nokunami.elementus.Elementus;
import net.nokunami.elementus.client.render.item.inventory.CatalystTooltip;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class ClientCatalystTooltip
implements ClientTooltipComponent {
    public static final ResourceLocation TEXTURE_LOCATION = Elementus.modLoc("textures/gui/container/catalyst_slot.png");
    private static final int MARGIN_Y = 4;
    private static final int TEX_SIZE_X = 32;
    private static final int TEX_SIZE_Y = 16;
    private static final int SLOT_SIZE_X = 16;
    private static final int SLOT_SIZE_Y = 12;
    private final NonNullList<ItemStack> coreItem;
    private final NonNullList<ItemStack> elytraItem;

    public ClientCatalystTooltip(CatalystTooltip tooltip) {
        this.coreItem = tooltip.getCoreItem();
        this.elytraItem = tooltip.getElytraItem();
    }

    public int m_142103_() {
        return this.gridSizeY() * 12 + 2 + 4;
    }

    public int m_142069_(@NotNull Font pFont) {
        return this.gridSizeX() * 16 + 2;
    }

    public void m_183452_(@NotNull Font pFont, int pX, int pY, @NotNull GuiGraphics pGuiGraphics) {
        int sizeX = this.gridSizeX();
        int sizeY = this.gridSizeY();
        int k = 0;
        for (int l = 0; l < sizeY; ++l) {
            for (int i1 = 0; i1 < sizeX; ++i1) {
                int j1 = pX + i1 * 16;
                int k1 = pY + l * 16;
                this.renderSlot(j1, k1, k++, pGuiGraphics);
            }
        }
    }

    private void renderSlot(int pX, int pY, int pItemIndex, GuiGraphics pGuiGraphics) {
        ItemStack itemstack;
        if (this.coreItem.isEmpty()) {
            this.blit(pGuiGraphics, pX, pY, Texture.CORE);
        } else {
            itemstack = (ItemStack)this.coreItem.get(0);
            pGuiGraphics.m_280256_(itemstack, pX, pY, pItemIndex);
        }
        if (this.elytraItem.isEmpty()) {
            this.blit(pGuiGraphics, pX + 16, pY, Texture.ELYTRA);
        } else {
            itemstack = (ItemStack)this.elytraItem.get(0);
            pGuiGraphics.m_280256_(itemstack, pX + 16, pY, pItemIndex);
        }
    }

    private void blit(GuiGraphics pGuiGraphics, int pX, int pY, Texture pTexture) {
        pGuiGraphics.m_280398_(TEXTURE_LOCATION, pX, pY, 0, (float)pTexture.x, (float)pTexture.y, pTexture.w, pTexture.h, 32, 16);
    }

    private int gridSizeX() {
        return 1;
    }

    private int gridSizeY() {
        return this.gridSizeX();
    }

    @OnlyIn(value=Dist.CLIENT)
    static enum Texture {
        ELYTRA(16, 0, 16, 16),
        CORE(0, 0, 16, 16);

        public final int x;
        public final int y;
        public final int w;
        public final int h;

        private Texture(int pX, int pY, int pW, int pH) {
            this.x = pX;
            this.y = pY;
            this.w = pW;
            this.h = pH;
        }
    }
}

