/*
 * Decompiled with CFR 0.152.
 */
package net.nokunami.elementus.client.model.mob;

import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.nokunami.elementus.client.animation.definitions.SteelGolemChestAnimation;
import net.nokunami.elementus.client.model.mob.SteelGolemModel;
import net.nokunami.elementus.common.entity.living.SteelGolem;
import org.jetbrains.annotations.NotNull;

public class SteelGolemChestModel<T extends SteelGolem>
extends SteelGolemModel<T> {
    private final ModelPart chestTop;
    private final ModelPart chestBottom;
    private final ModelPart chestLatch;

    public SteelGolemChestModel(ModelPart root) {
        super(root);
        ModelPart bone = root.m_171324_("bone");
        ModelPart body = bone.m_171324_("body");
        ModelPart head = body.m_171324_("head");
        ModelPart left_arm = body.m_171324_("left_arm");
        ModelPart right_arm = body.m_171324_("right_arm");
        this.chestTop = body.m_171324_("chest_top");
        this.chestBottom = this.chestTop.m_171324_("chest_bottom");
        this.chestLatch = this.chestTop.m_171324_("chest_latch");
        ModelPart left_leg = bone.m_171324_("left_leg");
        ModelPart right_leg = bone.m_171324_("right_leg");
    }

    public static LayerDefinition createChestLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition bone = partdefinition.m_171599_("bone", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.5f, (float)0.0f));
        PartDefinition body = bone.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-9.0f, -20.0f, -7.0f, 18.0f, 14.0f, 14.0f, new CubeDeformation(0.0f)).m_171514_(64, 0).m_171488_(-6.0f, -6.0f, -5.0f, 12.0f, 6.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)5.5f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(64, 16).m_171488_(-5.0f, -9.0f, -5.0f, 10.0f, 9.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(64, 35).m_171488_(-5.0f, -5.0f, -5.0f, 10.0f, 2.0f, 10.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)0.0f, (float)-20.0f, (float)-3.5f));
        PartDefinition left_arm = body.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(30, 28).m_171488_(0.0f, -6.0f, -4.0f, 7.0f, 36.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)9.0f, (float)-13.0f, (float)0.0f));
        PartDefinition right_arm = body.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(0, 28).m_171488_(-7.0f, -6.0f, -4.0f, 7.0f, 36.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-9.0f, (float)-13.0f, (float)0.0f));
        PartDefinition chest_top = body.m_171599_("chest_top", CubeListBuilder.m_171558_().m_171514_(64, 48).m_171488_(-7.0f, -2.5f, 0.0f, 14.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-3.5f, (float)5.0f));
        PartDefinition chest_bottom = chest_top.m_171599_("chest_bottom", CubeListBuilder.m_171558_().m_171514_(64, 55).m_171488_(-7.0f, 0.0f, 0.0f, 14.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-0.5f, (float)0.0f));
        PartDefinition chest_latch = chest_top.m_171599_("chest_latch", CubeListBuilder.m_171558_().m_171514_(64, 64).m_171488_(-1.0f, 0.0f, 0.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-0.5f, (float)4.0f));
        PartDefinition left_leg = bone.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(30, 72).m_171488_(-3.5f, 0.0f, -4.0f, 7.0f, 18.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.5f, (float)5.5f, (float)0.0f));
        PartDefinition right_leg = bone.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 72).m_171488_(-3.5f, 0.0f, -4.0f, 7.0f, 18.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.5f, (float)5.5f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    @Override
    public void setupAnim(@NotNull T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.resetChestTopPos();
        this.resetChestBottomPos();
        this.resetChestLatchPos();
        this.m_233381_(((SteelGolem)((Object)entity)).chestOpened, SteelGolemChestAnimation.chestOpen, ageInTicks);
        this.m_233381_(((SteelGolem)((Object)entity)).chestClosed, SteelGolemChestAnimation.chestClosed, ageInTicks);
        this.m_267799_(SteelGolemChestAnimation.walkCycle, limbSwing, limbSwingAmount, 4.45f, 500.0f);
    }

    private void resetChestTopPos() {
        this.chestTop.f_104200_ = 0.0f;
        this.chestTop.f_104201_ = -3.5f;
        this.chestTop.f_104202_ = 5.0f;
        this.chestTop.f_104203_ = 0.0f;
        this.chestTop.f_104204_ = 0.0f;
        this.chestTop.f_104205_ = 0.0f;
    }

    private void resetChestBottomPos() {
        this.chestBottom.f_104200_ = 0.0f;
        this.chestBottom.f_104201_ = -0.5f;
        this.chestBottom.f_104202_ = 0.0f;
        this.chestBottom.f_104203_ = 0.0f;
        this.chestBottom.f_104204_ = 0.0f;
        this.chestBottom.f_104205_ = 0.0f;
    }

    private void resetChestLatchPos() {
        this.chestLatch.f_104200_ = 0.0f;
        this.chestLatch.f_104201_ = -0.5f;
        this.chestLatch.f_104202_ = 4.0f;
        this.chestLatch.f_104203_ = 0.0f;
        this.chestLatch.f_104204_ = 0.0f;
        this.chestLatch.f_104205_ = 0.0f;
    }
}

