/*
 * Decompiled with CFR 0.152.
 */
package net.nokunami.elementus.client.model.mob;

import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.nokunami.elementus.client.animation.definitions.SteelGolemAnimation;
import net.nokunami.elementus.client.animation.definitions.SteelGolemAttackAnimation;
import net.nokunami.elementus.client.animation.definitions.SteelGolemChestAnimation;
import net.nokunami.elementus.common.entity.living.SteelGolem;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class SteelGolemModel<T extends SteelGolem>
extends HierarchicalModel<T> {
    public final float walkMaxAnimSpeed = 4.45f;
    public final float walkAnimScaleFactor = 500.0f;
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart left_arm;
    private final ModelPart right_arm;
    private final ModelPart left_leg;
    private final ModelPart right_leg;

    public SteelGolemModel(ModelPart pRoot) {
        this.root = pRoot;
        ModelPart bone = this.root.m_171324_("bone");
        this.body = bone.m_171324_("body");
        this.head = this.body.m_171324_("head");
        this.left_arm = this.body.m_171324_("left_arm");
        this.right_arm = this.body.m_171324_("right_arm");
        this.left_leg = bone.m_171324_("left_leg");
        this.right_leg = bone.m_171324_("right_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition bone = partdefinition.m_171599_("bone", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.5f, (float)0.0f));
        PartDefinition body = bone.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-9.0f, -20.0f, -7.0f, 18.0f, 14.0f, 14.0f, new CubeDeformation(0.0f)).m_171514_(64, 0).m_171488_(-6.0f, -6.0f, -5.0f, 12.0f, 6.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)5.5f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(64, 16).m_171488_(-5.0f, -9.0f, -5.0f, 10.0f, 9.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-20.0f, (float)-3.5f));
        body.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(30, 28).m_171488_(0.0f, -6.0f, -4.0f, 7.0f, 36.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)9.0f, (float)-13.0f, (float)0.0f));
        body.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(0, 28).m_171488_(-7.0f, -6.0f, -4.0f, 7.0f, 36.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-9.0f, (float)-13.0f, (float)0.0f));
        bone.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(30, 72).m_171488_(-3.5f, 0.0f, -4.0f, 7.0f, 18.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.5f, (float)5.5f, (float)0.0f));
        bone.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 72).m_171488_(-3.5f, 0.0f, -4.0f, 7.0f, 18.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.5f, (float)5.5f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public static LayerDefinition createBodyCarpetLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition bone = partdefinition.m_171599_("bone", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.5f, (float)0.0f));
        PartDefinition body = bone.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-9.0f, -20.0f, -7.0f, 18.0f, 14.0f, 14.0f, new CubeDeformation(0.0f)).m_171514_(0, 28).m_171488_(-9.0f, -6.0f, -7.0f, 18.0f, 24.0f, 14.0f, new CubeDeformation(0.0f)).m_171514_(128, 0).m_171488_(-6.0f, -6.0f, -5.0f, 12.0f, 6.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)5.5f, (float)0.0f));
        PartDefinition jacket = body.m_171599_("jacket", CubeListBuilder.m_171558_().m_171514_(128, 16).m_171488_(-6.0f, -6.0f, -5.0f, 12.0f, 6.0f, 10.0f, new CubeDeformation(0.25f)).m_171514_(64, 0).m_171488_(-9.0f, -20.0f, -7.0f, 18.0f, 14.0f, 14.0f, new CubeDeformation(0.25f)).m_171514_(64, 28).m_171488_(-9.0f, -5.55f, -7.0f, 18.0f, 24.0f, 14.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(128, 32).m_171488_(-5.0f, -9.0f, -5.0f, 10.0f, 9.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(128, 51).m_171488_(-5.0f, -9.0f, -5.0f, 10.0f, 9.0f, 10.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)0.0f, (float)-20.0f, (float)-3.5f));
        PartDefinition left_arm = body.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(64, 66).m_171488_(0.0f, -6.0f, -4.0f, 7.0f, 36.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(96, 66).m_171488_(0.0f, -6.0f, -4.0f, 7.0f, 36.0f, 8.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)9.0f, (float)-13.0f, (float)0.0f));
        PartDefinition right_arm = body.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(0, 66).m_171488_(-7.0f, -6.0f, -4.0f, 7.0f, 36.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(32, 66).m_171488_(-7.0f, -6.0f, -4.0f, 7.0f, 36.0f, 8.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)-9.0f, (float)-13.0f, (float)0.0f));
        PartDefinition left_leg = bone.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(64, 110).m_171488_(-3.5f, 0.0f, -4.0f, 7.0f, 18.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(96, 110).m_171488_(-3.5f, 0.0f, -4.0f, 7.0f, 18.0f, 8.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)4.5f, (float)5.5f, (float)0.0f));
        PartDefinition right_leg = bone.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 110).m_171488_(-3.5f, 0.0f, -4.0f, 7.0f, 18.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(32, 110).m_171488_(-3.5f, 0.0f, -4.0f, 7.0f, 18.0f, 8.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)-4.5f, (float)5.5f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)176, (int)176);
    }

    public static LayerDefinition createExtraLayer1(CubeDeformation deformation) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition bone = partdefinition.m_171599_("bone", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.5f, (float)0.0f));
        PartDefinition body = bone.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-9.0f, -20.0f, -7.0f, 18.0f, 14.0f, 14.0f, deformation).m_171514_(0, 98).m_171488_(-6.0f, -6.0f, -5.0f, 12.0f, 6.0f, 10.0f, deformation), PartPose.m_171419_((float)0.0f, (float)5.5f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(84, 98).m_171488_(-5.0f, -9.0f, -5.0f, 10.0f, 9.0f, 10.0f, deformation), PartPose.m_171419_((float)0.0f, (float)-20.0f, (float)-3.5f));
        PartDefinition left_arm = body.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(90, 28).m_171488_(0.0f, -6.0f, -4.0f, 7.0f, 36.0f, 8.0f, deformation), PartPose.m_171419_((float)9.0f, (float)-13.0f, (float)0.0f));
        PartDefinition right_arm = body.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(0, 28).m_171488_(-7.0f, -6.0f, -4.0f, 7.0f, 36.0f, 8.0f, deformation), PartPose.m_171419_((float)-9.0f, (float)-13.0f, (float)0.0f));
        PartDefinition left_leg = bone.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(90, 72).m_171488_(-3.5f, 0.0f, -4.0f, 7.0f, 18.0f, 8.0f, deformation), PartPose.m_171419_((float)4.5f, (float)5.5f, (float)0.0f));
        PartDefinition right_leg = bone.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 72).m_171488_(-3.5f, 0.0f, -4.0f, 7.0f, 18.0f, 8.0f, deformation), PartPose.m_171419_((float)-4.5f, (float)5.5f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)192, (int)192);
    }

    public static LayerDefinition createExtraLayer2(CubeDeformation deformation) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition bone = partdefinition.m_171599_("bone", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.5f, (float)0.0f));
        PartDefinition body = bone.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(64, 0).m_171488_(-9.0f, -20.0f, -7.0f, 18.0f, 14.0f, 14.0f, deformation).m_171514_(0, 114).m_171488_(-6.0f, -6.0f, -5.0f, 12.0f, 6.0f, 10.0f, deformation), PartPose.m_171419_((float)0.0f, (float)5.5f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(84, 117).m_171488_(-5.0f, -9.0f, -5.0f, 10.0f, 9.0f, 10.0f, deformation), PartPose.m_171419_((float)0.0f, (float)-20.0f, (float)-3.5f));
        PartDefinition left_arm = body.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(120, 28).m_171488_(0.0f, -6.0f, -4.0f, 7.0f, 36.0f, 8.0f, deformation), PartPose.m_171419_((float)9.0f, (float)-13.0f, (float)0.0f));
        PartDefinition right_arm = body.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(30, 28).m_171488_(-7.0f, -6.0f, -4.0f, 7.0f, 36.0f, 8.0f, deformation), PartPose.m_171419_((float)-9.0f, (float)-13.0f, (float)0.0f));
        PartDefinition left_leg = bone.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(120, 72).m_171488_(-3.5f, 0.0f, -4.0f, 7.0f, 18.0f, 8.0f, deformation), PartPose.m_171419_((float)4.5f, (float)5.5f, (float)0.0f));
        PartDefinition right_leg = bone.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(30, 72).m_171488_(-3.5f, 0.0f, -4.0f, 7.0f, 18.0f, 8.0f, deformation), PartPose.m_171419_((float)-4.5f, (float)5.5f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)192, (int)192);
    }

    public static LayerDefinition createExtraLayer3(CubeDeformation deformation) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition bone = partdefinition.m_171599_("bone", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.5f, (float)0.0f));
        PartDefinition body = bone.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(128, 0).m_171488_(-9.0f, -20.0f, -7.0f, 18.0f, 14.0f, 14.0f, deformation).m_171514_(0, 130).m_171488_(-6.0f, -6.0f, -5.0f, 12.0f, 6.0f, 10.0f, deformation), PartPose.m_171419_((float)0.0f, (float)5.5f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(84, 136).m_171488_(-5.0f, -9.0f, -5.0f, 10.0f, 9.0f, 10.0f, deformation), PartPose.m_171419_((float)0.0f, (float)-20.0f, (float)-3.5f));
        PartDefinition left_arm = body.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(150, 28).m_171488_(0.0f, -6.0f, -4.0f, 7.0f, 36.0f, 8.0f, deformation), PartPose.m_171419_((float)9.0f, (float)-13.0f, (float)0.0f));
        PartDefinition right_arm = body.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(60, 28).m_171488_(-7.0f, -6.0f, -4.0f, 7.0f, 36.0f, 8.0f, deformation), PartPose.m_171419_((float)-9.0f, (float)-13.0f, (float)0.0f));
        PartDefinition left_leg = bone.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(150, 72).m_171488_(-3.5f, 0.0f, -4.0f, 7.0f, 18.0f, 8.0f, deformation), PartPose.m_171419_((float)4.5f, (float)5.5f, (float)0.0f));
        PartDefinition right_leg = bone.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(60, 72).m_171488_(-3.5f, 0.0f, -4.0f, 7.0f, 18.0f, 8.0f, deformation), PartPose.m_171419_((float)-4.5f, (float)5.5f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)192, (int)192);
    }

    public void setupAnim(@NotNull T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        AnimationDefinition loopAttackAnim;
        this.resetBodyPos();
        this.resetHeadPos();
        this.resetArmPos();
        this.resetLegPos();
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        AnimationDefinition animationDefinition = ((SteelGolem)((Object)entity)).getAttackType() == 0 ? SteelGolemAttackAnimation.leftAttackLoop : (loopAttackAnim = ((SteelGolem)((Object)entity)).getAttackType() == 1 ? SteelGolemAttackAnimation.rightAttackLoop : SteelGolemAttackAnimation.upswingAttackLoop4);
        AnimationDefinition endAttackAnim = ((SteelGolem)((Object)entity)).getAttackType() == 0 ? SteelGolemAttackAnimation.leftAttackEnd : (((SteelGolem)((Object)entity)).getAttackType() == 1 ? SteelGolemAttackAnimation.rightAttackEnd : SteelGolemAttackAnimation.upswingAttackEnd3);
        this.m_233381_(((SteelGolem)((Object)entity)).attackLoopAnimationState, loopAttackAnim, ageInTicks);
        this.m_233381_(((SteelGolem)((Object)entity)).attackEndAnimationState, endAttackAnim, ageInTicks);
        this.m_233381_(((SteelGolem)((Object)entity)).upswingAttackAnimationState, SteelGolemAttackAnimation.upswingAttackLoop4, ageInTicks);
        if (entity.m_6047_()) {
            this.m_288214_(SteelGolemAnimation.crouch);
        }
        this.m_233381_(((SteelGolem)((Object)entity)).sitFromStandAnimState, SteelGolemAnimation.sitFromStand, ageInTicks);
        this.m_233381_(((SteelGolem)((Object)entity)).standFromSitAnimState, SteelGolemAnimation.standFromSit, ageInTicks);
        this.m_233381_(((SteelGolem)((Object)entity)).brokenAnim, SteelGolemAnimation.brokenDown, ageInTicks);
        this.m_233381_(((SteelGolem)((Object)entity)).repairedAnim, SteelGolemAnimation.repairUp, ageInTicks);
        this.m_233381_(((SteelGolem)((Object)entity)).ridden, SteelGolemAnimation.ridden, ageInTicks);
        this.m_233381_(((SteelGolem)((Object)entity)).unRide, SteelGolemAnimation.unRide, ageInTicks);
        if (!((SteelGolem)((Object)entity)).isChassisBroken()) {
            if (entity.m_20160_() || entity.m_20142_()) {
                this.m_267799_(SteelGolemAnimation.walkCycleWhileRidden, limbSwing, limbSwingAmount, 4.45f, 500.0f);
            } else {
                this.m_267799_(SteelGolemAnimation.walkCycle, limbSwing, limbSwingAmount, 4.45f, 500.0f);
            }
        }
        this.m_233381_(((SteelGolem)((Object)entity)).chestOpened, SteelGolemChestAnimation.chestOpen, ageInTicks);
        this.m_233381_(((SteelGolem)((Object)entity)).chestClosed, SteelGolemChestAnimation.chestClosed, ageInTicks);
    }

    private void resetBodyPos() {
        this.body.f_104200_ = 0.0f;
        this.body.f_104201_ = 5.0f;
        this.body.f_104202_ = 0.0f;
        this.body.f_104203_ = 0.0f;
        this.body.f_104204_ = 0.0f;
        this.body.f_104205_ = 0.0f;
    }

    private void resetHeadPos() {
        this.head.f_104200_ = 0.0f;
        this.head.f_104201_ = -20.0f;
        this.head.f_104202_ = -3.5f;
        this.head.f_104203_ = 0.0f;
        this.head.f_104204_ = 0.0f;
        this.head.f_104205_ = 0.0f;
    }

    private void resetArmPos() {
        this.left_arm.f_104200_ = 9.0f;
        this.left_arm.f_104201_ = -13.0f;
        this.left_arm.f_104202_ = 0.0f;
        this.left_arm.f_104203_ = 0.0f;
        this.left_arm.f_104204_ = 0.0f;
        this.left_arm.f_104205_ = 0.0f;
        this.right_arm.f_104200_ = -this.left_arm.f_104200_;
        this.right_arm.f_104201_ = this.left_arm.f_104201_;
        this.right_arm.f_104202_ = this.left_arm.f_104202_;
        this.right_arm.f_104203_ = this.left_arm.f_104203_;
        this.right_arm.f_104204_ = this.left_arm.f_104204_;
        this.right_arm.f_104205_ = this.left_arm.f_104205_;
    }

    private void resetLegPos() {
        this.left_leg.f_104200_ = 4.5f;
        this.left_leg.f_104201_ = 5.0f;
        this.left_leg.f_104202_ = 0.0f;
        this.left_leg.f_104203_ = 0.0f;
        this.left_leg.f_104204_ = 0.0f;
        this.left_leg.f_104205_ = 0.0f;
        this.right_leg.f_104200_ = -this.left_leg.f_104200_;
        this.right_leg.f_104201_ = this.left_leg.f_104201_;
        this.right_leg.f_104202_ = this.left_leg.f_104202_;
        this.right_leg.f_104203_ = this.left_leg.f_104203_;
        this.right_leg.f_104204_ = this.left_leg.f_104204_;
        this.right_leg.f_104205_ = this.left_leg.f_104205_;
    }

    @NotNull
    public ModelPart m_142109_() {
        return this.root;
    }
}

