/*
 * Decompiled with CFR 0.152.
 */
package net.nokunami.elementus.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.nokunami.elementus.client.model.ModModelLayers;
import net.nokunami.elementus.client.model.armor.CatalystBaseModel;
import net.nokunami.elementus.common.item.CatalystArmorItem;
import net.nokunami.elementus.common.item.CatalystItemUtil;
import net.nokunami.elementus.common.registry.ModItems;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class CatalystElytraExtraLayer<T extends LivingEntity, M extends EntityModel<T>>
extends ElytraLayer<T, M> {
    private final CatalystBaseModel<T> catalystBaseModel;

    public CatalystElytraExtraLayer(RenderLayerParent<T, M> pRenderer, EntityModelSet pModelSet) {
        super(pRenderer, pModelSet);
        this.catalystBaseModel = new CatalystBaseModel(pModelSet.m_171103_(ModModelLayers.CATALYST_ARMOR_MODEL));
    }

    public void m_6494_(@NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight, T livingEntity, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack itemstack = livingEntity.m_6844_(EquipmentSlot.CHEST);
        if (this.shouldRender(itemstack, (LivingEntity)livingEntity)) {
            ResourceLocation resourcelocation1 = this.getElytraTexture(itemstack, (LivingEntity)livingEntity);
            VertexConsumer vertexconsumer1 = ItemRenderer.m_115184_((MultiBufferSource)buffer, (RenderType)RenderType.m_110431_((ResourceLocation)resourcelocation1), (boolean)false, (boolean)itemstack.m_41790_());
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, 0.0f, 0.125f);
            this.m_117386_().m_102624_(this.catalystBaseModel);
            this.catalystBaseModel.m_6973_(livingEntity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            this.catalystBaseModel.renderElytra(poseStack, vertexconsumer1, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            poseStack.m_85849_();
        }
    }

    public boolean shouldRender(@NotNull ItemStack stack, LivingEntity entity) {
        return entity.m_6844_(EquipmentSlot.CHEST).m_150930_((Item)ModItems.ElementusItems.CATALYST_CHESTPLATE.get()) && CatalystArmorItem.getElytraEquipped(stack).findAny().isPresent();
    }

    @NotNull
    public ResourceLocation getElytraTexture(@NotNull ItemStack stack, @NotNull LivingEntity entity) {
        return new ResourceLocation(CatalystItemUtil.baseTextures(stack, (Entity)entity));
    }
}

