/*
 * Decompiled with CFR 0.152.
 */
package net.nokunami.elementus.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.nokunami.elementus.client.model.ModModelLayers;
import net.nokunami.elementus.client.model.armor.CatalystElytraModel;
import net.nokunami.elementus.common.item.CatalystArmorItem;
import net.nokunami.elementus.common.item.CatalystItemUtil;
import net.nokunami.elementus.common.registry.ModItems;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class CatalystElytraLayer<T extends LivingEntity, M extends EntityModel<T>>
extends ElytraLayer<T, M> {
    private final CatalystElytraModel<T> catalystElytraModel;
    private final CatalystElytraModel<T> elytraModel;

    public CatalystElytraLayer(RenderLayerParent<T, M> pRenderer, EntityModelSet pModelSet) {
        super(pRenderer, pModelSet);
        this.catalystElytraModel = new CatalystElytraModel(pModelSet.m_171103_(ModModelLayers.CATALYST_ELYTRA_MODEL));
        this.elytraModel = new CatalystElytraModel(pModelSet.m_171103_(ModModelLayers.CATALYST_BASE_ELYTRA_MODEL));
    }

    public void m_6494_(@NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight, T livingEntity, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack itemstack = livingEntity.m_6844_(EquipmentSlot.CHEST);
        int type = 0;
        if (this.shouldRender(itemstack, (LivingEntity)livingEntity)) {
            ResourceLocation resourcelocation;
            ResourceLocation resourcelocation1 = this.getCatalystElytraTexture(itemstack, (LivingEntity)livingEntity);
            if (livingEntity instanceof AbstractClientPlayer) {
                AbstractClientPlayer abstractclientplayer = (AbstractClientPlayer)livingEntity;
                if (abstractclientplayer.m_108562_() && abstractclientplayer.m_108563_() != null) {
                    resourcelocation = abstractclientplayer.m_108563_();
                    type = 1;
                } else if (abstractclientplayer.m_108555_() && abstractclientplayer.m_108561_() != null && abstractclientplayer.m_36170_(PlayerModelPart.CAPE)) {
                    resourcelocation = abstractclientplayer.m_108561_();
                    type = 1;
                } else {
                    resourcelocation = this.getElytraTexture(itemstack, (LivingEntity)livingEntity);
                }
            } else {
                resourcelocation = this.getElytraTexture(itemstack, (LivingEntity)livingEntity);
            }
            this.elytraModelType(type, poseStack, buffer, packedLight, livingEntity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, resourcelocation, resourcelocation1, itemstack);
        }
    }

    public boolean shouldRender(@NotNull ItemStack stack, LivingEntity entity) {
        return entity.m_6844_(EquipmentSlot.CHEST).m_150930_((Item)ModItems.ElementusItems.CATALYST_CHESTPLATE.get()) && CatalystArmorItem.getElytraEquipped(stack).findAny().isPresent();
    }

    @NotNull
    public ResourceLocation getElytraTexture(@NotNull ItemStack stack, @NotNull LivingEntity entity) {
        return new ResourceLocation("elementus", CatalystItemUtil.getElytraTexture(stack));
    }

    @NotNull
    public ResourceLocation getCatalystElytraTexture(@NotNull ItemStack stack, @NotNull LivingEntity entity) {
        return new ResourceLocation(CatalystItemUtil.baseTextures(stack, (Entity)entity));
    }

    public void elytraModelType(int type, PoseStack poseStack, MultiBufferSource buffer, int packedLight, T livingEntity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, ResourceLocation resourcelocation1, ResourceLocation resourcelocation2, ItemStack itemStack) {
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 0.0f, 0.125f);
        VertexConsumer vertexconsumer = ItemRenderer.m_115184_((MultiBufferSource)buffer, (RenderType)RenderType.m_110431_((ResourceLocation)resourcelocation1), (boolean)false, (boolean)itemStack.m_41790_());
        if (type == 1) {
            this.m_117386_().m_102624_(this.elytraModel);
            this.elytraModel.setupAnim((LivingEntity)livingEntity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            this.elytraModel.renderBase(poseStack, vertexconsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        } else {
            this.m_117386_().m_102624_(this.catalystElytraModel);
            this.catalystElytraModel.setupAnim((LivingEntity)livingEntity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            this.catalystElytraModel.renderCatalyst(poseStack, vertexconsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        poseStack.m_85849_();
    }
}

