/*
 * Decompiled with CFR 0.152.
 */
package net.nokunami.elementus.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.nokunami.elementus.Elementus;
import net.nokunami.elementus.client.model.ModModelLayers;
import net.nokunami.elementus.client.model.armor.ExtendedArmorModel;
import net.nokunami.elementus.common.item.DiarkriteBootsItem;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class DiarkriteEmissiveLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private final ExtendedArmorModel<T> diarkriteEmissive;

    public DiarkriteEmissiveLayer(RenderLayerParent<T, M> pRenderer, EntityModelSet pModelSet) {
        super(pRenderer);
        this.diarkriteEmissive = new ExtendedArmorModel(pModelSet.m_171103_(ModModelLayers.EXTENDED_ARMOR_MODEL));
    }

    public void render(@NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight, T livingEntity, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack itemstack = livingEntity.m_6844_(EquipmentSlot.FEET);
        if (this.shouldRender(itemstack, (LivingEntity)livingEntity)) {
            ResourceLocation resourcelocation1 = this.getElytraTexture(itemstack, (LivingEntity)livingEntity);
            VertexConsumer vertexconsumer1 = ItemRenderer.m_115184_((MultiBufferSource)buffer, (RenderType)RenderType.m_110431_((ResourceLocation)resourcelocation1), (boolean)false, (boolean)itemstack.m_41790_());
            poseStack.m_85836_();
            this.m_117386_().m_102624_(this.diarkriteEmissive);
            this.diarkriteEmissive.m_6973_((LivingEntity)livingEntity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            float oBrightness = 0.0f;
            float brightness = 0.0f;
            brightness += (0.0f - brightness) * 0.8f;
            float strength = 0.5f + Mth.m_14036_((float)((float)Math.cos((ageInTicks + partialTick) * 0.1f) - 0.25f), (float)-0.25f, (float)0.5f);
            strength += Mth.m_14179_((float)partialTick, (float)oBrightness, (float)brightness) * 0.025f * (float)Math.PI;
            strength = Mth.m_14036_((float)strength, (float)0.5f, (float)1.0f);
            this.diarkriteEmissive.f_102814_.m_104306_(poseStack, vertexconsumer1, 0xF00000, OverlayTexture.f_118083_, strength, strength, strength, 1.0f);
            this.diarkriteEmissive.f_102813_.m_104306_(poseStack, vertexconsumer1, 0xF00000, OverlayTexture.f_118083_, strength, strength, strength, 1.0f);
            poseStack.m_85849_();
        }
    }

    public boolean shouldRender(@NotNull ItemStack stack, LivingEntity entity) {
        return DiarkriteBootsItem.SculkWalkerActivation(entity);
    }

    @NotNull
    public ResourceLocation getElytraTexture(@NotNull ItemStack stack, @NotNull LivingEntity entity) {
        return Elementus.modLoc("textures/models/armor/diarkrite_layer_1_emissive.png");
    }
}

