/*
 * Decompiled with CFR 0.152.
 */
package net.nokunami.elementus.client.render.entity.steelGolem;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.nokunami.elementus.Elementus;
import net.nokunami.elementus.client.model.mob.SteelGolemModel;
import net.nokunami.elementus.common.entity.living.SteelGolem;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class SteelGolemLayer
extends RenderLayer<SteelGolem, SteelGolemModel<SteelGolem>> {
    private static final Map<SteelGolem.Crackiness, ResourceLocation> GOLEM_CRACKS = ImmutableMap.of((Object)((Object)SteelGolem.Crackiness.LOW), (Object)new ResourceLocation("elementus", "textures/entity/golem/steel_golem/steel_golem_crackiness_low.png"), (Object)((Object)SteelGolem.Crackiness.MEDIUM), (Object)new ResourceLocation("elementus", "textures/entity/golem/steel_golem/steel_golem_crackiness_medium.png"), (Object)((Object)SteelGolem.Crackiness.HIGH), (Object)new ResourceLocation("elementus", "textures/entity/golem/steel_golem/steel_golem_crackiness_high.png"));
    private static final Map<SteelGolem.ChassisCrackiness, ResourceLocation> CHASSIS_CRACKS = ImmutableMap.of((Object)((Object)SteelGolem.ChassisCrackiness.VERYLOW), (Object)new ResourceLocation("elementus", "textures/entity/golem/steel_golem/steel_golem_chassis_crackiness_very_low.png"), (Object)((Object)SteelGolem.ChassisCrackiness.LOW), (Object)new ResourceLocation("elementus", "textures/entity/golem/steel_golem/steel_golem_chassis_crackiness_low.png"), (Object)((Object)SteelGolem.ChassisCrackiness.MEDIUM), (Object)new ResourceLocation("elementus", "textures/entity/golem/steel_golem/steel_golem_chassis_crackiness_medium.png"), (Object)((Object)SteelGolem.ChassisCrackiness.HIGH), (Object)new ResourceLocation("elementus", "textures/entity/golem/steel_golem/steel_golem_chassis_crackiness_high.png"));

    public SteelGolemLayer(RenderLayerParent<SteelGolem, SteelGolemModel<SteelGolem>> render) {
        super(render);
    }

    public void render(@NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight, SteelGolem golem, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        int fullBright = 0xF000F0;
        float eyeRGB = 1.0f;
        if (golem.isChassisBroken()) {
            eyeRGB = Mth.m_14036_((float)((float)Math.cos(((float)golem.eyeLayerTick + partialTick) * 0.1f) - 0.125f), (float)-0.25f, (float)1.0f);
        }
        eyeRGB += Mth.m_14179_((float)partialTick, (float)golem.eyeOldLayerBrightness, (float)golem.eyeLayerBrightness) * 1.0f * (float)Math.PI;
        eyeRGB = Mth.m_14036_((float)eyeRGB, (float)0.0f, (float)1.0f);
        if (!golem.m_20145_()) {
            SteelGolem.ChassisCrackiness steelgolem$chassis;
            String location = golem.getAggroState() ? "aggressive" : "neutral";
            ResourceLocation eyeTexture = new ResourceLocation("elementus", "textures/entity/golem/steel_golem/steel_golem_" + location + ".png");
            RenderType renderLayer = RenderType.m_234338_((ResourceLocation)eyeTexture);
            VertexConsumer vertex = buffer.m_6299_(renderLayer);
            ((SteelGolemModel)this.m_117386_()).m_7695_(poseStack, vertex, fullBright, OverlayTexture.f_118083_, eyeRGB, eyeRGB, eyeRGB, eyeRGB);
            SteelGolem.Crackiness steelgolem$crackiness = golem.getCrackiness();
            if (steelgolem$crackiness != SteelGolem.Crackiness.NONE) {
                ResourceLocation golemCracks = GOLEM_CRACKS.get((Object)steelgolem$crackiness);
                SteelGolemLayer.m_117376_((EntityModel)this.m_117386_(), (ResourceLocation)golemCracks, (PoseStack)poseStack, (MultiBufferSource)buffer, (int)packedLight, (LivingEntity)golem, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            if ((steelgolem$chassis = golem.getChassisCrackiness()) != SteelGolem.ChassisCrackiness.NONE) {
                ResourceLocation chassisCracks = CHASSIS_CRACKS.get((Object)steelgolem$chassis);
                SteelGolemLayer.m_117376_((EntityModel)this.m_117386_(), (ResourceLocation)chassisCracks, (PoseStack)poseStack, (MultiBufferSource)buffer, (int)packedLight, (LivingEntity)golem, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            if (golem.getMossStage() > 0) {
                ResourceLocation mossTexture = Elementus.modLoc("textures/entity/golem/steel_golem/moss/steel_golem_moss_" + golem.getMossStage() + ".png");
                SteelGolemLayer.m_117376_((EntityModel)this.m_117386_(), (ResourceLocation)mossTexture, (PoseStack)poseStack, (MultiBufferSource)buffer, (int)packedLight, (LivingEntity)golem, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
    }
}

