/*
 * Decompiled with CFR 0.152.
 */
package net.nokunami.elementus.client.render.vehicle;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.BoatRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.vehicle.Boat;
import net.nokunami.elementus.common.entity.vehicle.ModBoatEntity;
import net.nokunami.elementus.common.entity.vehicle.ModChestBoatEntity;
import org.jetbrains.annotations.NotNull;

public class ModBoatRenderer
extends BoatRenderer {
    private final Map<ModBoatEntity.Type, Pair<ResourceLocation, ListModel<Boat>>> boatResources = (Map)Stream.of(ModBoatEntity.Type.values()).collect(ImmutableMap.toImmutableMap(type -> type, type -> Pair.of((Object)new ResourceLocation("elementus", ModBoatRenderer.getTextureLocation(type, pChestBoat)), this.createBoatModel(pContext, (ModBoatEntity.Type)((Object)type), pChestBoat))));

    public ModBoatRenderer(EntityRendererProvider.Context pContext, boolean pChestBoat) {
        super(pContext, pChestBoat);
    }

    private static String getTextureLocation(ModBoatEntity.Type pType, boolean pChestBoat) {
        return pChestBoat ? "textures/entity/chest_boat/" + pType.getName() + ".png" : "textures/entity/boat/" + pType.getName() + ".png";
    }

    private ListModel<Boat> createBoatModel(EntityRendererProvider.Context pContext, ModBoatEntity.Type pType, boolean pChestBoat) {
        ModelLayerLocation modellayerlocation = pChestBoat ? ModBoatRenderer.createChestBoatModelName(pType) : ModBoatRenderer.createBoatModelName(pType);
        ModelPart modelpart = pContext.m_174023_(modellayerlocation);
        return pChestBoat ? new ChestBoatModel(modelpart) : new BoatModel(modelpart);
    }

    public static ModelLayerLocation createBoatModelName(ModBoatEntity.Type pType) {
        return ModBoatRenderer.createLocation("boat/" + pType.getName());
    }

    public static ModelLayerLocation createChestBoatModelName(ModBoatEntity.Type pType) {
        return ModBoatRenderer.createLocation("chest_boat/" + pType.getName());
    }

    private static ModelLayerLocation createLocation(String pPath) {
        return new ModelLayerLocation(new ResourceLocation("elementus", pPath), "main");
    }

    @NotNull
    public Pair<ResourceLocation, ListModel<Boat>> getModelWithLocation(@NotNull Boat boat) {
        if (boat instanceof ModBoatEntity) {
            ModBoatEntity modBoat = (ModBoatEntity)boat;
            return this.boatResources.get((Object)modBoat.getModVariant());
        }
        if (boat instanceof ModChestBoatEntity) {
            ModChestBoatEntity modChestBoatEntity = (ModChestBoatEntity)boat;
            return this.boatResources.get((Object)modChestBoatEntity.getModVariant());
        }
        return super.getModelWithLocation(boat);
    }
}

