/*
 * Decompiled with CFR 0.152.
 */
package net.nokunami.elementus.common.compat.advancednetherite.item;

import com.autovw.advancednetherite.api.annotation.Internal;
import com.autovw.advancednetherite.common.item.AdvancedArmorItem;
import com.autovw.advancednetherite.config.ConfigHelper;
import com.autovw.advancednetherite.core.util.ModTooltips;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.nokunami.elementus.ElementusClient;
import net.nokunami.elementus.common.compat.advancednetherite.ANUtil;
import net.nokunami.elementus.common.registry.ModArmorMaterials;
import org.jetbrains.annotations.Nullable;

public class ANArmorItem
extends AdvancedArmorItem {
    protected final ModArmorMaterials material;

    public ANArmorItem(ModArmorMaterials material, ArmorItem.Type armorType, Item.Properties properties) {
        super((ArmorMaterial)material, armorType, properties);
        this.material = material;
    }

    public boolean pacifiesEndermen() {
        if (this.material == ModArmorMaterials.DIARKRITE_IRON) {
            return ConfigHelper.get().getCommon().getArmor().isIronEndermanPassiveArmor();
        }
        if (this.material == ModArmorMaterials.DIARKRITE_GOLD) {
            return ConfigHelper.get().getCommon().getArmor().isGoldEndermanPassiveArmor();
        }
        if (this.material == ModArmorMaterials.DIARKRITE_EMERALD) {
            return ConfigHelper.get().getCommon().getArmor().isEmeraldEndermanPassiveArmor();
        }
        if (this.material == ModArmorMaterials.DIARKRITE_DIAMOND) {
            return ConfigHelper.get().getCommon().getArmor().isDiamondEndermanPassiveArmor();
        }
        if (this.material == ModArmorMaterials.ANTHEKTITE_IRON) {
            return ConfigHelper.get().getCommon().getArmor().isIronEndermanPassiveArmor();
        }
        if (this.material == ModArmorMaterials.ANTHEKTITE_GOLD) {
            return ConfigHelper.get().getCommon().getArmor().isGoldEndermanPassiveArmor();
        }
        if (this.material == ModArmorMaterials.ANTHEKTITE_EMERALD) {
            return ConfigHelper.get().getCommon().getArmor().isEmeraldEndermanPassiveArmor();
        }
        return this.material == ModArmorMaterials.ANTHEKTITE_DIAMOND ? ConfigHelper.get().getCommon().getArmor().isDiamondEndermanPassiveArmor() : false;
    }

    public boolean pacifiesPiglins() {
        if (this.material == ModArmorMaterials.DIARKRITE_IRON) {
            return ConfigHelper.get().getCommon().getArmor().isIronPiglinPassiveArmor();
        }
        if (this.material == ModArmorMaterials.DIARKRITE_GOLD) {
            return ConfigHelper.get().getCommon().getArmor().isGoldPiglinPassiveArmor();
        }
        if (this.material == ModArmorMaterials.DIARKRITE_EMERALD) {
            return ConfigHelper.get().getCommon().getArmor().isEmeraldPiglinPassiveArmor();
        }
        if (this.material == ModArmorMaterials.DIARKRITE_DIAMOND) {
            return ConfigHelper.get().getCommon().getArmor().isDiamondPiglinPassiveArmor();
        }
        if (this.material == ModArmorMaterials.ANTHEKTITE_IRON) {
            return ConfigHelper.get().getCommon().getArmor().isIronPiglinPassiveArmor();
        }
        if (this.material == ModArmorMaterials.ANTHEKTITE_GOLD) {
            return ConfigHelper.get().getCommon().getArmor().isGoldPiglinPassiveArmor();
        }
        if (this.material == ModArmorMaterials.ANTHEKTITE_EMERALD) {
            return ConfigHelper.get().getCommon().getArmor().isEmeraldPiglinPassiveArmor();
        }
        return this.material == ModArmorMaterials.ANTHEKTITE_DIAMOND ? ConfigHelper.get().getCommon().getArmor().isDiamondPiglinPassiveArmor() : false;
    }

    public boolean pacifiesPhantoms() {
        if (this.material == ModArmorMaterials.DIARKRITE_IRON) {
            return ConfigHelper.get().getCommon().getArmor().isIronPhantomPassiveArmor();
        }
        if (this.material == ModArmorMaterials.DIARKRITE_GOLD) {
            return ConfigHelper.get().getCommon().getArmor().isGoldPhantomPassiveArmor();
        }
        if (this.material == ModArmorMaterials.DIARKRITE_EMERALD) {
            return ConfigHelper.get().getCommon().getArmor().isEmeraldPhantomPassiveArmor();
        }
        if (this.material == ModArmorMaterials.DIARKRITE_DIAMOND) {
            return ConfigHelper.get().getCommon().getArmor().isDiamondPhantomPassiveArmor();
        }
        if (this.material == ModArmorMaterials.ANTHEKTITE_IRON) {
            return ConfigHelper.get().getCommon().getArmor().isIronPhantomPassiveArmor();
        }
        if (this.material == ModArmorMaterials.ANTHEKTITE_GOLD) {
            return ConfigHelper.get().getCommon().getArmor().isGoldPhantomPassiveArmor();
        }
        if (this.material == ModArmorMaterials.ANTHEKTITE_EMERALD) {
            return ConfigHelper.get().getCommon().getArmor().isEmeraldPhantomPassiveArmor();
        }
        return this.material == ModArmorMaterials.ANTHEKTITE_DIAMOND ? ConfigHelper.get().getCommon().getArmor().isDiamondPhantomPassiveArmor() : false;
    }

    public boolean m_41475_() {
        return true;
    }

    public void addTooltips(ItemStack stack, Level level, List<Component> tooltips, TooltipFlag flag) {
    }

    public ChatFormatting customDurabilityBarColor(ItemStack stack) {
        return null;
    }

    @Internal
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flag) {
        if (ConfigHelper.get().getClient().showTooltips()) {
            if (Screen.m_96638_()) {
                if (this.pacifiesEndermen()) {
                    tooltip.add((Component)ModTooltips.ENDERMAN_PASSIVE_TOOLTIP);
                }
                if (this.pacifiesPiglins()) {
                    tooltip.add((Component)ModTooltips.PIGLIN_PASSIVE_TOOLTIP);
                }
                if (this.pacifiesPhantoms()) {
                    tooltip.add((Component)ModTooltips.PHANTOM_PASSIVE_TOOLTIP);
                }
            } else if (this.pacifiesEndermen() || this.pacifiesPiglins() || this.pacifiesPhantoms()) {
                tooltip.add((Component)ModTooltips.SHIFT_KEY_TOOLTIP);
            }
            this.addTooltips(stack, world, tooltip, flag);
        }
    }

    @Internal
    public int m_142159_(ItemStack stack) {
        int originalColor = super.m_142159_(stack);
        return this.customDurabilityBarColor(stack) != null && ConfigHelper.get().getClient().matchingDurabilityBars() ? Objects.requireNonNull(this.customDurabilityBarColor(stack).m_126665_()) : ANUtil.getDurabilityBarColor(originalColor, stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept((IClientItemExtensions)ElementusClient.PROXY.getArmorRenderProperties());
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        ArmorItem item = (ArmorItem)stack.m_41720_();
        String texture = item.m_40401_().m_6082_();
        String domain = "elementus";
        boolean helmet = slot == EquipmentSlot.HEAD;
        boolean leggings = slot == EquipmentSlot.LEGS;
        return String.format(Locale.ROOT, "%s:textures/models/armor/advancednetherite/%s_layer_" + (helmet | leggings ? "2.png" : "1.png"), domain, texture);
    }
}

