/*
 * Decompiled with CFR 0.152.
 */
package net.nokunami.elementus.common.compat.ironsspellbooks;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import io.redspace.ironsspellbooks.api.spells.IPresetSpellContainer;
import io.redspace.ironsspellbooks.api.spells.ISpellContainer;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.nokunami.elementus.ElementusClient;
import net.nokunami.elementus.common.compat.ironsspellbooks.MagicArmorMaterial;
import org.jetbrains.annotations.NotNull;

public class ISSArmorItem
extends ArmorItem
implements IPresetSpellContainer {
    protected final MagicArmorMaterial material;
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;

    public ISSArmorItem(MagicArmorMaterial material, ArmorItem.Type type, Item.Properties properties) {
        super((ArmorMaterial)material, type, properties);
        this.material = material;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        UUID uuid = (UUID)f_265987_.get(type);
        builder.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(uuid, "Armor modifier", (double)this.m_40404_(), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22285_, (Object)new AttributeModifier(uuid, "Armor toughness", (double)this.m_40405_(), AttributeModifier.Operation.ADDITION));
        if (this.f_40378_ > 0.0f) {
            builder.put((Object)Attributes.f_22278_, (Object)new AttributeModifier(uuid, "Knockback resistance", (double)this.f_40378_, AttributeModifier.Operation.ADDITION));
        }
        for (Map.Entry<Attribute, AttributeModifier> modifierEntry : material.getAdditionalAttributes().entrySet()) {
            AttributeModifier atr = modifierEntry.getValue();
            atr = new AttributeModifier(uuid, atr.m_22214_(), atr.m_22218_(), atr.m_22217_());
            builder.put((Object)modifierEntry.getKey(), (Object)atr);
        }
        this.defaultModifiers = builder.build();
    }

    @NotNull
    public Multimap<Attribute, AttributeModifier> m_7167_(@NotNull EquipmentSlot pEquipmentSlot) {
        return pEquipmentSlot == this.f_265916_.m_266308_() ? this.defaultModifiers : super.m_7167_(pEquipmentSlot);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        ArmorItem item = (ArmorItem)stack.m_41720_();
        String texture = item.m_40401_().m_6082_();
        String domain = "elementus";
        boolean helmet = slot == EquipmentSlot.HEAD;
        boolean leggings = slot == EquipmentSlot.LEGS;
        return String.format(Locale.ROOT, "%s:textures/models/armor/irons_spellbooks/%s_layer_" + (leggings | helmet ? "2.png" : "1.png"), domain, texture);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept((IClientItemExtensions)ElementusClient.PROXY.getArmorRenderProperties());
    }

    public void initializeSpellContainer(ItemStack itemStack) {
        ArmorItem armorItem;
        if (itemStack == null) {
            return;
        }
        Item item = itemStack.m_41720_();
        if (item instanceof ArmorItem && (armorItem = (ArmorItem)item).m_266204_() == ArmorItem.Type.CHESTPLATE && !ISpellContainer.isSpellContainer((ItemStack)itemStack)) {
            ISpellContainer spellContainer = ISpellContainer.create((int)1, (boolean)true, (boolean)true);
            spellContainer.save(itemStack);
        }
    }
}

