/*
 * Decompiled with CFR 0.152.
 */
package net.nokunami.elementus.common.compat.sniffsweapons;

import java.util.Locale;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.DyeableArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.nokunami.elementus.ElementusClient;
import net.nokunami.elementus.common.registry.ModArmorMaterials;
import org.jetbrains.annotations.Nullable;

public class SniffsWeaponsArmorItem
extends DyeableArmorItem {
    private final int color;
    private final String texture_type;
    protected final ModArmorMaterials material;

    public SniffsWeaponsArmorItem(ModArmorMaterials material, ArmorItem.Type type, String texture_type, int color, Item.Properties properties) {
        super((ArmorMaterial)material, type, properties);
        this.material = material;
        this.color = color;
        this.texture_type = texture_type;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept((IClientItemExtensions)ElementusClient.PROXY.getArmorRenderProperties());
    }

    public int m_41121_(ItemStack itemStack) {
        CompoundTag compoundTag = itemStack.m_41737_("display");
        return compoundTag != null && compoundTag.m_128425_("color", 99) ? compoundTag.m_128451_("color") : this.color;
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        ArmorItem item = (ArmorItem)stack.m_41720_();
        boolean is_overlay = Objects.equals(type, "overlay");
        String texture = item.m_40401_().m_6082_();
        String domain = "elementus";
        int idx = texture.indexOf(99);
        if (idx != -1) {
            domain = texture.substring(0, idx);
            texture = texture.substring(idx + 1);
        }
        if (this.texture_type.equals("clothed")) {
            String s1 = String.format(Locale.ROOT, "%s:textures/models/armor/sniffs_weapons/clothed_%s_cuirass_layer.png", domain, texture);
            String s2 = String.format(Locale.ROOT, "%s:textures/models/armor/clothed_cuirass_color.png", "sniffsweapons");
            return is_overlay ? s1 : s2;
        }
        return String.format(Locale.ROOT, "%s:textures/models/armor/sniffs_weapons/%s_%s.png", domain, this.texture_type, texture);
    }
}

