/*
 * Decompiled with CFR 0.152.
 */
package net.nokunami.elementus.common.config;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Scanner;
import net.nokunami.elementus.Elementus;
import org.apache.logging.log4j.Logger;
import org.apache.maven.artifact.versioning.ComparableVersion;

public class AetherModConfig {
    private static final Logger logger = Elementus.LOGGER;
    public static final AetherModConfig INSTANCE = new AetherModConfig();
    private static final Path CONFIG_PATH = Elementus.AE_CONFIG_PATH;
    public static final ComparableVersion VERSION = new ComparableVersion("1.4");
    public static double steelGloveDamage;
    public static double steelGloveMovementSpeed;
    public static double steelGloveAttackSpeed;
    public static double steelGloveArmorBonus;
    public static double steelGloveToughnessBonus;
    public static double diarkriteGloveDamage;
    public static double diarkriteGloveMovementSpeed;
    public static double diarkriteGloveAttackSpeed;
    public static double diarkriteGloveArmorBonus;
    public static double diarkriteGloveToughnessBonus;
    public static double anthektiteGloveDamage;
    public static double anthektiteGloveMovementSpeed;
    public static double anthektiteGloveAttackSpeed;
    public static double anthektiteGloveArmorBonus;
    public static double anthektiteGloveToughnessBonus;

    public static void reload() {
        INSTANCE.setDefaults();
        INSTANCE.load();
        logger.info("Aether Config loaded");
    }

    private void setDefaults() {
        steelGloveDamage = 0.6;
        steelGloveMovementSpeed = 0.0;
        steelGloveAttackSpeed = 0.0;
        steelGloveArmorBonus = 0.0;
        steelGloveToughnessBonus = 0.0;
        diarkriteGloveDamage = 1.25;
        diarkriteGloveMovementSpeed = -0.12;
        diarkriteGloveAttackSpeed = -0.05;
        diarkriteGloveArmorBonus = 0.0;
        diarkriteGloveToughnessBonus = 0.0;
        anthektiteGloveDamage = 0.75;
        anthektiteGloveMovementSpeed = 0.0;
        anthektiteGloveAttackSpeed = 0.16;
        anthektiteGloveArmorBonus = 0.0;
        anthektiteGloveToughnessBonus = 0.0;
    }

    /*
     * Unable to fully structure code
     */
    private void load() {
        version = new ComparableVersion("0");
        try {
            reader = Files.newBufferedReader(AetherModConfig.CONFIG_PATH);
            try {
                lineNumber = 0;
lbl6:
                // 23 sources

                block51: while ((line = reader.readLine()) != null) {
                    ++lineNumber;
                    commentStart = line.indexOf(35);
                    if (commentStart != -1) {
                        line = line.substring(0, commentStart);
                    }
                    if ((commentStart = line.indexOf(91)) != -1) {
                        line = line.substring(0, commentStart);
                    }
                    line.trim();
                    if (line.isEmpty()) continue;
                    errorPrefix = String.valueOf(AetherModConfig.CONFIG_PATH) + ": line " + lineNumber + ": ";
                    s = new Scanner(line);
                    try {
                        s.useLocale(Locale.US);
                        s.useDelimiter("\\s*=\\s*");
                        if (!s.hasNext()) {
                            AetherModConfig.logger.warn(errorPrefix + "missing parameter name");
                            continue;
                        }
                        key = s.next().trim();
                        if (key.equals("version")) {
                            if (!s.hasNext()) {
                                AetherModConfig.logger.warn(errorPrefix + "missing version number");
                                continue;
                            }
                            version.parseVersion(s.next().trim());
                            continue;
                        }
                        if (!s.hasNextDouble()) {
                            AetherModConfig.logger.warn(errorPrefix + "value is missing/wrong/not a number");
                            continue;
                        }
                        value = s.nextDouble();
                        var11_16 = key;
                        var12_17 = -1;
                        switch (var11_16.hashCode()) {
                            case -827602897: {
                                if (!var11_16.equals("steelGlove.Damage")) break;
                                var12_17 = 0;
                                break;
                            }
                            case 1125978136: {
                                if (!var11_16.equals("steelGlove.MovementSpeed")) break;
                                var12_17 = 1;
                                break;
                            }
                            case -374109665: {
                                if (!var11_16.equals("steelGlove.AttackSpeed")) break;
                                var12_17 = 2;
                                break;
                            }
                            case 2003868384: {
                                if (!var11_16.equals("steelGlove.ArmorBonus")) break;
                                var12_17 = 3;
                                break;
                            }
                            case 955032429: {
                                if (!var11_16.equals("steelGlove.ToughnessBonus")) break;
                                var12_17 = 4;
                                break;
                            }
                            case 129431425: {
                                if (!var11_16.equals("diarkriteGlove.Damage")) break;
                                var12_17 = 5;
                                break;
                            }
                            case 1963942022: {
                                if (!var11_16.equals("diarkriteGlove.MovementSpeed")) break;
                                var12_17 = 6;
                                break;
                            }
                            case 1597709837: {
                                if (!var11_16.equals("diarkriteGlove.AttackSpeed")) break;
                                var12_17 = 7;
                                break;
                            }
                            case -842018510: {
                                if (!var11_16.equals("diarkriteGlove.ArmorBonus")) break;
                                var12_17 = 8;
                                break;
                            }
                            case 1162109119: {
                                if (!var11_16.equals("diarkriteGlove.ToughnessBonus")) break;
                                var12_17 = 9;
                                break;
                            }
                            case -318978937: {
                                if (!var11_16.equals("anthektite.GloveDamage")) break;
                                var12_17 = 10;
                                break;
                            }
                            case -933232448: {
                                if (!var11_16.equals("anthektite.GloveMovementSpeed")) break;
                                var12_17 = 11;
                                break;
                            }
                            case -657816377: {
                                if (!var11_16.equals("anthektite.GloveAttackSpeed")) break;
                                var12_17 = 12;
                                break;
                            }
                            case -776230088: {
                                if (!var11_16.equals("anthektite.GloveArmorBonus")) break;
                                var12_17 = 13;
                                break;
                            }
                            case 1544013765: {
                                if (!var11_16.equals("anthektite.GloveToughnessBonus")) break;
                                var12_17 = 14;
                            }
                        }
                        switch (var12_17) {
                            case 0: {
                                AetherModConfig.steelGloveDamage = value;
                                ** break;
                            }
                            case 1: {
                                AetherModConfig.steelGloveMovementSpeed = value;
                                ** break;
                            }
                            case 2: {
                                AetherModConfig.steelGloveAttackSpeed = value;
                                ** break;
                            }
                            case 3: {
                                AetherModConfig.steelGloveArmorBonus = value;
                                ** break;
                            }
                            case 4: {
                                AetherModConfig.steelGloveToughnessBonus = value;
                                ** break;
                            }
                            case 5: {
                                AetherModConfig.diarkriteGloveDamage = value;
                                ** break;
                            }
                            case 6: {
                                AetherModConfig.diarkriteGloveMovementSpeed = value;
                                ** break;
                            }
                            case 7: {
                                AetherModConfig.diarkriteGloveAttackSpeed = value;
                                ** break;
                            }
                            case 8: {
                                AetherModConfig.diarkriteGloveArmorBonus = value;
                                ** break;
                            }
                            case 9: {
                                AetherModConfig.diarkriteGloveToughnessBonus = value;
                                ** break;
                            }
                            case 10: {
                                AetherModConfig.anthektiteGloveDamage = value;
                                ** break;
                            }
                            case 11: {
                                AetherModConfig.anthektiteGloveMovementSpeed = value;
                                ** break;
                            }
                            case 12: {
                                AetherModConfig.anthektiteGloveAttackSpeed = value;
                                ** break;
                            }
                            case 13: {
                                AetherModConfig.anthektiteGloveArmorBonus = value;
                                ** break;
                            }
                            case 14: {
                                AetherModConfig.anthektiteGloveToughnessBonus = value;
                                ** break;
                            }
                            default: {
                                AetherModConfig.logger.warn(errorPrefix + "unrecognized parameter name: " + key);
                                continue block51;
                            }
                        }
                    }
                    finally {
                        s.close();
                    }
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        catch (NoSuchFileException e) {
            this.save();
            AetherModConfig.logger.info("Config file not found, generating default");
        }
        catch (IOException e) {
            AetherModConfig.logger.warn("Could not read config file: ", (Throwable)e);
        }
        if (version.compareTo(AetherModConfig.VERSION) < 0) {
            AetherModConfig.logger.info("Config version outdated, Updating config \"aether_config\"!");
            this.save();
        }
    }

    private void save() {
        try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, new OpenOption[0]);){
            writer.write("version = " + String.valueOf(VERSION) + "\n");
            writer.write("# Note: Restart minecraft to apply changes in config\n");
            writer.write("# Aether Item Stats Config\n");
            writer.write("\n");
            writer.write("[TheAether.Steel]\n");
            writer.write("# Default: " + steelGloveDamage + "\n");
            writer.write("  steelGlove.Damage = " + steelGloveDamage + "\n");
            writer.write("# Default: " + steelGloveMovementSpeed + "\n");
            writer.write("  steelGlove.MovementSpeed = " + steelGloveMovementSpeed + "\n");
            writer.write("# Default: " + steelGloveAttackSpeed + "\n");
            writer.write("  steelGlove.AttackSpeed = " + steelGloveAttackSpeed + "\n");
            writer.write("# Default: " + steelGloveArmorBonus + "\n");
            writer.write("  steelGlove.ArmorBonus = " + steelGloveArmorBonus + "\n");
            writer.write("# Default: " + steelGloveToughnessBonus + "\n");
            writer.write("  steelGlove.ToughnessBonus = " + steelGloveToughnessBonus + "\n");
            writer.write("\n");
            writer.write("[TheAether.Diarkrite]\n");
            writer.write("# Default: " + diarkriteGloveDamage + "\n");
            writer.write("  diarkriteGlove.Damage = " + diarkriteGloveDamage + "\n");
            writer.write("# Default: " + diarkriteGloveMovementSpeed + "\n");
            writer.write("  diarkriteGlove.MovementSpeed = " + diarkriteGloveMovementSpeed + "\n");
            writer.write("# Default: " + diarkriteGloveAttackSpeed + "\n");
            writer.write("  diarkriteGlove.AttackSpeed = " + diarkriteGloveAttackSpeed + "\n");
            writer.write("# Default: " + diarkriteGloveArmorBonus + "\n");
            writer.write("  diarkriteGlove.ArmorBonus = " + diarkriteGloveArmorBonus + "\n");
            writer.write("# Default: " + diarkriteGloveToughnessBonus + "\n");
            writer.write("  diarkriteGlove.ToughnessBonus = " + diarkriteGloveToughnessBonus + "\n");
            writer.write("\n");
            writer.write("[TheAether.Anthektite]\n");
            writer.write("# Default: " + anthektiteGloveDamage + "\n");
            writer.write("  anthektiteGlove.Damage = " + anthektiteGloveDamage + "\n");
            writer.write("# Default: " + anthektiteGloveMovementSpeed + "\n");
            writer.write("  anthektiteGlove.MovementSpeed = " + anthektiteGloveMovementSpeed + "\n");
            writer.write("# Default: " + anthektiteGloveAttackSpeed + "\n");
            writer.write("  anthektiteGlove.AttackSpeed = " + anthektiteGloveAttackSpeed + "\n");
            writer.write("# Default: " + anthektiteGloveArmorBonus + "\n");
            writer.write("  anthektiteGlove.ArmorBonus = " + anthektiteGloveArmorBonus + "\n");
            writer.write("# Default: " + anthektiteGloveToughnessBonus + "\n");
            writer.write("  anthektiteGlove.ToughnessBonus = " + anthektiteGloveToughnessBonus + "\n");
        }
        catch (IOException e) {
            logger.warn("Could not save configuration file: ", (Throwable)e);
        }
    }
}

