/*
 * Decompiled with CFR 0.152.
 */
package net.nokunami.elementus.common.config;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Scanner;
import net.nokunami.elementus.Elementus;
import org.apache.logging.log4j.Logger;
import org.apache.maven.artifact.versioning.ComparableVersion;

public class ArmorConfig {
    private static final Logger logger = Elementus.LOGGER;
    public static final ArmorConfig INSTANCE = new ArmorConfig();
    private static final Path CONFIG_PATH = Elementus.ARMOR_CONFIG_PATH;
    public static final ComparableVersion VERSION = new ComparableVersion("1.4");
    public static int steelArmor_DurabilityForType;
    public static int steelArmor_Enchantability;
    public static int steelArmor_Helmet;
    public static int steelArmor_Chestplate;
    public static int steelArmor_Leggings;
    public static int steelArmor_Boots;
    public static double steelArmor_Toughness;
    public static double steelArmor_KnockbackResistance;
    public static double steelArmor_AttackSpeed;
    public static double steelArmor_MovementSpeed;
    public static int diarkriteArmor_DurabilityForType;
    public static int diarkriteArmor_Enchantability;
    public static int diarkriteArmor_Helmet;
    public static int diarkriteArmor_Chestplate;
    public static int diarkriteArmor_Leggings;
    public static int diarkriteArmor_Boots;
    public static double diarkriteArmor_Toughness;
    public static double diarkriteArmor_KnockbackResistance;
    public static double diarkriteArmor_AttackSpeed;
    public static double diarkriteArmor_MovementSpeed;
    public static int anthektiteArmor_DurabilityForType;
    public static int anthektiteArmor_Enchantability;
    public static int anthektiteArmor_Helmet;
    public static int anthektiteArmor_Chestplate;
    public static int anthektiteArmor_Leggings;
    public static int anthektiteArmor_Boots;
    public static double anthektiteArmor_Toughness;
    public static double anthektiteArmor_KnockbackResistance;
    public static double anthektiteArmor_AttackSpeed;
    public static double anthektiteArmor_MovementSpeed;

    public static void reload() {
        INSTANCE.setDefaults();
        INSTANCE.load();
        logger.info("Armor Config loaded");
    }

    private void setDefaults() {
        steelArmor_DurabilityForType = 24;
        steelArmor_Helmet = 3;
        steelArmor_Chestplate = 8;
        steelArmor_Leggings = 6;
        steelArmor_Boots = 3;
        steelArmor_Enchantability = 10;
        steelArmor_Toughness = 0.0;
        steelArmor_KnockbackResistance = 0.0;
        steelArmor_AttackSpeed = 0.0;
        steelArmor_MovementSpeed = 0.0;
        diarkriteArmor_DurabilityForType = 38;
        diarkriteArmor_Helmet = 3;
        diarkriteArmor_Chestplate = 8;
        diarkriteArmor_Leggings = 6;
        diarkriteArmor_Boots = 3;
        diarkriteArmor_Enchantability = 18;
        diarkriteArmor_Toughness = 4.0;
        diarkriteArmor_KnockbackResistance = 0.2;
        diarkriteArmor_AttackSpeed = 0.0;
        diarkriteArmor_MovementSpeed = -0.04;
        anthektiteArmor_DurabilityForType = 35;
        anthektiteArmor_Helmet = 3;
        anthektiteArmor_Chestplate = 8;
        anthektiteArmor_Leggings = 6;
        anthektiteArmor_Boots = 3;
        anthektiteArmor_Enchantability = 15;
        anthektiteArmor_Toughness = 2.0;
        anthektiteArmor_KnockbackResistance = 0.05;
        anthektiteArmor_AttackSpeed = 0.1;
        anthektiteArmor_MovementSpeed = 0.0;
    }

    /*
     * Unable to fully structure code
     */
    private void load() {
        version = new ComparableVersion("0");
        try {
            reader = Files.newBufferedReader(ArmorConfig.CONFIG_PATH);
            try {
                lineNumber = 0;
lbl6:
                // 38 sources

                block81: while ((line = reader.readLine()) != null) {
                    ++lineNumber;
                    commentStart = line.indexOf(35);
                    if (commentStart != -1) {
                        line = line.substring(0, commentStart);
                    }
                    if ((commentStart = line.indexOf(91)) != -1) {
                        line = line.substring(0, commentStart);
                    }
                    line.trim();
                    if (line.isEmpty()) continue;
                    errorPrefix = String.valueOf(ArmorConfig.CONFIG_PATH) + ": line " + lineNumber + ": ";
                    s = new Scanner(line);
                    try {
                        s.useLocale(Locale.US);
                        s.useDelimiter("\\s*=\\s*");
                        if (!s.hasNext()) {
                            ArmorConfig.logger.warn(errorPrefix + "missing parameter name");
                            continue;
                        }
                        key = s.next().trim();
                        if (key.equals("version")) {
                            if (!s.hasNext()) {
                                ArmorConfig.logger.warn(errorPrefix + "missing version number");
                                continue;
                            }
                            version.parseVersion(s.next().trim());
                            continue;
                        }
                        if (!s.hasNextDouble()) {
                            ArmorConfig.logger.warn(errorPrefix + "value is missing/wrong/not a number");
                            continue;
                        }
                        value = s.nextDouble();
                        var11_16 = key;
                        var12_17 = -1;
                        switch (var11_16.hashCode()) {
                            case 120416291: {
                                if (!var11_16.equals("steelArmor.Durability")) break;
                                var12_17 = 0;
                                break;
                            }
                            case 1961291143: {
                                if (!var11_16.equals("steelArmor.Helmet")) break;
                                var12_17 = 1;
                                break;
                            }
                            case 474282191: {
                                if (!var11_16.equals("steelArmor.Chestplate")) break;
                                var12_17 = 2;
                                break;
                            }
                            case 1837849348: {
                                if (!var11_16.equals("steelArmor.Leggings")) break;
                                var12_17 = 3;
                                break;
                            }
                            case 612216679: {
                                if (!var11_16.equals("steelArmor.Boots")) break;
                                var12_17 = 4;
                                break;
                            }
                            case -926567989: {
                                if (!var11_16.equals("steelArmor.Enchantability")) break;
                                var12_17 = 5;
                                break;
                            }
                            case -648520392: {
                                if (!var11_16.equals("steelArmor.Toughness")) break;
                                var12_17 = 6;
                                break;
                            }
                            case -918080646: {
                                if (!var11_16.equals("steelArmor.KnockbackResistance")) break;
                                var12_17 = 7;
                                break;
                            }
                            case -1801541474: {
                                if (!var11_16.equals("steelArmor.AttackSpeedBoost")) break;
                                var12_17 = 8;
                                break;
                            }
                            case -799167874: {
                                if (!var11_16.equals("steelArmor.MovementSpeed")) break;
                                var12_17 = 9;
                                break;
                            }
                            case 1569496693: {
                                if (!var11_16.equals("diarkriteArmor.Durability")) break;
                                var12_17 = 10;
                                break;
                            }
                            case -1376641831: {
                                if (!var11_16.equals("diarkriteArmor.Helmet")) break;
                                var12_17 = 11;
                                break;
                            }
                            case 1923362593: {
                                if (!var11_16.equals("diarkriteArmor.Chestplate")) break;
                                var12_17 = 12;
                                break;
                            }
                            case -1870135850: {
                                if (!var11_16.equals("diarkriteArmor.Leggings")) break;
                                var12_17 = 13;
                                break;
                            }
                            case -326742571: {
                                if (!var11_16.equals("diarkriteArmor.Boots")) break;
                                var12_17 = 14;
                                break;
                            }
                            case -719491299: {
                                if (!var11_16.equals("diarkriteArmor.Enchantability")) break;
                                var12_17 = 15;
                                break;
                            }
                            case 368055462: {
                                if (!var11_16.equals("diarkriteArmor.Toughness")) break;
                                var12_17 = 16;
                                break;
                            }
                            case -349505176: {
                                if (!var11_16.equals("diarkriteArmor.KnockbackResistance")) break;
                                var12_17 = 17;
                                break;
                            }
                            case -369338000: {
                                if (!var11_16.equals("diarkriteArmor.AttackSpeedBoost")) break;
                                var12_17 = 18;
                                break;
                            }
                            case 38796012: {
                                if (!var11_16.equals("diarkriteArmor.MovementSpeed")) break;
                                var12_17 = 19;
                                break;
                            }
                            case 279815749: {
                                if (!var11_16.equals("anthektiteArmor.Durability")) break;
                                var12_17 = 20;
                                break;
                            }
                            case 2146405545: {
                                if (!var11_16.equals("anthektiteArmor.Helmet")) break;
                                var12_17 = 21;
                                break;
                            }
                            case 633681649: {
                                if (!var11_16.equals("anthektiteArmor.Chestplate")) break;
                                var12_17 = 22;
                                break;
                            }
                            case -655836762: {
                                if (!var11_16.equals("anthektiteArmor.Leggings")) break;
                                var12_17 = 23;
                                break;
                            }
                            case -1875663867: {
                                if (!var11_16.equals("anthektiteArmor.Boots")) break;
                                var12_17 = 24;
                                break;
                            }
                            case 2111180525: {
                                if (!var11_16.equals("anthektiteArmor.Enchantability")) break;
                                var12_17 = 25;
                                break;
                            }
                            case -643378474: {
                                if (!var11_16.equals("anthektiteArmor.Toughness")) break;
                                var12_17 = 26;
                                break;
                            }
                            case -1427260520: {
                                if (!var11_16.equals("anthektiteArmor.KnockbackResistance")) break;
                                var12_17 = 27;
                                break;
                            }
                            case 1191986496: {
                                if (!var11_16.equals("anthektiteArmor.AttackSpeedBoost")) break;
                                var12_17 = 28;
                                break;
                            }
                            case 1931223324: {
                                if (!var11_16.equals("anthektiteArmor.MovementSpeed")) break;
                                var12_17 = 29;
                            }
                        }
                        switch (var12_17) {
                            case 0: {
                                ArmorConfig.steelArmor_DurabilityForType = (int)value;
                                ** break;
                            }
                            case 1: {
                                ArmorConfig.steelArmor_Helmet = (int)value;
                                ** break;
                            }
                            case 2: {
                                ArmorConfig.steelArmor_Chestplate = (int)value;
                                ** break;
                            }
                            case 3: {
                                ArmorConfig.steelArmor_Leggings = (int)value;
                                ** break;
                            }
                            case 4: {
                                ArmorConfig.steelArmor_Boots = (int)value;
                                ** break;
                            }
                            case 5: {
                                ArmorConfig.steelArmor_Enchantability = (int)value;
                                ** break;
                            }
                            case 6: {
                                ArmorConfig.steelArmor_Toughness = value;
                                ** break;
                            }
                            case 7: {
                                ArmorConfig.steelArmor_KnockbackResistance = value;
                                ** break;
                            }
                            case 8: {
                                ArmorConfig.steelArmor_AttackSpeed = value;
                                ** break;
                            }
                            case 9: {
                                ArmorConfig.steelArmor_MovementSpeed = value;
                                ** break;
                            }
                            case 10: {
                                ArmorConfig.diarkriteArmor_DurabilityForType = (int)value;
                                ** break;
                            }
                            case 11: {
                                ArmorConfig.diarkriteArmor_Helmet = (int)value;
                                ** break;
                            }
                            case 12: {
                                ArmorConfig.diarkriteArmor_Chestplate = (int)value;
                                ** break;
                            }
                            case 13: {
                                ArmorConfig.diarkriteArmor_Leggings = (int)value;
                                ** break;
                            }
                            case 14: {
                                ArmorConfig.diarkriteArmor_Boots = (int)value;
                                ** break;
                            }
                            case 15: {
                                ArmorConfig.diarkriteArmor_Enchantability = (int)value;
                                ** break;
                            }
                            case 16: {
                                ArmorConfig.diarkriteArmor_Toughness = value;
                                ** break;
                            }
                            case 17: {
                                ArmorConfig.diarkriteArmor_KnockbackResistance = value;
                                ** break;
                            }
                            case 18: {
                                ArmorConfig.diarkriteArmor_AttackSpeed = value;
                                ** break;
                            }
                            case 19: {
                                ArmorConfig.diarkriteArmor_MovementSpeed = value;
                                ** break;
                            }
                            case 20: {
                                ArmorConfig.anthektiteArmor_DurabilityForType = (int)value;
                                ** break;
                            }
                            case 21: {
                                ArmorConfig.anthektiteArmor_Helmet = (int)value;
                                ** break;
                            }
                            case 22: {
                                ArmorConfig.anthektiteArmor_Chestplate = (int)value;
                                ** break;
                            }
                            case 23: {
                                ArmorConfig.anthektiteArmor_Leggings = (int)value;
                                ** break;
                            }
                            case 24: {
                                ArmorConfig.anthektiteArmor_Boots = (int)value;
                                ** break;
                            }
                            case 25: {
                                ArmorConfig.anthektiteArmor_Enchantability = (int)value;
                                ** break;
                            }
                            case 26: {
                                ArmorConfig.anthektiteArmor_Toughness = value;
                                ** break;
                            }
                            case 27: {
                                ArmorConfig.anthektiteArmor_KnockbackResistance = value;
                                ** break;
                            }
                            case 28: {
                                ArmorConfig.anthektiteArmor_AttackSpeed = value;
                                ** break;
                            }
                            case 29: {
                                ArmorConfig.anthektiteArmor_MovementSpeed = value;
                                ** break;
                            }
                            default: {
                                ArmorConfig.logger.warn(errorPrefix + "unrecognized parameter name: " + key);
                                continue block81;
                            }
                        }
                    }
                    finally {
                        s.close();
                    }
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        catch (NoSuchFileException e) {
            this.save();
            ArmorConfig.logger.info("Config file not found, generating default");
        }
        catch (IOException e) {
            ArmorConfig.logger.warn("Could not read config file: ", (Throwable)e);
        }
        if (version.compareTo(ArmorConfig.VERSION) < 0) {
            ArmorConfig.logger.info("Config version outdated, Updating config \"elementus_armor_config\"!");
            this.save();
        }
    }

    private void save() {
        try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, new OpenOption[0]);){
            writer.write("version = " + String.valueOf(VERSION) + "\n");
            writer.write("# Note: Restart minecraft to apply changes in config\n");
            writer.write("# Armor Config\n");
            writer.write("# Vanilla Stats for comparison\n");
            writer.write("# Format:\n");
            writer.write("# [Material, Durability, [Helmet, Chestplate, Leggings, Boots], Enchantability, Toughness, KnockbackResistance]\n");
            writer.write("# [Leather   :5,  [1,3,2,1], 15, 0, 0  ]\n");
            writer.write("# [Chain     :15, [2,5,4,1], 25, 0, 0  ]\n");
            writer.write("# [Gold      :7,  [2,5,3,1], 12, 0, 0  ]\n");
            writer.write("# [Iron      :15, [2,6,5,2], 9,  0, 0  ]\n");
            writer.write("# [Diamond   :33, [3,8,6,3], 10, 2, 0  ]\n");
            writer.write("# [Netherite :37, [3,8,6,3], 15, 3, 0.1]\n");
            writer.write("\n");
            writer.write("\n");
            writer.write("[Steel]\n");
            writer.write("# Default: " + steelArmor_DurabilityForType + "\n");
            writer.write("  steelArmor.Durability = " + steelArmor_DurabilityForType + "\n");
            writer.write("# Default: " + steelArmor_Enchantability + "\n");
            writer.write("  steelArmor.Enchantability = " + steelArmor_Enchantability + "\n");
            writer.write("# Default: " + steelArmor_Helmet + "\n");
            writer.write("  steelArmor.Helmet = " + steelArmor_Helmet + "\n");
            writer.write("# Default: " + steelArmor_Chestplate + "\n");
            writer.write("  steelArmor.Chestplate = " + steelArmor_Chestplate + "\n");
            writer.write("# Default: " + steelArmor_Leggings + "\n");
            writer.write("  steelArmor.Leggings = " + steelArmor_Leggings + "\n");
            writer.write("# Default: " + steelArmor_Boots + "\n");
            writer.write("  steelArmor.Boots = " + steelArmor_Boots + "\n");
            writer.write("# Default: " + steelArmor_Toughness + "\n");
            writer.write("  steelArmor.Toughness = " + steelArmor_Toughness + "\n");
            writer.write("# Default: " + steelArmor_KnockbackResistance + "\n");
            writer.write("  steelArmor.KnockbackResistance = " + steelArmor_KnockbackResistance + "\n");
            writer.write("# Default: " + steelArmor_AttackSpeed + "\n");
            writer.write("  steelArmor.AttackSpeedBoost = " + steelArmor_AttackSpeed + "\n");
            writer.write("# Default: " + steelArmor_MovementSpeed + "\n");
            writer.write("  steelArmor.MovementSpeed = " + steelArmor_MovementSpeed + "\n");
            writer.write("\n");
            writer.write("[Diarkrite]\n");
            writer.write("# Default: " + diarkriteArmor_DurabilityForType + "\n");
            writer.write("  diarkriteArmor.Durability = " + diarkriteArmor_DurabilityForType + "\n");
            writer.write("# Default: " + diarkriteArmor_Enchantability + "\n");
            writer.write("  diarkriteArmor.Enchantability = " + diarkriteArmor_Enchantability + "\n");
            writer.write("# Default: " + diarkriteArmor_Helmet + "\n");
            writer.write("  diarkriteArmor.Helmet = " + diarkriteArmor_Helmet + "\n");
            writer.write("# Default: " + diarkriteArmor_Chestplate + "\n");
            writer.write("  diarkriteArmor.Chestplate = " + diarkriteArmor_Chestplate + "\n");
            writer.write("# Default: " + diarkriteArmor_Leggings + "\n");
            writer.write("  diarkriteArmor.Leggings = " + diarkriteArmor_Leggings + "\n");
            writer.write("# Default: " + diarkriteArmor_Boots + "\n");
            writer.write("  diarkriteArmor.Boots = " + diarkriteArmor_Boots + "\n");
            writer.write("# Default: " + diarkriteArmor_Toughness + "\n");
            writer.write("  diarkriteArmor.Toughness = " + diarkriteArmor_Toughness + "\n");
            writer.write("# Default: " + diarkriteArmor_KnockbackResistance + "\n");
            writer.write("  diarkriteArmor.KnockbackResistance = " + diarkriteArmor_KnockbackResistance + "\n");
            writer.write("# Default: " + diarkriteArmor_AttackSpeed + "\n");
            writer.write("  diarkriteArmor.AttackSpeedBoost = " + diarkriteArmor_AttackSpeed + "\n");
            writer.write("# Default: " + diarkriteArmor_MovementSpeed + "\n");
            writer.write("  diarkriteArmor.MovementSpeed = " + diarkriteArmor_MovementSpeed + "\n");
            writer.write("\n");
            writer.write("[Anthektite]\n");
            writer.write("# Default: " + anthektiteArmor_DurabilityForType + "\n");
            writer.write("  anthektiteArmor.Durability = " + anthektiteArmor_DurabilityForType + "\n");
            writer.write("# Default: " + anthektiteArmor_Enchantability + "\n");
            writer.write("  anthektiteArmor.Enchantability = " + anthektiteArmor_Enchantability + "\n");
            writer.write("# Default: " + anthektiteArmor_Helmet + "\n");
            writer.write("  anthektiteArmor.Helmet = " + anthektiteArmor_Helmet + "\n");
            writer.write("# Default: " + anthektiteArmor_Chestplate + "\n");
            writer.write("  anthektiteArmor.Chestplate = " + anthektiteArmor_Chestplate + "\n");
            writer.write("# Default: " + anthektiteArmor_Leggings + "\n");
            writer.write("  anthektiteArmor.Leggings = " + anthektiteArmor_Leggings + "\n");
            writer.write("# Default: " + anthektiteArmor_Boots + "\n");
            writer.write("  anthektiteArmor.Boots = " + anthektiteArmor_Boots + "\n");
            writer.write("# Default: " + anthektiteArmor_Toughness + "\n");
            writer.write("  anthektiteArmor.Toughness = " + anthektiteArmor_Toughness + "\n");
            writer.write("# Default: " + anthektiteArmor_KnockbackResistance + "\n");
            writer.write("  anthektiteArmor.KnockbackResistance = " + anthektiteArmor_KnockbackResistance + "\n");
            writer.write("# Default: " + anthektiteArmor_AttackSpeed + "\n");
            writer.write("  anthektiteArmor.AttackSpeedBoost = " + anthektiteArmor_AttackSpeed + "\n");
            writer.write("# Default: " + anthektiteArmor_MovementSpeed + "\n");
            writer.write("  anthektiteArmor.MovementSpeed = " + anthektiteArmor_MovementSpeed + "\n");
        }
        catch (IOException e) {
            logger.warn("Could not save configuration file: ", (Throwable)e);
        }
    }
}

