/*
 * Decompiled with CFR 0.152.
 */
package net.nokunami.elementus.common.config;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Scanner;
import net.nokunami.elementus.Elementus;
import org.apache.logging.log4j.Logger;
import org.apache.maven.artifact.versioning.ComparableVersion;

public class EntityConfig {
    private static final Logger logger = Elementus.LOGGER;
    public static final EntityConfig INSTANCE = new EntityConfig();
    private static final Path CONFIG_PATH = Elementus.ENTITY_CONFIG;
    public static final ComparableVersion VERSION = new ComparableVersion("1.4");
    public static double MaxHealth;
    public static double MovementSpeed;
    public static double AngryMovementSpeed;
    public static double KnockbackResist;
    public static double AttackDamage;
    public static double Armor;
    public static double Toughness;
    public static int RepairAmount;

    public static void reload() {
        INSTANCE.setDefaults();
        INSTANCE.load();
        logger.info("Entity Config loaded");
    }

    private void setDefaults() {
        MaxHealth = 150.0;
        MovementSpeed = 0.25;
        AngryMovementSpeed = 0.3;
        KnockbackResist = 1.0;
        AttackDamage = 15.0;
        Armor = 10.0;
        Toughness = 0.0;
        RepairAmount = 5;
    }

    /*
     * Unable to fully structure code
     */
    private void load() {
        version = new ComparableVersion("0");
        try {
            reader = Files.newBufferedReader(EntityConfig.CONFIG_PATH);
            try {
                lineNumber = 0;
lbl6:
                // 16 sources

                block37: while ((line = reader.readLine()) != null) {
                    ++lineNumber;
                    commentStart = line.indexOf(35);
                    if (commentStart != -1) {
                        line = line.substring(0, commentStart);
                    }
                    if ((commentStart = line.indexOf(91)) != -1) {
                        line = line.substring(0, commentStart);
                    }
                    line.trim();
                    if (line.isEmpty()) continue;
                    errorPrefix = String.valueOf(EntityConfig.CONFIG_PATH) + ": line " + lineNumber + ": ";
                    s = new Scanner(line);
                    try {
                        s.useLocale(Locale.US);
                        s.useDelimiter("\\s*=\\s*");
                        if (!s.hasNext()) {
                            EntityConfig.logger.warn(errorPrefix + "missing parameter name");
                            continue;
                        }
                        key = s.next().trim();
                        if (key.equals("version")) {
                            if (!s.hasNext()) {
                                EntityConfig.logger.warn(errorPrefix + "missing version number");
                                continue;
                            }
                            version.parseVersion(s.next().trim());
                            continue;
                        }
                        if (!s.hasNextDouble()) {
                            EntityConfig.logger.warn(errorPrefix + "value is missing/wrong/not a number");
                            continue;
                        }
                        value = s.nextDouble();
                        var11_16 = key;
                        var12_17 = -1;
                        switch (var11_16.hashCode()) {
                            case -1803193283: {
                                if (!var11_16.equals("Steel.MaxHealth")) break;
                                var12_17 = 0;
                                break;
                            }
                            case -926438987: {
                                if (!var11_16.equals("Steel.MovementSpeed")) break;
                                var12_17 = 1;
                                break;
                            }
                            case -592493062: {
                                if (!var11_16.equals("Steel.AngryMovementSpeed")) break;
                                var12_17 = 2;
                                break;
                            }
                            case -649179870: {
                                if (!var11_16.equals("Steel.KnockbackResist")) break;
                                var12_17 = 3;
                                break;
                            }
                            case -330138790: {
                                if (!var11_16.equals("Steel.AttackDamage")) break;
                                var12_17 = 4;
                                break;
                            }
                            case 363664156: {
                                if (!var11_16.equals("Steel.Armor")) break;
                                var12_17 = 5;
                                break;
                            }
                            case -417820689: {
                                if (!var11_16.equals("Steel.Toughness")) break;
                                var12_17 = 6;
                                break;
                            }
                            case -1045386808: {
                                if (!var11_16.equals("Steel.RepairAmount")) break;
                                var12_17 = 7;
                            }
                        }
                        switch (var12_17) {
                            case 0: {
                                EntityConfig.MaxHealth = value;
                                ** break;
                            }
                            case 1: {
                                EntityConfig.MovementSpeed = value;
                                ** break;
                            }
                            case 2: {
                                EntityConfig.AngryMovementSpeed = value;
                                ** break;
                            }
                            case 3: {
                                EntityConfig.KnockbackResist = value;
                                ** break;
                            }
                            case 4: {
                                EntityConfig.AttackDamage = value;
                                ** break;
                            }
                            case 5: {
                                EntityConfig.Armor = value;
                                ** break;
                            }
                            case 6: {
                                EntityConfig.Toughness = value;
                                ** break;
                            }
                            case 7: {
                                EntityConfig.RepairAmount = (int)value;
                                ** break;
                            }
                            default: {
                                EntityConfig.logger.warn(errorPrefix + "unrecognized parameter name: " + key);
                                continue block37;
                            }
                        }
                    }
                    finally {
                        s.close();
                    }
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        catch (NoSuchFileException e) {
            this.save();
            EntityConfig.logger.info("Config file not found, generating default");
        }
        catch (IOException e) {
            EntityConfig.logger.warn("Could not read config file: ", (Throwable)e);
        }
        if (version.compareTo(EntityConfig.VERSION) < 0) {
            EntityConfig.logger.info("Config version outdated, Updating config \"elementus_entity_config\"!");
            this.save();
        }
    }

    private void save() {
        try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, new OpenOption[0]);){
            writer.write("version = " + String.valueOf(VERSION) + "\n");
            writer.write("# Note: Restart minecraft to apply changes in config\n");
            writer.write("# Entity Config\n");
            writer.write("\n");
            writer.write("[SteelGolem]\n");
            writer.write("# Default: " + MaxHealth + "\n");
            writer.write("  Steel.MaxHealth = " + MaxHealth + "\n");
            writer.write("# Default: " + MovementSpeed + "\n");
            writer.write("  Steel.MovementSpeed = " + MovementSpeed + "\n");
            writer.write("# Default: " + AngryMovementSpeed + "\n");
            writer.write("  Steel.AngryMovementSpeed = " + AngryMovementSpeed + "\n");
            writer.write("# Default: " + KnockbackResist + "\n");
            writer.write("  Steel.KnockbackResist = " + KnockbackResist + "\n");
            writer.write("# Default: " + AttackDamage + "\n");
            writer.write("  Steel.AttackDamage = " + AttackDamage + "\n");
            writer.write("# Default: " + Armor + "\n");
            writer.write("  Steel.Armor = " + Armor + "\n");
            writer.write("# Default: " + Toughness + "\n");
            writer.write("  Steel.Toughness = " + Toughness + "\n");
            writer.write("# Default: " + RepairAmount + " (How many ingots does it take to fully heal)\n");
            writer.write("  Steel.RepairAmount = " + RepairAmount + "\n");
            writer.write("\n");
        }
        catch (IOException e) {
            logger.warn("Could not save configuration file: ", (Throwable)e);
        }
    }
}

