/*
 * Decompiled with CFR 0.152.
 */
package net.nokunami.elementus.common.config;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Scanner;
import net.nokunami.elementus.Elementus;
import org.apache.logging.log4j.Logger;
import org.apache.maven.artifact.versioning.ComparableVersion;

public class UniqueItemConfig {
    private static final Logger logger = Elementus.LOGGER;
    public static final UniqueItemConfig INSTANCE = new UniqueItemConfig();
    private static final Path CONFIG_PATH = Elementus.UNIQUE_ITEM_CONFIG_PATH;
    public static final ComparableVersion VERSION = new ComparableVersion("1.4");
    public static int diarkriteChargeBladeDamage;
    public static double diarkriteChargeBladeAttackSpeed;
    public static double diarkriteChargeBladeAttackReach;
    public static double diarkriteChargeBladeSonicDamage;
    public static int diarkriteChargeBladeBaseCharge;
    public static double diarkriteChargeBladeSacrificeDamageBonus;
    public static double diarkriteChargeBladeSelfSacrificeDamage;
    public static int diarkriteChargeBladeChargePenalty;
    public static int anthektiteChargeBladeDamage;
    public static double anthektiteChargeBladeAttackSpeed;
    public static double anthektiteChargeBladeAttackReach;
    public static int anthektiteChargeBladeAmpDamage;
    public static double anthektiteChargeBladeAmpAttackSpeed;
    public static double anthektiteChargeBladeAmpAttackReach;
    public static double diarkriteBootsToughness;
    public static double diarkriteBootsKnockbackResistance;
    public static double diarkriteBootsMovementSpeed;
    public static double diarkriteBootsStepHeight;

    public static void reload() {
        INSTANCE.setDefaults();
        INSTANCE.load();
        logger.info("Item Config loaded");
    }

    private void setDefaults() {
        diarkriteChargeBladeDamage = 3;
        diarkriteChargeBladeAttackSpeed = -2.7;
        diarkriteChargeBladeAttackReach = 1.0;
        diarkriteChargeBladeSonicDamage = 12.0;
        diarkriteChargeBladeBaseCharge = 7;
        diarkriteChargeBladeSacrificeDamageBonus = 0.25;
        diarkriteChargeBladeSelfSacrificeDamage = 0.25;
        diarkriteChargeBladeChargePenalty = 10;
        anthektiteChargeBladeDamage = 3;
        anthektiteChargeBladeAttackSpeed = -1.9;
        anthektiteChargeBladeAttackReach = 1.0;
        anthektiteChargeBladeAmpDamage = 3;
        anthektiteChargeBladeAmpAttackSpeed = -1.3;
        anthektiteChargeBladeAmpAttackReach = 1.0;
        diarkriteBootsToughness = 8.0;
        diarkriteBootsKnockbackResistance = 0.5;
        diarkriteBootsMovementSpeed = -0.5;
        diarkriteBootsStepHeight = 1.0;
    }

    /*
     * Unable to fully structure code
     */
    private void load() {
        version = new ComparableVersion("0");
        try {
            reader = Files.newBufferedReader(UniqueItemConfig.CONFIG_PATH);
            try {
                lineNumber = 0;
lbl6:
                // 22 sources

                block49: while ((line = reader.readLine()) != null) {
                    ++lineNumber;
                    commentStart = line.indexOf(35);
                    if (commentStart != -1) {
                        line = line.substring(0, commentStart);
                    }
                    if ((commentStart = line.indexOf(91)) != -1) {
                        line = line.substring(0, commentStart);
                    }
                    line.trim();
                    if (line.isEmpty()) continue;
                    errorPrefix = String.valueOf(UniqueItemConfig.CONFIG_PATH) + ": line " + lineNumber + ": ";
                    s = new Scanner(line);
                    try {
                        s.useLocale(Locale.US);
                        s.useDelimiter("\\s*=\\s*");
                        if (!s.hasNext()) {
                            UniqueItemConfig.logger.warn(errorPrefix + "missing parameter name");
                            continue;
                        }
                        key = s.next().trim();
                        if (key.equals("version")) {
                            if (!s.hasNext()) {
                                UniqueItemConfig.logger.warn(errorPrefix + "missing version number");
                                continue;
                            }
                            version.parseVersion(s.next().trim());
                            continue;
                        }
                        if (!s.hasNextDouble()) {
                            UniqueItemConfig.logger.warn(errorPrefix + "value is missing/wrong/not a number");
                            continue;
                        }
                        value = s.nextDouble();
                        var11_16 = key;
                        var12_17 = -1;
                        switch (var11_16.hashCode()) {
                            case -1911061002: {
                                if (!var11_16.equals("diarkriteChargeBlade.Damage")) break;
                                var12_17 = 0;
                                break;
                            }
                            case -324382536: {
                                if (!var11_16.equals("diarkriteChargeBlade.AttackSpeed")) break;
                                var12_17 = 1;
                                break;
                            }
                            case -325637660: {
                                if (!var11_16.equals("diarkriteChargeBlade.AttackReach")) break;
                                var12_17 = 2;
                                break;
                            }
                            case 586503828: {
                                if (!var11_16.equals("diarkriteChargeBlade.SonicDamage")) break;
                                var12_17 = 3;
                                break;
                            }
                            case 663639020: {
                                if (!var11_16.equals("diarkriteChargeBlade.BaseCharge")) break;
                                var12_17 = 4;
                                break;
                            }
                            case -897184698: {
                                if (!var11_16.equals("diarkriteChargeBlade.SacrificeDamageBonus")) break;
                                var12_17 = 5;
                                break;
                            }
                            case -1553603091: {
                                if (!var11_16.equals("diarkriteChargeBlade.SelfSacrificeDamage")) break;
                                var12_17 = 6;
                                break;
                            }
                            case 1220700878: {
                                if (!var11_16.equals("diarkriteChargeBlade.ChargePenalty")) break;
                                var12_17 = 7;
                                break;
                            }
                            case -48899642: {
                                if (!var11_16.equals("anthektiteChargeBlade.Damage")) break;
                                var12_17 = 8;
                                break;
                            }
                            case 832036584: {
                                if (!var11_16.equals("anthektiteChargeBlade.AttackSpeed")) break;
                                var12_17 = 9;
                                break;
                            }
                            case 830781460: {
                                if (!var11_16.equals("anthektiteChargeBlade.AttackReach")) break;
                                var12_17 = 10;
                                break;
                            }
                            case 1618021532: {
                                if (!var11_16.equals("anthektiteChargeBlade.AmpDamage")) break;
                                var12_17 = 11;
                                break;
                            }
                            case 1855521234: {
                                if (!var11_16.equals("anthektiteChargeBlade.AmpAttackSpeed")) break;
                                var12_17 = 12;
                                break;
                            }
                            case 1854266110: {
                                if (!var11_16.equals("anthektiteChargeBlade.AmpAttackReach")) break;
                                var12_17 = 13;
                            }
                        }
                        switch (var12_17) {
                            case 0: {
                                UniqueItemConfig.diarkriteChargeBladeDamage = (int)value;
                                ** break;
                            }
                            case 1: {
                                UniqueItemConfig.diarkriteChargeBladeAttackSpeed = value;
                                ** break;
                            }
                            case 2: {
                                UniqueItemConfig.diarkriteChargeBladeAttackReach = value;
                                ** break;
                            }
                            case 3: {
                                UniqueItemConfig.diarkriteChargeBladeSonicDamage = value;
                                ** break;
                            }
                            case 4: {
                                UniqueItemConfig.diarkriteChargeBladeBaseCharge = (int)value;
                                ** break;
                            }
                            case 5: {
                                UniqueItemConfig.diarkriteChargeBladeSacrificeDamageBonus = value;
                                ** break;
                            }
                            case 6: {
                                UniqueItemConfig.diarkriteChargeBladeSelfSacrificeDamage = value;
                                ** break;
                            }
                            case 7: {
                                UniqueItemConfig.diarkriteChargeBladeChargePenalty = (int)value;
                                ** break;
                            }
                            case 8: {
                                UniqueItemConfig.anthektiteChargeBladeDamage = (int)value;
                                ** break;
                            }
                            case 9: {
                                UniqueItemConfig.anthektiteChargeBladeAttackSpeed = value;
                                ** break;
                            }
                            case 10: {
                                UniqueItemConfig.anthektiteChargeBladeAttackReach = value;
                                ** break;
                            }
                            case 11: {
                                UniqueItemConfig.anthektiteChargeBladeAmpDamage = (int)value;
                                ** break;
                            }
                            case 12: {
                                UniqueItemConfig.anthektiteChargeBladeAmpAttackSpeed = value;
                                ** break;
                            }
                            case 13: {
                                UniqueItemConfig.anthektiteChargeBladeAmpAttackReach = value;
                                ** break;
                            }
                            default: {
                                UniqueItemConfig.logger.warn(errorPrefix + "unrecognized parameter name: " + key);
                                continue block49;
                            }
                        }
                    }
                    finally {
                        s.close();
                    }
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        catch (NoSuchFileException e) {
            this.save();
            UniqueItemConfig.logger.info("Config file not found, generating default");
        }
        catch (IOException e) {
            UniqueItemConfig.logger.warn("Could not read config file: ", (Throwable)e);
        }
        if (version.compareTo(UniqueItemConfig.VERSION) < 0) {
            UniqueItemConfig.logger.info("Config version outdated, Updating config \"elementus_item_config\"!");
            this.save();
        }
    }

    private void save() {
        try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, new OpenOption[0]);){
            writer.write("version = " + String.valueOf(VERSION) + "\n");
            writer.write("# Note: Restart minecraft to apply changes in config\n");
            writer.write("# Unique Item Stats Config\n");
            writer.write("\n");
            writer.write("[DiarkriteChargeBlade]\n");
            writer.write("# Default: " + diarkriteChargeBladeDamage + "\n");
            writer.write("  diarkriteChargeBlade.Damage = " + diarkriteChargeBladeDamage + "\n");
            writer.write("# Default: " + diarkriteChargeBladeAttackSpeed + "\n");
            writer.write("  diarkriteChargeBlade.AttackSpeed = " + diarkriteChargeBladeAttackSpeed + "\n");
            writer.write("# Default: " + diarkriteChargeBladeAttackReach + "\n");
            writer.write("  diarkriteChargeBlade.AttackReach = " + diarkriteChargeBladeAttackReach + "\n");
            writer.write("# Default: " + diarkriteChargeBladeSonicDamage + "\n");
            writer.write("  diarkriteChargeBlade.SonicDamage = " + diarkriteChargeBladeSonicDamage + "\n");
            writer.write("# Default: " + diarkriteChargeBladeBaseCharge + "\n");
            writer.write("  diarkriteChargeBlade.BaseCharge = " + diarkriteChargeBladeBaseCharge + "\n");
            writer.write("# Default: " + diarkriteChargeBladeSacrificeDamageBonus + "\n");
            writer.write("  diarkriteChargeBlade.SacrificeDamageBonus = " + diarkriteChargeBladeSacrificeDamageBonus + "\n");
            writer.write("# Default: " + diarkriteChargeBladeSelfSacrificeDamage + "\n");
            writer.write("  diarkriteChargeBlade.SelfSacrificeDamage = " + diarkriteChargeBladeSelfSacrificeDamage + "\n");
            writer.write("# Default: " + diarkriteChargeBladeChargePenalty + "\n");
            writer.write("  diarkriteChargeBlade.ChargePenalty = " + diarkriteChargeBladeChargePenalty + "\n");
            writer.write("\n");
            writer.write("\n");
            writer.write("[AnthektiteChargeBlade]\n");
            writer.write("# Default: " + anthektiteChargeBladeDamage + "\n");
            writer.write("  anthektiteChargeBlade.Damage = " + anthektiteChargeBladeDamage + "\n");
            writer.write("# Default: " + anthektiteChargeBladeAttackSpeed + "\n");
            writer.write("  anthektiteChargeBlade.AttackSpeed = " + anthektiteChargeBladeAttackSpeed + "\n");
            writer.write("# Default: " + anthektiteChargeBladeAttackReach + "\n");
            writer.write("  anthektiteChargeBlade.AttackReach = " + anthektiteChargeBladeAttackReach + "\n");
            writer.write("# Default: " + anthektiteChargeBladeAmpDamage + "\n");
            writer.write("  anthektiteChargeBlade.Damage = " + anthektiteChargeBladeAmpDamage + "\n");
            writer.write("# Default: " + anthektiteChargeBladeAmpAttackSpeed + "\n");
            writer.write("  anthektiteChargeBlade.AttackSpeed = " + anthektiteChargeBladeAttackSpeed + "\n");
            writer.write("# Default: " + anthektiteChargeBladeAmpAttackReach + "\n");
            writer.write("  anthektiteChargeBlade.AttackReach = " + anthektiteChargeBladeAmpAttackReach + "\n");
            writer.write("\n");
        }
        catch (IOException e) {
            logger.warn("Could not save configuration file: ", (Throwable)e);
        }
    }
}

