/*
 * Decompiled with CFR 0.152.
 */
package net.nokunami.elementus.common.effect;

import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.nokunami.elementus.Elementus;
import net.nokunami.elementus.common.config.CatalystArmorConfig;
import net.nokunami.elementus.common.effect.ModMobEffect;
import net.nokunami.elementus.common.registry.ModMobEffects;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber
public class NetherStarEffect
extends ModMobEffect {
    public NetherStarEffect() {
        super(MobEffectCategory.BENEFICIAL, 0x55FFFF);
        this.m_19472_(Attributes.f_22279_, "2d58ffbf-d9cb-4fd3-91d7-d7609ae0c3d0", CatalystArmorConfig.NSSpeed * 0.2, AttributeModifier.Operation.MULTIPLY_TOTAL);
        this.m_19472_(Attributes.f_22283_, "76da929d-8eb6-43eb-962a-cc655c1966a3", (double)CatalystArmorConfig.NSHaste * 0.1, AttributeModifier.Operation.MULTIPLY_TOTAL);
        this.m_19472_(Attributes.f_22281_, "2d58ffbf-d9cb-4fd3-91d7-d7609ae0c3d0", CatalystArmorConfig.NSAttack, AttributeModifier.Operation.ADDITION);
    }

    @SubscribeEvent
    public static void reduceDamage(LivingDamageEvent event) {
        LivingEntity entity = event.getEntity();
        MobEffectInstance effect = entity.m_21124_((MobEffect)ModMobEffects.ElementusEffects.BEACON_POWER.get());
        if (effect != null) {
            int level = effect.m_19564_();
            float reduction = 1.0f - NetherStarEffect.getReductionAmount(level);
            if (reduction <= 0.0f) {
                reduction = 0.0f;
            }
            float before = event.getAmount();
            event.setAmount(event.getAmount() * reduction);
            Elementus.LOGGER.debug("NetherStarPower.reduceDamage: {}->{}", (Object)Float.valueOf(before), (Object)Float.valueOf(event.getAmount()));
        }
    }

    public static float getReductionAmount(int level) {
        return (float)CatalystArmorConfig.NSResistance * 0.01f + (float)CatalystArmorConfig.NSResistAmountPerLevel * 0.01f * (float)level;
    }

    public void m_6742_(@NotNull LivingEntity pLivingEntity, int pAmplifier) {
        if (this == ModMobEffects.ElementusEffects.BEACON_POWER.get() && pLivingEntity.m_21223_() < pLivingEntity.m_21233_()) {
            pLivingEntity.m_5634_(1.0f);
        }
    }

    public boolean m_6584_(int pDuration, int pAmplifier) {
        if (this == ModMobEffects.ElementusEffects.BEACON_POWER.get()) {
            int k = 50 >> pAmplifier;
            if (k > 0) {
                return pDuration % k == 0;
            }
            return true;
        }
        return false;
    }
}

