/*
 * Decompiled with CFR 0.152.
 */
package net.nokunami.elementus.common.entity;

import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ModParticleUtil {
    public static void spawnParticlesOnEntity(Level pLevel, Position pPos, ParticleOptions pParticle, Entity entity, IntProvider pCount) {
        for (Direction direction : Direction.values()) {
            ModParticleUtil.spawnParticles(pLevel, pPos, pParticle, pCount, direction, entity, () -> ModParticleUtil.getRandomSpeedRanges(pLevel.f_46441_), 0.55);
        }
    }

    public static void spawnWideParticlesOnEntity(Level pLevel, Position pPos, ParticleOptions pParticle, Entity entity, IntProvider pCount) {
        for (Direction direction : Direction.values()) {
            ModParticleUtil.spawnWideParticles(pLevel, pPos, pParticle, pCount, direction, entity, () -> ModParticleUtil.getRandomSpeedRanges(pLevel.f_46441_), 0.55);
        }
    }

    public static void spawnParticles(Level pLevel, Position pPos, ParticleOptions pParticle, IntProvider pCount, Direction pDirection, Entity entity, Supplier<Vec3> pSpeedSupplier, double p_216325_) {
        int i = pCount.m_214085_(pLevel.f_46441_);
        for (int j = 0; j < i; ++j) {
            ModParticleUtil.randomParticleGenerator(pLevel, pPos, pDirection, entity, pParticle, pSpeedSupplier.get(), p_216325_);
        }
    }

    public static void spawnWideParticles(Level pLevel, Position pPos, ParticleOptions pParticle, IntProvider pCount, Direction pDirection, Entity entity, Supplier<Vec3> pSpeedSupplier, double p_216325_) {
        int i = pCount.m_214085_(pLevel.f_46441_);
        for (int j = 0; j < i; ++j) {
            ModParticleUtil.wideRandomParticleGenerator(pLevel, pPos, pDirection, entity, pParticle, pSpeedSupplier.get(), p_216325_);
        }
    }

    private static Vec3 getRandomSpeedRanges(RandomSource pRandom) {
        return new Vec3(Mth.m_216263_((RandomSource)pRandom, (double)-0.5, (double)0.5), Mth.m_216263_((RandomSource)pRandom, (double)-0.5, (double)0.5), Mth.m_216263_((RandomSource)pRandom, (double)-0.5, (double)0.5));
    }

    private static void randomParticleGenerator(Level level, Position blockPos, Direction direction, Entity entity, ParticleOptions particle, Vec3 vec3, double d) {
        int dX = direction.m_122429_();
        int dY = direction.m_122430_();
        int dZ = direction.m_122431_();
        double vX = blockPos.m_7096_() + (dX == 0 ? Mth.m_216263_((RandomSource)level.f_46441_, (double)(-entity.m_20205_()), (double)entity.m_20205_()) : (double)dX * d);
        double vY = blockPos.m_7098_() + (dY == 0 ? Mth.m_216263_((RandomSource)level.f_46441_, (double)(-entity.m_20206_() / 4.0f), (double)entity.m_20206_()) : (double)dY * d);
        double vZ = blockPos.m_7094_() + (dZ == 0 ? Mth.m_216263_((RandomSource)level.f_46441_, (double)(-entity.m_20205_()), (double)entity.m_20205_()) : (double)dZ * d);
        double x = dX == 0 ? vec3.m_7096_() : 0.0;
        double y = dY == 0 ? vec3.m_7098_() : 0.0;
        double z = dZ == 0 ? vec3.m_7094_() : 0.0;
        level.m_7106_(particle, vX, vY, vZ, x, y, z);
    }

    private static void wideRandomParticleGenerator(Level level, Position blockPos, Direction direction, Entity entity, ParticleOptions particle, Vec3 vec3, double d) {
        int dX = direction.m_122429_();
        int dY = direction.m_122430_();
        int dZ = direction.m_122431_();
        double vX = blockPos.m_7096_() + (dX == 0 ? Mth.m_216263_((RandomSource)level.f_46441_, (double)(-entity.m_20205_() * 2.0f), (double)(entity.m_20205_() * 2.0f)) : (double)dX * d);
        double vY = blockPos.m_7098_() + (dY == 0 ? Mth.m_216263_((RandomSource)level.f_46441_, (double)(-entity.m_20206_() / 4.0f), (double)entity.m_20206_()) : (double)dY * d);
        double vZ = blockPos.m_7094_() + (dZ == 0 ? Mth.m_216263_((RandomSource)level.f_46441_, (double)(-entity.m_20205_() * 2.0f), (double)(entity.m_20205_() * 2.0f)) : (double)dZ * d);
        double x = dX == 0 ? vec3.m_7096_() : 0.0;
        double y = dY == 0 ? vec3.m_7098_() : 0.0;
        double z = dZ == 0 ? vec3.m_7094_() : 0.0;
        level.m_7106_(particle, vX, vY, vZ, x, y, z);
    }
}

