/*
 * Decompiled with CFR 0.152.
 */
package net.nokunami.elementus.common.entity.ai.goal.steelGolem;

import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.nokunami.elementus.common.entity.MobUtil;
import net.nokunami.elementus.common.entity.living.SteelGolem;
import org.jetbrains.annotations.NotNull;

public class SteelGolemAttackGoal
extends MeleeAttackGoal {
    private SteelGolem steelGolem;
    protected int attackDelay = 10;
    protected int ticksTilNextAttack = 20;
    protected int fastAttackDelay = 10;
    protected int ticksTilNextFastAttack = 10;
    protected int aoeAttackDelay = 20;
    protected int ticksTilNextAoeAttack = 15;
    protected boolean shouldCountTillNextAttack = false;
    protected LivingEntity golemOwner;
    private final Predicate<Entity> aoeFilter = e -> MobUtil.alliedAttacked((Entity)this.steelGolem, e) || this.golemOwner != null && MobUtil.alliedAttacked((Entity)this.golemOwner, e);

    public SteelGolemAttackGoal(SteelGolem golem, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen) {
        super((PathfinderMob)golem, pSpeedModifier, pFollowingTargetEvenIfNotSeen);
        this.steelGolem = golem;
        this.golemOwner = golem.m_269323_() != null ? golem.m_269323_() : null;
    }

    protected void m_6739_(@NotNull LivingEntity enemy, double distToEnemySqr) {
        if (this.isEnemyWithinAttackDistance(enemy, distToEnemySqr)) {
            this.shouldCountTillNextAttack = true;
            if (this.isTimeToStartAttackAnimation()) {
                this.steelGolem.setAttacking(true);
                this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
            }
            if (this.m_25564_()) {
                this.f_25540_.m_21563_().m_24946_(enemy.m_20185_(), enemy.m_20188_(), enemy.m_20189_());
                this.performAttack(enemy);
            }
            if (this.isTimeToStartAoeAttackAnimation()) {
                this.steelGolem.setAoeAttacking(true);
                this.steelGolem.setAttackType(2);
            }
            if (this.isTimeToAoeAttack()) {
                this.f_25540_.m_21563_().m_24946_(enemy.m_20185_(), enemy.m_20188_(), enemy.m_20189_());
                this.performAoeAttack(enemy);
            }
        } else {
            this.m_25563_();
            this.shouldCountTillNextAttack = false;
            this.steelGolem.setAttacking(false);
            this.steelGolem.setAoeAttacking(false);
            this.steelGolem.attackAnimTimeout = 0;
            this.steelGolem.aoeAttackAnimTimeout = 0;
        }
    }

    boolean isEnemyWithinAttackDistance(LivingEntity enemy, double distToEnemySqr) {
        return distToEnemySqr <= this.m_6639_(enemy) * 2.25;
    }

    protected void m_25563_() {
        if (this.steelGolem.getFastAttack()) {
            this.ticksTilNextFastAttack = this.m_183277_(this.fastAttackDelay * 2);
        } else {
            this.ticksTilNextAttack = this.m_183277_(this.attackDelay * 2);
        }
    }

    protected boolean isTimeToStartAttackAnimation() {
        if (this.steelGolem.getAoeTimer() <= 0) {
            return false;
        }
        if (this.steelGolem.getFastAttack()) {
            return this.ticksTilNextFastAttack <= this.fastAttackDelay;
        }
        return this.ticksTilNextAttack <= this.attackDelay;
    }

    protected boolean m_25564_() {
        if (this.steelGolem.getFastAttack()) {
            return this.ticksTilNextFastAttack <= 0;
        }
        return this.ticksTilNextAttack <= 0;
    }

    protected int m_25565_() {
        if (this.steelGolem.getFastAttack()) {
            return this.ticksTilNextFastAttack;
        }
        return this.ticksTilNextAttack;
    }

    protected void performAttack(LivingEntity enemy) {
        this.m_25563_();
        this.f_25540_.m_6674_(InteractionHand.MAIN_HAND);
        this.f_25540_.m_7327_((Entity)enemy);
    }

    protected void resetAoeAttackCooldown() {
        this.ticksTilNextAoeAttack = this.m_183277_(this.aoeAttackDelay * 2);
        this.steelGolem.setAoeTimer(this.steelGolem.aoeAnimTimeout);
    }

    protected boolean isTimeToStartAoeAttackAnimation() {
        return this.ticksTilNextAoeAttack <= this.aoeAttackDelay && this.steelGolem.getAoeTimer() <= 0;
    }

    protected boolean isTimeToAoeAttack() {
        return this.ticksTilNextAoeAttack <= 0 && this.steelGolem.getAoeTimer() <= 0;
    }

    protected void performAoeAttack(LivingEntity enemy) {
        this.groundAttack(enemy);
        this.resetAoeAttackCooldown();
        this.steelGolem.setAttackType(2);
        this.f_25540_.m_6674_(InteractionHand.MAIN_HAND);
        this.f_25540_.m_21573_().m_26573_();
        this.f_25540_.m_7327_((Entity)enemy);
    }

    public void m_8037_() {
        super.m_8037_();
        if (!this.steelGolem.isChassisCompromised()) {
            if (this.steelGolem.getAoeTimer() > 20) {
                if (this.shouldCountTillNextAttack) {
                    if (this.steelGolem.getFastAttack()) {
                        this.ticksTilNextFastAttack = Math.max(this.ticksTilNextFastAttack - 1, 0);
                    } else {
                        this.ticksTilNextAttack = Math.max(this.ticksTilNextAttack - 1, 0);
                    }
                }
            } else {
                this.ticksTilNextAoeAttack = Math.max(this.ticksTilNextAoeAttack - 1, 0);
            }
        }
    }

    public void m_8041_() {
        super.m_8041_();
        this.steelGolem.setAttacking(false);
        this.steelGolem.setAoeAttacking(false);
    }

    public boolean m_8036_() {
        return !this.steelGolem.isChassisCompromised() && super.m_8036_();
    }

    private void groundAttack(LivingEntity livingEntity) {
        if (this.steelGolem.m_20096_()) {
            this.steelGolem.m_5496_(SoundEvents.f_11913_, 1.4f, 1.4f);
            this.steelGolem.m_5496_(SoundEvents.f_12057_, 1.0f, 1.0f);
            for (Entity entity : this.steelGolem.m_9236_().m_6443_(LivingEntity.class, this.steelGolem.m_20191_().m_82400_(6.0), this.aoeFilter)) {
                boolean flag;
                Mob target;
                if (!(entity instanceof Enemy) && entity != this.steelGolem.m_5448_() && (!(livingEntity instanceof Mob) || (target = (Mob)livingEntity).m_5448_() != this.f_25540_)) continue;
                if (entity.m_20096_() && (flag = entity.m_6469_(this.steelGolem.m_269291_().m_269333_((LivingEntity)this.steelGolem), (float)this.steelGolem.m_21133_(Attributes.f_22281_) * 0.75f))) {
                    entity.m_20184_().m_82520_(0.0, 0.2, 0.0);
                }
                this.launch(entity);
            }
        }
    }

    private void launch(Entity entity) {
        double d0 = entity.m_20185_() - this.steelGolem.m_20185_();
        double d1 = entity.m_20189_() - this.steelGolem.m_20189_();
        double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
        entity.m_5997_(d0 / d2 * 1.25, 0.2, d1 / d2 * 1.25);
    }
}

