/*
 * Decompiled with CFR 0.152.
 */
package net.nokunami.elementus.common.entity.ai.goal.steelGolem;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.nokunami.elementus.common.entity.living.SteelGolem;

public class SteelGolemFollowOwnerGoal
extends Goal {
    private static final int MIN_HORIZONTAL_DISTANCE_WHEN_TELEPORTING = 2;
    private static final int MAX_HORIZONTAL_DISTANCE_WHEN_TELEPORTING = 5;
    private static final int MAX_VERTICAL_DISTANCE_WHEN_TELEPORTING = 3;
    private final SteelGolem steelGolem;
    private LivingEntity owner;
    private final LevelReader level;
    private final double speedModifier;
    private final double aggroSpeedModifier;
    private final PathNavigation navigation;
    private int timeToRecalcPath;
    private final float stopDistance;
    private final float aggroStopDistance;
    private final float startDistance;
    private final float aggroStartDistance;
    private float oldWaterCost;
    private final boolean canFly;
    private final float teleportDistance;
    private final float aggroTeleportDistance;
    private final boolean brokenChassis;

    public SteelGolemFollowOwnerGoal(SteelGolem golem, double normalSpeed, double aggroSpeed, float startDistance, float aggroStartDistance, float stopDistance, float aggroStopDistance, boolean canFly, int teleportDistance, int aggroTeleportDistance) {
        this.steelGolem = golem;
        this.level = golem.m_9236_();
        this.navigation = golem.m_21573_();
        this.speedModifier = normalSpeed;
        this.aggroSpeedModifier = aggroSpeed;
        this.startDistance = startDistance;
        this.aggroStartDistance = aggroStartDistance;
        this.stopDistance = stopDistance;
        this.aggroStopDistance = aggroStopDistance;
        this.teleportDistance = teleportDistance;
        this.aggroTeleportDistance = aggroTeleportDistance;
        this.canFly = canFly;
        this.brokenChassis = golem.isChassisBroken();
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        if (!(golem.m_21573_() instanceof GroundPathNavigation) && !(golem.m_21573_() instanceof FlyingPathNavigation)) {
            throw new IllegalArgumentException("Unsupported mob type for FollowOwnerGoal");
        }
    }

    public boolean m_8036_() {
        LivingEntity livingentity = this.steelGolem.m_269323_();
        if (this.steelGolem.isChassisBroken()) {
            return false;
        }
        if (livingentity == null) {
            return false;
        }
        if (livingentity.m_5833_()) {
            return false;
        }
        if (this.unableToMove()) {
            return false;
        }
        if (this.steelGolem.m_20280_((Entity)livingentity) < (double)(this.startDistance * this.startDistance) && !this.steelGolem.getAggroState()) {
            return false;
        }
        if (this.steelGolem.m_20280_((Entity)livingentity) < (double)(this.aggroStartDistance * this.aggroStartDistance) && this.steelGolem.getAggroState()) {
            return false;
        }
        this.owner = livingentity;
        return true;
    }

    public boolean m_8045_() {
        if (this.navigation.m_26571_()) {
            return false;
        }
        if (this.unableToMove()) {
            return false;
        }
        if (this.steelGolem.getAggroState()) {
            return !(this.steelGolem.m_20280_((Entity)this.owner) <= (double)(this.aggroStopDistance * this.aggroStartDistance));
        }
        return !(this.steelGolem.m_20280_((Entity)this.owner) <= (double)(this.stopDistance * this.stopDistance));
    }

    private boolean unableToMove() {
        return this.steelGolem.m_21827_() || this.steelGolem.m_20159_() || this.steelGolem.m_21523_() || this.brokenChassis;
    }

    public void m_8056_() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.steelGolem.m_21439_(BlockPathTypes.WATER);
        this.steelGolem.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public void m_8041_() {
        this.owner = null;
        this.navigation.m_26573_();
        this.steelGolem.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
    }

    public void m_8037_() {
        this.steelGolem.m_21563_().m_24960_((Entity)this.owner, 10.0f, (float)this.steelGolem.m_8132_());
        if (this.steelGolem.m_5448_() == null && --this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = this.m_183277_(10);
            if (this.steelGolem.m_20280_((Entity)this.owner) >= (double)(this.aggroTeleportDistance * this.aggroTeleportDistance) && this.steelGolem.getAggroState()) {
                this.teleportToOwner();
            } else if (this.steelGolem.m_20280_((Entity)this.owner) >= (double)(this.teleportDistance * this.teleportDistance) && !this.steelGolem.getAggroState()) {
                this.teleportToOwner();
            } else if (this.steelGolem.getAggroState()) {
                this.navigation.m_5624_((Entity)this.owner, this.aggroSpeedModifier);
            } else {
                this.navigation.m_5624_((Entity)this.owner, this.speedModifier);
            }
        }
    }

    private void teleportToOwner() {
        BlockPos blockpos = this.owner.m_20183_();
        for (int i = 0; i < 10; ++i) {
            int j = this.randomIntInclusive(-5, 5);
            int k = this.randomIntInclusive(-3, 3);
            int l = this.randomIntInclusive(-5, 5);
            boolean bl = this.maybeTeleportTo(blockpos.m_123341_() + j, blockpos.m_123342_() + k, blockpos.m_123343_() + l);
            if (!bl) continue;
            return;
        }
    }

    private boolean maybeTeleportTo(int pX, int pY, int pZ) {
        if (Math.abs((double)pX - this.owner.m_20185_()) < 2.0 && Math.abs((double)pZ - this.owner.m_20189_()) < 2.0) {
            return false;
        }
        if (!this.canTeleportTo(new BlockPos(pX, pY, pZ))) {
            return false;
        }
        this.steelGolem.m_7678_((double)pX + 0.5, pY, (double)pZ + 0.5, this.steelGolem.m_146908_(), this.steelGolem.m_146909_());
        this.navigation.m_26573_();
        return true;
    }

    private boolean canTeleportTo(BlockPos pPos) {
        BlockPathTypes blockpathtypes = WalkNodeEvaluator.m_77604_((BlockGetter)this.level, (BlockPos.MutableBlockPos)pPos.m_122032_());
        if (blockpathtypes != BlockPathTypes.WALKABLE) {
            return false;
        }
        BlockState blockstate = this.level.m_8055_(pPos.m_7495_());
        if (!this.canFly && blockstate.m_60734_() instanceof LeavesBlock) {
            return false;
        }
        BlockPos blockpos = pPos.m_121996_((Vec3i)this.steelGolem.m_20183_());
        return this.level.m_45756_((Entity)this.steelGolem, this.steelGolem.m_20191_().m_82338_(blockpos));
    }

    private int randomIntInclusive(int pMin, int pMax) {
        return this.steelGolem.m_217043_().m_188503_(pMax - pMin + 1) + pMin;
    }
}

