/*
 * Decompiled with CFR 0.152.
 */
package net.nokunami.elementus.common.entity.ai.goal.steelGolem;

import java.util.EnumSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.nokunami.elementus.common.entity.living.SteelGolem;

public class SteelGolemNearestAttackableGoal<T extends LivingEntity>
extends TargetGoal {
    private static final int DEFAULT_RANDOM_INTERVAL = 10;
    protected final Class<T> targetType;
    protected final int randomInterval;
    @Nullable
    protected LivingEntity target;
    protected TargetingConditions targetConditions;
    private final SteelGolem steelGolem;

    public SteelGolemNearestAttackableGoal(SteelGolem golem, Class<T> pTargetType, int pRandomInterval, boolean pMustSee, boolean pMustReach, @Nullable Predicate<LivingEntity> pTargetPredicate) {
        super((Mob)golem, pMustSee, pMustReach);
        this.targetType = pTargetType;
        this.randomInterval = SteelGolemNearestAttackableGoal.m_186073_((int)pRandomInterval);
        this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
        this.targetConditions = TargetingConditions.m_148352_().m_26883_(this.m_7623_()).m_26888_(pTargetPredicate);
        this.steelGolem = golem;
    }

    public boolean m_8036_() {
        if (!this.steelGolem.getAggroState()) {
            return false;
        }
        if (this.randomInterval > 0 && this.steelGolem.m_217043_().m_188503_(this.randomInterval) != 0) {
            return false;
        }
        this.findTarget();
        return this.target != null;
    }

    protected AABB getTargetSearchArea(double pTargetDistance) {
        return this.steelGolem.m_20191_().m_82377_(pTargetDistance, 4.0, pTargetDistance);
    }

    protected void findTarget() {
        if (this.steelGolem.getAggroState()) {
            this.target = this.targetType != Player.class && this.targetType != ServerPlayer.class ? this.steelGolem.m_9236_().m_45982_(this.steelGolem.m_9236_().m_6443_(this.targetType, this.getTargetSearchArea(this.m_7623_()), living -> true), this.targetConditions, (LivingEntity)this.steelGolem, this.steelGolem.m_20185_(), this.steelGolem.m_20188_(), this.steelGolem.m_20189_()) : this.steelGolem.m_9236_().m_45949_(this.targetConditions, (LivingEntity)this.steelGolem, this.steelGolem.m_20185_(), this.steelGolem.m_20188_(), this.steelGolem.m_20189_());
        }
    }

    public void m_8056_() {
        if (this.steelGolem.getAggroState()) {
            this.steelGolem.m_6710_(this.target);
            super.m_8056_();
        }
    }

    public void setTarget(@Nullable LivingEntity pTarget) {
        this.target = pTarget;
    }
}

