/*
 * Decompiled with CFR 0.152.
 */
package net.nokunami.elementus.common.entity.living;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.PacketDistributor;
import net.nokunami.elementus.Elementus;
import net.nokunami.elementus.common.Etags;
import net.nokunami.elementus.common.config.EntityConfig;
import net.nokunami.elementus.common.entity.MobUtil;
import net.nokunami.elementus.common.entity.ModParticleUtil;
import net.nokunami.elementus.common.entity.ai.control.SmoothBodyControl;
import net.nokunami.elementus.common.entity.ai.goal.steelGolem.SteelGolemAttackGoal;
import net.nokunami.elementus.common.entity.ai.goal.steelGolem.SteelGolemFollowOwnerGoal;
import net.nokunami.elementus.common.entity.ai.goal.steelGolem.SteelGolemNearestAttackableGoal;
import net.nokunami.elementus.common.entity.ai.navigation.TestGroundNavigation;
import net.nokunami.elementus.common.entity.living.TamableChestedGolem;
import net.nokunami.elementus.common.inventory.SteelGolemInventoryMenu;
import net.nokunami.elementus.common.item.GolemUpgradeProperties;
import net.nokunami.elementus.common.item.SteelGolemUpgradeItem;
import net.nokunami.elementus.common.network.ModNetwork;
import net.nokunami.elementus.common.network.SteelGolemInventoryPacket;
import net.nokunami.elementus.common.registry.ModSoundEvents;
import org.jetbrains.annotations.NotNull;

public class SteelGolem
extends TamableChestedGolem
implements NeutralMob,
Shearable,
IForgeShearable {
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private int remainingPersistentAngerTime;
    @Nullable
    private UUID persistentAngerTarget;
    protected static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(SteelGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Boolean> IS_ATTACKING = SynchedEntityData.m_135353_(SteelGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_AOE_ATTACKING = SynchedEntityData.m_135353_(SteelGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> FAST_ATTACK = SynchedEntityData.m_135353_(SteelGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> AOE_TIMER = SynchedEntityData.m_135353_(SteelGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> CHASSIS_STATUS = SynchedEntityData.m_135353_(SteelGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> AGGRO = SynchedEntityData.m_135353_(SteelGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_WAXED = SynchedEntityData.m_135353_(SteelGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> CHASSIS_HEALTH = SynchedEntityData.m_135353_(SteelGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ATTACK_TYPE = SynchedEntityData.m_135353_(SteelGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> MOSS_TIMER = SynchedEntityData.m_135353_(SteelGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> MOSS_STAGE = SynchedEntityData.m_135353_(SteelGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> BROKEN_TICK = SynchedEntityData.m_135353_(SteelGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SIT_TICK = SynchedEntityData.m_135353_(SteelGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> CHEST_OPEN = SynchedEntityData.m_135353_(SteelGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public final AnimationState attackLoopAnimationState = new AnimationState();
    public final AnimationState attackEndAnimationState = new AnimationState();
    public final AnimationState upswingAttackAnimationState = new AnimationState();
    public final AnimationState sitFromStandAnimState = new AnimationState();
    public final AnimationState standFromSitAnimState = new AnimationState();
    public final AnimationState brokenAnim = new AnimationState();
    public final AnimationState repairedAnim = new AnimationState();
    public final AnimationState ridden = new AnimationState();
    public final AnimationState unRide = new AnimationState();
    public final AnimationState chestOpened = new AnimationState();
    public final AnimationState chestClosed = new AnimationState();
    public int attackAnimTimeout = 0;
    public int aoeAttackAnimTimeout = 0;
    public int aoeAnimTimeout = 320;
    public float eyeLayerBrightness;
    public float eyeOldLayerBrightness;
    public int eyeLayerTick;
    private static final UUID ARMOR_MODIFIER_UUID = UUID.fromString("556E1665-8B10-40C8-8F9D-CF9B1667F295");
    private static final UUID TOUGHNESS_MODIFIER_UUID = UUID.fromString("0e936964-c9bb-4eb7-a718-ed69de8a4e8f");
    public Predicate<Entity> GOLEM_SURROUNDING_TARGETS = entity -> {
        if (!(entity instanceof Mob)) return false;
        Mob mob = (Mob)entity;
        if (entity instanceof Enemy) return true;
        if (entity == this.m_5448_()) return true;
        if (this.m_269323_() == null) return false;
        if (mob.m_5448_() != this.m_269323_()) return false;
        return true;
    };
    public static float rawBbWidth = 1.6f;
    public static float rawBbHeight = 2.9f;

    public SteelGolem(EntityType<? extends TamableChestedGolem> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.createInventory();
        this.m_274367_(1.5f);
        GroundPathNavigation groundpathnavigation = (GroundPathNavigation)this.m_21573_();
        groundpathnavigation.m_7008_(true);
        groundpathnavigation.m_255224_(true);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
        this.f_19804_.m_135372_(IS_ATTACKING, (Object)false);
        this.f_19804_.m_135372_(CHASSIS_HEALTH, (Object)5);
        this.f_19804_.m_135372_(CHASSIS_STATUS, (Object)false);
        this.f_19804_.m_135372_(AGGRO, (Object)true);
        this.f_19804_.m_135372_(IS_WAXED, (Object)false);
        this.f_19804_.m_135372_(ATTACK_TYPE, (Object)0);
        this.f_19804_.m_135372_(MOSS_TIMER, (Object)0);
        this.f_19804_.m_135372_(MOSS_STAGE, (Object)0);
        this.f_19804_.m_135372_(BROKEN_TICK, (Object)0);
        this.f_19804_.m_135372_(SIT_TICK, (Object)0);
        this.f_19804_.m_135372_(AOE_TIMER, (Object)100);
        this.f_19804_.m_135372_(IS_AOE_ATTACKING, (Object)false);
        this.f_19804_.m_135372_(CHEST_OPEN, (Object)false);
        this.f_19804_.m_135372_(FAST_ATTACK, (Object)false);
    }

    @Override
    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        this.m_21678_(tag);
        tag.m_128379_("PlayerCreated", this.isPlayerCreated());
        tag.m_128405_("ChassisValue", this.getChassisHealth());
        tag.m_128379_("ChassisState", this.isChassisBroken());
        tag.m_128379_("AggroState", this.getAggroState());
        tag.m_128379_("Waxed", this.isWaxed());
        tag.m_128405_("AttackType", this.getAttackType());
        tag.m_128405_("MossTimer", this.getMossTimer());
        tag.m_128405_("MossStage", this.getMossStage());
        tag.m_128379_("Chested", this.hasChest());
        if (!this.inventory.m_8020_(1).m_41619_()) {
            tag.m_128365_("ArmorItem", (Tag)this.inventory.m_8020_(1).m_41739_(new CompoundTag()));
        }
        if (!this.inventory.m_8020_(2).m_41619_()) {
            tag.m_128365_("LeavesDecoration", (Tag)this.inventory.m_8020_(2).m_41739_(new CompoundTag()));
        }
        if (!this.inventory.m_8020_(3).m_41619_()) {
            tag.m_128365_("DecorItem", (Tag)this.inventory.m_8020_(3).m_41739_(new CompoundTag()));
        }
        tag.m_128405_("BrokenTick", this.getBrokenTick());
        tag.m_128405_("SitTick", this.getSitTick());
        tag.m_128405_("AoeTimer", this.getAoeTimer());
        tag.m_128379_("ChestOpened", this.chestOpened());
        tag.m_128379_("FastAttack", this.getFastAttack());
    }

    @Override
    public void m_7378_(@NotNull CompoundTag tag) {
        ItemStack leaves;
        ItemStack armorItem;
        super.m_7378_(tag);
        this.setPlayerCreated(tag.m_128471_("PlayerCreated"));
        this.m_147285_(this.m_9236_(), tag);
        this.setChassisHealth(tag.m_128451_("ChassisValue"));
        this.setChassisState(tag.m_128471_("ChassisState"));
        this.setAggroState(tag.m_128471_("AggroState"));
        this.setWaxed(tag.m_128471_("Waxed"));
        this.setAttackType(tag.m_128451_("AttackType"));
        this.setMossTimer(tag.m_128451_("MossTimer"));
        this.setMossStage(tag.m_128451_("MossStage"));
        if (tag.m_128425_("ArmorItem", 10) && !(armorItem = ItemStack.m_41712_((CompoundTag)tag.m_128469_("ArmorItem"))).m_41619_() && this.isArmor(armorItem)) {
            this.inventory.m_6836_(1, armorItem);
        }
        if (tag.m_128425_("LeavesDecoration", 10) && (leaves = ItemStack.m_41712_((CompoundTag)tag.m_128469_("LeavesDecoration"))).m_204117_(Etags.Items.STEEL_GOLEM_LEAVES_DECORATION)) {
            this.inventory.m_6836_(2, leaves);
        }
        if (tag.m_128425_("DecorItem", 10)) {
            this.inventory.m_6836_(3, ItemStack.m_41712_((CompoundTag)tag.m_128469_("DecorItem")));
        }
        this.updateContainerEquipment();
        this.setBrokenTick(tag.m_128451_("BrokenTick"));
        this.setSitTick(tag.m_128451_("SitTick"));
        this.setAoeTimer(tag.m_128451_("AoeTimer"));
        this.isChestOpened(tag.m_128471_("ChestOpened"));
        this.setFastAttack(tag.m_128471_("FastAttack"));
    }

    public ItemStack getArmor() {
        return this.m_6844_(EquipmentSlot.CHEST);
    }

    private void setArmor(ItemStack stack) {
        this.m_8061_(EquipmentSlot.CHEST, stack);
        this.m_21409_(EquipmentSlot.CHEST, 0.0f);
    }

    public ItemStack isCamouflaged() {
        return this.m_6844_(EquipmentSlot.LEGS);
    }

    private void wearCamouflaged(ItemStack stack) {
        this.m_8061_(EquipmentSlot.LEGS, stack);
        this.m_21409_(EquipmentSlot.LEGS, 0.0f);
    }

    public ItemStack getDripCarpet() {
        return this.m_6844_(EquipmentSlot.FEET);
    }

    private void wearDripCarpet(ItemStack stack) {
        this.m_8061_(EquipmentSlot.FEET, stack);
        this.m_21409_(EquipmentSlot.FEET, 0.0f);
    }

    public boolean chestOpened() {
        return (Boolean)this.f_19804_.m_135370_(CHEST_OPEN);
    }

    public void isChestOpened(boolean open) {
        this.f_19804_.m_135381_(CHEST_OPEN, (Object)open);
    }

    @Override
    protected void updateContainerEquipment() {
        super.updateContainerEquipment();
        if (!this.m_9236_().f_46443_) {
            super.updateContainerEquipment();
            this.setArmorEquipment(this.inventory.m_8020_(1));
            this.m_21409_(EquipmentSlot.CHEST, 0.0f);
            this.wearCamouflaged(this.inventory.m_8020_(2));
            this.wearDripCarpet(this.inventory.m_8020_(3));
        }
    }

    private void setArmorEquipment(ItemStack pStack) {
        this.setArmor(pStack);
        if (!this.m_9236_().f_46443_) {
            Objects.requireNonNull(this.m_21051_(Attributes.f_22284_)).m_22120_(ARMOR_MODIFIER_UUID);
            Objects.requireNonNull(this.m_21051_(Attributes.f_22285_)).m_22120_(TOUGHNESS_MODIFIER_UUID);
            if (this.isArmor(pStack)) {
                int armor = ((SteelGolemUpgradeItem)pStack.m_41720_()).properties.getArmor();
                double toughness = ((SteelGolemUpgradeItem)pStack.m_41720_()).properties.getToughness();
                if (armor != 0) {
                    Objects.requireNonNull(this.m_21051_(Attributes.f_22284_)).m_22118_(new AttributeModifier(ARMOR_MODIFIER_UUID, "Armor bonus", (double)armor, AttributeModifier.Operation.ADDITION));
                }
                if (toughness != 0.0) {
                    Objects.requireNonNull(this.m_21051_(Attributes.f_22285_)).m_22118_(new AttributeModifier(TOUGHNESS_MODIFIER_UUID, "Toughness", toughness, AttributeModifier.Operation.ADDITION));
                }
            }
        }
    }

    @Override
    public void m_5757_(@NotNull Container container) {
        ItemStack armor = this.getArmor();
        ItemStack leaves = this.isCamouflaged();
        ItemStack carpet = this.getDripCarpet();
        super.m_5757_(container);
        ItemStack armor1 = this.getArmor();
        ItemStack leaves1 = this.isCamouflaged();
        ItemStack carpet1 = this.getDripCarpet();
        if (this.f_19797_ > 20 && this.isArmor(armor1) && armor != armor1) {
            this.m_5496_((SoundEvent)ModSoundEvents.STEEL_GOLEM_ARMORED.get(), 0.5f, 1.0f);
        }
        if (this.f_19797_ > 20 && leaves != leaves1) {
            this.m_5496_((SoundEvent)ModSoundEvents.STEEL_GOLEM_LEAVES_SWAG.get(), 0.5f, 1.0f);
        }
        if (this.f_19797_ > 20 && carpet != carpet1) {
            this.m_5496_((SoundEvent)ModSoundEvents.STEEL_GOLEM_CARPET_SWAG.get(), 0.5f, 1.0f);
        }
    }

    protected SoundEvent m_5592_() {
        return this.isChassisCompromised() ? SoundEvents.f_12059_ : (SoundEvent)ModSoundEvents.STEEL_GOLEM_DOWN.get();
    }

    protected SoundEvent m_7975_(@NotNull DamageSource pDamageSource) {
        return this.isChassisCompromised() ? null : SoundEvents.f_12008_;
    }

    @NotNull
    public InteractionResult m_7111_(@NotNull Player player, @NotNull Vec3 vec3, @NotNull InteractionHand hand) {
        boolean saddleHeight;
        double d0 = vec3.f_82480_;
        ItemStack itemStack = player.m_21120_(hand);
        boolean chassisCondition = this.getChassisHealth() < 5;
        boolean healItem = itemStack.m_204117_(Etags.Items.STEEL_GOLEM_HEAL) || itemStack.m_204117_(Etags.Items.STEEL_GOLEM_REPAIR_HALF);
        boolean repair = itemStack.m_204117_(Etags.Items.STEEL_GOLEM_REPAIR_FULL);
        boolean aggroStateChanger = itemStack.m_204117_(ItemTags.f_271388_) || itemStack.m_204117_(ItemTags.f_271207_);
        boolean healAndRepair = healItem || repair;
        boolean isHurt = this.m_21223_() < this.m_21233_();
        boolean bl = saddleHeight = d0 >= (double)(this.m_20206_() * 0.65f);
        if (this.m_21824_()) {
            if (!this.isChassisBroken() && this.m_6254_() && saddleHeight) {
                if (isHurt && healAndRepair || chassisCondition && repair || (!this.m_20160_() || aggroStateChanger) && player.m_36341_() || itemStack.m_41647_(player, (LivingEntity)this, hand).m_19077_()) {
                    return this.m_6071_(player, hand);
                }
                if (!player.m_6047_()) {
                    return this.doPlayerRide(player);
                }
                if (!this.m_20197_().isEmpty() && this.m_21830_((LivingEntity)player)) {
                    this.m_20153_();
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        return super.m_7111_(player, vec3, hand);
    }

    @NotNull
    public InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        boolean aggroStateChanger;
        ItemStack itemStack = player.m_21120_(hand);
        boolean canHeal = this.m_21223_() < this.m_21233_();
        boolean shearMoss = itemStack.m_150930_(Items.f_42574_) && this.getMossStage() > 0 && this.m_6220_();
        boolean armor = this.canWearArmor() && this.isArmor(itemStack) && !this.isWearingArmor();
        boolean leaves = itemStack.m_204117_(Etags.Items.STEEL_GOLEM_LEAVES_DECORATION) && this.isCamouflaged().m_41619_();
        boolean carpet = itemStack.m_204117_(Etags.Items.STEEL_GOLEM_CARPET_DECORATION) && this.getDripCarpet().m_41619_();
        boolean wax = itemStack.m_150930_(Items.f_42784_) && !this.isWaxed();
        boolean scrapWax = itemStack.m_204117_(ItemTags.f_271207_) && this.isWaxed();
        boolean chassisCondition = this.getChassisHealth() < 5;
        boolean healItem = itemStack.m_204117_(Etags.Items.STEEL_GOLEM_HEAL) || itemStack.m_204117_(Etags.Items.STEEL_GOLEM_REPAIR_HALF);
        boolean repair = itemStack.m_204117_(Etags.Items.STEEL_GOLEM_REPAIR_FULL);
        boolean bl = aggroStateChanger = (itemStack.m_204117_(ItemTags.f_271388_) || itemStack.m_204117_(ItemTags.f_271207_)) && player.m_36341_();
        if (this.m_21523_() && this.m_21524_() == player) {
            return super.m_6071_(player, hand);
        }
        if (this.m_21824_()) {
            if (!this.isChassisBroken()) {
                if (canHeal && healItem || chassisCondition && repair) {
                    return this.healGolem(player, itemStack);
                }
                if (aggroStateChanger) {
                    return this.aggroStateChange();
                }
            } else if (healItem || chassisCondition && repair) {
                return this.healGolem(player, itemStack);
            }
            if (shearMoss) {
                return this.trimMoss(player, hand);
            }
            if (armor || leaves || carpet || wax || scrapWax) {
                return this.setGolemDecoration(player, hand);
            }
            if (player.m_36341_()) {
                return this.openInventory(player);
            }
            if (!super.m_6071_(player, hand).m_19077_() && this.m_21830_((LivingEntity)player) && !this.isChassisBroken()) {
                if (itemStack.m_150930_(Items.f_42655_) && this.m_6573_(player)) {
                    return super.m_6071_(player, hand);
                }
                return this.sitOrder();
            }
            return InteractionResult.PASS;
        }
        if (this.isPlayerCreated() || !this.isPlayerCreated() && player.m_7500_()) {
            return this.tameGolem(player);
        }
        return super.m_6071_(player, hand);
    }

    public InteractionResult sitOrder() {
        if (this.getSitTick() == 0 || this.getSitTick() == 15) {
            this.m_21839_(!this.m_21827_());
        }
        this.f_20899_ = false;
        this.f_21344_.m_26573_();
        return InteractionResult.SUCCESS;
    }

    public InteractionResult setGolemDecoration(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (this.isArmor(stack)) {
            this.equipArmor(player, stack);
        } else if (stack.m_150930_(Items.f_42450_)) {
            super.m_6071_(player, hand);
        } else if (stack.m_150930_(Items.f_42784_) && !this.isWaxed()) {
            this.setWaxed(true);
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            this.m_216990_(SoundEvents.f_144178_);
            ModParticleUtil.spawnParticlesOnEntity(this.m_9236_(), (Position)this.m_20182_(), (ParticleOptions)ParticleTypes.f_175828_, (Entity)this, (IntProvider)UniformInt.m_146622_((int)3, (int)5));
        } else if (stack.m_204117_(ItemTags.f_271207_) && this.isWaxed()) {
            this.setWaxed(false);
            if (!player.m_7500_()) {
                stack.m_41622_(1, (LivingEntity)player, e -> e.m_21190_(player.m_7655_()));
            }
            this.m_216990_(SoundEvents.f_144060_);
            ModParticleUtil.spawnParticlesOnEntity(this.m_9236_(), (Position)this.m_20182_(), (ParticleOptions)ParticleTypes.f_175829_, (Entity)this, (IntProvider)UniformInt.m_146622_((int)3, (int)5));
        } else {
            int slot = 3;
            if (stack.m_204117_(Etags.Items.STEEL_GOLEM_LEAVES_DECORATION)) {
                slot = 2;
            }
            this.inventory.m_6836_(slot, stack.m_255036_(1));
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
        }
        this.f_21344_.m_26573_();
        return InteractionResult.SUCCESS;
    }

    public InteractionResult trimMoss(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        this.m_5851_(SoundSource.PLAYERS);
        this.m_146852_(GameEvent.f_157781_, (Entity)player);
        itemStack.m_41622_(1, (LivingEntity)player, item -> item.m_21190_(hand));
        return InteractionResult.SUCCESS;
    }

    protected InteractionResult healGolem(Player player, ItemStack stack) {
        boolean chassisCondition = this.getChassisHealth() < 5;
        boolean repairHalf = stack.m_204117_(Etags.Items.STEEL_GOLEM_REPAIR_HALF);
        boolean repairFull = stack.m_204117_(Etags.Items.STEEL_GOLEM_REPAIR_FULL);
        float randomFloat = 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f;
        int b = this.isChassisBroken() ? 1 : 0;
        float healAmount = 1.0f;
        if (repairHalf) {
            healAmount = 0.5f;
        }
        this.setChassisState(false);
        if (chassisCondition && repairFull) {
            this.setChassisHealth(this.getChassisHealth() + 1);
        }
        this.m_5634_((int)(EntityConfig.MaxHealth / (double)EntityConfig.RepairAmount * (double)healAmount) - b);
        this.m_5496_(this.isChassisBroken() ? (SoundEvent)ModSoundEvents.STEEL_GOLEM_REVIVE.get() : (SoundEvent)ModSoundEvents.STEEL_GOLEM_REPAIR.get(), 1.0f, randomFloat);
        if (!player.m_7500_()) {
            stack.m_41774_(1);
        }
        return InteractionResult.SUCCESS;
    }

    protected InteractionResult tameGolem(Player player) {
        if (!this.isPlayerCreated()) {
            this.setPlayerCreated(true);
        }
        this.m_21828_(player);
        this.f_21344_.m_26573_();
        this.m_6710_(null);
        this.m_9236_().m_7605_((Entity)this, (byte)7);
        return InteractionResult.SUCCESS;
    }

    protected InteractionResult aggroStateChange() {
        this.f_21344_.m_26573_();
        this.setAggroState(!this.getAggroState());
        this.m_6710_(null);
        return InteractionResult.SUCCESS;
    }

    protected void m_19956_(@NotNull Entity passenger, @NotNull Entity.MoveFunction moveFunction) {
        float height = rawBbHeight;
        float sitting = (float)this.getSitTick() / 15.0f * 0.75f;
        float crouch = this.m_20089_() == Pose.CROUCHING ? 1.0f : 0.0f;
        double passengerRidingOffset = (double)(height - Math.max(sitting, crouch)) * 0.75;
        if (this.m_20363_(passenger)) {
            float dro = 0.75f;
            Vec3 offset = (switch (this.m_20197_().stream().toList().indexOf(passenger)) {
                case 0 -> new Vec3(0.0, passengerRidingOffset + passenger.m_6049_(), 0.0);
                case 1 -> new Vec3(0.0, passengerRidingOffset + passenger.m_6049_(), (double)(-dro));
                case 2 -> new Vec3(0.0, passengerRidingOffset + passenger.m_6049_(), (double)dro);
                default -> Vec3.f_82478_;
            }).m_82524_((float)(-Math.toRadians(this.m_146908_()) - 1.5707963267948966));
            moveFunction.m_20372_(passenger, this.m_20185_() + offset.f_82479_, this.m_20186_() + offset.f_82480_, this.m_20189_() + offset.f_82481_);
        }
    }

    protected boolean m_7310_(@NotNull Entity pPassenger) {
        return this.m_20197_().size() < this.getMaxPassengers();
    }

    @Override
    protected int getMaxPassengers() {
        return 3;
    }

    public boolean hasEnoughSpaceFor(Entity pEntity) {
        return pEntity.m_20205_() < this.m_20205_() || pEntity.m_20206_() < this.m_20206_();
    }

    @Override
    public boolean canWearArmor() {
        return true;
    }

    @Override
    public boolean isArmor(@NotNull ItemStack stack) {
        return stack.m_41720_() instanceof SteelGolemUpgradeItem;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, EntityConfig.MaxHealth).m_22268_(Attributes.f_22279_, EntityConfig.MovementSpeed).m_22268_(Attributes.f_22278_, EntityConfig.KnockbackResist).m_22268_(Attributes.f_22281_, EntityConfig.AttackDamage).m_22268_(Attributes.f_22284_, EntityConfig.Armor).m_22268_(Attributes.f_22285_, EntityConfig.Toughness);
    }

    public void m_6075_() {
        Object object;
        super.m_6075_();
        List list = this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82377_((double)0.2f, (double)-0.01f, (double)0.2f), EntitySelector.m_20421_((Entity)this));
        HashSet entitySet = new HashSet(this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_().m_82400_(2.0), this.GOLEM_SURROUNDING_TARGETS));
        if (this.m_9236_().f_46443_) {
            this.setupAnim();
            if (this.isChassisBroken()) {
                ++this.eyeLayerTick;
                if (this.eyeLayerBrightness < 1.0f) {
                    this.eyeLayerBrightness += (0.0f - this.eyeLayerBrightness) * 0.02f;
                }
            } else {
                --this.eyeLayerTick;
                if (this.eyeLayerBrightness > 0.0f) {
                    this.eyeLayerBrightness -= (0.0f + this.eyeLayerBrightness) * 0.02f;
                }
            }
        }
        if (!this.m_9236_().f_46443_) {
            SteelGolemUpgradeItem upgradeItem;
            this.m_21666_((ServerLevel)this.m_9236_(), true);
            if (this.m_21825_() || this.isChassisBroken()) {
                if (this.getMossStage() < 3 && !this.isWaxed()) {
                    this.setMossTimer(this.getMossTimer() + 1);
                }
                if (this.getSitTick() < 15) {
                    this.setSitTick(this.getSitTick() + 1);
                }
                this.m_20124_(Pose.SITTING);
            } else {
                if (this.getSitTick() > 0) {
                    this.setSitTick(this.getSitTick() - 1);
                }
                this.m_20124_(Pose.STANDING);
            }
            if (this.isChassisBroken()) {
                this.setBrokenTick(20);
                this.f_21344_.m_26573_();
                if (this.m_21223_() > 1.0f) {
                    this.m_21153_(1.0f);
                }
            } else if (this.getBrokenTick() > 0) {
                this.setBrokenTick(this.getBrokenTick() - 1);
            }
            if (this.getMossTimer() > 144000) {
                this.setMossStage(this.getMossStage() + 1);
                this.setMossTimer(0);
            }
            if (!this.getArmor().m_41619_() && (object = this.getArmor().m_41720_()) instanceof SteelGolemUpgradeItem) {
                SteelGolemUpgradeItem armorItem = (SteelGolemUpgradeItem)((Object)object);
                armorItem.onArmorTick(this.getArmor(), this.m_9236_(), this);
            }
            this.setFastAttack((object = this.getArmor().m_41720_()) instanceof SteelGolemUpgradeItem && (upgradeItem = (SteelGolemUpgradeItem)((Object)object)).isFastAttack());
            this.m_6858_(this.m_20142_());
        }
        if (!list.isEmpty() && this.m_21825_()) {
            boolean flag = !this.m_9236_().f_46443_ && !(this.m_6688_() instanceof Player);
            object = list.iterator();
            while (object.hasNext()) {
                Entity entity = (Entity)object.next();
                if (this.m_6254_() && flag && this.m_20197_().size() < this.getMaxPassengers() && this.hasEnoughSpaceFor(entity) && !(entity instanceof Enemy)) {
                    if (entity.m_20159_() || !(entity instanceof LivingEntity) || entity instanceof WaterAnimal || entity instanceof Player) continue;
                    entity.m_20329_((Entity)this);
                    continue;
                }
                this.m_7334_(entity);
            }
        }
        if (!entitySet.isEmpty() && (object = entitySet.stream().findAny().get()) instanceof Mob) {
            Mob mob = (Mob)object;
            if (!this.isChassisBroken() && mob.m_5448_() != null && (mob.m_5448_() == this || this.m_269323_() != null && (mob.m_5448_().m_7306_((Entity)this.m_269323_()) || mob.m_5448_().m_7307_((Entity)this.m_269323_())))) {
                if (entitySet.size() > 5 && this.getAoeTimer() > 160) {
                    this.setAoeTimer(160);
                }
                if (entitySet.size() > 2 && this.getAoeTimer() > 0 && this.m_5448_() != null) {
                    this.setAoeTimer(this.getAoeTimer() - 1);
                }
            }
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_9236_() instanceof ServerLevel && !this.isChassisBroken()) {
            boolean isTwoAboveSolid = this.m_9236_().m_8055_(this.m_20183_().m_6630_(2)).m_280296_();
            boolean isThreeAboveSolid = this.m_9236_().m_8055_(this.m_20183_().m_6630_(3)).m_280296_();
            Vec3i offset = this.getDirectionVector();
            boolean isFacingSolid = this.m_9236_().m_8055_(this.m_20183_().m_121945_(this.m_6350_())).m_280296_();
            if (isFacingSolid) {
                offset = offset.m_7918_(0, 1, 0);
            }
            boolean isOffsetFacingSolid = this.m_9236_().m_8055_(this.m_20183_().m_121955_(offset)).m_280296_();
            boolean isOffsetFacingAboveSolid = this.m_9236_().m_8055_(this.m_20183_().m_121955_(offset).m_7494_()).m_280296_();
            boolean isOffsetFacingTwoAboveSolid = this.m_9236_().m_8055_(this.m_20183_().m_121955_(offset).m_6630_(2)).m_280296_();
            boolean shouldCrouch = isTwoAboveSolid || !isOffsetFacingSolid && !isOffsetFacingAboveSolid && (isOffsetFacingTwoAboveSolid || isFacingSolid && isThreeAboveSolid);
            boolean isSculkSensorNearby = this.m_9236_().m_45556_(this.m_20191_().m_82400_(9.0)).anyMatch(block -> block.m_60713_(Blocks.f_152500_));
            boolean isStuckWhileNav = this.m_21573_().m_26577_();
            this.m_20124_(this.m_5830_() || shouldCrouch || isSculkSensorNearby || isStuckWhileNav ? Pose.CROUCHING : this.m_20089_());
            this.m_6210_();
        }
        if (this.m_5448_() != null && this.m_20280_((Entity)this.m_5448_()) < 4.25) {
            this.m_21573_().m_26573_();
        }
    }

    private Vec3i getDirectionVector() {
        return new Vec3i(this.m_6350_().m_122429_(), this.m_6350_().m_122430_(), this.m_6350_().m_122431_());
    }

    public boolean m_213854_() {
        return this.m_6047_();
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level level) {
        return new TestGroundNavigation((Mob)this, level);
    }

    public int m_6056_() {
        return this.m_5448_() != null ? 3 + (int)(this.m_21223_() - 1.0f) : 3;
    }

    private void setupAnim() {
        if (!this.isChassisBroken()) {
            if (this.isAttacking() && this.attackAnimTimeout <= 0 && this.getAoeTimer() > 10) {
                SteelGolemUpgradeItem upgradeItem;
                if (this.getAttackType() == 1) {
                    this.setAttackType(0);
                } else {
                    this.setAttackType(1);
                }
                Item item = this.getArmor().m_41720_();
                this.attackAnimTimeout = item instanceof SteelGolemUpgradeItem && (upgradeItem = (SteelGolemUpgradeItem)item).isFastAttack() ? 10 : 20;
                this.attackLoopAnimationState.m_216973_();
                this.attackLoopAnimationState.m_216977_(this.f_19797_);
            } else {
                --this.attackAnimTimeout;
            }
            if (this.isAoeAttacking() && this.aoeAttackAnimTimeout <= 0 && this.getAoeTimer() <= 0) {
                this.setAttackType(2);
                this.aoeAttackAnimTimeout = 35;
                this.attackLoopAnimationState.m_216973_();
                this.upswingAttackAnimationState.m_216973_();
                this.upswingAttackAnimationState.m_216977_(this.f_19797_);
            } else {
                --this.aoeAttackAnimTimeout;
            }
        }
        this.sitFromStandAnimState.m_246184_(this.m_21825_() && this.getBrokenTick() <= 0, this.f_19797_);
        this.standFromSitAnimState.m_246184_(!this.m_21825_(), this.f_19797_);
        this.brokenAnim.m_246184_(this.isChassisBroken(), this.f_19797_);
        this.repairedAnim.m_246184_(!this.isChassisBroken() && this.getBrokenTick() != 0, this.f_19797_);
        this.ridden.m_246184_(this.m_20160_(), this.f_19797_);
        this.unRide.m_246184_(!this.m_20160_(), this.f_19797_);
        this.chestOpened.m_246184_(this.chestOpened(), this.f_19797_);
        this.chestClosed.m_246184_(!this.chestOpened(), this.f_19797_);
    }

    public void stopAllAttackAnimation() {
        this.attackLoopAnimationState.m_216973_();
        this.attackEndAnimationState.m_216973_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(1, (Goal)new SteelGolemAttackGoal(this, 1.2, true));
        this.f_21345_.m_25352_(2, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 0.9, 32.0f){

            public boolean m_8036_() {
                return !SteelGolem.this.m_21825_() && !SteelGolem.this.isChassisBroken() && SteelGolem.this.getAoeTimer() <= 0 && super.m_8036_();
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new SteelGolemFollowOwnerGoal(this, 1.0, 1.25, 8.0f, 20.0f, 6.0f, 9.0f, false, 12, 28));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 12.0f){

            public boolean m_8036_() {
                return !SteelGolem.this.m_21825_() && !SteelGolem.this.isChassisBroken() && super.m_8036_();
            }
        });
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.5){

            public boolean m_8036_() {
                return !SteelGolem.this.m_21825_() && !SteelGolem.this.isChassisBroken() && super.m_8036_();
            }
        });
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean m_8036_() {
                return !SteelGolem.this.m_21825_() && !SteelGolem.this.isChassisBroken() && super.m_8036_();
            }
        });
        this.f_21346_.m_25352_(0, (Goal)new NearestAttackableTargetGoal<Mob>((Mob)this, Mob.class, 5, false, false, entity -> entity.m_6095_().m_204039_(Etags.Entity.STEEL_GOLEM_PRIORITY_TARGETS)){

            public boolean m_8036_() {
                return !SteelGolem.this.m_21825_() && !SteelGolem.this.isChassisBroken() && super.m_8036_();
            }
        });
        this.f_21346_.m_25352_(0, (Goal)new NearestAttackableTargetGoal<Mob>((Mob)this, Mob.class, 5, false, false, entity -> {
            if (!(entity instanceof Mob)) return false;
            Mob mob = (Mob)entity;
            if (this.m_269323_() == null) return false;
            if (mob.m_5448_() != this.m_269323_()) return false;
            return true;
        }){

            public boolean m_8036_() {
                return (!SteelGolem.this.m_21825_() && !SteelGolem.this.isChassisBroken() && SteelGolem.this.getAggroState() || SteelGolem.this.m_20160_()) && super.m_8036_();
            }
        });
        this.f_21346_.m_25352_(1, new SteelGolemNearestAttackableGoal<Mob>(this, Mob.class, 5, false, false, p_28879_ -> p_28879_ instanceof Enemy && !(p_28879_ instanceof Creeper)));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal(this){

            public boolean m_8036_() {
                return !SteelGolem.this.isChassisBroken() && super.m_8036_();
            }
        });
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtTargetGoal(this){

            public boolean m_8036_() {
                return !SteelGolem.this.isChassisBroken() && super.m_8036_();
            }
        });
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal<Player>((Mob)this, Player.class, 10, true, false, arg_0 -> ((SteelGolem)this).m_21674_(arg_0)){

            public boolean m_8036_() {
                return !SteelGolem.this.m_21825_() && !SteelGolem.this.isChassisBroken() && super.m_8036_();
            }
        });
        this.f_21346_.m_25352_(4, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    public void m_7822_(byte pId) {
        if (pId == 4) {
            if (this.getAttackType() == 2) {
                ModParticleUtil.spawnWideParticlesOnEntity(this.m_9236_(), (Position)this.m_20182_(), (ParticleOptions)ParticleTypes.f_123813_, (Entity)this, (IntProvider)UniformInt.m_146622_((int)1, (int)2));
                ModParticleUtil.spawnWideParticlesOnEntity(this.m_9236_(), (Position)this.m_20182_(), (ParticleOptions)ParticleTypes.f_123777_, (Entity)this, (IntProvider)UniformInt.m_146622_((int)1, (int)3));
                this.aoeAttackAnimTimeout = 15;
            }
            this.attackAnimTimeout = 10;
            this.m_5496_(SoundEvents.f_12057_, 1.0f, 0.5f);
        } else {
            super.m_7822_(pId);
        }
    }

    public boolean m_7757_(@NotNull LivingEntity target, @NotNull LivingEntity owner) {
        if (!(target instanceof Creeper) && !(target instanceof Ghast)) {
            OwnableEntity o;
            if (target instanceof SteelGolem) {
                SteelGolem golem = (SteelGolem)target;
                return !golem.m_21824_() || golem.m_269323_() != owner;
            }
            if (target instanceof Player && owner instanceof Player && !((Player)owner).m_7099_((Player)target)) {
                return false;
            }
            if (target instanceof OwnableEntity && (o = (OwnableEntity)target).m_269323_() != null) {
                return false;
            }
            return !(target instanceof TamableAnimal) || !((TamableAnimal)target).m_21824_();
        }
        return false;
    }

    public int m_8132_() {
        return this.m_21825_() || this.m_20160_() ? 0 : super.m_8132_();
    }

    public boolean m_142066_() {
        return !this.isChassisBroken() && super.m_142066_();
    }

    @NotNull
    protected BodyRotationControl m_7560_() {
        return new SmoothBodyControl((Mob)this);
    }

    @NotNull
    public EntityDimensions m_6972_(@NotNull Pose pose) {
        if (pose == Pose.SITTING) {
            return EntityDimensions.m_20395_((float)rawBbWidth, (float)(rawBbHeight - 0.75f));
        }
        if (pose == Pose.CROUCHING) {
            return EntityDimensions.m_20395_((float)rawBbWidth, (float)(rawBbHeight - 1.0f));
        }
        return super.m_6972_(pose);
    }

    public boolean m_21525_() {
        return this.isChassisBroken() && super.m_21525_();
    }

    public void setAttacking(boolean attacking) {
        this.f_19804_.m_135381_(IS_ATTACKING, (Object)attacking);
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(IS_ATTACKING);
    }

    public int getChassisHealth() {
        return (Integer)this.f_19804_.m_135370_(CHASSIS_HEALTH);
    }

    public void setChassisHealth(int health) {
        this.f_19804_.m_135381_(CHASSIS_HEALTH, (Object)health);
    }

    public void setChassisState(boolean state) {
        this.f_19804_.m_135381_(CHASSIS_STATUS, (Object)state);
    }

    public boolean isChassisBroken() {
        return (Boolean)this.f_19804_.m_135370_(CHASSIS_STATUS);
    }

    public boolean isChassisCompromised() {
        if (this.m_21223_() <= 0.0f) {
            if (this.isPlayerCreated() && this.getChassisHealth() > 1) {
                this.stopAllAttackAnimation();
                this.setChassisState(true);
                this.setChassisHealth(this.getChassisHealth() - 1);
                this.m_21153_(1.0f);
                this.m_21662_();
                this.m_21561_(false);
                this.m_21839_(false);
                return false;
            }
            return true;
        }
        return false;
    }

    public ItemStack getSaddle() {
        return this.inventory.m_8020_(0);
    }

    public void setAggroState(boolean state) {
        this.f_19804_.m_135381_(AGGRO, (Object)state);
    }

    public boolean getAggroState() {
        return (Boolean)this.f_19804_.m_135370_(AGGRO);
    }

    public void setAttackType(int type) {
        this.f_19804_.m_135381_(ATTACK_TYPE, (Object)type);
    }

    public int getAttackType() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_TYPE);
    }

    public int getMossTimer() {
        return (Integer)this.f_19804_.m_135370_(MOSS_TIMER);
    }

    public void setMossTimer(int ticks) {
        this.f_19804_.m_135381_(MOSS_TIMER, (Object)ticks);
    }

    public int getMossStage() {
        return (Integer)this.f_19804_.m_135370_(MOSS_STAGE);
    }

    public void setMossStage(int stage) {
        this.f_19804_.m_135381_(MOSS_STAGE, (Object)stage);
    }

    public boolean isWaxed() {
        return (Boolean)this.f_19804_.m_135370_(IS_WAXED);
    }

    public void setWaxed(boolean i) {
        this.f_19804_.m_135381_(IS_WAXED, (Object)i);
    }

    public int getBrokenTick() {
        return (Integer)this.f_19804_.m_135370_(BROKEN_TICK);
    }

    public void setBrokenTick(int i) {
        this.f_19804_.m_135381_(BROKEN_TICK, (Object)i);
    }

    public int getSitTick() {
        return (Integer)this.f_19804_.m_135370_(SIT_TICK);
    }

    public void setSitTick(int i) {
        this.f_19804_.m_135381_(SIT_TICK, (Object)i);
    }

    public int getAoeTimer() {
        return (Integer)this.f_19804_.m_135370_(AOE_TIMER);
    }

    public void setAoeTimer(int i) {
        this.f_19804_.m_135381_(AOE_TIMER, (Object)i);
    }

    public void setAoeAttacking(boolean b) {
        this.f_19804_.m_135381_(IS_AOE_ATTACKING, (Object)b);
    }

    public boolean getFastAttack() {
        return (Boolean)this.f_19804_.m_135370_(FAST_ATTACK);
    }

    public void setFastAttack(boolean b) {
        this.f_19804_.m_135381_(FAST_ATTACK, (Object)b);
    }

    public boolean isAoeAttacking() {
        return (Boolean)this.f_19804_.m_135370_(IS_AOE_ATTACKING);
    }

    @Override
    public void m_213583_(@NotNull Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverplayer = (ServerPlayer)player;
            if (this.m_6084_()) {
                if (serverplayer.f_36096_ != serverplayer.f_36095_) {
                    serverplayer.m_6915_();
                }
                this.isChestOpened(true);
                serverplayer.m_9217_();
                ModNetwork.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverplayer), (Object)new SteelGolemInventoryPacket(serverplayer.f_8940_, this.inventory.m_6643_(), this.m_19879_()));
                serverplayer.f_36096_ = new SteelGolemInventoryMenu(serverplayer.f_8940_, serverplayer.m_150109_(), (Container)this.inventory, this);
                serverplayer.m_143399_(serverplayer.f_36096_);
                MinecraftForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open((Player)serverplayer, serverplayer.f_36096_));
            }
        }
    }

    @Override
    public InteractionResult openInventory(Player player) {
        this.m_213583_(player);
        return InteractionResult.SUCCESS;
    }

    @Override
    protected int getInventorySize() {
        return 24;
    }

    public boolean m_6673_(DamageSource source) {
        if (source.m_269533_(Etags.DamageTypes.STEEL_GOLEM_IMMUNE) && !source.m_269533_(DamageTypeTags.f_268738_)) {
            return true;
        }
        if (this.isChassisBroken() && this.getChassisHealth() != 0) {
            return true;
        }
        return super.m_6673_(source);
    }

    protected void m_7324_(@NotNull Entity entity) {
        if (entity instanceof Enemy && !(entity instanceof Creeper) && !MobUtil.tamedMob(entity) && this.m_217043_().m_188503_(20) == 0 && this.getAggroState()) {
            this.m_6710_((LivingEntity)entity);
        }
        super.m_7324_(entity);
    }

    @Override
    public boolean m_6094_() {
        Item item = this.getArmor().m_41720_();
        if (item instanceof SteelGolemUpgradeItem) {
            SteelGolemUpgradeItem golemUpgradeItem = (SteelGolemUpgradeItem)item;
            GolemUpgradeProperties golemUpgradeProperties = golemUpgradeItem.getGolemUpgradeProperties();
            return golemUpgradeProperties != null && !golemUpgradeItem.isNotPushable() && !this.m_21825_() && !this.isChassisBroken() && !this.m_20160_();
        }
        return !this.m_21825_() && !this.isChassisBroken() && !this.m_20160_();
    }

    @Override
    protected float m_245547_(@NotNull Player player) {
        float f = player.m_20142_() ? 0.1f : 0.0f;
        return (float)(this.m_21133_(Attributes.f_22279_) * (double)0.3f) + f;
    }

    public boolean m_264410_() {
        return true;
    }

    protected boolean m_6107_() {
        return this.isChassisBroken() || this.m_21224_();
    }

    public boolean m_5843_() {
        return this.m_20184_().m_165925_() > 2.500000277905201E-7 && this.f_19796_.m_188503_(5) == 0;
    }

    public boolean m_6549_(@NotNull EntityType<?> pType) {
        if (this.isPlayerCreated() && pType == EntityType.f_20532_) {
            return false;
        }
        return pType != EntityType.f_20558_ && super.m_6549_(pType);
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    public void m_7870_(int time) {
        this.remainingPersistentAngerTime = time;
    }

    public int m_6784_() {
        return this.remainingPersistentAngerTime;
    }

    public void m_6925_(@org.jetbrains.annotations.Nullable UUID target) {
        this.persistentAngerTarget = target;
    }

    @org.jetbrains.annotations.Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public boolean m_21660_() {
        return !this.isChassisBroken() && super.m_21660_();
    }

    public boolean m_7327_(Entity entity) {
        this.m_9236_().m_7605_((Entity)this, (byte)4);
        float f = this.getAttackDamage();
        float f1 = (int)f > 0 ? f / 1.5f + (float)this.f_19796_.m_188503_((int)f) : f;
        boolean flag = entity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), f1);
        if (flag) {
            double d2;
            if (entity instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity;
                d2 = livingentity.m_21133_(Attributes.f_22278_);
            } else {
                d2 = 0.0;
            }
            double d0 = d2;
            double d1 = Math.max(0.0, 2.0 - d0);
            entity.m_20256_(entity.m_20184_().m_82542_(d1, 1.0, d1));
            this.m_19970_((LivingEntity)this, entity);
        }
        this.m_5496_(SoundEvents.f_12057_, 1.0f, 1.0f);
        return flag;
    }

    private float getAttackDamage() {
        return (float)this.m_21133_(Attributes.f_22281_);
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        Crackiness steelgolem$crackiness = this.getCrackiness();
        boolean flag = super.m_6469_(source, amount);
        if (!this.m_9236_().f_46443_) {
            this.m_21839_(false);
        }
        if (flag && this.getCrackiness() != steelgolem$crackiness) {
            this.m_5496_(SoundEvents.f_12058_, 1.0f, 1.0f);
        }
        return flag;
    }

    public void m_6667_(@NotNull DamageSource cause) {
        if (!this.isChassisCompromised()) {
            this.f_20890_ = false;
            if (!this.m_9236_().f_46443_ && this.m_9236_().m_46469_().m_46207_(GameRules.f_46142_) && this.m_269323_() instanceof ServerPlayer) {
                this.m_269323_().m_213846_((Component)Component.m_237110_((String)"entity.elementus.steel_golem_down", (Object[])new Object[]{this.getChassisHealth()}));
                this.m_21662_();
                this.m_20153_();
            }
        } else {
            super.m_6667_(cause);
        }
        this.m_21662_();
        this.m_20153_();
    }

    public boolean m_5801_() {
        return !this.isChassisBroken() && super.m_5801_();
    }

    public boolean m_5789_() {
        return !this.isChassisBroken() && super.m_5789_();
    }

    public Crackiness getCrackiness() {
        return Crackiness.byFraction(this.m_21223_() / this.m_21233_());
    }

    public ChassisCrackiness getChassisCrackiness() {
        if (this.isPlayerCreated()) {
            return ChassisCrackiness.byFraction((float)this.getChassisHealth() / 5.0f);
        }
        return ChassisCrackiness.NONE;
    }

    public boolean m_5829_() {
        Item item;
        if (!this.getArmor().m_41619_() && (item = this.getArmor().m_41720_()) instanceof SteelGolemUpgradeItem) {
            SteelGolemUpgradeItem armorItem = (SteelGolemUpgradeItem)item;
            return armorItem.isNotPushable() && (this.m_21825_() || this.isChassisBroken());
        }
        return super.m_5829_();
    }

    @NotNull
    protected ResourceLocation m_7582_() {
        if (this.getMossStage() == 0) {
            return this.m_6095_().m_20677_();
        }
        return switch (this.getMossStage()) {
            case 1 -> Elementus.modLoc("entities/steel_golem/moss_1");
            case 2 -> Elementus.modLoc("entities/steel_golem/moss_2");
            case 3 -> Elementus.modLoc("entities/steel_golem/moss_3");
            default -> throw new IncompatibleClassChangeError();
        };
    }

    public boolean m_6779_(@NotNull LivingEntity pTarget) {
        return !this.isChassisBroken() && super.m_6779_(pTarget);
    }

    protected void m_7355_(@NotNull BlockPos pPos, @NotNull BlockState pBlock) {
        this.m_5496_(SoundEvents.f_12010_, 2.0f, 0.5f);
    }

    protected void m_7472_(@NotNull DamageSource pSource, int pLooting, boolean pRecentlyHit) {
        super.m_7472_(pSource, pLooting, pRecentlyHit);
        ItemStack leaves = this.isCamouflaged();
        ItemStack saddle = this.getSaddle();
        ItemStack carpet = this.getDripCarpet();
        if (leaves != null) {
            this.m_19983_(leaves);
        }
        if (saddle != null) {
            this.m_19983_(saddle);
        }
        if (carpet != null) {
            this.m_19983_(carpet);
        }
    }

    public boolean isPlayerCreated() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setPlayerCreated(boolean playerMade) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        if (playerMade) {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(b0 | 1)));
        } else {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(b0 & 0xFFFFFFFE)));
        }
    }

    @Override
    public boolean m_6573_(@NotNull Player pPlayer) {
        return !this.m_21523_() && !this.m_21660_();
    }

    @NotNull
    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.95f * this.m_20192_()), (double)(this.m_20205_() * 0.4f));
    }

    public boolean m_6097_() {
        return !this.isChassisBroken();
    }

    public boolean isShearable(@NotNull ItemStack item, Level level, BlockPos pos) {
        return this.getMossStage() > 0 && !this.isChassisBroken();
    }

    @NotNull
    public List<ItemStack> onSheared(@org.jetbrains.annotations.Nullable Player player, @NotNull ItemStack item, Level level, BlockPos pos, int fortune) {
        level.m_6269_(null, (Entity)this, SoundEvents.f_144187_, player == null ? SoundSource.BLOCKS : SoundSource.PLAYERS, 1.0f, 1.0f);
        this.m_146852_(GameEvent.f_157781_, (Entity)player);
        if (!level.f_46443_) {
            int i = 1 + this.f_19796_.m_188503_(3);
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (int j = 0; j < i; ++j) {
                items.add(new ItemStack((ItemLike)Items.f_151016_));
            }
            return items;
        }
        return Collections.emptyList();
    }

    public void m_5851_(@NotNull SoundSource pSource) {
        this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_12344_, pSource, 1.0f, 1.0f);
        this.setMossStage(this.getMossStage() - 1);
        int i = 1 + this.f_19796_.m_188503_(3);
        for (int j = 0; j < i; ++j) {
            ItemEntity itementity = this.m_19983_(new ItemStack((ItemLike)Items.f_151016_));
            if (itementity == null) continue;
            itementity.m_20256_(itementity.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f), (double)(this.f_19796_.m_188501_() * 0.05f), (double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f)));
        }
    }

    public boolean m_6220_() {
        return this.getMossStage() > 0 && !this.isChassisCompromised();
    }

    public static enum Crackiness {
        NONE(1.0f),
        LOW(0.75f),
        MEDIUM(0.5f),
        HIGH(0.25f);

        private static final List<Crackiness> BY_DAMAGE;
        private final float fraction;

        private Crackiness(float pFraction) {
            this.fraction = pFraction;
        }

        public static Crackiness byFraction(float pFraction) {
            for (Crackiness steelgolem$crackiness : BY_DAMAGE) {
                if (!(pFraction < steelgolem$crackiness.fraction)) continue;
                return steelgolem$crackiness;
            }
            return NONE;
        }

        static {
            BY_DAMAGE = (List)Stream.of(Crackiness.values()).sorted(Comparator.comparingDouble(p_28904_ -> p_28904_.fraction)).collect(ImmutableList.toImmutableList());
        }
    }

    public static enum ChassisCrackiness {
        NONE(1.0f),
        VERYLOW(0.81f),
        LOW(0.61f),
        MEDIUM(0.41f),
        HIGH(0.21f);

        private static final List<ChassisCrackiness> BY_DAMAGE;
        private final float fraction;

        private ChassisCrackiness(float pFraction) {
            this.fraction = pFraction;
        }

        public static ChassisCrackiness byFraction(float pFraction) {
            for (ChassisCrackiness steelgolem$chassis : BY_DAMAGE) {
                if (!(pFraction < steelgolem$chassis.fraction)) continue;
                return steelgolem$chassis;
            }
            return NONE;
        }

        static {
            BY_DAMAGE = (List)Stream.of(ChassisCrackiness.values()).sorted(Comparator.comparingDouble(p_28904_ -> p_28904_.fraction)).collect(ImmutableList.toImmutableList());
        }
    }
}

