/*
 * Decompiled with CFR 0.152.
 */
package net.nokunami.elementus.common.entity.living;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.nokunami.elementus.common.entity.living.TamableGolem;
import net.nokunami.elementus.common.registry.ModSoundEvents;
import org.jetbrains.annotations.NotNull;

public abstract class TamableChestedGolem
extends TamableGolem {
    protected TamableChestedGolem(EntityType<? extends TamableChestedGolem> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Override
    protected int getInventorySize() {
        return this.hasChest() ? 17 : super.getInventorySize();
    }

    @Override
    protected void m_5907_() {
        super.m_5907_();
        if (this.hasChest()) {
            if (!this.m_9236_().f_46443_) {
                this.m_19998_((ItemLike)Blocks.f_50087_);
            }
            this.setChest(false);
        }
    }

    @Override
    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("Chested", this.hasChest());
        if (this.hasChest()) {
            ListTag listtag = new ListTag();
            for (int i = 2; i < this.inventory.m_6643_(); ++i) {
                ItemStack itemstack = this.inventory.m_8020_(i);
                if (itemstack.m_41619_()) continue;
                CompoundTag compoundtag = new CompoundTag();
                compoundtag.m_128344_("Slot", (byte)i);
                itemstack.m_41739_(compoundtag);
                listtag.add((Object)compoundtag);
            }
            pCompound.m_128365_("Items", (Tag)listtag);
        }
    }

    @Override
    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        this.setChest(tag.m_128471_("Chested"));
        if (this.hasChest()) {
            ListTag listtag = tag.m_128437_("Items", 10);
            for (int i = 0; i < listtag.size(); ++i) {
                CompoundTag compoundtag = listtag.m_128728_(i);
                int j = compoundtag.m_128445_("Slot") & 0xFF;
                if (j < 2 || j >= this.inventory.m_6643_()) continue;
                this.inventory.m_6836_(j, ItemStack.m_41712_((CompoundTag)compoundtag));
            }
        }
        this.updateContainerEquipment();
    }

    @Override
    @NotNull
    public SlotAccess m_141942_(int pSlot) {
        return pSlot == 499 ? new SlotAccess(){

            @NotNull
            public ItemStack m_142196_() {
                return TamableChestedGolem.this.hasChest() ? new ItemStack((ItemLike)Items.f_42009_) : ItemStack.f_41583_;
            }

            public boolean m_142104_(@NotNull ItemStack stack) {
                if (stack.m_41619_()) {
                    if (TamableChestedGolem.this.hasChest()) {
                        TamableChestedGolem.this.setChest(false);
                        TamableChestedGolem.this.createInventory();
                    }
                    return true;
                }
                if (stack.m_150930_(Items.f_42009_)) {
                    if (!TamableChestedGolem.this.hasChest()) {
                        TamableChestedGolem.this.setChest(true);
                        TamableChestedGolem.this.createInventory();
                    }
                    return true;
                }
                return false;
            }
        } : super.m_141942_(pSlot);
    }

    private void equipChest(Player pPlayer, ItemStack pChestStack) {
        this.setChest(true);
        this.playChestEquipsSound();
        if (!pPlayer.m_150110_().f_35937_) {
            pChestStack.m_41774_(1);
        }
        this.createInventory();
    }

    protected void playChestEquipsSound() {
        this.m_5496_((SoundEvent)ModSoundEvents.STEEL_GOLEM_CHESTED.get(), 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
    }

    public int getInventoryColumns() {
        return 5;
    }
}

