/*
 * Decompiled with CFR 0.152.
 */
package net.nokunami.elementus.common.entity.living;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.RiderShieldingMount;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.network.NetworkHooks;
import net.nokunami.elementus.common.registry.ModSoundEvents;
import org.jetbrains.annotations.NotNull;

public abstract class TamableGolem
extends TamableAnimal
implements ContainerListener,
HasCustomInventoryScreen,
MenuProvider,
PlayerRideableJumping,
Saddleable,
RiderShieldingMount {
    private static final EntityDataAccessor<Byte> DATA_SADDLED_ID = SynchedEntityData.m_135353_(TamableGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Boolean> DATA_ID_CHEST = SynchedEntityData.m_135353_(TamableGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final int EQUIPMENT_SLOT_OFFSET = 400;
    public static final int CHEST_SLOT_OFFSET = 499;
    public static final int INVENTORY_SLOT_OFFSET = 500;
    public static final int SADDLE_FLAG_ID = 1;
    public static final int INV_SLOT_SADDLE = 0;
    public static final int INV_SLOT_ARMOR = 1;
    public static final int INV_BASE_COUNT = 2;
    public int sprintCounter;
    protected boolean isJumping;
    public SimpleContainer inventory;
    protected LazyOptional<?> itemHandler = null;

    protected TamableGolem(EntityType<? extends TamableGolem> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.createInventory();
    }

    public boolean m_7307_(@NotNull Entity pEntity) {
        if (this.m_21824_()) {
            LivingEntity livingentity = this.m_269323_();
            if (pEntity == livingentity) {
                return true;
            }
            if (livingentity != null) {
                return livingentity.m_7307_(pEntity);
            }
        }
        return super.m_7307_(pEntity);
    }

    public boolean m_275843_() {
        return false;
    }

    public double m_262813_() {
        return 1.25;
    }

    @NotNull
    public SoundEvent m_246265_() {
        return (SoundEvent)ModSoundEvents.STEEL_GOLEM_SADDLED.get();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DATA_SADDLED_ID, (Object)0);
        this.f_19804_.m_135372_(DATA_ID_CHEST, (Object)false);
    }

    protected boolean getSaddleFlag() {
        return ((Byte)this.f_19804_.m_135370_(DATA_SADDLED_ID) & 1) != 0;
    }

    protected void setSaddleFlag(boolean pValue) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_SADDLED_ID);
        if (pValue) {
            this.f_19804_.m_135381_(DATA_SADDLED_ID, (Object)((byte)(b0 | 1)));
        } else {
            this.f_19804_.m_135381_(DATA_SADDLED_ID, (Object)((byte)(b0 & 0xFFFFFFFE)));
        }
    }

    public boolean hasChest() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ID_CHEST);
    }

    public void setChest(boolean pChested) {
        this.f_19804_.m_135381_(DATA_ID_CHEST, (Object)pChested);
    }

    public boolean isJumping() {
        return this.isJumping;
    }

    public void setIsJumping(boolean pJumping) {
        this.isJumping = pJumping;
    }

    public boolean m_6741_() {
        return this.m_6084_() && this.m_21824_();
    }

    public void m_5853_(@Nullable SoundSource pSource) {
        this.inventory.m_6836_(0, new ItemStack((ItemLike)Items.f_42450_));
    }

    public void equipArmor(@NotNull Player pPlayer, @NotNull ItemStack pArmor) {
        if (this.isArmor(pArmor)) {
            this.inventory.m_6836_(1, pArmor.m_255036_(1));
            if (!pPlayer.m_150110_().f_35937_) {
                pArmor.m_41774_(1);
            }
        }
    }

    public boolean m_6254_() {
        return !this.m_6844_(EquipmentSlot.HEAD).m_41619_();
    }

    public boolean m_6094_() {
        return !this.m_20160_();
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, @NotNull DamageSource pSource) {
        return false;
    }

    protected int getInventorySize() {
        return 2;
    }

    protected void createInventory() {
        SimpleContainer simplecontainer = this.inventory;
        this.inventory = new SimpleContainer(this.getInventorySize());
        if (simplecontainer != null) {
            simplecontainer.m_19181_((ContainerListener)this);
            int i = Math.min(simplecontainer.m_6643_(), this.inventory.m_6643_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = simplecontainer.m_8020_(j);
                if (itemstack.m_41619_()) continue;
                this.inventory.m_6836_(j, itemstack.m_41777_());
            }
        }
        this.inventory.m_19164_((ContainerListener)this);
        this.updateContainerEquipment();
        this.itemHandler = LazyOptional.of(() -> new InvWrapper((Container)this.inventory));
    }

    protected void updateContainerEquipment() {
        if (!this.m_9236_().f_46443_) {
            this.setSaddle(this.inventory.m_8020_(0));
        }
    }

    public void m_5757_(@NotNull Container pContainer) {
        boolean flag = this.m_6254_();
        this.updateContainerEquipment();
        if (this.f_19797_ > 20 && !flag && this.m_6254_()) {
            this.m_5496_(this.m_246265_(), 0.5f, 1.0f);
        }
    }

    private void setSaddle(ItemStack stack) {
        this.m_8061_(EquipmentSlot.HEAD, stack);
        this.m_21409_(EquipmentSlot.HEAD, 0.0f);
    }

    public void m_213583_(@NotNull Player pPlayer) {
    }

    public InteractionResult openInventory(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)this);
        }
        this.m_213583_(player);
        if (this.hasChest()) {
            this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_11749_, SoundSource.NEUTRAL, 0.5f, 1.0f);
        }
        return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
    }

    protected InteractionResult doPlayerRide(Player pPlayer) {
        this.m_21839_(false);
        this.m_21837_(false);
        if (!this.m_9236_().f_46443_) {
            pPlayer.m_146922_(this.m_146908_());
            pPlayer.m_146926_(this.m_146909_());
            pPlayer.m_20329_((Entity)this);
        }
        return InteractionResult.SUCCESS;
    }

    protected void m_5907_() {
        super.m_5907_();
        if (this.inventory != null) {
            for (int i = 0; i < this.inventory.m_6643_(); ++i) {
                ItemStack itemstack = this.inventory.m_8020_(i);
                if (itemstack.m_41619_() || EnchantmentHelper.m_44924_((ItemStack)itemstack)) continue;
                this.m_19983_(itemstack);
            }
        }
    }

    protected void m_274498_(@NotNull Player pPlayer, @NotNull Vec3 pTravelVector) {
        super.m_274498_(pPlayer, pTravelVector);
        Vec2 vec2 = this.getRiddenRotation((LivingEntity)pPlayer);
        this.m_19915_(vec2.f_82471_, vec2.f_82470_);
        this.f_20883_ = this.f_20885_ = this.m_146908_();
        this.f_19859_ = this.f_20885_;
    }

    public boolean m_6573_(Player pPlayer) {
        return super.m_6573_(pPlayer);
    }

    protected Vec2 getRiddenRotation(LivingEntity pEntity) {
        return new Vec2(pEntity.m_146909_() * 0.25f, pEntity.m_146908_());
    }

    @NotNull
    protected Vec3 m_274312_(Player pPlayer, @NotNull Vec3 pTravelVector) {
        float f = pPlayer.f_20900_ * 0.5f;
        float f1 = pPlayer.f_20902_;
        if (f1 <= 0.0f) {
            f1 *= 0.25f;
        }
        return new Vec3((double)f, 0.0, (double)f1);
    }

    protected float m_245547_(@NotNull Player pPlayer) {
        return super.m_245547_(pPlayer);
    }

    protected void executeRidersJump(float pPlayerJumpPendingScale, Vec3 pTravelVector) {
        double d0 = 0.9 * (double)pPlayerJumpPendingScale * (double)this.m_20098_();
        double d1 = d0 + (double)this.m_285755_();
        Vec3 vec3 = this.m_20184_();
        this.m_20334_(vec3.f_82479_, d1, vec3.f_82481_);
        this.setIsJumping(true);
        this.f_19812_ = true;
        ForgeHooks.onLivingJump((LivingEntity)this);
        if (pTravelVector.f_82481_ > 0.0) {
            float f = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
            float f1 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
            this.m_20256_(this.m_20184_().m_82520_((double)(-0.4f * f * pPlayerJumpPendingScale), 0.0, (double)(0.4f * f1 * pPlayerJumpPendingScale)));
        }
    }

    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        if (!this.inventory.m_8020_(0).m_41619_()) {
            tag.m_128365_("SaddleItem", (Tag)this.inventory.m_8020_(0).m_41739_(new CompoundTag()));
        }
    }

    public void m_7378_(@NotNull CompoundTag tag) {
        ItemStack itemStack;
        super.m_7378_(tag);
        if (tag.m_128425_("SaddleItem", 10) && (itemStack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("SaddleItem"))).m_150930_(Items.f_42450_)) {
            this.inventory.m_6836_(0, itemStack);
        }
        this.updateContainerEquipment();
    }

    public void m_7888_(int pJumpPower) {
    }

    public boolean m_7132_() {
        return false;
    }

    public void m_7199_(int pJumpPower) {
    }

    public void m_8012_() {
    }

    protected int getMaxPassengers() {
        return 1;
    }

    public boolean canWearArmor() {
        return false;
    }

    public boolean isWearingArmor() {
        return !this.m_6844_(EquipmentSlot.CHEST).m_41619_();
    }

    public boolean isArmor(@NotNull ItemStack pStack) {
        return false;
    }

    protected SlotAccess createEquipmentSlotAccess(final int pSlot, final Predicate<ItemStack> pStackFilter) {
        return new SlotAccess(){

            @NotNull
            public ItemStack m_142196_() {
                return TamableGolem.this.inventory.m_8020_(pSlot);
            }

            public boolean m_142104_(@NotNull ItemStack stack) {
                if (!pStackFilter.test(stack)) {
                    return false;
                }
                TamableGolem.this.inventory.m_6836_(pSlot, stack);
                TamableGolem.this.updateContainerEquipment();
                return true;
            }
        };
    }

    @NotNull
    public SlotAccess m_141942_(int pSlot) {
        int j;
        int i = pSlot - 400;
        if (i >= 0 && i < 2 && i < this.inventory.m_6643_()) {
            if (i == 0) {
                return this.createEquipmentSlotAccess(i, stack -> stack.m_41619_() || stack.m_150930_(Items.f_42450_));
            }
            if (i == 1) {
                if (!this.canWearArmor()) {
                    return SlotAccess.f_147290_;
                }
                return this.createEquipmentSlotAccess(i, p_149516_ -> p_149516_.m_41619_() || this.isArmor((ItemStack)p_149516_));
            }
        }
        return (j = pSlot - 500 + 2) >= 2 && j < this.inventory.m_6643_() ? SlotAccess.m_147292_((Container)this.inventory, (int)j) : super.m_141942_(pSlot);
    }

    @Nullable
    public LivingEntity m_6688_() {
        Player player;
        Entity entity = this.m_146895_();
        if (!(entity instanceof Mob) && this.m_6254_() && (entity = this.m_146895_()) instanceof Player && this.m_21830_((LivingEntity)(player = (Player)entity))) {
            return player;
        }
        return null;
    }

    @Nullable
    private Vec3 getDismountLocationInDirection(Vec3 pDirection, LivingEntity passenger) {
        double d0 = this.m_20185_() + pDirection.f_82479_;
        double d1 = this.m_20191_().f_82289_;
        double d2 = this.m_20189_() + pDirection.f_82481_;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        block0: for (Pose pose : passenger.m_7431_()) {
            blockpos$mutableblockpos.m_122169_(d0, d1, d2);
            double d3 = this.m_20191_().f_82292_ + 0.75;
            do {
                double d4 = this.m_9236_().m_45573_((BlockPos)blockpos$mutableblockpos);
                if ((double)blockpos$mutableblockpos.m_123342_() + d4 > d3) continue block0;
                if (DismountHelper.m_38439_((double)d4)) {
                    AABB aabb = passenger.m_21270_(pose);
                    Vec3 vec3 = new Vec3(d0, (double)blockpos$mutableblockpos.m_123342_() + d4, d2);
                    if (DismountHelper.m_38456_((CollisionGetter)this.m_9236_(), (LivingEntity)passenger, (AABB)aabb.m_82383_(vec3))) {
                        passenger.m_20124_(pose);
                        return vec3;
                    }
                }
                blockpos$mutableblockpos.m_122173_(Direction.UP);
            } while ((double)blockpos$mutableblockpos.m_123342_() < d3);
        }
        return null;
    }

    @NotNull
    public Vec3 m_7688_(LivingEntity pLivingEntity) {
        Vec3 vec3 = TamableGolem.m_19903_((double)this.m_20205_(), (double)pLivingEntity.m_20205_(), (float)(this.m_146908_() + (pLivingEntity.m_5737_() == HumanoidArm.RIGHT ? 90.0f : -90.0f)));
        Vec3 vec31 = this.getDismountLocationInDirection(vec3, pLivingEntity);
        if (vec31 != null) {
            return vec31;
        }
        Vec3 vec32 = TamableGolem.m_19903_((double)this.m_20205_(), (double)pLivingEntity.m_20205_(), (float)(this.m_146908_() + (pLivingEntity.m_5737_() == HumanoidArm.LEFT ? 90.0f : -90.0f)));
        Vec3 vec33 = this.getDismountLocationInDirection(vec32, pLivingEntity);
        return vec33 != null ? vec33 : this.m_20182_();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction facing) {
        if (this.m_6084_() && capability == ForgeCapabilities.ITEM_HANDLER && this.itemHandler != null) {
            return this.itemHandler.cast();
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.itemHandler != null) {
            LazyOptional<?> oldHandler = this.itemHandler;
            this.itemHandler = null;
            oldHandler.invalidate();
        }
    }

    public boolean hasInventoryChanged(@NotNull Container pInventory) {
        return this.inventory != pInventory;
    }

    @Nullable
    public AgeableMob m_142606_(@NotNull ServerLevel pLevel, @NotNull AgeableMob pOtherParent) {
        return null;
    }

    protected int m_7302_(int pAir) {
        return pAir;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, @NotNull Inventory pPlayerInventory, @NotNull Player pPlayer) {
        return null;
    }
}

