/*
 * Decompiled with CFR 0.152.
 */
package net.nokunami.elementus.common.entity.projectile;

import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.server.ServerLifecycleHooks;
import net.nokunami.elementus.Elementus;
import net.nokunami.elementus.common.entity.MobUtil;
import net.nokunami.elementus.common.item.AnthektiteChargeBlade;
import net.nokunami.elementus.common.item.ChargeBladeItem;
import net.nokunami.elementus.common.registry.ModEnchantments;
import net.nokunami.elementus.common.registry.ModEntityType;
import net.nokunami.elementus.common.registry.ModParticleTypes;
import org.jetbrains.annotations.NotNull;

public class PulseBurstEntity
extends Projectile {
    protected static final EntityDataAccessor<Optional<UUID>> OWNER_UNIQUE_ID = SynchedEntityData.m_135353_(PulseBurstEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    protected static final EntityDataAccessor<BlockPos> BLOCK_POS = SynchedEntityData.m_135353_(PulseBurstEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    protected static final EntityDataAccessor<Float> DISCARD_DISTANCE = SynchedEntityData.m_135353_(PulseBurstEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Boolean> FRIENDLY_FIRE = SynchedEntityData.m_135353_(PulseBurstEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<ItemStack> WEAPON = SynchedEntityData.m_135353_(PulseBurstEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private float damage = 7.5f;
    private int delay = 0;
    public Predicate<? super Entity> REMOVE_ENTITIES_PREDICATE = e -> MobUtil.allied((Entity)this.getTrueOwner(), e, this.getFriendlyFire()) || e.equals((Object)this.getTrueOwner());

    public PulseBurstEntity(EntityType<? extends Projectile> entityType, Level level) {
        super(entityType, level);
    }

    protected PulseBurstEntity(EntityType<? extends Projectile> pEntityType, double pX, double pY, double pZ, Level pLevel) {
        this(pEntityType, pLevel);
        this.m_6034_(pX, pY, pZ);
    }

    protected PulseBurstEntity(EntityType<? extends Projectile> pEntityType, LivingEntity pShooter, Level pLevel) {
        this(pEntityType, pShooter.m_20185_(), pShooter.m_20188_() - (double)0.1f, pShooter.m_20189_(), pLevel);
        this.m_5602_((Entity)pShooter);
    }

    public PulseBurstEntity(Level pLevel, LivingEntity shooter) {
        this((EntityType<? extends Projectile>)((EntityType)ModEntityType.PULSE_BURST.get()), shooter, pLevel);
        this.setOwnerId(shooter.m_20148_());
        this.setBlockPos(shooter.m_20183_());
        this.setItemStack(shooter.m_21211_());
    }

    public void launchSlash(Entity pShooter, float pX, float pY, float pZ, float pVelocity, float pInaccuracy) {
        float f = -Mth.m_14031_((float)(pY * ((float)Math.PI / 180))) * Mth.m_14089_((float)(pX * ((float)Math.PI / 180)));
        float f1 = -Mth.m_14031_((float)((pX + pZ) * ((float)Math.PI / 180)));
        float f2 = Mth.m_14089_((float)(pY * ((float)Math.PI / 180))) * Mth.m_14089_((float)(pX * ((float)Math.PI / 180)));
        this.m_6686_(f, f1, f2, pVelocity, pInaccuracy);
        this.m_146926_(pX);
        this.m_146922_(pY);
    }

    public float getDamage() {
        return this.damage;
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(OWNER_UNIQUE_ID, Optional.empty());
        this.f_19804_.m_135372_(BLOCK_POS, (Object)BlockPos.f_121853_);
        this.f_19804_.m_135372_(DISCARD_DISTANCE, (Object)Float.valueOf(10.0f));
        this.f_19804_.m_135372_(FRIENDLY_FIRE, (Object)false);
        this.f_19804_.m_135372_(WEAPON, (Object)ItemStack.f_41583_);
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        UUID uuid;
        super.m_7378_(compound);
        if (compound.m_128403_("Owner")) {
            uuid = compound.m_128342_("Owner");
        } else {
            String s = compound.m_128461_("Owner");
            uuid = OldUsersConverter.m_11083_((MinecraftServer)Objects.requireNonNull(this.m_20194_()), (String)s);
        }
        if (uuid != null) {
            try {
                this.setOwnerId(uuid);
            }
            catch (Throwable s) {
                // empty catch block
            }
        }
        if (compound.m_128441_("Damage")) {
            this.setDamage(compound.m_128451_("Damage"));
        }
        int x = compound.m_128451_("PosX");
        int y = compound.m_128451_("PosY");
        int z = compound.m_128451_("PosZ");
        this.setBlockPos(new BlockPos(x, y, z));
        this.setDiscardDistance(compound.m_128457_("DiscardDistance"));
        this.setFriendlyFire(compound.m_128471_("FriendlyFire"));
        CompoundTag stack = compound.m_128469_("ItemStack");
        if (!stack.m_128456_()) {
            ItemStack itemStack = ItemStack.m_41712_((CompoundTag)stack);
            if (itemStack.m_41619_()) {
                Elementus.LOGGER.warn("Unable to load ItemStack from: {}", (Object)stack);
            }
            this.setItemStack(itemStack);
        }
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        if (this.getOwnerId() != null) {
            compound.m_128362_("Owner", this.getOwnerId());
        }
        compound.m_128350_("Damage", this.getDamage());
        compound.m_128405_("PosX", this.getBlockPos().m_123341_());
        compound.m_128405_("PosY", this.getBlockPos().m_123342_());
        compound.m_128405_("PosZ", this.getBlockPos().m_123343_());
        compound.m_128350_("DiscardDistance", this.getDiscardDistance());
        compound.m_128379_("FriendlyFire", this.getFriendlyFire());
        if (!this.getItemStack().m_41619_()) {
            compound.m_128365_("ItemStack", (Tag)this.getItemStack().m_41739_(new CompoundTag()));
        }
    }

    public LivingEntity getTrueOwner() {
        try {
            UUID uuid = this.getOwnerId();
            return uuid == null ? null : PulseBurstEntity.getLivingEntityByUuiD(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    @Nullable
    public UUID getOwnerId() {
        return ((Optional)this.f_19804_.m_135370_(OWNER_UNIQUE_ID)).orElse(null);
    }

    public void setOwnerId(@Nullable UUID uuid) {
        this.f_19804_.m_135381_(OWNER_UNIQUE_ID, Optional.ofNullable(uuid));
    }

    public BlockPos getBlockPos() {
        return (BlockPos)this.f_19804_.m_135370_(BLOCK_POS);
    }

    public void setBlockPos(BlockPos blockPos) {
        this.f_19804_.m_135381_(BLOCK_POS, (Object)blockPos);
    }

    public float getDiscardDistance() {
        return ((Float)this.f_19804_.m_135370_(DISCARD_DISTANCE)).floatValue();
    }

    public void setDiscardDistance(float v) {
        this.f_19804_.m_135381_(DISCARD_DISTANCE, (Object)Float.valueOf(v));
    }

    public boolean getFriendlyFire() {
        return (Boolean)this.f_19804_.m_135370_(FRIENDLY_FIRE);
    }

    public void setFriendlyFire(boolean b) {
        this.f_19804_.m_135381_(FRIENDLY_FIRE, (Object)b);
    }

    public ItemStack getItemStack() {
        return (ItemStack)this.f_19804_.m_135370_(WEAPON);
    }

    public void setItemStack(ItemStack b) {
        this.f_19804_.m_135381_(WEAPON, (Object)b);
    }

    public void m_8119_() {
        int totalDelay = 6;
        ParticleOptions burstEmitter = (ParticleOptions)ModParticleTypes.SONIC_BOOM_START.get();
        ParticleOptions trail = (ParticleOptions)ModParticleTypes.SONIC_BURST.get();
        if (!this.getItemStack().m_41619_()) {
            this.setFriendlyFire(AnthektiteChargeBlade.getFriendlyFire(this.getItemStack()));
            if (ChargeBladeItem.isEnchantedWith(this.getItemStack(), ModEnchantments.SACRIFICE_CURSE)) {
                burstEmitter = (ParticleOptions)ModParticleTypes.SACRIFICE_SONIC_BOOM_START.get();
                trail = (ParticleOptions)ModParticleTypes.SACRIFICE_SONIC_BURST.get();
            }
        }
        if (this.getTrueOwner() != null) {
            double discardDistance;
            double blockPos = this.m_20238_(this.getBlockPos().m_252807_());
            if (blockPos >= (discardDistance = (double)Mth.m_14207_((float)this.getDiscardDistance()))) {
                this.m_146870_();
            }
            if (this.delay < totalDelay) {
                ++this.delay;
            } else {
                this.m_9236_().m_7106_(burstEmitter, this.m_20185_() + this.m_20184_().f_82479_, this.m_20186_() + this.m_20184_().f_82480_, this.m_20189_() + this.m_20184_().f_82481_, 0.0, 0.0, 0.0);
                this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_215771_, this.m_5720_(), 5.0f, 1.0f, false);
                this.delay = 0;
            }
            HashSet targets = new HashSet(this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_().m_82400_(5.0), e -> MobUtil.allied((Entity)this.getTrueOwner(), (Entity)e, this.getFriendlyFire())));
            float damage1 = this.getDamage();
            if (!targets.isEmpty()) {
                for (Entity entity : targets) {
                    if (!(entity instanceof LivingEntity)) continue;
                    LivingEntity living = (LivingEntity)entity;
                    if (entity == this.getTrueOwner() || this.delay != totalDelay / 2) continue;
                    living.m_6469_(entity.m_269291_().m_269285_((Entity)this.getTrueOwner()), damage1 += EnchantmentHelper.m_44833_((ItemStack)this.getItemStack(), (MobType)living.m_6336_()));
                }
            }
            if (this.delay == totalDelay / 2) {
                this.m_9236_().m_7106_(trail, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
            }
        }
        this.m_146884_(this.m_20182_().m_82549_(this.m_20184_()));
        Vec3 vec34 = this.m_20184_();
        this.m_20334_(vec34.f_82479_, vec34.f_82480_, vec34.f_82481_);
    }

    public boolean m_6072_() {
        return false;
    }

    public boolean m_6060_() {
        return false;
    }

    public boolean m_6469_(@NotNull DamageSource pSource, float pAmount) {
        return false;
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static LivingEntity getLivingEntityByUuiD(UUID uuid) {
        return PulseBurstEntity.getLivingEntityByUuiD(ServerLifecycleHooks.getCurrentServer(), uuid);
    }

    public static LivingEntity getLivingEntityByUuiD(MinecraftServer server, UUID uuid) {
        if (uuid != null && server != null) {
            for (ServerLevel world : server.m_129785_()) {
                Entity entity = world.m_8791_(uuid);
                if (!(entity instanceof LivingEntity)) continue;
                return (LivingEntity)entity;
            }
        }
        return null;
    }
}

