/*
 * Decompiled with CFR 0.152.
 */
package net.nokunami.elementus.common.entity.projectile;

import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.server.ServerLifecycleHooks;
import net.nokunami.elementus.Elementus;
import net.nokunami.elementus.common.entity.MobUtil;
import net.nokunami.elementus.common.entity.projectile.SwordDanceSlashEntity;
import net.nokunami.elementus.common.item.AnthektiteChargeBlade;
import net.nokunami.elementus.common.registry.ModEntityType;
import net.nokunami.elementus.common.registry.ModParticleTypes;
import org.jetbrains.annotations.NotNull;

public class RushProjectileEntity
extends Projectile {
    protected static final EntityDataAccessor<Optional<UUID>> OWNER_UNIQUE_ID = SynchedEntityData.m_135353_(RushProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    protected static final EntityDataAccessor<BlockPos> BLOCK_POS = SynchedEntityData.m_135353_(RushProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    protected static final EntityDataAccessor<Float> DISCARD_DISTANCE = SynchedEntityData.m_135353_(RushProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Boolean> FRIENDLY_FIRE = SynchedEntityData.m_135353_(RushProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<ItemStack> WEAPON = SynchedEntityData.m_135353_(RushProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private float damage = 7.5f;
    private int totalLifespan = 120;
    private int delay = 0;
    private final int totalDelay;
    public Predicate<LivingEntity> REMOVE_PREDICATE = e -> {
        OwnableEntity ownable;
        return !(e instanceof OwnableEntity) && (e.m_7307_((Entity)this.getTrueOwner()) && this.getFriendlyFire() || !e.m_7307_((Entity)this.getTrueOwner())) || e instanceof OwnableEntity && ((ownable = (OwnableEntity)e).m_269323_() != null && (ownable.m_269323_().m_7306_((Entity)this.getTrueOwner()) || ownable.m_269323_().m_7307_((Entity)this.getTrueOwner())) && this.getFriendlyFire() || ownable.m_269323_() == null);
    };
    public Predicate<? super Entity> REMOVE_ENTITIES_PREDICATE = e -> MobUtil.allied((Entity)this.getTrueOwner(), e, this.getFriendlyFire()) || e.equals((Object)this.getTrueOwner());
    public Predicate<? super LivingEntity> REMOVE_ENTITIES_PREDICATE2 = e -> MobUtil.allied((Entity)this.getTrueOwner(), (Entity)e, this.getFriendlyFire());
    private final Set<Entity> alreadyHitEntities = new HashSet<Entity>();

    public RushProjectileEntity(EntityType<? extends Projectile> entityType, Level level) {
        super(entityType, level);
        this.totalDelay = 1;
    }

    protected RushProjectileEntity(EntityType<? extends Projectile> pEntityType, double pX, double pY, double pZ, Level pLevel) {
        this(pEntityType, pLevel);
        this.m_6034_(pX, pY, pZ);
    }

    protected RushProjectileEntity(EntityType<? extends Projectile> pEntityType, LivingEntity pShooter, Level pLevel) {
        this(pEntityType, pShooter.m_20185_(), pShooter.m_20188_() - (double)0.1f, pShooter.m_20189_(), pLevel);
        this.m_5602_((Entity)pShooter);
    }

    public RushProjectileEntity(Level pLevel, LivingEntity pShooter) {
        this((EntityType<? extends Projectile>)((EntityType)ModEntityType.RUSH_PROJECTILE.get()), pShooter, pLevel);
    }

    public float getDamage() {
        return this.damage;
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    public int getTotalLifespan() {
        return this.totalLifespan;
    }

    public void setTotalLifespan(int totalLifespan) {
        this.totalLifespan = totalLifespan;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(OWNER_UNIQUE_ID, Optional.empty());
        this.f_19804_.m_135372_(BLOCK_POS, (Object)BlockPos.f_121853_);
        this.f_19804_.m_135372_(DISCARD_DISTANCE, (Object)Float.valueOf(10.0f));
        this.f_19804_.m_135372_(FRIENDLY_FIRE, (Object)false);
        this.f_19804_.m_135372_(WEAPON, (Object)ItemStack.f_41583_);
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        UUID uuid;
        super.m_7378_(compound);
        if (compound.m_128403_("Owner")) {
            uuid = compound.m_128342_("Owner");
        } else {
            String s = compound.m_128461_("Owner");
            uuid = OldUsersConverter.m_11083_((MinecraftServer)Objects.requireNonNull(this.m_20194_()), (String)s);
        }
        if (uuid != null) {
            try {
                this.setOwnerId(uuid);
            }
            catch (Throwable s) {
                // empty catch block
            }
        }
        if (compound.m_128441_("Damage")) {
            this.setDamage(compound.m_128451_("Damage"));
        }
        if (compound.m_128441_("TotalLife")) {
            this.setTotalLifespan(compound.m_128451_("TotalLife"));
        }
        int x = compound.m_128451_("PosX");
        int y = compound.m_128451_("PosY");
        int z = compound.m_128451_("PosZ");
        this.setBlockPos(new BlockPos(x, y, z));
        this.setDiscardDistance(compound.m_128457_("DiscardDistance"));
        this.setFriendlyFire(compound.m_128471_("FriendlyFire"));
        CompoundTag stack = compound.m_128469_("ItemStack");
        if (!stack.m_128456_()) {
            ItemStack itemStack = ItemStack.m_41712_((CompoundTag)stack);
            if (itemStack.m_41619_()) {
                Elementus.LOGGER.warn("Unable to load ItemStack from: {}", (Object)stack);
            }
            this.setItemStack(itemStack);
        }
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        if (this.getOwnerId() != null) {
            compound.m_128362_("Owner", this.getOwnerId());
        }
        compound.m_128350_("Damage", this.getDamage());
        compound.m_128405_("TotalLife", this.getTotalLifespan());
        compound.m_128405_("PosX", this.getBlockPos().m_123341_());
        compound.m_128405_("PosY", this.getBlockPos().m_123342_());
        compound.m_128405_("PosZ", this.getBlockPos().m_123343_());
        compound.m_128350_("DiscardDistance", this.getDiscardDistance());
        compound.m_128379_("FriendlyFire", this.getFriendlyFire());
        if (!this.getItemStack().m_41619_()) {
            compound.m_128365_("ItemStack", (Tag)this.getItemStack().m_41739_(new CompoundTag()));
        }
    }

    public LivingEntity getTrueOwner() {
        try {
            UUID uuid = this.getOwnerId();
            return uuid == null ? null : RushProjectileEntity.getLivingEntityByUuiD(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    @Nullable
    public UUID getOwnerId() {
        return ((Optional)this.f_19804_.m_135370_(OWNER_UNIQUE_ID)).orElse(null);
    }

    public void setOwnerId(@Nullable UUID uuid) {
        this.f_19804_.m_135381_(OWNER_UNIQUE_ID, Optional.ofNullable(uuid));
    }

    public BlockPos getBlockPos() {
        return (BlockPos)this.f_19804_.m_135370_(BLOCK_POS);
    }

    public void setBlockPos(BlockPos blockPos) {
        this.f_19804_.m_135381_(BLOCK_POS, (Object)blockPos);
    }

    public float getDiscardDistance() {
        return ((Float)this.f_19804_.m_135370_(DISCARD_DISTANCE)).floatValue();
    }

    public void setDiscardDistance(float v) {
        this.f_19804_.m_135381_(DISCARD_DISTANCE, (Object)Float.valueOf(v));
    }

    public boolean getFriendlyFire() {
        return (Boolean)this.f_19804_.m_135370_(FRIENDLY_FIRE);
    }

    public void setFriendlyFire(boolean b) {
        this.f_19804_.m_135381_(FRIENDLY_FIRE, (Object)b);
    }

    public ItemStack getItemStack() {
        return (ItemStack)this.f_19804_.m_135370_(WEAPON);
    }

    public void setItemStack(ItemStack b) {
        this.f_19804_.m_135381_(WEAPON, (Object)b);
    }

    public void m_8119_() {
        if (!this.getItemStack().m_41619_()) {
            this.setFriendlyFire(AnthektiteChargeBlade.getFriendlyFire(this.getItemStack()));
        }
        Entity owner = this.m_19749_();
        if (this.f_19797_ > this.getTotalLifespan()) {
            this.m_146870_();
        }
        if (this.m_9236_().f_46443_ || owner == null || !owner.m_213877_()) {
            if (this.delay < this.totalDelay) {
                ++this.delay;
            } else {
                if (!this.getTrueOwner().m_20096_()) {
                    this.m_9236_().m_7106_((ParticleOptions)ModParticleTypes.RUSH_TRAIL.get(), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
                }
                this.delay = 0;
            }
        }
        if (this.getTrueOwner() != null) {
            this.m_146884_(this.getTrueOwner().m_20318_((float)this.f_19797_).m_82520_(0.0, (double)this.getTrueOwner().m_20206_() * 0.25, 0.0));
            HashSet targets = new HashSet(this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_().m_82377_(1.5, 0.5, 1.5), e -> MobUtil.allied((Entity)this.getTrueOwner(), (Entity)e, this.getFriendlyFire())));
            targets.remove(this.getTrueOwner());
            float damage1 = this.getDamage();
            if (!targets.isEmpty()) {
                for (Entity entity : targets) {
                    if (!(entity instanceof LivingEntity)) continue;
                    LivingEntity living = (LivingEntity)entity;
                    if (entity == this.getTrueOwner()) continue;
                    this.swordDanceSlash(this.getTrueOwner(), this.getTrueOwner().m_7655_(), damage1 += EnchantmentHelper.m_44833_((ItemStack)this.getItemStack(), (MobType)living.m_6336_()), entity);
                    if (living.m_271686_() != this.getTrueOwner()) continue;
                    this.m_146870_();
                }
            }
        }
    }

    public void swordDanceSlash(LivingEntity player, InteractionHand hand, float damage, Entity target) {
        Level level = player.m_9236_();
        if (!this.alreadyHitEntities.contains(target)) {
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12316_, SoundSource.PLAYERS, 1.0f, 1.4f / (level.f_46441_.m_188501_() * 0.4f + 0.8f));
            boolean mirrored = false;
            if (player.m_7655_() == InteractionHand.MAIN_HAND) {
                if (player.m_5737_() == HumanoidArm.RIGHT) {
                    mirrored = true;
                }
            } else if (player.m_5737_() == HumanoidArm.LEFT) {
                mirrored = true;
            }
            SwordDanceSlashEntity slash = new SwordDanceSlashEntity(level, player);
            slash.setOwnerId(player.m_20148_());
            slash.setDamage(damage);
            slash.setItemStack(player.m_21120_(hand));
            slash.setMirrored(mirrored);
            Vec3 hitLocation = player.m_20182_().m_82520_(0.0, (double)(player.m_20206_() * 0.3f), 0.0).m_82549_(player.m_20156_().m_82542_((double)1.65f, (double)0.35f, (double)1.65f));
            slash.m_20219_(hitLocation);
            slash.m_146922_(player.m_146908_());
            level.m_7967_((Entity)slash);
            this.alreadyHitEntities.add(target);
        }
    }

    public boolean m_6060_() {
        return false;
    }

    public boolean m_6469_(@NotNull DamageSource pSource, float pAmount) {
        return false;
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static LivingEntity getLivingEntityByUuiD(UUID uuid) {
        return RushProjectileEntity.getLivingEntityByUuiD(ServerLifecycleHooks.getCurrentServer(), uuid);
    }

    public static LivingEntity getLivingEntityByUuiD(MinecraftServer server, UUID uuid) {
        if (uuid != null && server != null) {
            for (ServerLevel world : server.m_129785_()) {
                Entity entity = world.m_8791_(uuid);
                if (!(entity instanceof LivingEntity)) continue;
                return (LivingEntity)entity;
            }
        }
        return null;
    }
}

