/*
 * Decompiled with CFR 0.152.
 */
package net.nokunami.elementus.common.entity.projectile;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.server.ServerLifecycleHooks;
import net.nokunami.elementus.Elementus;
import net.nokunami.elementus.common.entity.MobUtil;
import net.nokunami.elementus.common.item.AnthektiteChargeBlade;
import net.nokunami.elementus.common.registry.ModEntityType;
import net.nokunami.elementus.common.registry.ModItems;
import org.jetbrains.annotations.NotNull;

public class SwordDanceSlashEntity
extends Projectile {
    protected static final EntityDataAccessor<Optional<UUID>> OWNER_UNIQUE_ID = SynchedEntityData.m_135353_(SwordDanceSlashEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    protected static final EntityDataAccessor<Boolean> FRIENDLY_FIRE = SynchedEntityData.m_135353_(SwordDanceSlashEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<ItemStack> WEAPON = SynchedEntityData.m_135353_(SwordDanceSlashEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    protected static final EntityDataAccessor<Boolean> MIRRORED = SynchedEntityData.m_135353_(SwordDanceSlashEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private ItemStack weapon = new ItemStack((ItemLike)ModItems.ElementusItems.ANTHEKTITE_CHARGE_BLADE.get());
    private float damage = 7.5f;
    private final Set<Entity> alreadyHitEntities;
    public Predicate<? super Entity> REMOVE_ENTITIES_PREDICATE = e -> MobUtil.allied((Entity)this.getTrueOwner(), e, this.getFriendlyFire()) || e.equals((Object)this.getTrueOwner());
    public static float bbWidth = 4.25f;
    public static float bbHeight = 0.9f;

    public SwordDanceSlashEntity(EntityType<? extends Projectile> entityType, Level level) {
        super(entityType, level);
        this.alreadyHitEntities = new HashSet<Entity>();
    }

    protected SwordDanceSlashEntity(EntityType<? extends Projectile> pEntityType, double pX, double pY, double pZ, Level pLevel) {
        this(pEntityType, pLevel);
        this.m_6034_(pX, pY, pZ);
    }

    protected SwordDanceSlashEntity(EntityType<? extends Projectile> pEntityType, LivingEntity pShooter, Level pLevel) {
        this(pEntityType, pShooter.m_20185_(), pShooter.m_20188_() - (double)0.1f, pShooter.m_20189_(), pLevel);
        this.m_5602_((Entity)pShooter);
    }

    public SwordDanceSlashEntity(Level pLevel, LivingEntity pShooter) {
        this((EntityType<? extends Projectile>)((EntityType)ModEntityType.SWORD_DANCE_SLASH.get()), pShooter, pLevel);
        this.weapon = pShooter.m_21205_();
    }

    public void launchSlash(LivingEntity entity, float pX, float pY, float pZ, float pVelocity, float pInaccuracy, Vec3 vec3) {
        float f = -Mth.m_14031_((float)(pY * ((float)Math.PI / 180))) * Mth.m_14089_((float)(pX * ((float)Math.PI / 180)));
        float f1 = -Mth.m_14031_((float)((pX + pZ) * ((float)Math.PI / 180)));
        float f2 = Mth.m_14089_((float)(pY * ((float)Math.PI / 180))) * Mth.m_14089_((float)(pX * ((float)Math.PI / 180)));
        this.m_6686_(f, f1, f2, pVelocity, pInaccuracy);
        this.m_6034_(vec3.f_82479_, vec3.f_82480_ - 1.0, vec3.f_82481_);
    }

    public float getDamage() {
        return this.damage;
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(OWNER_UNIQUE_ID, Optional.empty());
        this.f_19804_.m_135372_(FRIENDLY_FIRE, (Object)false);
        this.f_19804_.m_135372_(WEAPON, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(MIRRORED, (Object)false);
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        UUID uuid;
        super.m_7378_(compound);
        if (compound.m_128403_("Owner")) {
            uuid = compound.m_128342_("Owner");
        } else {
            String s = compound.m_128461_("Owner");
            uuid = OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)s);
        }
        if (uuid != null) {
            try {
                this.setOwnerId(uuid);
            }
            catch (Throwable s) {
                // empty catch block
            }
        }
        if (compound.m_128441_("Damage")) {
            this.setDamage(compound.m_128457_("Damage"));
        }
        this.setFriendlyFire(compound.m_128471_("FriendlyFire"));
        CompoundTag stack = compound.m_128469_("ItemStack");
        if (!stack.m_128456_()) {
            ItemStack itemStack = ItemStack.m_41712_((CompoundTag)stack);
            if (itemStack.m_41619_()) {
                Elementus.LOGGER.warn("Unable to load ItemStack from: {}", (Object)stack);
            }
            this.setItemStack(itemStack);
        }
        this.setMirrored(compound.m_128471_("Mirrored"));
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        if (this.getOwnerId() != null) {
            compound.m_128362_("Owner", this.getOwnerId());
        }
        compound.m_128350_("Damage", this.getDamage());
        compound.m_128379_("FriendlyFire", this.getFriendlyFire());
        if (!this.getItemStack().m_41619_()) {
            compound.m_128365_("ItemStack", (Tag)this.getItemStack().m_41739_(new CompoundTag()));
        }
        compound.m_128379_("Mirrored", this.getMirrored());
    }

    public LivingEntity getTrueOwner() {
        try {
            UUID uuid = this.getOwnerId();
            return uuid == null ? null : SwordDanceSlashEntity.getLivingEntityByUuiD(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    @Nullable
    public UUID getOwnerId() {
        return ((Optional)this.f_19804_.m_135370_(OWNER_UNIQUE_ID)).orElse(null);
    }

    public void setOwnerId(@Nullable UUID p_184754_1_) {
        this.f_19804_.m_135381_(OWNER_UNIQUE_ID, Optional.ofNullable(p_184754_1_));
    }

    public boolean getFriendlyFire() {
        return (Boolean)this.f_19804_.m_135370_(FRIENDLY_FIRE);
    }

    public void setFriendlyFire(boolean b) {
        this.f_19804_.m_135381_(FRIENDLY_FIRE, (Object)b);
    }

    public ItemStack getItemStack() {
        return (ItemStack)this.f_19804_.m_135370_(WEAPON);
    }

    public void setItemStack(ItemStack b) {
        this.f_19804_.m_135381_(WEAPON, (Object)b);
    }

    public boolean getMirrored() {
        return (Boolean)this.f_19804_.m_135370_(MIRRORED);
    }

    public void setMirrored(boolean b) {
        this.f_19804_.m_135381_(MIRRORED, (Object)b);
    }

    public void m_8119_() {
        boolean breakBlock;
        this.setFriendlyFire(AnthektiteChargeBlade.getFriendlyFire(this.weapon));
        if (this.getTrueOwner() != null) {
            if (this.f_19797_ >= 12) {
                this.m_146870_();
            }
            HashSet targets = new HashSet(this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_().m_82400_(0.5), e -> MobUtil.allied((Entity)this.getTrueOwner(), (Entity)e, this.getFriendlyFire())));
            float damage1 = this.getDamage();
            if (!targets.isEmpty()) {
                for (Entity entity : targets) {
                    if (!(entity instanceof LivingEntity)) continue;
                    LivingEntity living = (LivingEntity)entity;
                    if (entity == this.getTrueOwner()) continue;
                    this.hurtMob(living, entity.m_269291_().m_269075_((Player)this.getTrueOwner()), damage1 += EnchantmentHelper.m_44833_((ItemStack)this.weapon, (MobType)living.m_6336_()));
                }
            }
        }
        if (breakBlock = true) {
            AABB aabb = this.m_20191_().m_82400_(0.2);
            for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
                BlockState blockstate = this.m_9236_().m_8055_(blockpos);
                if (!blockstate.m_204336_(BlockTags.f_144281_)) continue;
                ItemStack itemStack = this.weapon;
                if (this.weapon == null || this.weapon.m_41619_()) {
                    itemStack = new ItemStack((ItemLike)ModItems.ElementusItems.ANTHEKTITE_CHARGE_BLADE.get());
                }
                SwordDanceSlashEntity.breakBlock(this.m_9236_(), blockpos, itemStack, (Entity)this);
            }
        }
        super.m_8119_();
    }

    private void hurtMob(LivingEntity entity, DamageSource source, float damage) {
        if (!this.alreadyHitEntities.contains(entity)) {
            entity.m_6469_(source, damage);
            this.alreadyHitEntities.add((Entity)entity);
        }
    }

    public boolean m_6072_() {
        return false;
    }

    public boolean m_20068_() {
        return true;
    }

    public boolean m_6060_() {
        return false;
    }

    public boolean m_6469_(@NotNull DamageSource pSource, float pAmount) {
        return false;
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static LivingEntity getLivingEntityByUuiD(Level level, UUID uuid) {
        return SwordDanceSlashEntity.getLivingEntityByUuiD(level.m_7654_(), uuid);
    }

    public static LivingEntity getLivingEntityByUuiD(UUID uuid) {
        return SwordDanceSlashEntity.getLivingEntityByUuiD(ServerLifecycleHooks.getCurrentServer(), uuid);
    }

    public static LivingEntity getLivingEntityByUuiD(MinecraftServer server, UUID uuid) {
        if (uuid != null && server != null) {
            for (ServerLevel world : server.m_129785_()) {
                Entity entity = world.m_8791_(uuid);
                if (!(entity instanceof LivingEntity)) continue;
                return (LivingEntity)entity;
            }
        }
        return null;
    }

    public static boolean breakBlock(Level level, BlockPos blockPos, ItemStack itemStack, @Nullable Entity entity) {
        BlockState blockstate = level.m_8055_(blockPos);
        if (blockstate.m_60795_()) {
            return false;
        }
        FluidState fluidstate = level.m_6425_(blockPos);
        if (!(blockstate.m_60734_() instanceof BaseFireBlock)) {
            level.m_46796_(2001, blockPos, Block.m_49956_((BlockState)blockstate));
        }
        BlockEntity blockentity = blockstate.m_155947_() ? level.m_7702_(blockPos) : null;
        Block.m_49881_((BlockState)blockstate, (Level)level, (BlockPos)blockPos, (BlockEntity)blockentity, (Entity)entity, (ItemStack)itemStack);
        boolean flag = level.m_6933_(blockPos, fluidstate.m_76188_(), 3, 512);
        if (flag) {
            level.m_220407_(GameEvent.f_157794_, blockPos, GameEvent.Context.m_223719_((Entity)entity, (BlockState)blockstate));
        }
        return flag;
    }

    public static boolean areAllies(@Nullable Entity entity, @Nullable Entity entity1) {
        if (entity != null && entity1 != null) {
            return entity.m_7307_(entity1) || entity1.m_7307_(entity) || entity == entity1;
        }
        return false;
    }
}

