/*
 * Decompiled with CFR 0.152.
 */
package net.nokunami.elementus.common.entity.vehicle;

import java.util.function.IntFunction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidType;
import net.nokunami.elementus.common.registry.ModBlocks;
import net.nokunami.elementus.common.registry.ModEntityType;
import net.nokunami.elementus.common.registry.ModItems;
import org.jetbrains.annotations.NotNull;

public class ModBoatEntity
extends Boat {
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE = SynchedEntityData.m_135353_(ModBoatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public ModBoatEntity(EntityType<? extends Boat> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public ModBoatEntity(Level level, double pX, double pY, double pZ) {
        this((EntityType<? extends Boat>)((EntityType)ModEntityType.MOD_BOAT.get()), level);
        this.m_6034_(pX, pY, pZ);
        this.f_19854_ = pX;
        this.f_19855_ = pY;
        this.f_19856_ = pZ;
    }

    @NotNull
    public Item m_38369_() {
        switch (this.getModVariant()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case MOVCADIA: 
        }
        return (Item)ModItems.ElementusItems.MOVCADIA_BOAT.get();
    }

    public void setVariant(Type pVariant) {
        this.f_19804_.m_135381_(DATA_ID_TYPE, (Object)pVariant.ordinal());
    }

    public Type getModVariant() {
        return Type.byId((Integer)this.f_19804_.m_135370_(DATA_ID_TYPE));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_TYPE, (Object)Type.MOVCADIA.ordinal());
    }

    protected void m_7380_(CompoundTag pCompound) {
        pCompound.m_128359_("Type", this.getModVariant().m_7912_());
    }

    protected void m_7378_(CompoundTag pCompound) {
        if (pCompound.m_128425_("Type", 8)) {
            this.setVariant(Type.byName(pCompound.m_128461_("Type")));
        }
    }

    public boolean canBoatInFluid(FluidState state) {
        ModBoatEntity boat = this;
        return state.supportsBoating((Boat)boat) || state.getFluidType().equals(Fluids.f_76195_.getFluidType()) && ModBoatEntity.isFireproofBoat(this.getModVariant());
    }

    public boolean canBoatInFluid(FluidType type) {
        ModBoatEntity boat = this;
        return type.supportsBoating((Boat)boat) || type.equals(Fluids.f_76195_.getFluidType()) && ModBoatEntity.isFireproofBoat(this.getModVariant());
    }

    public static boolean isFireproofBoat(Type boatType) {
        return ((FireBlock)Blocks.f_50083_).m_221164_(boatType.getPlanks().m_49966_()) == 0;
    }

    public boolean m_5825_() {
        return ModBoatEntity.isFireproofBoat(this.getModVariant()) || super.m_5825_();
    }

    public static enum Type implements StringRepresentable
    {
        MOVCADIA((Block)ModBlocks.ElementusBlocks.MOVCADIA_PLANKS.get(), "movcadia");

        private final String name;
        private final Block planks;
        public static final StringRepresentable.EnumCodec<Type> CODEC;
        private static final IntFunction<Type> BY_ID;

        private Type(Block pPlanks, String pName) {
            this.name = pName;
            this.planks = pPlanks;
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }

        public Block getPlanks() {
            return this.planks;
        }

        public String toString() {
            return this.name;
        }

        public static Type byId(int pId) {
            return BY_ID.apply(pId);
        }

        public static Type byName(String pName) {
            return (Type)CODEC.m_262792_(pName, (Enum)MOVCADIA);
        }

        static {
            CODEC = StringRepresentable.m_216439_(Type::values);
            BY_ID = ByIdMap.m_262839_(Enum::ordinal, (Object[])Type.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        }
    }
}

