/*
 * Decompiled with CFR 0.152.
 */
package net.nokunami.elementus.common.entity.vehicle;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.ChestBoat;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidType;
import net.nokunami.elementus.common.entity.vehicle.ModBoatEntity;
import net.nokunami.elementus.common.registry.ModEntityType;
import net.nokunami.elementus.common.registry.ModItems;
import org.jetbrains.annotations.NotNull;

public class ModChestBoatEntity
extends ChestBoat {
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE = SynchedEntityData.m_135353_(ModChestBoatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public ModChestBoatEntity(EntityType<? extends ChestBoat> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public ModChestBoatEntity(Level pLevel, double pX, double pY, double pZ) {
        this((EntityType<? extends ChestBoat>)((EntityType)ModEntityType.MOD_CHEST_BOAT.get()), pLevel);
        this.m_6034_(pX, pY, pZ);
        this.f_19854_ = pX;
        this.f_19855_ = pY;
        this.f_19856_ = pZ;
    }

    @NotNull
    public Item m_38369_() {
        switch (this.getModVariant()) {
            case MOVCADIA: {
                return (Item)ModItems.ElementusItems.MOVCADIA_CHEST_BOAT.get();
            }
        }
        return super.m_38369_();
    }

    public void setVariant(ModBoatEntity.Type pVariant) {
        this.f_19804_.m_135381_(DATA_ID_TYPE, (Object)pVariant.ordinal());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_TYPE, (Object)ModBoatEntity.Type.MOVCADIA.ordinal());
    }

    protected void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128359_("Type", this.getModVariant().m_7912_());
    }

    protected void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128425_("Type", 8)) {
            this.setVariant(ModBoatEntity.Type.byName(pCompound.m_128461_("Type")));
        }
    }

    public ModBoatEntity.Type getModVariant() {
        return ModBoatEntity.Type.byId((Integer)this.f_19804_.m_135370_(DATA_ID_TYPE));
    }

    public boolean canBoatInFluid(FluidState state) {
        ModChestBoatEntity boat = this;
        return state.supportsBoating((Boat)boat) || state.getFluidType().equals(Fluids.f_76195_.getFluidType()) && ModChestBoatEntity.isFireproofBoat(this.getModVariant());
    }

    public boolean canBoatInFluid(FluidType type) {
        ModChestBoatEntity boat = this;
        return type.supportsBoating((Boat)boat) || type.equals(Fluids.f_76195_.getFluidType()) && ModChestBoatEntity.isFireproofBoat(this.getModVariant());
    }

    public static boolean isFireproofBoat(ModBoatEntity.Type boatType) {
        return ((FireBlock)Blocks.f_50083_).m_221164_(boatType.getPlanks().m_49966_()) == 0;
    }

    public boolean m_5825_() {
        return ModChestBoatEntity.isFireproofBoat(this.getModVariant()) || super.m_5825_();
    }
}

