/*
 * Decompiled with CFR 0.152.
 */
package net.nokunami.elementus.common.inventory;

import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.nokunami.elementus.common.Etags;
import net.nokunami.elementus.common.entity.living.SteelGolem;
import net.nokunami.elementus.common.entity.living.TamableChestedGolem;
import net.nokunami.elementus.common.entity.living.TamableGolem;
import org.jetbrains.annotations.NotNull;

public class SteelGolemInventoryMenu
extends AbstractContainerMenu {
    private final Container container;
    private final SteelGolem golem;

    public SteelGolemInventoryMenu(int containerId, Inventory inventory, Container container, SteelGolem steelGolem) {
        super(null, containerId);
        this.container = container;
        this.golem = steelGolem;
        int i = 3;
        container.m_5856_(inventory.f_35978_);
        this.golem.isChestOpened(true);
        if (this.hasChest(this.golem)) {
            this.golem.m_9236_().m_5594_(null, this.golem.m_20183_(), SoundEvents.f_11749_, SoundSource.NEUTRAL, 0.5f, 1.0f);
        }
        this.m_38897_(new Slot(container, 0, 8, 18){

            public boolean m_5857_(@NotNull ItemStack stack) {
                return stack.m_150930_(Items.f_42450_) && !this.m_6657_() && SteelGolemInventoryMenu.this.golem.m_6741_();
            }

            public int m_6641_() {
                return 1;
            }
        });
        this.m_38897_(new Slot(container, 1, 8, 36){

            public boolean m_5857_(@NotNull ItemStack stack) {
                return SteelGolemInventoryMenu.this.golem.isArmor(stack);
            }

            public int m_6641_() {
                return 1;
            }
        });
        this.m_38897_(new Slot(container, 2, 8, 54){

            public boolean m_5857_(@NotNull ItemStack stack) {
                return stack.m_204117_(Etags.Items.STEEL_GOLEM_LEAVES_DECORATION);
            }

            public int m_6641_() {
                return 1;
            }
        });
        this.m_38897_(new Slot(container, 3, 8, 72){

            public boolean m_5857_(@NotNull ItemStack stack) {
                return stack.m_204117_(Etags.Items.STEEL_GOLEM_CARPET_DECORATION);
            }

            public int m_6641_() {
                return 1;
            }
        });
        if (this.hasChest(this.golem)) {
            for (int k = 0; k < 4; ++k) {
                for (int l = 0; l < steelGolem.getInventoryColumns(); ++l) {
                    this.m_38897_(new Slot(container, 4 + l + k * steelGolem.getInventoryColumns(), 80 + l * 18, 18 + k * 18));
                }
            }
        }
        for (int i1 = 0; i1 < i; ++i1) {
            for (int k1 = 0; k1 < 9; ++k1) {
                this.m_38897_(new Slot((Container)inventory, k1 + i1 * 9 + 9, 8 + k1 * 18, 120 + i1 * 18 - 18));
            }
        }
        for (int j1 = 0; j1 < 9; ++j1) {
            this.m_38897_(new Slot((Container)inventory, j1, 8 + j1 * 18, 160));
        }
    }

    public boolean m_6875_(@NotNull Player player) {
        return !this.golem.hasInventoryChanged(this.container) && this.container.m_6542_(player) && this.golem.m_6084_() && this.golem.m_20270_((Entity)player) < 8.0f;
    }

    private boolean hasChest(TamableGolem golem) {
        return golem instanceof TamableChestedGolem && golem.hasChest();
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index < this.container.m_6643_() ? !this.m_38903_(itemstack1, this.container.m_6643_(), this.f_38839_.size(), true) : !this.m_38903_(itemstack1, 0, this.container.m_6643_(), false)) {
                return ItemStack.f_41583_;
            }
            int i = this.container.m_6643_();
            if (index < i) {
                if (!this.m_38903_(itemstack1, i, this.f_38839_.size(), true)) {
                    return ItemStack.f_41583_;
                }
            } else if (this.m_38853_(1).m_5857_(itemstack1) && !this.m_38853_(1).m_6657_()) {
                if (!this.m_38903_(itemstack1, 1, 2, false)) {
                    return ItemStack.f_41583_;
                }
            } else if (this.m_38853_(0).m_5857_(itemstack1)) {
                if (!this.m_38903_(itemstack1, 0, 1, false)) {
                    return ItemStack.f_41583_;
                }
            } else if (i <= 2 || !this.m_38903_(itemstack1, 2, i, false)) {
                int j = i + 27;
                int k = j + 9;
                if (index >= j && index < k ? !this.m_38903_(itemstack1, i, j, false) : (index >= i && index < j ? !this.m_38903_(itemstack1, j, k, false) : !this.m_38903_(itemstack1, j, j, false))) {
                    return ItemStack.f_41583_;
                }
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_269060_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    public void m_6877_(@NotNull Player player) {
        super.m_6877_(player);
        this.container.m_5785_(player);
        if (this.hasChest(this.golem)) {
            this.golem.m_9236_().m_5594_(null, this.golem.m_20183_(), SoundEvents.f_11747_, SoundSource.NEUTRAL, 0.5f, 1.0f);
        }
        this.golem.isChestOpened(false);
    }
}

