/*
 * Decompiled with CFR 0.152.
 */
package net.nokunami.elementus.common.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import net.nokunami.elementus.common.config.UniqueItemConfig;
import net.nokunami.elementus.common.entity.projectile.AnthektiteSlashEntity;
import net.nokunami.elementus.common.entity.projectile.RushProjectileEntity;
import net.nokunami.elementus.common.entity.projectile.SwordDanceSlashEntity;
import net.nokunami.elementus.common.item.ChargeBladeItem;
import net.nokunami.elementus.common.network.AnthektiteChargeBladeSlashPacket;
import net.nokunami.elementus.common.network.ModNetwork;
import net.nokunami.elementus.common.registry.ModMobEffects;
import net.nokunami.elementus.common.registry.ModSoundEvents;
import net.nokunami.elementus.common.registry.ModTiers;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="elementus", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class AnthektiteChargeBlade
extends ChargeBladeItem {
    private final Multimap<Attribute, AttributeModifier> swordDanceAttribute;

    public AnthektiteChargeBlade() {
        super(ModTiers.ANTHEKTITE, UniqueItemConfig.anthektiteChargeBladeDamage, (float)UniqueItemConfig.anthektiteChargeBladeAttackSpeed, (float)UniqueItemConfig.anthektiteChargeBladeAttackReach, new Item.Properties().m_41486_().m_41497_(Rarity.EPIC));
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        this.swordDanceAttribute = this.createAttributes((ImmutableMultimap.Builder<Attribute, AttributeModifier>)builder, UniqueItemConfig.anthektiteChargeBladeAmpDamage, (float)UniqueItemConfig.anthektiteChargeBladeAmpAttackSpeed, (float)UniqueItemConfig.anthektiteChargeBladeAmpAttackReach).build();
    }

    @Override
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        return slot.equals((Object)EquipmentSlot.MAINHAND) & AnthektiteChargeBlade.getState(stack) ? this.swordDanceAttribute : super.getAttributeModifiers(slot, stack);
    }

    @Override
    public void m_6883_(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slotId, boolean isSelected) {
        LivingEntity living;
        super.m_6883_(stack, level, entity, slotId, isSelected);
        AnthektiteChargeBlade.setState(stack, entity instanceof LivingEntity && (living = (LivingEntity)entity).m_21023_((MobEffect)ModMobEffects.ElementusEffects.ANTHEKTITE_SWORD_DANCE.get()));
    }

    @Override
    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        this.friendlyFireTooltip(tooltip, stack);
        if (stack.m_41793_()) {
            tooltip.add(CommonComponents.f_237098_);
        }
    }

    @Override
    public boolean canDisableShield(ItemStack stack, ItemStack shield, LivingEntity entity, LivingEntity attacker) {
        return false;
    }

    @Override
    public boolean m_41386_(DamageSource pDamageSource) {
        return pDamageSource.m_269533_(DamageTypeTags.f_268738_);
    }

    public static boolean getState(ItemStack stack) {
        return stack.m_41784_().m_128471_("SwordDance");
    }

    public static void setState(ItemStack stack, boolean b) {
        stack.m_41784_().m_128379_("SwordDance", b);
    }

    public int m_142159_(@NotNull ItemStack pStack) {
        return 12054986;
    }

    public static void emptyClick(ItemStack stack, InteractionHand hand) {
        if (!stack.m_41619_() && stack.m_41720_() instanceof AnthektiteChargeBlade) {
            ModNetwork.INSTANCE.send(PacketDistributor.SERVER.noArg(), (Object)new AnthektiteChargeBladeSlashPacket(hand));
        }
    }

    public static void spawnSlash(Player player, InteractionHand hand) {
        Level level = player.m_9236_();
        if (player.m_36403_(1.0f) >= 0.99f) {
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)ModSoundEvents.CHARGE_BLADE_WIND_SLASH.get(), SoundSource.PLAYERS, 1.0f, 1.4f / (level.f_46441_.m_188501_() * 0.4f + 0.8f));
            if (!level.f_46443_) {
                AnthektiteSlashEntity slash = new AnthektiteSlashEntity(level, (LivingEntity)player);
                slash.setOwnerId(player.m_20148_());
                slash.setBlockPos(player.m_20183_());
                slash.setDamage(5.0f);
                slash.setDiscardDistance(16.0f);
                slash.setChargeable(!player.m_21023_((MobEffect)ModMobEffects.ElementusEffects.ANTHEKTITE_SWORD_DANCE.get()));
                slash.setItemStack(player.m_21120_(hand));
                slash.launchSlash((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 1.0f, 1.0f);
                level.m_7967_((Entity)slash);
            }
        }
    }

    public static void swordDanceSlash(Player player, InteractionHand hand) {
        Level level = player.m_9236_();
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11897_, SoundSource.PLAYERS, 1.0f, 1.4f / (level.f_46441_.m_188501_() * 0.4f + 0.8f));
        if (!level.f_46443_) {
            boolean mirrored = false;
            if (player.m_7655_() == InteractionHand.MAIN_HAND) {
                if (player.m_5737_() == HumanoidArm.RIGHT) {
                    mirrored = true;
                }
            } else if (player.m_5737_() == HumanoidArm.LEFT) {
                mirrored = true;
            }
            SwordDanceSlashEntity slash = new SwordDanceSlashEntity(level, (LivingEntity)player);
            slash.setOwnerId(player.m_20148_());
            slash.setDamage(20.0f);
            slash.setItemStack(player.m_21120_(hand));
            slash.setMirrored(mirrored);
            Vec3 hitLocation = player.m_20182_().m_82520_(0.0, (double)(player.m_20206_() * 0.3f), 0.0).m_82549_(player.m_20156_().m_82542_((double)1.65f, (double)0.35f, (double)1.65f));
            slash.m_20219_(hitLocation);
            slash.m_146922_(player.m_146908_());
            level.m_7967_((Entity)slash);
        }
    }

    public static void rush(Player player) {
        Level level = player.m_9236_();
        level.m_6269_(null, (Entity)player, (SoundEvent)ModSoundEvents.CHARGE_BLADE_RUSH.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        if (!level.f_46443_) {
            if (player.m_20096_() && player.m_5686_((float)player.f_19797_) > -5.0f) {
                AnthektiteChargeBlade.applyRecoil((Entity)player, (Entity)player, 1.25, 0.0, 1.25, true);
                player.m_246865_(player.m_20184_().m_82520_(0.0, 0.5, 0.0));
            } else {
                AnthektiteChargeBlade.applyRecoil((Entity)player, (Entity)player, 2.0, 2.0, 2.0, true);
            }
            RushProjectileEntity slash = new RushProjectileEntity(level, (LivingEntity)player);
            slash.setOwnerId(player.m_20148_());
            slash.setDamage(12.0f);
            slash.setTotalLifespan(20);
            slash.setItemStack(player.m_21120_(player.m_7655_()));
            level.m_7967_((Entity)slash);
        }
    }

    @SubscribeEvent
    public static void EmptyClickEvents(PlayerInteractEvent.LeftClickEmpty event) {
        AnthektiteChargeBlade.emptyClick(event.getItemStack(), event.getEntity().m_7655_());
    }
}

