/*
 * Decompiled with CFR 0.152.
 */
package net.nokunami.elementus.common.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.nokunami.elementus.ElementusClient;
import net.nokunami.elementus.ModChecker;
import net.nokunami.elementus.client.render.item.inventory.CatalystTooltip;
import net.nokunami.elementus.common.Etags;
import net.nokunami.elementus.common.config.CatalystArmorConfig;
import net.nokunami.elementus.common.config.ModConfig;
import net.nokunami.elementus.common.item.CatalystItemUtil;
import net.nokunami.elementus.common.registry.ModArmorMaterials;
import net.nokunami.elementus.common.registry.ModSoundEvents;
import nonamecrackers2.witherstormmod.common.init.WitherStormModItems;
import nonamecrackers2.witherstormmod.common.init.WitherStormModSoundEvents;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CatalystArmorItem
extends ArmorItem {
    public final ModArmorMaterials material;
    public static Multimap<Attribute, AttributeModifier> defaultModifiers;
    private static final String core = "Items";
    private static final String elytra = "ElytraEquipped";
    private static final String elytraL = "ElytraEquiped";
    public static int attributeCheck;

    public CatalystArmorItem(ModArmorMaterials material, ArmorItem.Type type, Item.Properties properties) {
        super((ArmorMaterial)material, type, properties);
        this.material = material;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        UUID uuid = (UUID)f_265987_.get(type);
        builder.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(uuid, "Armor modifier", (double)this.m_40404_(), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22285_, (Object)new AttributeModifier(uuid, "Armor toughness", (double)this.m_40405_(), AttributeModifier.Operation.ADDITION));
        if (this.f_40378_ > 0.0f) {
            builder.put((Object)Attributes.f_22278_, (Object)new AttributeModifier(uuid, "Knockback resistance", (double)this.f_40378_, AttributeModifier.Operation.ADDITION));
        }
        for (Map.Entry<Attribute, AttributeModifier> modifierEntry : material.getAdditionalAttributes().entrySet()) {
            AttributeModifier atr = modifierEntry.getValue();
            atr = new AttributeModifier(uuid, atr.m_22214_(), atr.m_22218_(), atr.m_22217_());
            builder.put((Object)modifierEntry.getKey(), (Object)atr);
        }
        defaultModifiers = builder.build();
    }

    @NotNull
    public ModArmorMaterials getMaterial() {
        return this.material;
    }

    @NotNull
    public Multimap<Attribute, AttributeModifier> m_7167_(@NotNull EquipmentSlot pEquipmentSlot) {
        return pEquipmentSlot == this.f_265916_.m_266308_() ? defaultModifiers : super.m_7167_(pEquipmentSlot);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept((IClientItemExtensions)ElementusClient.PROXY.getArmorRenderProperties());
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return CatalystItemUtil.armorTexture(stack, entity);
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        if (CatalystArmorItem.getContents(stack).findAny().isPresent()) {
            tooltip.add((Component)Component.m_237115_((String)(this.m_5524_() + "." + CatalystArmorItem.catalystActivator(stack) + "_title_desc")).m_130940_(this.titleColor(stack)));
            tooltip.add((Component)Component.m_237115_((String)(this.m_5524_() + "." + CatalystArmorItem.catalystActivator(stack) + "_desc")).m_130940_(ChatFormatting.GRAY));
        }
        if (CatalystArmorItem.getElytraEquipped(stack).findAny().isPresent()) {
            tooltip.add((Component)Component.m_237115_((String)(this.m_5524_() + ".elytra_equipped")).m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.UNDERLINE));
        }
        if (CatalystArmorItem.getElytraEquiped(stack).findAny().isPresent()) {
            tooltip.add((Component)Component.m_237115_((String)(this.m_5524_() + ".elytra_equipped_legacy")).m_130940_(ChatFormatting.DARK_RED).m_130940_(ChatFormatting.UNDERLINE));
        }
        if (CatalystArmorItem.catalystActivator(stack).equals("arcane_ingot")) {
            if (ModChecker.ironsSpellbooks) {
                if (CatalystArmorConfig.ISS_MaxMana != 0) {
                    tooltip.add((Component)Component.m_237110_((String)(this.m_5524_() + ".iss_max_mana_desc"), (Object[])new Object[]{String.valueOf(CatalystArmorConfig.ISS_MaxMana)}).m_130940_(ChatFormatting.AQUA));
                }
                if (CatalystArmorConfig.ISS_ManaRegen != 0.0) {
                    tooltip.add((Component)Component.m_237110_((String)(this.m_5524_() + ".iss_mana_regen_desc"), (Object[])new Object[]{(int)(CatalystArmorConfig.ISS_ManaRegen * 100.0) + "%"}).m_130940_(ChatFormatting.AQUA));
                }
                if (CatalystArmorConfig.ISS_SpellPower != 0.0) {
                    tooltip.add((Component)Component.m_237110_((String)(this.m_5524_() + ".iss_spell_power_desc"), (Object[])new Object[]{(int)(CatalystArmorConfig.ISS_SpellPower * 100.0) + "%"}).m_130940_(ChatFormatting.AQUA));
                }
                if (CatalystArmorConfig.ISS_SpellResist != 0.0) {
                    tooltip.add((Component)Component.m_237110_((String)(this.m_5524_() + ".iss_spell_resist_desc"), (Object[])new Object[]{(int)(CatalystArmorConfig.ISS_SpellResist * 100.0) + "%"}).m_130940_(ChatFormatting.AQUA));
                }
            } else {
                tooltip.add((Component)Component.m_237115_((String)"item.elementus.iss_not_installed.desc").m_130940_(ChatFormatting.DARK_GRAY));
            }
        }
    }

    private ChatFormatting titleColor(ItemStack stack) {
        return switch (CatalystArmorItem.catalystActivator(stack)) {
            case "ignitium_ingot" -> ChatFormatting.YELLOW;
            case "heart_of_the_sea" -> ChatFormatting.BLUE;
            case "totem_of_undying" -> ChatFormatting.GOLD;
            case "cursium_ingot" -> ChatFormatting.DARK_AQUA;
            case "withered_nether_star" -> ChatFormatting.DARK_PURPLE;
            default -> ChatFormatting.LIGHT_PURPLE;
        };
    }

    public void onArmorTick(ItemStack stack, Level world, Player player) {
        CatalystItemUtil.netherStar(stack, player);
        CatalystItemUtil.ignitium(stack, player);
        CatalystItemUtil.arcane(stack, player);
        CatalystItemUtil.heartSea(stack, player);
        CatalystItemUtil.witheredNetherStar(stack, player);
    }

    public void m_6883_(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slotId, boolean isSelected) {
        if (!level.f_46443_ && entity instanceof Player) {
            Player player = (Player)entity;
            int type = 0;
            if (CatalystArmorItem.catalystActivator(stack).equals(Items.f_42686_.toString())) {
                type = 1;
            }
            if (CatalystArmorItem.catalystActivator(stack).equals(Items.f_42716_.toString())) {
                type = 2;
            }
            if (ModChecker.witherStormMod && CatalystArmorItem.catalystActivator(stack).equals(((Item)WitherStormModItems.WITHERED_NETHER_STAR.get()).toString())) {
                type = 3;
            }
            CatalystItemUtil.effectRadius(player, stack, level, type);
        }
        super.m_6883_(stack, level, entity, slotId, isSelected);
    }

    public static void attribute(int i) {
        attributeCheck = i;
    }

    public static String catalystActivator(ItemStack stack) {
        return CatalystArmorItem.getContents(stack).findAny().isPresent() ? CatalystArmorItem.getContents(stack).findAny().get().m_41720_().toString() : "false";
    }

    public boolean m_41386_(@NotNull DamageSource source) {
        return false;
    }

    public int getEntityLifespan(ItemStack stack, Level level) {
        return Integer.MAX_VALUE;
    }

    public boolean m_41465_() {
        return (Boolean)ModConfig.COMMON.catalystArmorDurability.get() == false;
    }

    public boolean isRepairable(@NotNull ItemStack stack) {
        return (Boolean)ModConfig.COMMON.catalystArmorDurability.get();
    }

    public static boolean isFlyEnabled(ItemStack stack) {
        return CatalystArmorItem.getElytraEquipped(stack).findAny().isPresent();
    }

    public boolean canElytraFly(ItemStack stack, LivingEntity entity) {
        return CatalystArmorItem.isFlyEnabled(stack);
    }

    public boolean elytraFlightTick(ItemStack stack, LivingEntity entity, int flightTicks) {
        int nextFlightTick;
        if (!entity.m_9236_().f_46443_ && (nextFlightTick = flightTicks + 1) % 10 == 0) {
            if (nextFlightTick % 20 == 0 && !((Boolean)ModConfig.COMMON.catalystArmorDurability.get()).booleanValue()) {
                stack.m_41622_(1, entity, e -> e.m_21166_(EquipmentSlot.CHEST));
            }
            entity.m_146850_(GameEvent.f_223705_);
        }
        return true;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return (Boolean)ModConfig.COMMON.catalystArmorDurability.get() == false ? super.canApplyAtEnchantingTable(stack, enchantment) : enchantment != Enchantments.f_44962_ && super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public boolean m_8120_(@NotNull ItemStack pStack) {
        return this.getMaxStackSize(pStack) == 1;
    }

    public boolean m_142207_(ItemStack stack, @NotNull Slot slot, @NotNull ClickAction action, @NotNull Player player) {
        if (stack.m_41613_() != 1 || action != ClickAction.SECONDARY) {
            return false;
        }
        ItemStack itemstack = slot.m_7993_();
        if (itemstack.m_41619_()) {
            if (CatalystArmorItem.checkElytraEquiped(stack) > 0) {
                this.playElytraEquipSound(player);
                CatalystArmorItem.removeEquipedElytra(stack).ifPresent(item -> CatalystArmorItem.equipElytraL(stack, slot.m_150659_(item)));
            } else if (CatalystArmorItem.checkElytraEquipped(stack) > 0) {
                this.playElytraEquipSound(player);
                CatalystArmorItem.removeEquippedElytra(stack).ifPresent(item -> CatalystArmorItem.equipElytra(stack, slot.m_150659_(item)));
            } else if (CatalystArmorItem.getContentWeight(stack) > 0) {
                this.playRemoveSound(player);
                CatalystArmorItem.removeCore(stack).ifPresent(item -> CatalystArmorItem.insertCore(stack, slot.m_150659_(item)));
            }
        } else if (itemstack.m_204117_(Etags.Items.CATALYST_ITEMS)) {
            int i = 1 - CatalystArmorItem.getContentWeight(stack);
            int j = CatalystArmorItem.insertCore(stack, slot.m_150647_(itemstack.m_41613_(), i, player));
            if (j > 0) {
                this.playInsertSound(player, stack);
            }
        } else if (itemstack.m_204117_(Etags.Items.CATALYST_ELYTRA)) {
            int e = 1 - CatalystArmorItem.checkElytraEquipped(stack);
            int g = CatalystArmorItem.equipElytra(stack, slot.m_150647_(itemstack.m_41613_(), e, player));
            if (g > 0) {
                this.playElytraEquipSound(player);
            }
        }
        return true;
    }

    public boolean m_142305_(ItemStack coreStack, @NotNull ItemStack mouseStack, @NotNull Slot slot, @NotNull ClickAction action, @NotNull Player player, @NotNull SlotAccess access) {
        if (coreStack.m_41613_() != 1) {
            return false;
        }
        if (action == ClickAction.SECONDARY && slot.m_150651_(player)) {
            if (mouseStack.m_41619_()) {
                if (CatalystArmorItem.checkElytraEquiped(coreStack) > 0) {
                    CatalystArmorItem.removeEquipedElytra(coreStack).ifPresent(item -> {
                        this.playElytraEquipSound(player);
                        access.m_142104_(item);
                    });
                } else if (CatalystArmorItem.checkElytraEquipped(coreStack) > 0) {
                    CatalystArmorItem.removeEquippedElytra(coreStack).ifPresent(item -> {
                        this.playElytraEquipSound(player);
                        access.m_142104_(item);
                    });
                } else if (CatalystArmorItem.getContentWeight(coreStack) > 0) {
                    CatalystArmorItem.removeCore(coreStack).ifPresent(item -> {
                        this.playRemoveSound(player);
                        access.m_142104_(item);
                    });
                }
            } else {
                int i = CatalystArmorItem.insertCore(coreStack, mouseStack);
                int e = CatalystArmorItem.equipElytra(coreStack, mouseStack);
                if (i > 0) {
                    this.playInsertSound(player, coreStack);
                    mouseStack.m_41774_(i);
                }
                if (e > 0) {
                    this.playElytraEquipSound(player);
                    mouseStack.m_41774_(e);
                }
            }
            return true;
        }
        return false;
    }

    private static int insertCore(ItemStack coreStack, ItemStack insertStack) {
        if (!insertStack.m_41619_() && insertStack.m_204117_(Etags.Items.CATALYST_ITEMS)) {
            int k;
            CompoundTag tag = coreStack.m_41784_();
            if (!tag.m_128441_(core)) {
                tag.m_128365_(core, (Tag)new ListTag());
            }
            if ((k = Math.min(insertStack.m_41613_(), 1 - CatalystArmorItem.getContentWeight(coreStack))) == 0) {
                return 0;
            }
            CompoundTag newTag = new CompoundTag();
            insertStack.m_255036_(k).m_41739_(newTag);
            tag.m_128437_(core, 10).add(0, (Tag)newTag);
            return k;
        }
        return 0;
    }

    private static int equipElytra(ItemStack coreStack, ItemStack insertStack) {
        if (!insertStack.m_41619_() && insertStack.m_204117_(Etags.Items.CATALYST_ELYTRA)) {
            int k;
            CompoundTag tag = coreStack.m_41784_();
            if (!tag.m_128441_(elytra)) {
                tag.m_128365_(elytra, (Tag)new ListTag());
            }
            if ((k = Math.min(insertStack.m_41613_(), 1 - CatalystArmorItem.checkElytraEquipped(coreStack))) == 0) {
                return 0;
            }
            CompoundTag newTag = new CompoundTag();
            insertStack.m_255036_(k).m_41739_(newTag);
            tag.m_128437_(elytra, 10).add(0, (Tag)newTag);
            return k;
        }
        return 0;
    }

    private static int equipElytraL(ItemStack coreStack, ItemStack insertStack) {
        if (!insertStack.m_41619_() && insertStack.m_204117_(Etags.Items.CATALYST_ELYTRA)) {
            int k;
            CompoundTag tag = coreStack.m_41784_();
            if (!tag.m_128441_(elytraL)) {
                tag.m_128365_(elytraL, (Tag)new ListTag());
            }
            if ((k = Math.min(insertStack.m_41613_(), 1 - CatalystArmorItem.checkElytraEquipped(coreStack))) == 0) {
                return 0;
            }
            CompoundTag newTag = new CompoundTag();
            insertStack.m_255036_(k).m_41739_(newTag);
            tag.m_128437_(elytraL, 10).add(0, (Tag)newTag);
            return k;
        }
        return 0;
    }

    static int getContentWeight(ItemStack pStack) {
        return CatalystArmorItem.getContents(pStack).mapToInt(ItemStack::m_41613_).sum();
    }

    public static int checkElytraEquipped(ItemStack pStack) {
        return CatalystArmorItem.getElytraEquipped(pStack).mapToInt(ItemStack::m_41613_).sum();
    }

    public static int checkElytraEquiped(ItemStack pStack) {
        return CatalystArmorItem.getElytraEquiped(pStack).mapToInt(ItemStack::m_41613_).sum();
    }

    private static Optional<ItemStack> removeCore(ItemStack stack) {
        ListTag items = stack.m_41784_().m_128437_(core, 10);
        ItemStack itemstack = ItemStack.m_41712_((CompoundTag)items.m_128728_(0));
        if (!stack.m_41784_().m_128441_(core)) {
            return Optional.empty();
        }
        if (items.isEmpty()) {
            return Optional.empty();
        }
        items.remove(0);
        if (items.isEmpty()) {
            stack.m_41749_(core);
        }
        return Optional.of(itemstack);
    }

    private static Optional<ItemStack> removeEquippedElytra(ItemStack stack) {
        ListTag items = stack.m_41784_().m_128437_(elytra, 10);
        ItemStack itemstack = ItemStack.m_41712_((CompoundTag)items.m_128728_(0));
        if (!stack.m_41784_().m_128441_(elytra)) {
            return Optional.empty();
        }
        if (items.isEmpty()) {
            return Optional.empty();
        }
        items.remove(0);
        if (items.isEmpty()) {
            stack.m_41749_(elytra);
        }
        return Optional.of(itemstack);
    }

    private static Optional<ItemStack> removeEquipedElytra(ItemStack stack) {
        ListTag items = stack.m_41784_().m_128437_(elytraL, 10);
        ItemStack itemstack = ItemStack.m_41712_((CompoundTag)items.m_128728_(0));
        if (!stack.m_41784_().m_128441_(elytraL)) {
            return Optional.empty();
        }
        if (items.isEmpty()) {
            return Optional.empty();
        }
        items.remove(0);
        if (items.isEmpty()) {
            stack.m_41749_(elytraL);
        }
        return Optional.of(itemstack);
    }

    public static Stream<ItemStack> getContents(ItemStack stack) {
        return stack.m_41783_() == null ? Stream.empty() : stack.m_41783_().m_128437_(core, 10).stream().map(CompoundTag.class::cast).map(ItemStack::m_41712_);
    }

    public static Stream<ItemStack> getElytraEquipped(ItemStack stack) {
        return stack.m_41783_() == null ? Stream.empty() : stack.m_41783_().m_128437_(elytra, 10).stream().map(CompoundTag.class::cast).map(ItemStack::m_41712_);
    }

    public static Stream<ItemStack> getElytraEquiped(ItemStack stack) {
        return stack.m_41783_() == null ? Stream.empty() : stack.m_41783_().m_128437_(elytraL, 10).stream().map(CompoundTag.class::cast).map(ItemStack::m_41712_);
    }

    @NotNull
    public Optional<TooltipComponent> m_142422_(@NotNull ItemStack stack) {
        NonNullList core = NonNullList.m_122779_();
        NonNullList elytra = NonNullList.m_122779_();
        CatalystArmorItem.getContents(stack).forEach(arg_0 -> core.add(arg_0));
        CatalystArmorItem.getElytraEquipped(stack).forEach(arg_0 -> elytra.add(arg_0));
        return Optional.of(new CatalystTooltip((NonNullList<ItemStack>)core, (NonNullList<ItemStack>)elytra));
    }

    public void onDestroyed(ItemEntity itemEntity, DamageSource damageSource) {
        ItemUtils.m_150952_((ItemEntity)itemEntity, CatalystArmorItem.getContents(itemEntity.m_32055_()));
    }

    private void playRemoveSound(Player entity) {
        entity.m_5496_((SoundEvent)ModSoundEvents.CATALYST_ARMOR_DEACTIVATE.get(), 0.75f, 0.6f + entity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    private void playInsertSound(Player entity, ItemStack stack) {
        entity.m_5496_((SoundEvent)ModSoundEvents.CATALYST_ARMOR_ACTIVATE.get(), 0.75f, 0.5f + entity.m_9236_().m_213780_().m_188501_() * 0.4f);
        if (CatalystArmorItem.catalystActivator(stack).equals("withered_nether_star") && ModChecker.witherStormMod) {
            entity.m_5496_((SoundEvent)WitherStormModSoundEvents.WITHER_STORM_REACTIVATES.get(), 0.8f, 1.0f);
        }
    }

    private void playElytraEquipSound(Player entity) {
        entity.m_5496_(SoundEvents.f_11674_, 0.75f, 1.0f);
    }

    static {
        attributeCheck = 0;
    }
}

