/*
 * Decompiled with CFR 0.152.
 */
package net.nokunami.elementus.common.item;

import com.github.L_Ender.cataclysm.init.ModEffect;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.nokunami.elementus.ModChecker;
import net.nokunami.elementus.common.config.CatalystArmorConfig;
import net.nokunami.elementus.common.item.CatalystArmorItem;
import net.nokunami.elementus.common.registry.ModArmorMaterials;
import net.nokunami.elementus.common.registry.ModItems;
import net.nokunami.elementus.common.registry.ModMobEffects;
import net.nokunami.elementus.common.registry.ModSoundEvents;

public class CatalystItemUtil {
    public static final String netherStar = "nether_star";
    public static final String ignitium = "ignitium_ingot";
    public static final String arcane = "arcane_ingot";
    public static final String heartSea = "heart_of_the_sea";
    public static final String totem = "totem_of_undying";
    public static final String cursium = "cursium_ingot";
    public static final String witheredNetherStar = "withered_nether_star";
    public static final UUID maxManaUUID = UUID.fromString("58868843-e045-405d-bd63-05eefabb7383");
    public static final UUID manaRegenUUID = UUID.fromString("6f40fd38-64eb-469f-8fe6-854c9ca5e73a");
    public static final UUID spellPowerUUID = UUID.fromString("80d938ca-e805-4cf5-8239-e019a687acf6");
    public static final UUID spellResistUUID = UUID.fromString("ab2b408a-cc76-447a-829b-1161e4313726");

    public static void netherStar(ItemStack s, Player p) {
        boolean healthActivation;
        boolean bl = healthActivation = p.m_21233_() / 2.0f >= p.m_21223_();
        if (CatalystArmorItem.catalystActivator(s).equals(netherStar)) {
            if (healthActivation && !p.m_36335_().m_41519_(s.m_41720_())) {
                p.m_5496_((SoundEvent)ModSoundEvents.CATALYST_ARMOR_ACTIVATE.get(), 1.25f, 1.5f + p.m_9236_().m_213780_().m_188501_() * 0.4f);
                p.m_21195_((MobEffect)ModMobEffects.ElementusEffects.BEACON_POWER.get());
                if (!p.m_21023_((MobEffect)ModMobEffects.ElementusEffects.BEACON_POWER.get())) {
                    p.m_7292_(new MobEffectInstance((MobEffect)ModMobEffects.ElementusEffects.BEACON_POWER.get(), 100 + CatalystArmorConfig.NSDuration, CatalystArmorConfig.NSBoostedAmp));
                }
                p.m_36335_().m_41524_(s.m_41720_(), CatalystArmorConfig.NSCooldown);
            }
            if (!p.m_36335_().m_41519_(s.m_41720_()) && !p.m_21023_((MobEffect)ModMobEffects.ElementusEffects.BEACON_POWER.get())) {
                p.m_7292_(new MobEffectInstance((MobEffect)ModMobEffects.ElementusEffects.BEACON_POWER.get(), 100));
            }
        }
    }

    public static void ignitium(ItemStack s, Player p) {
        boolean healthActivation;
        boolean bl = healthActivation = p.m_21233_() / 2.0f >= p.m_21223_();
        if (CatalystArmorItem.catalystActivator(s).equals(ignitium)) {
            if (ModChecker.cataclysm && p.m_21023_((MobEffect)ModEffect.EFFECTBLAZING_BRAND.get())) {
                p.m_216990_(SoundEvents.f_11937_);
                p.m_21195_((MobEffect)ModEffect.EFFECTBLAZING_BRAND.get());
            }
            if (healthActivation) {
                CatalystItemUtil.mobEffect((Entity)p, mobEffectType.HASTE, CatalystArmorConfig.ignitium_HasteDuration, CatalystArmorConfig.ignitium_HasteAmp, false, false, true);
                CatalystItemUtil.mobEffect((Entity)p, mobEffectType.STRENGTH, CatalystArmorConfig.ignitium_StrengthDuration, CatalystArmorConfig.ignitium_StrengthAmp, false, false, true);
                CatalystItemUtil.mobEffect((Entity)p, mobEffectType.RESIST, CatalystArmorConfig.ignitium_ResistanceDuration, CatalystArmorConfig.ignitium_ResistanceAmp, false, false, true);
            }
        }
    }

    public static void arcane(ItemStack s, Player p) {
        if (CatalystArmorItem.catalystActivator(s).equals(arcane)) {
            p.m_7292_(new MobEffectInstance((MobEffect)ModMobEffects.ISSEffects.ADD_ISS_MANA.get(), 0, 0, false, false, true));
        }
    }

    public static void heartSea(ItemStack s, Player p) {
        if (CatalystArmorItem.catalystActivator(s).equals(heartSea) && p.m_20070_()) {
            CatalystItemUtil.mobEffect((Entity)p, mobEffectType.SEA, 2, 0, false, true, true);
        }
    }

    public static void witheredNetherStar(ItemStack s, Player p) {
        boolean healthActivation;
        boolean bl = healthActivation = p.m_21233_() / 2.0f >= p.m_21223_();
        if (CatalystArmorItem.catalystActivator(s).equals(witheredNetherStar)) {
            if (healthActivation) {
                if (!p.m_21023_((MobEffect)ModMobEffects.ElementusEffects.WITHERED_BEACON_POWER.get())) {
                    p.m_7292_(new MobEffectInstance((MobEffect)ModMobEffects.ElementusEffects.WITHERED_BEACON_POWER.get(), 100, 1));
                }
            } else if (!p.m_21023_((MobEffect)ModMobEffects.ElementusEffects.WITHERED_BEACON_POWER.get())) {
                p.m_7292_(new MobEffectInstance((MobEffect)ModMobEffects.ElementusEffects.WITHERED_BEACON_POWER.get(), 100));
            }
        }
    }

    public static void addCUstomAttribute(ModArmorMaterials m, ArmorItem.Type t, ItemStack s) {
        UUID uuid = (UUID)CatalystArmorItem.f_265987_.get(ArmorItem.Type.CHESTPLATE);
        s.m_41643_(Attributes.f_22284_, new AttributeModifier(uuid, "Armor modifier", (double)m.m_7366_(t), AttributeModifier.Operation.ADDITION), t.m_266308_());
        s.m_41643_(Attributes.f_22285_, new AttributeModifier(uuid, "Armor toughness", (double)m.m_6651_(), AttributeModifier.Operation.ADDITION), t.m_266308_());
        if (m.m_6649_() > 0.0f) {
            s.m_41643_(Attributes.f_22278_, new AttributeModifier(uuid, "Knockback resistance", (double)m.m_6649_(), AttributeModifier.Operation.ADDITION), t.m_266308_());
        }
        if (ModChecker.ironsSpellbooks && CatalystArmorItem.catalystActivator(s).equals(arcane)) {
            if (CatalystArmorConfig.ISS_MaxMana != 0) {
                s.m_41643_((Attribute)AttributeRegistry.MAX_MANA.get(), new AttributeModifier(maxManaUUID, "maxMana", (double)CatalystArmorConfig.ISS_MaxMana, AttributeModifier.Operation.ADDITION), t.m_266308_());
            }
            if (CatalystArmorConfig.ISS_ManaRegen != 0.0) {
                s.m_41643_((Attribute)AttributeRegistry.MANA_REGEN.get(), new AttributeModifier(manaRegenUUID, "manaRegen", CatalystArmorConfig.ISS_ManaRegen, AttributeModifier.Operation.MULTIPLY_TOTAL), EquipmentSlot.CHEST);
            }
            if (CatalystArmorConfig.ISS_SpellPower != 0.0) {
                s.m_41643_((Attribute)AttributeRegistry.SPELL_POWER.get(), new AttributeModifier(spellPowerUUID, "spellPower", CatalystArmorConfig.ISS_SpellPower, AttributeModifier.Operation.MULTIPLY_TOTAL), EquipmentSlot.CHEST);
            }
            if (CatalystArmorConfig.ISS_SpellResist != 0.0) {
                s.m_41643_((Attribute)AttributeRegistry.SPELL_RESIST.get(), new AttributeModifier(spellResistUUID, "spellResist", CatalystArmorConfig.ISS_SpellResist, AttributeModifier.Operation.MULTIPLY_TOTAL), EquipmentSlot.CHEST);
            }
        } else {
            s.m_41749_("AttributeModifiers");
        }
    }

    public static void alliedMobEffects(Entity entity, int type) {
        int amp1 = 1;
        int amp2 = 2;
        int duration = 400;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (type == 1) {
                CatalystItemUtil.mobEffect((Entity)livingEntity, mobEffectType.HASTE, duration, amp1, true, true, true);
                CatalystItemUtil.mobEffect((Entity)livingEntity, mobEffectType.REGEN, duration, amp1, true, true, true);
                CatalystItemUtil.mobEffect((Entity)livingEntity, mobEffectType.SPEED, duration, amp1, true, true, true);
                CatalystItemUtil.mobEffect((Entity)livingEntity, mobEffectType.RESIST, duration, amp1, true, true, true);
            }
            if (type == 2) {
                CatalystItemUtil.mobEffect((Entity)livingEntity, mobEffectType.SEA, duration, amp1, false, true, true);
            }
            if (type == 3) {
                CatalystItemUtil.mobEffect((Entity)livingEntity, mobEffectType.JUMP, duration, amp2, true, true, true);
                CatalystItemUtil.mobEffect((Entity)livingEntity, mobEffectType.HASTE, duration, amp2, true, true, true);
                CatalystItemUtil.mobEffect((Entity)livingEntity, mobEffectType.REGEN, duration, amp2, true, true, true);
                CatalystItemUtil.mobEffect((Entity)livingEntity, mobEffectType.SPEED, duration, amp2, true, true, true);
                CatalystItemUtil.mobEffect((Entity)livingEntity, mobEffectType.RESIST, duration, amp2, true, true, true);
            }
        }
    }

    public static void effectRadius(Player p, ItemStack stack, Level w, int type) {
        Level level = p.m_9236_();
        String catalyst = CatalystArmorItem.catalystActivator(stack);
        ItemStack chestplateItem = p.m_6844_(EquipmentSlot.CHEST);
        int range = 16;
        if (!level.f_46443_ && chestplateItem.m_150930_((Item)ModItems.ElementusItems.CATALYST_CHESTPLATE.get())) {
            if (catalyst.equals(netherStar) || catalyst.equals(witheredNetherStar)) {
                CatalystItemUtil.areaEffect(p, w, type, range);
            } else if (catalyst.equals(heartSea)) {
                for (Entity entity : w.m_45933_((Entity)p, p.m_20191_().m_82400_((double)range))) {
                    Player player;
                    if (!entity.m_20070_()) continue;
                    if (entity instanceof LivingEntity) {
                        LivingEntity livingEntity = (LivingEntity)entity;
                        if (!livingEntity.m_7307_((Entity)p)) continue;
                        CatalystItemUtil.alliedMobEffects((Entity)livingEntity, type);
                        continue;
                    }
                    if (entity instanceof OwnableEntity) {
                        OwnableEntity tamableAnimal = (OwnableEntity)entity;
                        if (tamableAnimal.m_269323_() == null || !tamableAnimal.m_269323_().m_7306_((Entity)p) && !tamableAnimal.m_269323_().m_7307_((Entity)p)) continue;
                        CatalystItemUtil.alliedMobEffects((Entity)tamableAnimal, type);
                        continue;
                    }
                    if (!(entity instanceof Player) || !(player = (Player)entity).m_7307_((Entity)p) && !player.m_5647_().equals(null) || player.m_21023_((MobEffect)ModMobEffects.ElementusEffects.BEACON_POWER.get())) continue;
                    CatalystItemUtil.alliedMobEffects((Entity)player, type);
                }
            }
        }
    }

    public static void areaEffect(Player p, Level w, int type, int range) {
        for (Entity entity : w.m_45933_((Entity)p, p.m_20191_().m_82400_((double)range))) {
            Player player;
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (!livingEntity.m_7307_((Entity)p)) continue;
                CatalystItemUtil.alliedMobEffects((Entity)livingEntity, type);
                continue;
            }
            if (entity instanceof OwnableEntity) {
                OwnableEntity tamableAnimal = (OwnableEntity)entity;
                if (!Objects.requireNonNull(tamableAnimal.m_269323_()).m_7306_((Entity)p) && !tamableAnimal.m_269323_().m_7307_((Entity)p)) continue;
                CatalystItemUtil.alliedMobEffects((Entity)tamableAnimal, type);
                continue;
            }
            if (!(entity instanceof Player) || !(player = (Player)entity).m_7307_((Entity)p) && !player.m_5647_().equals(null) || player.m_21023_((MobEffect)ModMobEffects.ElementusEffects.BEACON_POWER.get())) continue;
            CatalystItemUtil.alliedMobEffects((Entity)player, type);
        }
    }

    public static void mobEffect(Entity entity, mobEffectType effect, int duration, int amp, boolean ambient, boolean visible, boolean icon) {
        if (duration != 0 && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            switch (effect) {
                case JUMP: {
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19603_, duration, amp, ambient, visible, icon));
                    break;
                }
                case SPEED: {
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19596_, duration, amp, ambient, visible, icon));
                    break;
                }
                case HASTE: {
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19598_, duration, amp, ambient, visible, icon));
                    break;
                }
                case STRENGTH: {
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19600_, duration, amp, ambient, visible, icon));
                    break;
                }
                case REGEN: {
                    if (livingEntity.m_21023_(MobEffects.f_19605_)) break;
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19605_, duration, amp, ambient, visible, icon));
                    break;
                }
                case RESIST: {
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19606_, duration, amp, ambient, visible, icon));
                    break;
                }
                case SEA: {
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19592_, duration, amp, ambient, visible, icon));
                }
            }
        }
    }

    public static String armorTexture(ItemStack stack, Entity entity) {
        return CatalystItemUtil.baseTextures(stack, entity);
    }

    public static String baseTextures(ItemStack stack, Entity entity) {
        String base = "%s:textures/models/armor/catalyst/catalyst_armor_layer.png";
        String format = "%s:textures/models/armor/catalyst/catalyst_%s_armor_layer.png";
        String armor = String.format(Locale.ROOT, format, "elementus", CatalystArmorItem.catalystActivator(stack));
        if (CatalystArmorItem.getContentWeight(stack) > 0) {
            if (CatalystArmorItem.catalystActivator(stack).equals(ignitium)) {
                LivingEntity livingEntity;
                if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_21233_() / 2.0f >= livingEntity.m_21223_()) {
                    return String.format(Locale.ROOT, format, "elementus", "ignitium_ingot_soul");
                }
                return String.format(Locale.ROOT, format, "elementus", ignitium);
            }
            return armor;
        }
        return String.format(Locale.ROOT, base, "elementus");
    }

    private static String elytraTexture(ItemStack stack) {
        if (CatalystArmorItem.getElytraEquipped(stack).findAny().isPresent()) {
            CatalystArmorItem.getElytraEquipped(stack).findAny().get().m_41720_();
        }
        return "elytra";
    }

    public static String getElytraTexture(ItemStack stack) {
        return String.format(Locale.ROOT, "textures/models/armor/catalyst/elytra/catalyst_%s.png", CatalystItemUtil.elytraTexture(stack));
    }

    public static enum mobEffectType {
        JUMP("jump"),
        SPEED("speed"),
        HASTE("haste"),
        STRENGTH("strength"),
        REGEN("regen"),
        RESIST("resist"),
        SEA("sea");

        private final String name;

        private mobEffectType(String pName) {
            this.name = pName;
        }

        public String getName() {
            return this.name;
        }
    }
}

