/*
 * Decompiled with CFR 0.152.
 */
package net.nokunami.elementus.common.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.nokunami.elementus.ModChecker;
import net.nokunami.elementus.common.config.UniqueItemConfig;
import net.nokunami.elementus.common.registry.ModEnchantments;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChargeBladeItem
extends SwordItem {
    public static final String CHARGE_TAG = "Charge";
    public static final String RESONANCE_CHARGE_TAG = "ResonanceCharge";
    public static final String RESONANCE_TICK_TAG = "ResonanceTick";
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;
    protected static final UUID BASE_ATTACK_REACH_UUID = UUID.fromString("fe181be2-3fd8-4a90-ba64-a4a06cef6d27");

    public ChargeBladeItem(Tier pTier, int attackDamage, float attackSpeed, float attackReach, Item.Properties properties) {
        super(pTier, attackDamage, attackSpeed, properties);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        this.defaultModifiers = this.createAttributes((ImmutableMultimap.Builder<Attribute, AttributeModifier>)builder, attackDamage, attackSpeed, attackReach).build();
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        return slot.equals((Object)EquipmentSlot.MAINHAND) ? this.defaultModifiers : super.getAttributeModifiers(slot, stack);
    }

    protected ImmutableMultimap.Builder<Attribute, AttributeModifier> createAttributes(ImmutableMultimap.Builder<Attribute, AttributeModifier> builder, int attackDamage, float attackSpeed, float attackReach) {
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)((float)attackDamage + this.m_43314_().m_6631_()), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)attackSpeed, AttributeModifier.Operation.ADDITION));
        if (!ModChecker.betterCombat && attackDamage != 0) {
            builder.put((Object)((Attribute)ForgeMod.ENTITY_REACH.get()), (Object)new AttributeModifier(BASE_ATTACK_REACH_UUID, "Weapon modifier", (double)attackReach, AttributeModifier.Operation.ADDITION));
        }
        return builder;
    }

    public int m_8105_(@NotNull ItemStack pStack) {
        return 72000;
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack pStack) {
        return UseAnim.BLOCK;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    public void m_6883_(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slotId, boolean isSelected) {
        if (ChargeBladeItem.isEnchantedWith(stack, ModEnchantments.RESONANCE) && ChargeBladeItem.getResonanceTick(stack) > 0) {
            ChargeBladeItem.setResonanceTick(stack, ChargeBladeItem.getResonanceTick(stack) - 1);
        }
        super.m_6883_(stack, level, entity, slotId, isSelected);
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        Minecraft mc = Minecraft.m_91087_();
        assert (mc.f_91074_ != null);
        boolean creative = mc.f_91074_.m_7500_();
        if (creative) {
            tooltip.add((Component)Component.m_237113_((String)"(").m_7220_((Component)Component.m_237115_((String)"gameMode.creative")).m_130946_(")").m_130940_(ChatFormatting.DARK_GRAY));
        }
        tooltip.add((Component)Component.m_237110_((String)"item.elementus.charge_item.charge_desc", (Object[])new Object[]{ChargeBladeItem.getCharge(stack), ChargeBladeItem.getMaxCharge(stack)}).m_130940_(ChatFormatting.GRAY));
    }

    public void friendlyFireTooltip(List<Component> tooltip, ItemStack stack) {
        String friendlyFireStr = String.valueOf(ChargeBladeItem.getFriendlyFire(stack));
        tooltip.add((Component)Component.m_237110_((String)"item.elementus.charge_item.friendly_fire_desc", (Object[])new Object[]{friendlyFireStr.substring(0, 1).toUpperCase(Locale.ROOT) + friendlyFireStr.substring(1)}).m_130940_(ChatFormatting.GRAY));
    }

    public static boolean isEnchantedWith(ItemStack stack, Supplier<? extends Enchantment> enchantment) {
        return EnchantmentHelper.getTagEnchantmentLevel((Enchantment)enchantment.get(), (ItemStack)stack) > 0;
    }

    public static void setCharge(ItemStack stack, int amount) {
        stack.m_41784_().m_128405_(CHARGE_TAG, Math.min(ChargeBladeItem.getCharge(stack) + amount, ChargeBladeItem.getMaxCharge(stack)));
    }

    public static int getCharge(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null ? tag.m_128451_(CHARGE_TAG) : 0;
    }

    public static boolean getChargedState(ItemStack stack) {
        return ChargeBladeItem.getCharge(stack) >= ChargeBladeItem.getMaxCharge(stack);
    }

    public static int getMaxCharge(ItemStack stack) {
        int level = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)((Enchantment)ModEnchantments.CHARGE_STACKING.get()), (ItemStack)stack);
        return ChargeBladeItem.getChargeStack(stack) * (ChargeBladeItem.isEnchantedWith(stack, ModEnchantments.CHARGE_STACKING) ? level + 1 : 1);
    }

    public static int getChargeStack(ItemStack stack) {
        return ChargeBladeItem.isEnchantedWith(stack, ModEnchantments.CONDENSED_BURST) ? UniqueItemConfig.diarkriteChargeBladeChargePenalty : UniqueItemConfig.diarkriteChargeBladeBaseCharge;
    }

    public static float getChargeAmount(ItemStack stack, boolean b) {
        float base;
        float i0 = Math.min(ChargeBladeItem.getCharge(stack), ChargeBladeItem.getChargeStack(stack));
        float i1 = ChargeBladeItem.getChargeStack(stack);
        float f = base = !b ? i0 / i1 : 1.0f;
        if (ChargeBladeItem.isEnchantedWith(stack, ModEnchantments.SACRIFICE_CURSE)) {
            base += 1.25f;
        }
        return base;
    }

    public static boolean getFriendlyFire(ItemStack stack) {
        return stack.m_41784_().m_128471_("FriendlyFire");
    }

    public static void setFriendlyFire(ItemStack stack, boolean b) {
        stack.m_41784_().m_128379_("FriendlyFire", b);
    }

    public static void setResonanceCharge(ItemStack stack, int amount) {
        if (ChargeBladeItem.isEnchantedWith(stack, ModEnchantments.RESONANCE)) {
            stack.m_41784_().m_128405_(RESONANCE_CHARGE_TAG, (int)Math.min((double)(ChargeBladeItem.getResonanceCharge(stack) + amount), (double)ChargeBladeItem.getChargeStack(stack) * 1.5));
        }
    }

    public static int getResonanceCharge(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null ? tag.m_128451_(RESONANCE_CHARGE_TAG) : 0;
    }

    public static void setResonanceTick(ItemStack stack, int amount) {
        stack.m_41784_().m_128405_(RESONANCE_TICK_TAG, amount);
    }

    public static int getResonanceTick(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null ? tag.m_128451_(RESONANCE_TICK_TAG) : 0;
    }

    public boolean m_142305_(@NotNull ItemStack stack, @NotNull ItemStack otherStack, @NotNull Slot slot, @NotNull ClickAction action, @NotNull Player player, @NotNull SlotAccess access) {
        if (otherStack.m_41619_() && action == ClickAction.SECONDARY) {
            ChargeBladeItem.setFriendlyFire(stack, !ChargeBladeItem.getFriendlyFire(stack));
            player.m_216990_(SoundEvents.f_11897_);
            return true;
        }
        return super.m_142305_(stack, otherStack, slot, action, player, access);
    }

    public boolean m_8120_(@NotNull ItemStack stack) {
        return this.getMaxStackSize(stack) == 1;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment) && enchantment != Enchantments.f_44986_ && enchantment != Enchantments.f_44962_;
    }

    public boolean isDamageable(ItemStack stack) {
        return false;
    }

    public boolean canDisableShield(ItemStack stack, ItemStack shield, LivingEntity entity, LivingEntity attacker) {
        return true;
    }

    public boolean m_41386_(@NotNull DamageSource pDamageSource) {
        return false;
    }

    public int m_142158_(@NotNull ItemStack pStack) {
        return Math.round(13.0f - (float)(ChargeBladeItem.getMaxCharge(pStack) - ChargeBladeItem.getCharge(pStack)) * 13.0f / (float)ChargeBladeItem.getMaxCharge(pStack));
    }

    public boolean m_142522_(@NotNull ItemStack pStack) {
        return !ChargeBladeItem.isEnchantedWith(pStack, ModEnchantments.CHARGE_STACKING) && ChargeBladeItem.getCharge(pStack) > 0;
    }

    public boolean isMultiBarVisible(@NotNull ItemStack pStack) {
        return ChargeBladeItem.isEnchantedWith(pStack, ModEnchantments.CHARGE_STACKING) && ChargeBladeItem.getCharge(pStack) > 0;
    }

    public boolean m_7579_(@NotNull ItemStack stack, LivingEntity target, @NotNull LivingEntity attacker) {
        Player player;
        if (target.m_5789_() && attacker instanceof Player && (player = (Player)attacker).m_36403_(1.0f) >= 0.5f && !ChargeBladeItem.isEnchantedWith(stack, ModEnchantments.SACRIFICE_CURSE)) {
            ChargeBladeItem.setCharge(stack, 1);
            ServerLevel level = (ServerLevel)attacker.m_9236_();
            if (ChargeBladeItem.isEnchantedWith(stack, ModEnchantments.RESONANCE) && !ChargeBladeItem.getChargedState(stack)) {
                ChargeBladeItem.setResonanceCharge(stack, 1);
            }
            if (!attacker.m_9236_().f_46443_ && ChargeBladeItem.getChargedState(stack)) {
                level.m_6269_(null, (Entity)target, SoundEvents.f_11871_, SoundSource.PLAYERS, 1.0f, 0.0f);
            }
        }
        return super.m_7579_(stack, target, attacker);
    }

    public boolean canParry() {
        return false;
    }

    public static void applyRecoil(Entity target, Entity source, double aX, double aY, double aZ, boolean type) {
        Vec3 lookDirection = source.m_20252_(1.0f);
        double fX = -aX;
        double fY = -aY;
        double fZ = -aZ;
        if (type) {
            fX = aX;
            fY = aY;
            fZ = aZ;
        }
        Vec3 knockback = lookDirection.m_82542_(fX, fY, fZ);
        target.m_20334_(source.m_20184_().f_82479_ + knockback.f_82479_, source.m_20184_().f_82480_ + knockback.f_82480_, source.m_20184_().f_82481_ + knockback.f_82481_);
        target.f_19864_ = true;
    }

    public static void applyRecoil(Entity target, Entity source, double amount, boolean type) {
        ChargeBladeItem.applyRecoil(target, source, amount, amount, amount, type);
    }
}

